<?php
$query = new WP_Query(array(
            'post_type' => 'post',
            'showposts' => $instance['post_number'],
            'cat' => $instance['category']
        ));

global $post;
$excerpt_symbols_count = get_option(THEMEMAKERS_THEME_PREFIX . "excerpt_symbols_count");
if (!$excerpt_symbols_count) {
    $excerpt_symbols_count = 140;
}
?>
<div class="widget widget_latest_posts">
    <?php if ($instance['title'] != '') { ?>
        <h3 class="widget-title"><?php echo $instance['title']; ?></h3>
    <?php } ?>
    <div class="widget-container">
        <ul>
            <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                    <li>
                        <?php if (has_post_thumbnail() AND $instance['show_thumbnail']) { ?>
                            <span class="small-custom-frame">
                                <a href="<?php the_permalink(); ?>"><img class="alignleft" src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 50, true, 50); ?>" alt="<?php the_title(); ?>" /></a>
                            </span>
                        <?php } ?>
                        <a href="<?php the_permalink(); ?>" class="teaser-title"><?php the_title(); ?></a>
                        <div class="teaser-date"><?php _e('Posted on', THEMEMAKERS_THEME_FOLDER_NAME); ?> <?php the_time('M d, Y'); ?></div>
                        <?php if ($instance['show_exerpt']) : ?>
                            <p>
                                <?php
                                if ($excerpt_symbols_count) {
                                    echo substr(get_the_excerpt(), 0, $excerpt_symbols_count) . " ...";
                                } else {
                                    the_excerpt();
                                }
                                ?>
                            </p>
                        <?php endif; ?>
                        <div class="clear"></div>
                    </li>
                    <?php
                endwhile;
            endif;
            ?>
        </ul>	
    </div>
    <?php if ($instance['show_see_all_button'] == "true"): ?>
        <?php if ($instance['category'] > 0): ?>   
            <a class="see-all" href="<?php echo get_category_link((int) $instance['category']); ?>"><?php _e('See all news', THEMEMAKERS_THEME_FOLDER_NAME); ?></a>
        <?php else: ?>
            <a class="see-all" href="<?php echo home_url() . '/?year=' . date('Y') ?>"><?php _e('See all news', THEMEMAKERS_THEME_FOLDER_NAME); ?></a>
        <?php endif; ?>
    <?php endif; ?>
</div>

