<?php

class Thememakers_Entity_Slides {

    public function register() {

        $args = array(
            'labels' => array(
                'name' => __('Slides', THEMEMAKERS_THEME_FOLDER_NAME),
                'singular_name' => __('Slides', THEMEMAKERS_THEME_FOLDER_NAME),
                'add_new' => __('Add New', THEMEMAKERS_THEME_FOLDER_NAME),
                'add_new_item' => __('Add New Slide', THEMEMAKERS_THEME_FOLDER_NAME),
                'edit_item' => __('Edit Slide', THEMEMAKERS_THEME_FOLDER_NAME),
                'new_item' => __('New Slide', THEMEMAKERS_THEME_FOLDER_NAME),
                'view_item' => __('View Slide', THEMEMAKERS_THEME_FOLDER_NAME),
                'search_items' => __('Search Slides', THEMEMAKERS_THEME_FOLDER_NAME),
                'not_found' => __('No Slides found', THEMEMAKERS_THEME_FOLDER_NAME),
                'not_found_in_trash' => __('No Slides found in Trash', THEMEMAKERS_THEME_FOLDER_NAME),
                'parent_item_colon' => ''
            ),
            'public' => true,
            //'menu_icon' => THEMEMAKERS_THEME_URI . '/images/icons/slides.png',
            'exclude_from_search' => false,
            'publicly_queryable' => true,
            'show_ui' => true,
            'query_var' => true,
            'capability_type' => 'post',
            'has_archive' => true,
            'hierarchical' => true,
            'menu_position' => null,
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
            'rewrite' => array('slug' => 'slides'),
            'show_in_admin_bar' => true
        );
        register_post_type('slides', $args);
        flush_rewrite_rules(false);


        add_filter("manage_slides_posts_columns", array("Thememakers_Entity_Slides", "show_edit_columns"));
        add_action("manage_slides_posts_custom_column", array("Thememakers_Entity_Slides", "show_edit_columns_content"));
    }

    public function settings_meta() {
        global $post;
        $data = array();
        $custom = get_post_custom($post->ID);
        $data['slide_link'] = @$custom["slide_link"][0];
        $data['slide_subtitle'] = @$custom["slide_subtitle"][0];
        echo ThemeMakersThemeView::draw_html('slides/settings', $data);
    }

    public static function save($post_id) {
        update_post_meta($post_id, "slide_link", $_POST["slide_link"]);
        update_post_meta($post_id, "slide_subtitle", $_POST["slide_subtitle"]);
    }

    public static function init_meta_boxes() {
        add_meta_box("settings_meta", __("Slide settings", THEMEMAKERS_THEME_FOLDER_NAME), array('Thememakers_Entity_Slides', 'settings_meta'), "slides", "normal", "low");
    }

    public function show_edit_columns_content($column) {
        global $post;

        switch ($column) {
            case "image":
                if (has_post_thumbnail($post->ID)) {
                    $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
                    $src = urlencode($image[0]);

                    echo '<img alt="" src="' . ThemeMakersHelper::resize_image($src, 200) . '"/>';
                }

                break;
            case "date":
                $date = get_post_modified_time("U", false, $post->ID);
                echo $date;
                break;
        }
    }

    public function show_edit_columns($columns) {
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "title" => __("Portfolio Title", THEMEMAKERS_THEME_FOLDER_NAME),
            "image" => __("Featured image", THEMEMAKERS_THEME_FOLDER_NAME),
            "date" => __("Date", THEMEMAKERS_THEME_FOLDER_NAME)
        );

        return $columns;
    }

    

}

