<?php
$args = array(
    'orderby' => $orderby,
    'order' => $order,
    'post_status' => array('publish')
);

$offset = 0;
if (isset($_GET['offset'])) {
    $offset = (int) $_GET['offset'];
    $args['offset'] = $offset;
}

if (!empty($posts_per_page)) {
    $args['posts_per_page'] = $posts_per_page;
}

if ((int) $cat > 0) {
    $args['cat'] = $cat;
}


if (!empty($posts)) {
    $posts = explode(',', $posts);
    $args['post__in'] = $posts;
}



global $wp_query;
$original_query = $wp_query;
$wp_query = null;
$wp_query = new WP_Query($args);


if ((int) $paging) {
    ?>
    <div class="pagenavi">
        <?php for ($i = 0; $i < $wp_query->max_num_pages; $i++) : ?>
            <?php if ($offset == $i * $posts_per_page): ?>
                <span class="current"><?php echo $i + 1 ?></span>
            <?php else: ?>
                <a class="page" title="<?php echo $i + 1 ?>" href="?offset=<?php echo $i * $posts_per_page ?>"><?php echo $i + 1 ?></a>
            <?php endif; ?>
        <?php endfor; ?>
    </div>
    <?php
}

if (have_posts()) :
    while (have_posts()) : the_post();
        global $post;
        ?>

        <article class="post-item">

            <?php if ((int) $image): ?>
                <div class="post-thumb alignleft">
                    <a href="<?php echo get_permalink($post->ID) ?>"><img class="add-border alignleft" alt="" src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 345, true, 220) ?>"></a>
                </div><!--/ post-thumb-->
            <?php endif; ?>


            <div class="entry">

                <div class="post-title">
                    <h3><a href="<?php echo get_permalink($post->ID) ?>"><?php the_title(); ?></a></h3>
                </div><!--/ post-title-->

                <?php if ((int) $meta): ?>
                    <div class="post-meta clearfix">
                        <div class="post-date"><?php _e('Date', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <?php the_time('F j, Y'); ?></div>
                        <div class="post-author"><?php _e('Author', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <?php the_author_link(); ?></div>
                        <div class="post-tags"><?php the_tags(); ?></div>
                    </div><!--/ post-meta-->
                <?php endif; ?>
                <p>
                    <?php
                    if ((int) $full) {
                        echo $post->post_content;
                    } else {
                        echo $post->post_excerpt;
                    }
                    ?>
                </p>

                <div class="post-comments-icon"><a href="<?php the_permalink(); ?>/#comments"><?php comments_number('0', '1', '%'); ?></a></div><!--/ post-comments-icon-->

            </div><!--/ entry-->

            <div class="clear"></div>
        </article>

        <?php
    endwhile;
else:
    _e('no posts found', THEMEMAKERS_THEME_FOLDER_NAME);
endif;


if ((int) $paging) {
    ?>
    <div class="pagenavi">
        <?php for ($i = 0; $i < $wp_query->max_num_pages; $i++) : ?>
            <?php if ($offset == $i * $posts_per_page): ?>
                <span class="current"><?php echo $i + 1 ?></span>
            <?php else: ?>
                <a class="page" title="<?php echo $i + 1 ?>" href="?offset=<?php echo $i * $posts_per_page ?>"><?php echo $i + 1 ?></a>
            <?php endif; ?>
        <?php endfor; ?>
    </div>
    <?php
}

$wp_query = null;
$wp_query = $original_query;
wp_reset_postdata();

