<?php
//contact form on front by shortcode
$contact_form = Thememakers_Entity_Contact_Form::get_form($form_name);

//output fields
if (!empty($contact_form['inputs'])) {
    ?>
    <form method="post" name="contactform" id="contactform">
        <input type="hidden" name="contact_form_name" value="<?php echo $form_name ?>" />
        <?php foreach ($contact_form['inputs'] as $key => $input) : ?>
            <label><span class="required"><?php echo($input['is_required'] ? "*" : "") ?></span><?php echo $input['label'] ?>:</label>
            <?php
       
			
				$name = strtolower(trim($input['label']));
                $name = str_replace(" ", "_", $name);
                $pattern = "/[^a-zA-Z0-9_]+/i";
                $name = preg_replace($pattern, "", $name);
            switch ($input['type']) {
                case "textinput":case "email":case "subject":
                    ?>
                    <input type="text" name="<?php echo $name ?>" value="" />
                    <?php
                    break;

                case "messagebody":
                    ?>
                    <textarea name="<?php echo $name ?>"></textarea>
                    <?php
                    break;

                case "select":
                    $select_options = explode(",", $input['options']);
                    ?>
                    <select name="<?php echo $name ?>">
                        <?php if (!empty($select_options)): ?>
                            <?php foreach ($select_options as $value) : ?>
                                <option value="<?php echo $value; ?>"><?php echo $value; ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <?php
                    break;

                default:
                    break;
            }
            ?>
        <?php endforeach; ?>
        <br />
        <?php if ($contact_form['has_capture']): ?>
            <br />
            <div class="row">
                <iframe src="<?php echo home_url() ?>/?update_capcha=1" height="27" width="72" scrolling="no" frameborder="0" marginheight="0" marginwidth="0" style="vertical-align: middle;" class="capcha_image_frame" name="capcha_image_frame"></iframe>
                <input type="text" style="width: 50px; margin: 0 0 0 8px; vertical-align: middle;" value="" size="6" name="verify" />
            </div>
        <?php endif; ?>


        <input type="submit" class="button <?php echo $contact_form['submit_button'] ?> small" value="<?php _e('Submit', THEMEMAKERS_THEME_FOLDER_NAME); ?>" />


    </form>
    <div id="contact_form_responce" style="display: none;"><ul></ul></div>

    <?php
}
?>
<div class="clear"></div>

<?php wp_enqueue_script('contactform_js', THEMEMAKERS_THEME_URI . '/js/contactform.js') ?>

