<?php
//capcha refreshing
if (isset($_GET['update_capcha'])) {
    ?>
    <img class="capture_image" border="0" alt="" style="vertical-align:middle" src="<?php bloginfo('stylesheet_directory'); ?>/admin/extensions/contact_form_capcha/image.php">
    <?php
    exit;
}
?>

<!DOCTYPE html>
<!--[if IE 7]>					<html class="ie7 no-js" <?php language_attributes(); ?>>     <![endif]-->
<!--[if lte IE 8]>              <html class="ie8 no-js" <?php language_attributes(); ?>>     <![endif]-->
<!--[if IE 9]>					<html class="ie9 no-js" <?php language_attributes(); ?>>     <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!--> <html class="not-ie no-js" <?php language_attributes(); ?>>  <!--<![endif]-->
    <head>

        <?php echo ThemeMakersHelperFonts::get_google_fonts_link() ?>

        <?php
        global $post;
        $meta_title = "";
        $meta_keywords = "";
        $meta_description = "";


        if (is_front_page()) {
            $meta_title = get_option(THEMEMAKERS_THEME_PREFIX . "meta_title_home");
            $meta_keywords = get_option(THEMEMAKERS_THEME_PREFIX . "meta_keywords_home");
            $meta_description = get_option(THEMEMAKERS_THEME_PREFIX . "meta_description_home");
        } else {
            if (is_single() OR is_page()) {
                $custom = get_post_custom($post->ID);
                $meta_title = @$custom["meta_title"][0];
                $meta_keywords = @$custom["meta_keywords"][0];
                $meta_description = @$custom["meta_description"][0];
            } else {

                if (is_object($post)) {
                    switch ($post->post_type) {
                        case 'post':
                            $meta_title = get_option(THEMEMAKERS_THEME_PREFIX . "meta_title_post_listing");
                            $meta_keywords = get_option(THEMEMAKERS_THEME_PREFIX . "meta_keywords_post_listing");
                            $meta_description = get_option(THEMEMAKERS_THEME_PREFIX . "meta_description_post_listing");
                            break;
                        case 'folio':
                            $meta_title = get_option(THEMEMAKERS_THEME_PREFIX . "meta_title_portfolio_listing");
                            $meta_keywords = get_option(THEMEMAKERS_THEME_PREFIX . "meta_keywords_portfolio_listing");
                            $meta_description = get_option(THEMEMAKERS_THEME_PREFIX . "meta_description_portfolio_listing");
                            break;
                        case 'gall':
                            $meta_title = get_option(THEMEMAKERS_THEME_PREFIX . "meta_title_gallery_listing");
                            $meta_keywords = get_option(THEMEMAKERS_THEME_PREFIX . "meta_keywords_gallery_listing");
                            $meta_description = get_option(THEMEMAKERS_THEME_PREFIX . "meta_description_gallery_listing");
                            break;

                        default:
                            break;
                    }
                }

                //***
                global $cat;
                $cat_head_seo_data = Thememakers_Entity_SEO_Group::get_cat_head_seo_data($cat);
                if (!empty($cat_head_seo_data['meta_title'])) {
                    $meta_title = $cat_head_seo_data['meta_title'];
                    $meta_keywords = $cat_head_seo_data['meta_keywords'];
                    $meta_description = $cat_head_seo_data['meta_description'];
                }
            }
        }
        //*****
        $_REQUEST['disable_blog_comments'] = get_option(THEMEMAKERS_THEME_PREFIX . "disable_blog_comments");
        ?>


        
        <title><?php if(empty($meta_title)): ?><?php echo get_bloginfo('name', 'display')?> <?php wp_title(); ?>
            <?php else: ?><?php echo get_bloginfo('name', 'display')?> &raquo; <?php echo($meta_title); ?><?php endif; ?>
        </title>

        <script type="text/javascript" src="http://www.google.com/jsapi"></script>
        <?php
        wp_deregister_script('jquery');
        wp_register_script('jquery', THEMEMAKERS_THEME_URI . '/js/jquery172.js', array(), '1.7.2');
        wp_print_scripts('jquery');
        ?>
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/mediaelement/mediaelement-and-player.min.js"></script>

        <?php
        //FAVICON
        $favicon = get_option(THEMEMAKERS_THEME_PREFIX . 'favicon_img');
        if ($favicon) :
            ?>
            <link href="<?php echo $favicon; ?>" rel="icon" type="image/x-icon" />
        <?php else: ?>
            <link rel="shortcut icon" href="<?php bloginfo('stylesheet_directory'); ?>/favicon.ico" type="image/x-icon" />
        <?php endif; ?>




        <?php if (!empty($meta_keywords)): ?>
            <META NAME="keywords" CONTENT="<?php echo htmlspecialchars($meta_keywords, ENT_QUOTES) ?>">
        <?php endif; ?>
        <?php if (!empty($meta_description)): ?>
            <META NAME="Description" CONTENT="<?php echo htmlspecialchars($meta_description, ENT_QUOTES) ?>">
        <?php endif; ?>


        <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>,audio/mpeg; charset=<?php bloginfo('charset'); ?>" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta charset="UTF-8" />


        <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php
        $feedburner = get_option(THEMEMAKERS_THEME_PREFIX . 'feedburner');
        if ($feedburner) {
            echo $feedburner;
        } else {
            bloginfo('rss2_url');
        }
        ?>" />

        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

        <?php wp_head(); ?>


		
		<?php include_once THEMEMAKERS_THEME_PATH . '/ie8.php'; ?>

        <link rel='stylesheet' href='<?php echo bloginfo('stylesheet_url') ?>' type='text/css' media='all' />
		<link rel="stylesheet" href="<?php echo THEMEMAKERS_THEME_URI; ?>/css/custom1.css" type="text/css" media="all" />
        <link rel="stylesheet" href="<?php echo THEMEMAKERS_THEME_URI; ?>/css/custom2.css" type="text/css" media="all" />

       
       
		
        <!--[if lt IE 9]>
                        <script src="http://ie7-js.googlecode.com/svn/version/2.1(beta4)/IE8.js"></script>
        <![endif]-->


        <style type="text/css" media="print">#wpadminbar { display:none; }</style>

        <script type="text/javascript">
            var template_directory = "<?php echo THEMEMAKERS_THEME_URI; ?>/";
            var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
            //translations
            var lang_enter_correctly="<?php _e('Please enter correct', THEMEMAKERS_THEME_FOLDER_NAME); ?>";
            var lang_sended_succsessfully="<?php _e('Your message has been sent successfully!', THEMEMAKERS_THEME_FOLDER_NAME); ?>";
            var lang_server_failed="<?php _e('Server failed. Send later', THEMEMAKERS_THEME_FOLDER_NAME); ?>";
        </script>



        <!-- HTML5 Shiv + detect touch events -->
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/modernizr.custom.js"></script>

    </head>
	<?php
    $page_id = 0;
    if (is_single() OR is_page() OR is_front_page()) {
        global $post;
        $page_id = $post->ID;
    }
    ?>
	 <body <?php body_class('color-1 pattern-1 h-style-1 text-1'); ?> style="<?php echo ThemeMakersHelper::get_page_backround($page_id) ?>">

   

        <!-- ***************** - BEGIN Top Holder - ***************** -->
        <div class="top-holder"></div><!--/ top-holder-->
        <!-- ***************** - END Top Holder - ******************* -->


        <!-- ***************** - BEGIN Wrapper - ******************* -->
        <?php
        $sidebar_position = "";
        $page_sidebar_position = "default";

        if (is_single() OR is_page()) {
            $page_sidebar_position = get_post_meta(get_the_ID(), 'page_sidebar_position', TRUE);
        }

        if (!empty($page_sidebar_position) AND $page_sidebar_position != 'default') {
            $sidebar_position = $page_sidebar_position;
        } else {
            $sidebar_position = get_option(THEMEMAKERS_THEME_PREFIX . "sidebar_position");
        }

        if (!$sidebar_position) {
            $sidebar_position = "sbl";
        }
        ?>




        <div id="wrapper" class="<?php echo $sidebar_position; ?>">

            <!-- ***************** - BEGIN Header - ******************* -->
			
            <header class="clearfix">
				
                <div class="logo">
                    <?php
                    $logo_type = get_option(THEMEMAKERS_THEME_PREFIX . 'logo_type');
                    $logo_text = get_option(THEMEMAKERS_THEME_PREFIX . 'logo_text');
                    $logo_img = get_option(THEMEMAKERS_THEME_PREFIX . 'logo_img');

                    if (!$logo_type AND $logo_text) {
                        ?>
                        <a title="<?php bloginfo('description'); ?>" href="<?php echo home_url(); ?>"><?php echo $logo_text; ?></a>
                    <?php } else if ($logo_type AND $logo_img) { ?>
                        <a title="<?php bloginfo('description'); ?>" href="<?php echo home_url(); ?>"><img src="<?php echo $logo_img; ?>" alt="<?php bloginfo('name'); ?>" /></a>
                    <?php } else { ?>
                        <a title="<?php bloginfo('description'); ?>" href="<?php echo home_url(); ?>"><img src="<?php echo THEMEMAKERS_THEME_URI; ?>/images/logo.png" alt="<?php bloginfo('name'); ?>" /></a>
                    <?php } ?>
                </div>
				
                <div class="info-call">
                    <p><?php echo ThemeMakersHelper::get_contact_information() ?></p>
                </div>
				
            </header>
			
			
            <!-- ***************** - END Header - ******************* -->
			
            <div id="content-wrapper">

                <section id="content">
                    <!-- ************ - BEGIN Navigation - ************** -->
                    <nav class="navigation" id="navigation">

                        <?php wp_nav_menu(array('theme_location' => 'primary', 'container_class' => false)); ?>
                        
                        <?php $hide_search_on_menu = get_option(THEMEMAKERS_THEME_PREFIX . "hide_search_on_menu"); ?>

                        <?php if (!$hide_search_on_menu): ?>
                            <div class="search-top">
                                <?php get_search_form(); ?>
                            </div><!--/ search-top-->
                        <?php endif; ?>

                        <div class="clear"></div>
                    </nav><!--/ navigation-->
                    <!-- ************ - END Navigation - ************** -->

                    <?php if (!is_front_page()) { ?>

                        <?php $hide_breadcrumb = get_option(THEMEMAKERS_THEME_PREFIX . "hide_breadcrumb"); ?>
                        <?php if (!$hide_breadcrumb AND (is_single() OR is_page())): ?>

                            <?php
                            //*****
                            global $post;
                            if (is_object($post)) {
                                $page_settings = Thememakers_Entity_Page_Constructor::get_page_settings($post->ID);
                            }
                            ?>

                            <?php if (!$page_settings['page_slider']): ?>
                                <?php if ($page_settings['page_slider_type'] != 'mosaic'): ?>
                                    <!-- ************ - BEGIN Breadcrumbs - ************** -->
                                    <div id="breadcrumbs">
                                        <a title="<?php _e('Home', THEMEMAKERS_THEME_FOLDER_NAME); ?>" href="<?php bloginfo('url'); ?>"><?php _e('Home', THEMEMAKERS_THEME_FOLDER_NAME); ?></a><?php wp_title('&raquo;'); ?>
                                    </div><!--/ breadcrumbs-->
                                    <!-- ************ - END Breadcrumbs - ************** -->
                                <?php endif; ?>
                            <?php endif; ?>

                        <?php endif; ?>
                    <?php } ?>
					
									<?php get_template_part('slider'); ?>