DROP TABLE wp_commentmeta;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE wp_comments;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO wp_comments VALUES("1","1","Mr WordPress","","http://wordpress.org/","","2014-02-13 15:29:33","2014-02-13 15:29:33","Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.","0","1","","","0","0");
INSERT INTO wp_comments VALUES("2","235","Mr WordPress","","http://wordpress.org/","","2012-08-05 13:35:44","2012-08-05 13:35:44","Hi, this is a comment.<br />To delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.","0","1","","","0","0");
INSERT INTO wp_comments VALUES("3","64","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:50","2012-08-06 10:45:50","Vestibulum aliquet purus vitae turpis sodales pretium. Vivamus fringilla quam at turpis accumsan pulvinar.\n\nIn hac habitasse platea dictumst. Sed nunc orci, bibendum vitae placerat eu, luctus a quam.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("4","64","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:58","2012-08-06 10:45:58","Vestibulum aliquet purus vitae turpis sodales pretium. Vivamus fringilla quam at turpis accumsan pulvinar.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("5","66","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:38","2012-08-06 10:45:38","Vestibulum aliquet purus vitae turpis sodales pretium. Vivamus fringilla quam at turpis accumsan pulvinar.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("6","68","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:38:27","2012-08-06 10:38:27","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("7","68","admin","thethememakers@gmail.com","","","2012-08-06 10:40:52","2012-08-06 10:40:52","Nulla laoreet nulla at tellus varius lacinia. Nullam consequat lorem felis. In varius eleifend lacus","0","1","","","6","1");
INSERT INTO wp_comments VALUES("8","70","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:01","2012-08-06 10:45:01","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("9","70","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:11","2012-08-06 10:45:11","Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("10","70","ThemeMakers","thethememakers@gmail.com","","46.33.253.225","2012-08-06 10:45:21","2012-08-06 10:45:21","Vestibulum aliquet purus vitae turpis sodales pretium. Vivamus fringilla quam at turpis accumsan pulvinar.","0","1","","","0","1");
INSERT INTO wp_comments VALUES("11","70","admin","thethememakers@gmail.com","","","2012-08-07 09:29:52","2012-08-07 09:29:52","Vivamus fringilla quam at turpis accumsan pulvinar. ","0","1","","","9","1");



DROP TABLE wp_links;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE wp_nivoslider4wp;

CREATE TABLE `wp_nivoslider4wp` (
  `nivoslider4wp_id` int(11) NOT NULL AUTO_INCREMENT,
  `nivoslider4wp_type` text COLLATE utf8_unicode_ci,
  `nivoslider4wp_order` int(11) DEFAULT NULL,
  `nivoslider4wp_text_headline` text COLLATE utf8_unicode_ci,
  `nivoslider4wp_x` int(11) DEFAULT NULL,
  `nivoslider4wp_y` int(11) DEFAULT NULL,
  `nivoslider4wp_x2` int(11) DEFAULT NULL,
  `nivoslider4wp_y2` int(11) DEFAULT NULL,
  `nivoslider4wp_w` int(11) DEFAULT NULL,
  `nivoslider4wp_h` int(11) DEFAULT NULL,
  `nivoslider4wp_image_link` text COLLATE utf8_unicode_ci,
  `nivoslider4wp_image_status` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`nivoslider4wp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO wp_nivoslider4wp VALUES("1","jpeg","0","Human Resource Management ","0","0","770","372","770","372","","1");



DROP TABLE wp_options;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=78267 DEFAULT CHARSET=utf8;

INSERT INTO wp_options VALUES("1","siteurl","http://buildtheark.co.ke/new","yes");
INSERT INTO wp_options VALUES("2","blogname","Build The Ark","yes");
INSERT INTO wp_options VALUES("3","blogdescription","BTA","yes");
INSERT INTO wp_options VALUES("4","users_can_register","0","yes");
INSERT INTO wp_options VALUES("5","admin_email","production@softlinkoptions.com","yes");
INSERT INTO wp_options VALUES("6","start_of_week","1","yes");
INSERT INTO wp_options VALUES("7","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("8","use_smilies","1","yes");
INSERT INTO wp_options VALUES("9","require_name_email","","yes");
INSERT INTO wp_options VALUES("10","comments_notify","","yes");
INSERT INTO wp_options VALUES("11","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("16","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("17","default_category","1","yes");
INSERT INTO wp_options VALUES("18","default_comment_status","closed","yes");
INSERT INTO wp_options VALUES("19","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("20","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("21","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("22","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("23","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("28","comment_moderation","1","yes");
INSERT INTO wp_options VALUES("29","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO wp_options VALUES("31","gzipcompression","0","yes");
INSERT INTO wp_options VALUES("32","hack_file","0","yes");
INSERT INTO wp_options VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("34","moderation_keys","","no");
INSERT INTO wp_options VALUES("35","active_plugins","a:3:{i:1;s:41:\"wordpress-importer/wordpress-importer.php\";i:2;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:3;s:27:\"wp-super-cache/wp-cache.php\";}","yes");
INSERT INTO wp_options VALUES("36","home","http://buildtheark.co.ke/new","yes");
INSERT INTO wp_options VALUES("37","category_base","","yes");
INSERT INTO wp_options VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("39","advanced_edit","0","yes");
INSERT INTO wp_options VALUES("40","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("41","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("42","default_email_category","1","yes");
INSERT INTO wp_options VALUES("43","recently_edited","a:5:{i:0;s:65:\"/home/wwwbuild/public_html/new/wp-content/themes/freely/style.css\";i:2;s:67:\"/home/wwwbuild/public_html/new/wp-content/themes/freely/sidebar.php\";i:3;s:69:\"/home/wwwbuild/public_html/new/wp-content/themes/freely/functions.php\";i:4;s:65:\"/home/wwwtests/public_html/bta/wp-content/themes/freely/style.css\";i:5;s:66:\"/home/wwwtests/public_html/bta/wp-content/themes/freely/footer.php\";}","no");
INSERT INTO wp_options VALUES("44","template","freely","yes");
INSERT INTO wp_options VALUES("45","stylesheet","freely","yes");
INSERT INTO wp_options VALUES("46","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("47","blacklist_keys","","no");
INSERT INTO wp_options VALUES("48","comment_registration","1","yes");
INSERT INTO wp_options VALUES("49","html_type","text/html","yes");
INSERT INTO wp_options VALUES("50","use_trackback","0","yes");
INSERT INTO wp_options VALUES("51","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("52","db_version","27916","yes");
INSERT INTO wp_options VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("54","upload_path","","yes");
INSERT INTO wp_options VALUES("55","blog_public","1","yes");
INSERT INTO wp_options VALUES("56","default_link_category","2","yes");
INSERT INTO wp_options VALUES("57","show_on_front","page","yes");
INSERT INTO wp_options VALUES("58","tag_base","","yes");
INSERT INTO wp_options VALUES("59","show_avatars","1","yes");
INSERT INTO wp_options VALUES("60","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("61","upload_url_path","","yes");
INSERT INTO wp_options VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("64","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("65","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("66","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("67","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("68","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("69","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("70","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("71","image_default_size","","yes");
INSERT INTO wp_options VALUES("72","image_default_align","","yes");
INSERT INTO wp_options VALUES("73","close_comments_for_old_posts","","yes");
INSERT INTO wp_options VALUES("74","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("75","thread_comments","1","yes");
INSERT INTO wp_options VALUES("76","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("77","page_comments","","yes");
INSERT INTO wp_options VALUES("78","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("79","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("80","comment_order","asc","yes");
INSERT INTO wp_options VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("82","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("83","widget_text","a:4:{i:2;a:3:{s:5:\"title\";s:14:\"Postal Address\";s:4:\"text\";s:323:\"<p><br><span style=\"color: #716d6d; font-size: 14px;\"><strong>Company Name:</strong> Build the Ark </span></br>\r\n<br><span style=\"color: #716d6d; font-size: 14px;\"><strong>Address:</strong> P.O. BOX 52920-00100 Kasuku Center Kileleshwa, Nairobi Kenya</span></br>\r\n<br><span style=\"color: #716d6d; font-size: 14px;\">\r\n</p>\r\n\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:12:\"Our Location\";s:4:\"text\";s:347:\"<br><span style=\"color: #716d6d; font-size: 14px;\">\r\n<ul>\r\n<li>Build The Ark Limited </li>\r\n<li>Suite No: 3</li>\r\n<li>6th Floor</li>\r\n<li>Silkwood Office Suites</li>\r\n<li>Ngong Road </li>\r\n<li>(Above National Bank of Kenya )</li>\r\n</ul>\r\n</address></span></br>\r\n<p><a href=\"http://buildtheark.co.ke/new/contacts/\">click Here For Directions</a></p>\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:10:\"Let\'s Talk\";s:4:\"text\";s:308:\"<p>\r\n<strong>Telephone:</strong> +254 727 222 444</span></br>\r\n<br><span style=\"color: #716d6d; font-size: 14px;\"><strong>Email Contact:</strong> info[@]buildtheark.co.ke</span></br>\r\n<br><span style=\"color: #716d6d; font-size: 14px;\"><strong>Website Address:</strong> www.buildtheark.co.ke</span></br>\r\n</p>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("84","widget_rss","a:0:{}","yes");
INSERT INTO wp_options VALUES("85","uninstall_plugins","a:1:{s:27:\"wp-super-cache/wp-cache.php\";s:23:\"wpsupercache_deactivate\";}","no");
INSERT INTO wp_options VALUES("86","timezone_string","","yes");
INSERT INTO wp_options VALUES("87","page_for_posts","72","yes");
INSERT INTO wp_options VALUES("88","page_on_front","204","yes");
INSERT INTO wp_options VALUES("89","default_post_format","0","yes");
INSERT INTO wp_options VALUES("90","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("91","initial_db_version","26691","yes");
INSERT INTO wp_options VALUES("92","wp_user_roles","a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:19:\"manage_job_listings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"employer\";a:2:{s:4:\"name\";s:8:\"Employer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;}}}","yes");
INSERT INTO wp_options VALUES("93","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("94","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("95","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("96","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("97","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("98","sidebars_widgets","a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:27:\"thememakers_default_sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:10:\"nav_menu-2\";i:2;s:33:\"thememakers_testimonials_widget-3\";}s:19:\"footer_left_sidebar\";a:1:{i:0;s:6:\"text-4\";}s:21:\"footer_middle_sidebar\";a:1:{i:0;s:6:\"text-3\";}s:20:\"footer_right_sidebar\";a:1:{i:0;s:6:\"text-2\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("99","cron","a:9:{i:1416984206;a:1:{s:19:\"wp_cache_gc_watcher\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1416984267;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1416984910;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1416986876;a:1:{s:34:\"job_manager_check_for_expired_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1416987240;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1416994076;a:1:{s:31:\"job_manager_delete_old_previews\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1417015779;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1417015786;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("125","recently_activated","a:2:{s:49:\"nivo-slider-simplified/nivo_slider_simplified.php\";i:1416921776;s:43:\"nivo-slider-for-wordpress/nivoslider4wp.php\";i:1416920894;}","yes");
INSERT INTO wp_options VALUES("132","ossdl_off_cdn_url","http://buildtheark.co.ke/new","yes");
INSERT INTO wp_options VALUES("133","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO wp_options VALUES("134","ossdl_off_exclude",".php","yes");
INSERT INTO wp_options VALUES("135","ossdl_cname","","yes");
INSERT INTO wp_options VALUES("137","wpsupercache_start","1392305452","yes");
INSERT INTO wp_options VALUES("138","wpsupercache_count","0","yes");
INSERT INTO wp_options VALUES("139","supercache_stats","a:3:{s:9:\"generated\";i:1392305644;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1392305644;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}","yes");
INSERT INTO wp_options VALUES("140","_transient_random_seed","899cfaf2b746b94663f935e6c5826035","yes");
INSERT INTO wp_options VALUES("146","wpsupercache_gc_time","1416983667","yes");
INSERT INTO wp_options VALUES("150","auto_core_update_notified","a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:30:\"production@softlinkoptions.com\";s:7:\"version\";s:5:\"4.0.1\";s:9:\"timestamp\";i:1416797198;}","yes");
INSERT INTO wp_options VALUES("151","_site_transient_timeout_browser_e0acbe6b4333b2774cf2305ecf4cd614","1397737192","yes");
INSERT INTO wp_options VALUES("152","_site_transient_browser_e0acbe6b4333b2774cf2305ecf4cd614","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"32.0.1700.76\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("181","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1397136336;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("182","current_theme","Freely","yes");
INSERT INTO wp_options VALUES("183","theme_mods_freely","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}}","yes");
INSERT INTO wp_options VALUES("184","theme_switched","","yes");
INSERT INTO wp_options VALUES("185","thememakers_theme_was_activated","1","yes");
INSERT INTO wp_options VALUES("186","thememakers_slider_nivo_enable_caption","1","yes");
INSERT INTO wp_options VALUES("187","thememakers_slider_nivo_control_nav","1","yes");
INSERT INTO wp_options VALUES("188","thememakers_slider_accordion_enable_caption","1","yes");
INSERT INTO wp_options VALUES("189","thememakers_slider_rama_enable_caption","1","yes");
INSERT INTO wp_options VALUES("190","thememakers_show_full_content","0","yes");
INSERT INTO wp_options VALUES("191","thememakers_excerpt_symbols_count","140","yes");
INSERT INTO wp_options VALUES("192","thememakers_disable_blog_comments","1","yes");
INSERT INTO wp_options VALUES("193","thememakers_disable_portfolio_comments","1","yes");
INSERT INTO wp_options VALUES("194","thememakers_gallery_height","365","yes");
INSERT INTO wp_options VALUES("195","thememakers_gallery_width","770","yes");
INSERT INTO wp_options VALUES("196","thememakers_portfolio_slider_width","470","yes");
INSERT INTO wp_options VALUES("197","thememakers_disable_content_autoparagraphs","1","yes");
INSERT INTO wp_options VALUES("198","thememakers_disable_content_linebreak","1","yes");
INSERT INTO wp_options VALUES("199","thememakers_sidebar_position","sbl","yes");
INSERT INTO wp_options VALUES("200","thememakers_copyright_text","Copyright © 2014. Build The Ark. All rights reserved","yes");
INSERT INTO wp_options VALUES("280","category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("281","clients_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("282","skills_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("283","gallery_categories_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("444","thememakers_favicon_img","http://buildtheark.co.ke/new/wp-content/uploads/2014/09/favicon.png","yes");
INSERT INTO wp_options VALUES("445","thememakers_logo_type","1","yes");
INSERT INTO wp_options VALUES("446","thememakers_logo_img","http://buildtheark.co.ke/new/wp-content/uploads/2014/09/logo1.png","yes");
INSERT INTO wp_options VALUES("447","thememakers_logo_text","","yes");
INSERT INTO wp_options VALUES("448","thememakers_hide_search_on_menu","0","yes");
INSERT INTO wp_options VALUES("449","thememakers_hide_breadcrumb","0","yes");
INSERT INTO wp_options VALUES("450","thememakers_hide_footer","0","yes");
INSERT INTO wp_options VALUES("451","thememakers_hide_wp_image_sizes","0","yes");
INSERT INTO wp_options VALUES("452","thememakers_custom_css","h5{\r\ncolor: #ff6600;\r\n}\r\nh1{\r\ncolor: #000000;\r\n}","yes");
INSERT INTO wp_options VALUES("453","thememakers_contact_info","","yes");
INSERT INTO wp_options VALUES("454","thememakers_tracking_code","","yes");
INSERT INTO wp_options VALUES("455","thememakers_feedburner","","yes");
INSERT INTO wp_options VALUES("456","thememakers_export_settings","","yes");
INSERT INTO wp_options VALUES("457","thememakers_import_settings","","yes");
INSERT INTO wp_options VALUES("458","thememakers_header_color","#ffffff","yes");
INSERT INTO wp_options VALUES("459","thememakers_disable_header_color","0","yes");
INSERT INTO wp_options VALUES("460","thememakers_header_bg_color","#e0dddd","yes");
INSERT INTO wp_options VALUES("461","thememakers_disable_header_bg_color","0","yes");
INSERT INTO wp_options VALUES("462","thememakers_links_color","#f19330","yes");
INSERT INTO wp_options VALUES("463","thememakers_body_pattern_selected","0","yes");
INSERT INTO wp_options VALUES("464","thememakers_body_pattern","","yes");
INSERT INTO wp_options VALUES("465","thememakers_disable_body_bg","0","yes");
INSERT INTO wp_options VALUES("466","thememakers_heading_font","","yes");
INSERT INTO wp_options VALUES("467","thememakers_h1_font_family","","yes");
INSERT INTO wp_options VALUES("468","thememakers_h1_font_size","0","yes");
INSERT INTO wp_options VALUES("469","thememakers_h2_font_family","","yes");
INSERT INTO wp_options VALUES("470","thememakers_h2_font_size","0","yes");
INSERT INTO wp_options VALUES("471","thememakers_h3_font_family","","yes");
INSERT INTO wp_options VALUES("472","thememakers_h3_font_size","0","yes");
INSERT INTO wp_options VALUES("473","thememakers_h4_font_family","","yes");
INSERT INTO wp_options VALUES("474","thememakers_h4_font_size","0","yes");
INSERT INTO wp_options VALUES("475","thememakers_h5_font_family","","yes");
INSERT INTO wp_options VALUES("476","thememakers_h5_font_size","0","yes");
INSERT INTO wp_options VALUES("477","thememakers_h6_font_family","","yes");
INSERT INTO wp_options VALUES("478","thememakers_h6_font_size","0","yes");
INSERT INTO wp_options VALUES("479","thememakers_main_nav_font","","yes");
INSERT INTO wp_options VALUES("480","thememakers_main_nav_font_size","0","yes");
INSERT INTO wp_options VALUES("481","thememakers_main_nav_def_text_color","#101010","yes");
INSERT INTO wp_options VALUES("482","thememakers_main_nav_curr_text_color","#050000","yes");
INSERT INTO wp_options VALUES("483","thememakers_main_nav_hover_text_color","f1932f","yes");
INSERT INTO wp_options VALUES("484","thememakers_main_nav_def_item_bg_color","","yes");
INSERT INTO wp_options VALUES("485","thememakers_main_nav_curr_item_bg_color","#f1932f","yes");
INSERT INTO wp_options VALUES("486","thememakers_main_nav_hover_item_bg_color","#f1932f","yes");
INSERT INTO wp_options VALUES("487","thememakers_content_fonts","","yes");
INSERT INTO wp_options VALUES("488","thememakers_content_font_family","","yes");
INSERT INTO wp_options VALUES("489","thememakers_content_font_size","14","yes");
INSERT INTO wp_options VALUES("490","thememakers_content_text_color","#716d6d","yes");
INSERT INTO wp_options VALUES("491","thememakers_content_link_color","#f1932f","yes");
INSERT INTO wp_options VALUES("492","thememakers_content_link_hover_color","#787878","yes");
INSERT INTO wp_options VALUES("493","thememakers_buttons_font_family","Verdana","yes");
INSERT INTO wp_options VALUES("494","thememakers_buttons_font_size","0","yes");
INSERT INTO wp_options VALUES("495","thememakers_buttons_text_color","#f1932f","yes");
INSERT INTO wp_options VALUES("496","thememakers_widgets_heading_font_family","","yes");
INSERT INTO wp_options VALUES("497","thememakers_widgets_heading_font_size","0","yes");
INSERT INTO wp_options VALUES("498","thememakers_widget_def_title_color","#1A1A1B","yes");
INSERT INTO wp_options VALUES("499","thememakers_widget_def_title_bg_color","#ECECEC","yes");
INSERT INTO wp_options VALUES("500","thememakers_widget_def_text_color","#787878","yes");
INSERT INTO wp_options VALUES("501","thememakers_widget_def_bg_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("502","thememakers_widget_def_link_color","#f1932f","yes");
INSERT INTO wp_options VALUES("503","thememakers_widget_def_link_hover_color","#f1932f","yes");
INSERT INTO wp_options VALUES("504","thememakers_widget_colored_bg_color","#f1932f","yes");
INSERT INTO wp_options VALUES("505","thememakers_widget_colored_title_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("506","thememakers_widget_colored_title_bg_color","#85B602","yes");
INSERT INTO wp_options VALUES("507","thememakers_widget_colored_text_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("508","thememakers_widget_colored_link_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("509","thememakers_widget_colored_link_hover_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("510","thememakers_widget_colored_testimonials_text_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("511","thememakers_widget_colored_testimonials_author_text_color","#f1932f","yes");
INSERT INTO wp_options VALUES("512","thememakers_widget_colored_testimonials_bg_color","","yes");
INSERT INTO wp_options VALUES("513","thememakers_image_frame_bg_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("514","thememakers_image_frame_bg_hover_color","#8F8F8F","yes");
INSERT INTO wp_options VALUES("515","thememakers_image_frame_border_color","#E0E0E0","yes");
INSERT INTO wp_options VALUES("516","thememakers_image_frame_border_color_hover","#E0E0E0","yes");
INSERT INTO wp_options VALUES("517","thememakers_footer_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("518","thememakers_disable_footer_color","0","yes");
INSERT INTO wp_options VALUES("519","thememakers_footer_bg_color","","yes");
INSERT INTO wp_options VALUES("520","thememakers_disable_footer_bg_color","0","yes");
INSERT INTO wp_options VALUES("521","thememakers_footer_widget_title_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("522","thememakers_disable_footer_widget_title_color","0","yes");
INSERT INTO wp_options VALUES("523","thememakers_slider_circle_slide_width","770","yes");
INSERT INTO wp_options VALUES("524","thememakers_slider_height_option","372","yes");
INSERT INTO wp_options VALUES("525","thememakers_slider_nivo_autoslide","7038","yes");
INSERT INTO wp_options VALUES("526","thememakers_slider_nivo_transition_speed","1869","yes");
INSERT INTO wp_options VALUES("527","thememakers_slider_nivo_transition_effect","boxRain","yes");
INSERT INTO wp_options VALUES("528","thememakers_slider_nivo_random_start","0","yes");
INSERT INTO wp_options VALUES("529","thememakers_slider_nivo_pause_on_hover","1","yes");
INSERT INTO wp_options VALUES("530","thememakers_slider_nivo_direction_nav","0","yes");
INSERT INTO wp_options VALUES("531","thememakers_slider_nivo_direction_nav_hide","0","yes");
INSERT INTO wp_options VALUES("532","thememakers_slider_nivo_manual_advance","0","yes");
INSERT INTO wp_options VALUES("533","thememakers_slider_nivo_slide_width","770","yes");
INSERT INTO wp_options VALUES("534","thememakers_slider_nivo_thumb_slide_width","200","yes");
INSERT INTO wp_options VALUES("535","thememakers_slider_nivo_box_rows","4","yes");
INSERT INTO wp_options VALUES("536","thememakers_slider_nivo_box_cols","8","yes");
INSERT INTO wp_options VALUES("537","thememakers_slider_nivo_slices","15","yes");
INSERT INTO wp_options VALUES("538","thememakers_slider_nivo_start_slide","0","yes");
INSERT INTO wp_options VALUES("539","thememakers_slider_accordion_delay","3000","yes");
INSERT INTO wp_options VALUES("540","thememakers_slider_accordion_transition_speed","600","yes");
INSERT INTO wp_options VALUES("541","thememakers_slider_accordion_auto_play","0","yes");
INSERT INTO wp_options VALUES("542","thememakers_slider_accordion_pause_on_hover","0","yes");
INSERT INTO wp_options VALUES("543","thememakers_slider_accordion_expanded_width","60","yes");
INSERT INTO wp_options VALUES("544","thememakers_slider_accordion_bg_height","340","yes");
INSERT INTO wp_options VALUES("545","thememakers_slider_accordion_caption_color","","yes");
INSERT INTO wp_options VALUES("546","thememakers_slider_accordion_easing","swing","yes");
INSERT INTO wp_options VALUES("547","thememakers_slider_accordion_stop_at_end","0","yes");
INSERT INTO wp_options VALUES("548","thememakers_slider_rama_autoslide","6000","yes");
INSERT INTO wp_options VALUES("549","thememakers_slider_rama_width","770","yes");
INSERT INTO wp_options VALUES("550","thememakers_slider_rama_transition_effect","random","yes");
INSERT INTO wp_options VALUES("551","thememakers_slider_rama_content_effect","fade","yes");
INSERT INTO wp_options VALUES("552","thememakers_slider_mosaic_color","#C6E346","yes");
INSERT INTO wp_options VALUES("553","thememakers_slider_mosaic_frame_width","770","yes");
INSERT INTO wp_options VALUES("554","thememakers_slider_mosaic_tiles_x","6","yes");
INSERT INTO wp_options VALUES("555","thememakers_slider_mosaic_tiles_y","11","yes");
INSERT INTO wp_options VALUES("556","thememakers_slider_mosaic_tile_border","1","yes");
INSERT INTO wp_options VALUES("557","thememakers_slider_mosaic_tile_border_color","#FFFFFF","yes");
INSERT INTO wp_options VALUES("558","thememakers_slider_mosaic_effect_intensity","0.5","yes");
INSERT INTO wp_options VALUES("559","thememakers_sliders","a:1:{i:29;a:2:{s:4:\"name\";s:9:\"Home Page\";s:7:\"options\";a:3:{i:2;a:6:{s:5:\"image\";s:69:\"http://buildtheark.co.ke/new/wp-content/uploads/2014/05/strategy1.jpg\";s:5:\"title\";s:23:\"Human Resource Strategy\";s:8:\"subtitle\";s:8:\"Planning\";s:11:\"description\";s:136:\"Human resources planning is a process that identifies current and future human resources needs for an organization to achieve its goals.\";s:4:\"link\";s:0:\"\";s:10:\"additional\";a:4:{s:17:\"slide_title_color\";s:0:\"\";s:20:\"slide_subtitle_color\";s:0:\"\";s:23:\"slide_description_color\";s:0:\"\";s:4:\"rama\";a:3:{s:12:\"slide_effect\";s:0:\"\";s:12:\"title_effect\";s:0:\"\";s:18:\"description_effect\";s:0:\"\";}}}i:1;a:6:{s:5:\"image\";s:75:\"http://buildtheark.co.ke/new/wp-content/uploads/2014/04/human_resources.jpg\";s:5:\"title\";s:22:\"Performance Management\";s:8:\"subtitle\";s:4:\"(PM)\";s:11:\"description\";s:136:\"Performance management (PM) includes activities which ensure that goals are consistently being met in an effective and efficient manner.\";s:4:\"link\";s:0:\"\";s:10:\"additional\";a:4:{s:17:\"slide_title_color\";s:0:\"\";s:20:\"slide_subtitle_color\";s:0:\"\";s:23:\"slide_description_color\";s:0:\"\";s:4:\"rama\";a:3:{s:12:\"slide_effect\";s:0:\"\";s:12:\"title_effect\";s:0:\"\";s:18:\"description_effect\";s:0:\"\";}}}i:0;a:6:{s:5:\"image\";s:85:\"http://buildtheark.co.ke/new/wp-content/uploads/2014/09/Human-Resource-Management.jpg\";s:5:\"title\";s:25:\"Human Resource Management\";s:8:\"subtitle\";s:17:\"HRM, or simply HR\";s:11:\"description\";s:124:\"A function in organizations designed to maximize employee performance in service of their employer’s strategic objectives.\";s:4:\"link\";s:0:\"\";s:10:\"additional\";a:4:{s:17:\"slide_title_color\";s:0:\"\";s:20:\"slide_subtitle_color\";s:0:\"\";s:23:\"slide_description_color\";s:0:\"\";s:4:\"rama\";a:3:{s:12:\"slide_effect\";s:0:\"\";s:12:\"title_effect\";s:0:\"\";s:18:\"description_effect\";s:0:\"\";}}}}}}","yes");
INSERT INTO wp_options VALUES("560","thememakers_blog_layout","default","yes");
INSERT INTO wp_options VALUES("561","thememakers_enable_related_posts","0","yes");
INSERT INTO wp_options VALUES("562","thememakers_show_author_info","0","yes");
INSERT INTO wp_options VALUES("563","thememakers_hide_post_metadata","0","yes");
INSERT INTO wp_options VALUES("564","thememakers_gallery_hide_filter","0","yes");
INSERT INTO wp_options VALUES("565","thememakers_thememakers_sidebars","a:0:{}","yes");
INSERT INTO wp_options VALUES("566","thememakers_meta_title_home","","yes");
INSERT INTO wp_options VALUES("567","thememakers_meta_keywords_home","","yes");
INSERT INTO wp_options VALUES("568","thememakers_meta_description_home","","yes");
INSERT INTO wp_options VALUES("569","thememakers_meta_title_post_listing","","yes");
INSERT INTO wp_options VALUES("570","thememakers_meta_keywords_post_listing","","yes");
INSERT INTO wp_options VALUES("571","thememakers_meta_description_post_listing","","yes");
INSERT INTO wp_options VALUES("572","thememakers_meta_title_portfolio_listing","","yes");
INSERT INTO wp_options VALUES("573","thememakers_meta_keywords_portfolio_listing","","yes");
INSERT INTO wp_options VALUES("574","thememakers_meta_description_portfolio_listing","","yes");
INSERT INTO wp_options VALUES("575","thememakers_meta_title_gallery_listing","","yes");
INSERT INTO wp_options VALUES("576","thememakers_meta_keywords_gallery_listing","","yes");
INSERT INTO wp_options VALUES("577","thememakers_meta_description_gallery_listing","","yes");
INSERT INTO wp_options VALUES("578","thememakers_thememakers_seo_groups","a:1:{i:0;a:5:{s:4:\"name\";s:0:\"\";s:5:\"title\";s:0:\"\";s:8:\"keywords\";s:0:\"\";s:11:\"description\";s:0:\"\";s:3:\"cat\";a:1:{i:0;s:2:\"-1\";}}}","yes");
INSERT INTO wp_options VALUES("1724","db_upgraded","","yes");
INSERT INTO wp_options VALUES("2298","can_compress_scripts","1","yes");
INSERT INTO wp_options VALUES("2309","_site_transient_timeout_wordpress_credits_en_US","1397820603","yes");
INSERT INTO wp_options VALUES("2310","_site_transient_wordpress_credits_en_US","a:2:{s:6:\"groups\";a:6:{s:15:\"project-leaders\";a:4:{s:4:\"name\";s:15:\"Project Leaders\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:6:{s:4:\"ryan\";a:4:{i:0;s:10:\"Ryan Boren\";i:1;s:32:\"c22398fb9602c967d1dac8174f4a1a4e\";i:2;s:4:\"ryan\";i:3;s:14:\"Lead Developer\";}s:11:\"markjaquith\";a:4:{i:0;s:12:\"Mark Jaquith\";i:1;s:32:\"097a87a525e317519b5ee124820012fb\";i:2;s:11:\"markjaquith\";i:3;s:14:\"Lead Developer\";}s:4:\"matt\";a:4:{i:0;s:14:\"Matt Mullenweg\";i:1;s:32:\"767fc9c115a1b989744c755db47feb60\";i:2;s:4:\"matt\";i:3;s:23:\"Cofounder, Project Lead\";}s:5:\"nacin\";a:4:{i:0;s:12:\"Andrew Nacin\";i:1;s:32:\"01cfe9feaafb068590891bbd1f6a7f5a\";i:2;s:5:\"nacin\";i:3;s:14:\"Lead Developer\";}s:6:\"azaozz\";a:4:{i:0;s:10:\"Andrew Ozz\";i:1;s:32:\"4e84843ebff0918d72ade21c6ee7b1e4\";i:2;s:6:\"azaozz\";i:3;s:14:\"Lead Developer\";}s:5:\"westi\";a:4:{i:0;s:14:\"Peter Westwood\";i:1;s:32:\"5b3b5ce04dd402124aba53142b3e47f6\";i:2;s:5:\"westi\";i:3;s:14:\"Lead Developer\";}}}s:15:\"core-developers\";a:4:{s:4:\"name\";s:23:\"Contributing Developers\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:0;s:4:\"data\";a:6:{s:4:\"dd32\";a:4:{i:0;s:10:\"Dion Hulse\";i:1;s:32:\"fa63bbe285f64ba10985551154474e25\";i:2;s:4:\"dd32\";i:3;s:14:\"Core Developer\";}s:4:\"koop\";a:4:{i:0;s:17:\"Daryl Koopersmith\";i:1;s:32:\"26671c19c0d5722d0b1c101fd9d35175\";i:2;s:4:\"koop\";i:3;s:14:\"Core Developer\";}s:5:\"duck_\";a:4:{i:0;s:8:\"Jon Cave\";i:1;s:32:\"c422d58d80cf37281d34221f21a4a557\";i:2;s:5:\"duck_\";i:3;s:14:\"Core Developer\";}s:5:\"helen\";a:4:{i:0;s:16:\"Helen Hou-Sandí\";i:1;s:32:\"6506162ada6b700b151ad8a187f65842\";i:2;s:5:\"helen\";i:3;s:14:\"Core Developer\";}s:7:\"ocean90\";a:4:{i:0;s:17:\"Dominik Schilling\";i:1;s:32:\"3e8e161d97d793bd8fc2dcd62583bb76\";i:2;s:7:\"ocean90\";i:3;s:0:\"\";}s:14:\"SergeyBiryukov\";a:4:{i:0;s:15:\"Sergey Biryukov\";i:1;s:32:\"750b7b0fcd855389264c2b1294d61bd6\";i:2;s:14:\"SergeyBiryukov\";i:3;s:0:\"\";}}}s:23:\"contributing-developers\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:6:{s:14:\"wonderboymusic\";a:4:{i:0;s:12:\"Scott Taylor\";i:1;s:32:\"0e9fc8ea22885ed718ee37d31dcffb8c\";i:2;s:14:\"wonderboymusic\";i:3;s:0:\"\";}s:11:\"johnbillion\";a:4:{i:0;s:15:\"John Blackbourn\";i:1;s:32:\"0000ba6dd1b089e1746abbfe6281ee3b\";i:2;s:11:\"johnbillion\";i:3;s:0:\"\";}s:12:\"DrewAPicture\";a:4:{i:0;s:11:\"Drew Jaynes\";i:1;s:32:\"95c934fa2c3362794bf62ff8c59ada08\";i:2;s:12:\"DrewAPicture\";i:3;s:0:\"\";}s:12:\"lancewillett\";a:4:{i:0;s:13:\"Lance Willett\";i:1;s:32:\"ddc339d9565077190a08a9e5da7a5f44\";i:2;s:12:\"lancewillett\";i:3;s:0:\"\";}s:6:\"gcorne\";a:4:{i:0;s:17:\"Gregory Cornelius\";i:1;s:32:\"16836597f6d030b7ea01750a33e058df\";i:2;s:6:\"gcorne\";i:3;s:0:\"\";}s:11:\"DH-Shredder\";a:4:{i:0;s:13:\"Mike Schroder\";i:1;s:32:\"76424a001dc6b3ebb4faca0c567800c4\";i:2;s:11:\"DH-Shredder\";i:3;s:0:\"\";}}}s:16:\"recent-rockstars\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:18:{s:15:\"adamsilverstein\";a:4:{i:0;s:16:\"Adam Silverstein\";i:1;s:32:\"08001a0a424aed1382375a446ed690d6\";i:2;s:15:\"adamsilverstein\";i:3;s:0:\"\";}s:5:\"avryl\";a:4:{i:0;s:17:\"Janneke Van Dorpe\";i:1;s:32:\"7c9d3a0262734566951c66a12c9a7720\";i:2;s:5:\"avryl\";i:3;s:0:\"\";}s:3:\"ehg\";a:4:{i:0;s:12:\"Chris Blower\";i:1;s:32:\"dac3fa4f660db27bff792344b3d1df34\";i:2;s:3:\"ehg\";i:3;s:0:\"\";}s:13:\"EmpireOfLight\";a:4:{i:0;s:10:\"Ben Dunkle\";i:1;s:32:\"1772cd53f2747f71c8455ac820606afc\";i:2;s:13:\"EmpireOfLight\";i:3;s:0:\"\";}s:8:\"ethitter\";a:4:{i:0;s:12:\"Erick Hitter\";i:1;s:32:\"fcf17d516139b240f405706d6fc8fc10\";i:2;s:8:\"ethitter\";i:3;s:0:\"\";}s:10:\"jeremyfelt\";a:4:{i:0;s:11:\"Jeremy Felt\";i:1;s:32:\"d1759b1c669981b7c52ec9a97d19e6bd\";i:2;s:10:\"jeremyfelt\";i:3;s:0:\"\";}s:6:\"jorbin\";a:4:{i:0;s:12:\"Aaron Jorbin\";i:1;s:32:\"b3e2b94eb305bf95a1bee11bc7705fb7\";i:2;s:6:\"jorbin\";i:3;s:0:\"\";}s:9:\"kovshenin\";a:4:{i:0;s:20:\"Konstantin Kovshenin\";i:1;s:32:\"8585b20b69e8ff4b0ba737accfdbb31b\";i:2;s:9:\"kovshenin\";i:3;s:0:\"\";}s:8:\"kpdesign\";a:4:{i:0;s:11:\"Kim Parsell\";i:1;s:32:\"c2f7f079b6d2610c97715b55f12b5ba5\";i:2;s:8:\"kpdesign\";i:3;s:0:\"\";}s:6:\"matveb\";a:4:{i:0;s:15:\"Matías Ventura\";i:1;s:32:\"3f8389957d0c59bb0bd5433e86b53a19\";i:2;s:6:\"matveb\";i:3;s:0:\"\";}s:4:\"mcsf\";a:4:{i:0;s:14:\"Miguel Fonseca\";i:1;s:32:\"7e89b8105f7e05afa2872e411d3f76ad\";i:2;s:4:\"mcsf\";i:3;s:0:\"\";}s:9:\"melchoyce\";a:4:{i:0;s:10:\"Mel Choyce\";i:1;s:32:\"2dc245d4cf9e5579dfb0e13e7dcb75db\";i:2;s:9:\"melchoyce\";i:3;s:0:\"\";}s:15:\"michael-arestad\";a:4:{i:0;s:15:\"Michael Arestad\";i:1;s:32:\"46e0f1b10224bb4e832ea9633acee2b8\";i:2;s:15:\"michael-arestad\";i:3;s:0:\"\";}s:8:\"obenland\";a:4:{i:0;s:19:\"Konstantin Obenland\";i:1;s:32:\"2370ea5912750f4cb0f3c51ae1cbca55\";i:2;s:8:\"obenland\";i:3;s:0:\"\";}s:5:\"pento\";a:4:{i:0;s:15:\"Gary Pendergast\";i:1;s:32:\"1ad9e5c98d81c6815a65dab5b6e1f669\";i:2;s:5:\"pento\";i:3;s:0:\"\";}s:12:\"shaunandrews\";a:4:{i:0;s:13:\"Shaun Andrews\";i:1;s:32:\"b7fdd6477cc13ca16e8358a0725bc02c\";i:2;s:12:\"shaunandrews\";i:3;s:0:\"\";}s:8:\"smashcut\";a:4:{i:0;s:12:\"Michael Pick\";i:1;s:32:\"b6ebbee8aa2ee353cd189fa0071df169\";i:2;s:8:\"smashcut\";i:3;s:0:\"\";}s:11:\"westonruter\";a:4:{i:0;s:12:\"Weston Ruter\";i:1;s:32:\"22ed378fbf1d918ef43a45b2a1f34634\";i:2;s:11:\"westonruter\";i:3;s:0:\"\";}}}s:5:\"props\";a:4:{s:4:\"name\";s:33:\"Core Contributors to WordPress %s\";s:12:\"placeholders\";a:1:{i:0;s:3:\"3.9\";}s:4:\"type\";s:4:\"list\";s:4:\"data\";a:238:{s:13:\"aaroncampbell\";s:17:\"Aaron D. Campbell\";s:7:\"kawauso\";s:11:\"Adam Harley\";s:7:\"adelval\";s:7:\"adelval\";s:4:\"ajay\";s:4:\"Ajay\";s:5:\"akeda\";s:11:\"Akeda Bagus\";s:6:\"xknown\";s:11:\"Alex Concha\";s:5:\"aliso\";s:14:\"Alison Barrett\";s:15:\"collinsinternet\";s:13:\"Allan Collins\";s:8:\"sabreuse\";s:22:\"Amy Hendrix (sabreuse)\";s:7:\"afercia\";s:13:\"Andrea Fercia\";s:8:\"norcross\";s:15:\"Andrew Norcross\";s:5:\"rarst\";s:24:\"Andrey \"Rarst\" Savchenko\";s:9:\"andykeith\";s:10:\"Andy Keith\";s:4:\"andy\";s:12:\"Andy Skelton\";s:7:\"atimmer\";s:16:\"Anton Timmermans\";s:9:\"aubreypwd\";s:15:\"Aubrey Portwood\";s:5:\"barry\";s:5:\"Barry\";s:7:\"toszcze\";s:18:\"Bartosz Romanowski\";s:8:\"bassgang\";s:8:\"bassgang\";s:7:\"bcworkz\";s:7:\"bcworkz\";s:13:\"empireoflight\";s:10:\"Ben Dunkle\";s:5:\"neoxx\";s:14:\"Bernhard Riedl\";s:9:\"bigdawggi\";s:9:\"bigdawggi\";s:11:\"bobbingwide\";s:11:\"bobbingwide\";s:9:\"bobbravo2\";s:10:\"Bob Gregor\";s:9:\"bradparbs\";s:9:\"bradparbs\";s:5:\"bradt\";s:14:\"Brad Touesnard\";s:5:\"bramd\";s:5:\"bramd\";s:7:\"kraftbj\";s:13:\"Brandon Kraft\";s:9:\"brasofilo\";s:9:\"brasofilo\";s:9:\"bravokeyl\";s:9:\"bravokeyl\";s:6:\"bpetty\";s:11:\"Bryan Petty\";s:7:\"cgaffga\";s:7:\"cgaffga\";s:12:\"chiragswadia\";s:13:\"Chirag Swadia\";s:6:\"chouby\";s:6:\"Chouby\";s:12:\"chriseverson\";s:12:\"chriseverson\";s:14:\"chrisguitarguy\";s:14:\"chrisguitarguy\";s:10:\"c3mdigital\";s:14:\"Chris Olbekson\";s:10:\"chrisscott\";s:11:\"Chris Scott\";s:6:\"cfinke\";s:17:\"Christopher Finke\";s:7:\"ciantic\";s:7:\"ciantic\";s:12:\"cmmarslender\";s:12:\"cmmarslender\";s:8:\"antorome\";s:21:\"Comparativa de Bancos\";s:8:\"cojennin\";s:15:\"Connor Jennings\";s:6:\"corphi\";s:6:\"Corphi\";s:14:\"corvannoorloos\";s:16:\"Cor van Noorloos\";s:10:\"cramdesign\";s:10:\"cramdesign\";s:15:\"danielbachhuber\";s:16:\"Daniel Bachhuber\";s:10:\"redsweater\";s:27:\"Daniel Jalkut (Red Sweater)\";s:11:\"dannydehaan\";s:13:\"Danny de Haan\";s:6:\"dpe415\";s:5:\"DaveE\";s:9:\"eightface\";s:23:\"Dave Kellam (eightface)\";s:13:\"davidakennedy\";s:16:\"David A. Kennedy\";s:13:\"davidanderson\";s:14:\"David Anderson\";s:13:\"davidmarichal\";s:14:\"David Marichal\";s:17:\"denis-de-bernardy\";s:17:\"Denis de Bernardy\";s:12:\"dougwollison\";s:13:\"Doug Wollison\";s:12:\"drewapicture\";s:26:\"Drew Jaynes (DrewAPicture)\";s:11:\"drprotocols\";s:11:\"DrProtocols\";s:6:\"dustyf\";s:16:\"Dustin Filippini\";s:11:\"eatingrules\";s:11:\"eatingrules\";s:6:\"plocha\";s:4:\"edik\";s:10:\"eliorivero\";s:11:\"Elio Rivero\";s:4:\"enej\";s:4:\"enej\";s:9:\"ericlewis\";s:17:\"Eric Andrew Lewis\";s:8:\"evarlese\";s:13:\"Erica Varlese\";s:8:\"ericmann\";s:9:\"Eric Mann\";s:11:\"ejdanderson\";s:13:\"Evan Anderson\";s:9:\"fahmiadib\";s:5:\"Fahmi\";s:8:\"fboender\";s:8:\"fboender\";s:11:\"frank-klein\";s:11:\"Frank Klein\";s:7:\"garyc40\";s:8:\"Gary Cao\";s:5:\"garyj\";s:10:\"Gary Jones\";s:8:\"genkisan\";s:8:\"genkisan\";s:10:\"soulseekah\";s:17:\"Gennady Kovshenin\";s:15:\"georgestephanis\";s:16:\"George Stephanis\";s:14:\"grahamarmfield\";s:15:\"Graham Armfield\";s:8:\"vancoder\";s:13:\"Grant Mangham\";s:6:\"tivnet\";s:17:\"Gregory Karpinsky\";s:5:\"hakre\";s:5:\"hakre\";s:5:\"hanni\";s:5:\"hanni\";s:8:\"ippetkov\";s:8:\"ippetkov\";s:7:\"ipstenu\";s:22:\"Ipstenu (Mika Epstein)\";s:8:\"jdgrimes\";s:11:\"J.D. Grimes\";s:12:\"jackreichert\";s:13:\"Jack Reichert\";s:9:\"_jameslee\";s:8:\"jameslee\";s:7:\"janrenn\";s:7:\"janrenn\";s:5:\"jaycc\";s:5:\"JayCC\";s:11:\"jeffsebring\";s:12:\"Jeff Sebring\";s:7:\"jenmylo\";s:8:\"Jen Mylo\";s:5:\"jesin\";s:7:\"Jesin A\";s:6:\"jayjdk\";s:24:\"Jesper Johansen (jayjdk)\";s:14:\"jnielsendotnet\";s:14:\"jnielsendotnet\";s:6:\"jartes\";s:10:\"Joan Artes\";s:9:\"joedolson\";s:10:\"Joe Dolson\";s:8:\"joehoyle\";s:9:\"Joe Hoyle\";s:15:\"johnjamesjacoby\";s:17:\"John James Jacoby\";s:10:\"johnpbloch\";s:13:\"John P. Bloch\";s:10:\"johnregan3\";s:10:\"John Regan\";s:6:\"jond3r\";s:23:\"Jonas Bolinder (jond3r)\";s:11:\"joostdevalk\";s:13:\"Joost de Valk\";s:7:\"shelob9\";s:12:\"Josh Pollock\";s:14:\"joshuaabenazer\";s:15:\"Joshua Abenazer\";s:10:\"jstraitiff\";s:10:\"jstraitiff\";s:8:\"juliobox\";s:12:\"Julio Potier\";s:9:\"kopepasah\";s:16:\"Justin Kopepasah\";s:13:\"justinsainton\";s:14:\"Justin Sainton\";s:10:\"kadamwhite\";s:12:\"K.Adam White\";s:7:\"trepmal\";s:16:\"Kailey (trepmal)\";s:8:\"kasparsd\";s:7:\"Kaspars\";s:6:\"ryelle\";s:10:\"Kelly Dwan\";s:7:\"kerikae\";s:7:\"kerikae\";s:12:\"kworthington\";s:17:\"Kevin Worthington\";s:6:\"kwight\";s:10:\"Kirk Wight\";s:7:\"kitchin\";s:7:\"kitchin\";s:7:\"klihelp\";s:7:\"klihelp\";s:6:\"knutsp\";s:13:\"Knut Sparhell\";s:6:\"drozdz\";s:15:\"Krzysiek Drozdz\";s:11:\"leewillis77\";s:10:\"Lee Willis\";s:7:\"lkwdwrd\";s:7:\"lkwdwrd\";s:8:\"lpointet\";s:8:\"lpointet\";s:8:\"spmlucas\";s:13:\"Lucas Karpiuk\";s:10:\"ldebrouwer\";s:14:\"Luc De Brouwer\";s:11:\"mark8barnes\";s:11:\"Mark Barnes\";s:12:\"markoheijnen\";s:13:\"Marko Heijnen\";s:9:\"marventus\";s:9:\"Marventus\";s:13:\"iammattthomas\";s:20:\"Matt (Thomas) Miklic\";s:7:\"mjbanks\";s:10:\"Matt Banks\";s:7:\"mboynes\";s:14:\"Matthew Boynes\";s:6:\"mdbitz\";s:14:\"Matthew Denton\";s:7:\"mattheu\";s:20:\"Matthew Haines-Young\";s:11:\"mattonomics\";s:11:\"mattonomics\";s:8:\"mattyrob\";s:8:\"mattyrob\";s:9:\"maxcutler\";s:10:\"Max Cutler\";s:8:\"mcadwell\";s:8:\"mcadwell\";s:7:\"meloniq\";s:7:\"meloniq\";s:10:\"michelwppi\";s:22:\"Michel - xiligroup dev\";s:8:\"gradyetc\";s:10:\"Mike Burns\";s:10:\"mikecorkum\";s:10:\"mikecorkum\";s:12:\"mikehansenme\";s:11:\"Mike Hansen\";s:10:\"mikemanger\";s:11:\"Mike Manger\";s:12:\"mikeschinkel\";s:13:\"Mike Schinkel\";s:11:\"dh-shredder\";s:13:\"Mike Schroder\";s:15:\"mitchoyoshitaka\";s:35:\"mitcho (Michael Yoshitaka Erlewine)\";s:6:\"batmoo\";s:15:\"Mohammad Jangda\";s:11:\"morganestes\";s:12:\"Morgan Estes\";s:5:\"mor10\";s:22:\"Morten Rand-Hendriksen\";s:3:\"Nao\";s:12:\"Naoko Takano\";s:7:\"alex-ye\";s:14:\"Nashwan Doaqan\";s:8:\"nendeb55\";s:8:\"nendeb55\";s:16:\"celloexpressions\";s:11:\"Nick Halsey\";s:25:\"nicolealleyinteractivecom\";s:13:\"Nicole Arnold\";s:4:\"nikv\";s:19:\"Nikhil Vimal (NikV)\";s:7:\"nivijah\";s:7:\"nivijah\";s:9:\"nofearinc\";s:9:\"nofearinc\";s:14:\"nunomorgadinho\";s:15:\"Nuno Morgadinho\";s:5:\"olivm\";s:5:\"olivM\";s:5:\"jbkkd\";s:11:\"Omer Korner\";s:11:\"originalexe\";s:11:\"OriginalEXE\";s:10:\"oso96_2000\";s:10:\"oso96_2000\";s:11:\"patricknami\";s:11:\"patricknami\";s:6:\"djpaul\";s:10:\"Paul Gibbs\";s:9:\"paulwilde\";s:10:\"Paul Wilde\";s:9:\"pavelevap\";s:9:\"pavelevap\";s:7:\"pbearne\";s:7:\"Pbearne\";s:17:\"philiparthurmoore\";s:19:\"Philip Arthur Moore\";s:7:\"mordauk\";s:17:\"Pippin Williamson\";s:11:\"nprasath002\";s:17:\"Prasath Nadarajah\";s:11:\"prettyboymp\";s:11:\"prettyboymp\";s:7:\"raamdev\";s:8:\"Raam Dev\";s:11:\"rachelbaker\";s:11:\"rachelbaker\";s:11:\"ramonchiara\";s:11:\"ramonchiara\";s:11:\"mauryaratan\";s:16:\"Ram Ratan Maurya\";s:6:\"ounziw\";s:18:\"Rescuework Support\";s:9:\"rhyswynne\";s:10:\"Rhys Wynne\";s:14:\"ricardocorreia\";s:15:\"Ricardo Correia\";s:11:\"richard2222\";s:11:\"richard2222\";s:10:\"theorboman\";s:15:\"Richard Sweeney\";s:11:\"iamfriendly\";s:12:\"Richard Tape\";s:8:\"rickalee\";s:20:\"Ricky Lee Whittemore\";s:11:\"miqrogroove\";s:13:\"Robert Chapin\";s:9:\"robmiller\";s:9:\"robmiller\";s:13:\"rodrigosprimo\";s:13:\"Rodrigo Primo\";s:13:\"romaimperator\";s:13:\"romaimperator\";s:10:\"roothorick\";s:10:\"roothorick\";s:8:\"ruudjoyo\";s:9:\"ruud@joyo\";s:6:\"rmccue\";s:10:\"Ryan McCue\";s:7:\"salcode\";s:7:\"salcode\";s:6:\"otto42\";s:18:\"Samuel Wood (Otto)\";s:6:\"sandyr\";s:7:\"Sandeep\";s:8:\"scottlee\";s:9:\"Scott Lee\";s:11:\"coffee2code\";s:12:\"Scott Reilly\";s:8:\"greglone\";s:12:\"ScreenfeedFr\";s:6:\"scribu\";s:6:\"scribu\";s:6:\"sdasse\";s:6:\"sdasse\";s:6:\"bootsz\";s:10:\"Sean Butze\";s:10:\"seanchayes\";s:10:\"Sean Hayes\";s:10:\"nessworthy\";s:15:\"Sean Nessworthy\";s:14:\"sergeybiryukov\";s:15:\"Sergey Biryukov\";s:10:\"shahpranaf\";s:10:\"shahpranaf\";s:9:\"shinichin\";s:9:\"ShinichiN\";s:5:\"pross\";s:13:\"Simon Prosser\";s:13:\"simonwheatley\";s:14:\"Simon Wheatley\";s:7:\"siobhan\";s:7:\"Siobhan\";s:7:\"siobhyb\";s:24:\"Siobhan Bamber (siobhyb)\";s:8:\"sirzooro\";s:8:\"sirzooro\";s:12:\"solarissmoke\";s:12:\"solarissmoke\";s:8:\"sonjanyc\";s:8:\"sonjanyc\";s:14:\"spencerfinnell\";s:15:\"Spencer Finnell\";s:11:\"piontkowski\";s:19:\"Spencer Piontkowski\";s:11:\"stephcook22\";s:11:\"stephcook22\";s:6:\"netweb\";s:13:\"Stephen Edgar\";s:13:\"stephenharris\";s:14:\"Stephen Harris\";s:7:\"sbruner\";s:12:\"Steve Bruner\";s:11:\"stevenkword\";s:11:\"Steven Word\";s:8:\"miyauchi\";s:17:\"Takayuki Miyauchi\";s:8:\"tanner-m\";s:14:\"Tanner Moushey\";s:8:\"tlovett1\";s:13:\"Taylor Lovett\";s:6:\"tbrams\";s:6:\"tbrams\";s:10:\"tellyworth\";s:10:\"tellyworth\";s:8:\"tobiasbg\";s:8:\"TobiasBg\";s:8:\"tomauger\";s:9:\"Tom Auger\";s:7:\"willmot\";s:11:\"Tom Willmot\";s:13:\"topher1kenobe\";s:6:\"Topher\";s:9:\"topquarky\";s:9:\"topquarky\";s:10:\"zodiac1978\";s:18:\"Torsten Landsiedel\";s:4:\"toru\";s:4:\"Toru\";s:7:\"wpsmith\";s:12:\"Travis Smith\";s:11:\"umeshsingla\";s:11:\"Umesh Kumar\";s:18:\"undergroundnetwork\";s:18:\"undergroundnetwork\";s:8:\"varunagw\";s:8:\"VarunAgw\";s:5:\"wawco\";s:5:\"wawco\";s:8:\"wokamoto\";s:8:\"wokamoto\";s:6:\"xsonic\";s:6:\"xsonic\";s:5:\"yoavf\";s:10:\"Yoav Farhi\";s:10:\"yurivictor\";s:11:\"Yuri Victor\";s:9:\"zbtirrell\";s:12:\"Zach Tirrell\";s:13:\"vanillalounge\";s:13:\"Ze Fontainhas\";}}s:9:\"libraries\";a:3:{s:4:\"name\";s:18:\"External Libraries\";s:4:\"type\";s:9:\"libraries\";s:4:\"data\";a:28:{i:0;a:2:{i:0;s:11:\"Backbone.js\";i:1;s:22:\"http://backbonejs.org/\";}i:1;a:2:{i:0;s:10:\"Class POP3\";i:1;s:24:\"http://squirrelmail.org/\";}i:2;a:2:{i:0;s:16:\"Color Animations\";i:1;s:39:\"http://plugins.jquery.com/project/color\";}i:3;a:2:{i:0;s:15:\"Horde Text Diff\";i:1;s:22:\"http://pear.horde.org/\";}i:4;a:2:{i:0;s:11:\"hoverIntent\";i:1;s:45:\"http://plugins.jquery.com/project/hoverIntent\";}i:5;a:2:{i:0;s:13:\"imgAreaSelect\";i:1;s:42:\"http://odyniec.net/projects/imgareaselect/\";}i:6;a:2:{i:0;s:4:\"Iris\";i:1;s:34:\"https://github.com/Automattic/Iris\";}i:7;a:2:{i:0;s:6:\"jQuery\";i:1;s:18:\"http://jquery.com/\";}i:8;a:2:{i:0;s:9:\"jQuery UI\";i:1;s:20:\"http://jqueryui.com/\";}i:9;a:2:{i:0;s:14:\"jQuery Hotkeys\";i:1;s:41:\"https://github.com/tzuryby/jquery.hotkeys\";}i:10;a:2:{i:0;s:22:\"jQuery serializeObject\";i:1;s:49:\"http://benalman.com/projects/jquery-misc-plugins/\";}i:11;a:2:{i:0;s:12:\"jQuery.query\";i:1;s:46:\"http://plugins.jquery.com/project/query-object\";}i:12;a:2:{i:0;s:14:\"jQuery.suggest\";i:1;s:41:\"http://plugins.jquery.com/project/suggest\";}i:13;a:2:{i:0;s:21:\"jQuery UI Touch Punch\";i:1;s:27:\"http://touchpunch.furf.com/\";}i:14;a:2:{i:0;s:5:\"json2\";i:1;s:43:\"https://github.com/douglascrockford/JSON-js\";}i:15;a:2:{i:0;s:7:\"Masonry\";i:1;s:28:\"http://masonry.desandro.com/\";}i:16;a:2:{i:0;s:15:\"MediaElement.js\";i:1;s:26:\"http://mediaelementjs.com/\";}i:17;a:2:{i:0;s:6:\"PclZip\";i:1;s:33:\"http://www.phpconcept.net/pclzip/\";}i:18;a:2:{i:0;s:6:\"PemFTP\";i:1;s:50:\"http://www.phpclasses.org/browse/package/1743.html\";}i:19;a:2:{i:0;s:6:\"phpass\";i:1;s:31:\"http://www.openwall.com/phpass/\";}i:20;a:2:{i:0;s:9:\"PHPMailer\";i:1;s:55:\"http://code.google.com/a/apache-extras.org/p/phpmailer/\";}i:21;a:2:{i:0;s:8:\"Plupload\";i:1;s:24:\"http://www.plupload.com/\";}i:22;a:2:{i:0;s:9:\"SimplePie\";i:1;s:21:\"http://simplepie.org/\";}i:23;a:2:{i:0;s:27:\"The Incutio XML-RPC Library\";i:1;s:34:\"http://scripts.incutio.com/xmlrpc/\";}i:24;a:2:{i:0;s:8:\"Thickbox\";i:1;s:32:\"http://jquery.com/demo/thickbox/\";}i:25;a:2:{i:0;s:7:\"TinyMCE\";i:1;s:23:\"http://www.tinymce.com/\";}i:26;a:2:{i:0;s:13:\"Underscore.js\";i:1;s:24:\"http://underscorejs.org/\";}i:27;a:2:{i:0;s:6:\"zxcvbn\";i:1;s:30:\"https://github.com/lowe/zxcvbn\";}}}}s:4:\"data\";a:2:{s:8:\"profiles\";s:32:\"http://profiles.wordpress.org/%s\";s:7:\"version\";s:3:\"3.9\";}}","yes");
INSERT INTO wp_options VALUES("3105","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("3346","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("3380","widget_thememakers_testimonials_widget","a:2:{i:3;a:2:{s:5:\"title\";s:12:\"Testimonials\";s:5:\"pause\";i:7000;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("5644","_site_transient_timeout_browser_29b40f21f2d9eeb05784514a1981eb17","1400762819","yes");
INSERT INTO wp_options VALUES("5645","_site_transient_browser_29b40f21f2d9eeb05784514a1981eb17","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"34.0.1847.131\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("6872","_site_transient_timeout_browser_9a6fdb1686542e60272eb428c19dff9e","1400847438","yes");
INSERT INTO wp_options VALUES("6873","_site_transient_browser_9a6fdb1686542e60272eb428c19dff9e","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"34.0.1847.137\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("12540","thememakers_contact_form","a:1:{s:13:\"537e283047aad\";a:6:{s:9:\"inique_id\";s:13:\"537e283047aad\";s:5:\"title\";s:10:\"Contact Us\";s:11:\"has_capture\";s:1:\"1\";s:13:\"submit_button\";s:6:\"vinous\";s:15:\"recepient_email\";s:22:\"info@buildtheark.co.ke\";s:6:\"inputs\";a:4:{s:13:\"54741aae99d4f\";a:4:{s:4:\"type\";s:9:\"textinput\";s:5:\"label\";s:4:\"Name\";s:7:\"options\";s:0:\"\";s:11:\"is_required\";s:1:\"1\";}s:13:\"54741aae99dd5\";a:4:{s:4:\"type\";s:5:\"email\";s:5:\"label\";s:10:\"Your Email\";s:7:\"options\";s:0:\"\";s:11:\"is_required\";s:1:\"1\";}s:13:\"54741aae99e58\";a:4:{s:4:\"type\";s:7:\"subject\";s:5:\"label\";s:15:\"Message Subject\";s:7:\"options\";s:0:\"\";s:11:\"is_required\";s:1:\"0\";}s:13:\"54741aae99eda\";a:4:{s:4:\"type\";s:11:\"messagebody\";s:5:\"label\";s:7:\"Message\";s:7:\"options\";s:0:\"\";s:11:\"is_required\";s:1:\"1\";}}}}","yes");
INSERT INTO wp_options VALUES("12541","thememakers_contact_form_index","537e283047aad","yes");
INSERT INTO wp_options VALUES("12666","widget_nav_menu","a:2:{i:2;a:2:{s:5:\"title\";s:11:\"Our Sevices\";s:8:\"nav_menu\";i:19;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("13552","widget_thememakers_social_links_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("28143","_site_transient_timeout_browser_22c42b2ceb6de606267824dc00fce28e","1401954923","yes");
INSERT INTO wp_options VALUES("28144","_site_transient_browser_22c42b2ceb6de606267824dc00fce28e","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"29.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("30301","job_listing_type_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("30302","job_manager_installed_terms","1","yes");
INSERT INTO wp_options VALUES("30303","wp_job_manager_version","1.13.0","yes");
INSERT INTO wp_options VALUES("30309","job_manager_per_page","10","yes");
INSERT INTO wp_options VALUES("30310","job_manager_hide_filled_positions","","yes");
INSERT INTO wp_options VALUES("30311","job_manager_enable_categories","1","yes");
INSERT INTO wp_options VALUES("30312","job_manager_enable_registration","1","yes");
INSERT INTO wp_options VALUES("30313","job_manager_registration_role","employer","yes");
INSERT INTO wp_options VALUES("30314","job_manager_user_requires_account","1","yes");
INSERT INTO wp_options VALUES("30315","job_manager_submission_requires_approval","1","yes");
INSERT INTO wp_options VALUES("30316","job_manager_submission_duration","30","yes");
INSERT INTO wp_options VALUES("30317","job_manager_allowed_application_method","","yes");
INSERT INTO wp_options VALUES("30318","job_manager_submit_page_slug","","yes");
INSERT INTO wp_options VALUES("30416","_transient_timeout_settings_errors","1416921401","no");
INSERT INTO wp_options VALUES("30417","_transient_settings_errors","a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:15:\"Settings saved.\";s:4:\"type\";s:7:\"updated\";}}","no");
INSERT INTO wp_options VALUES("33432","_site_transient_timeout_browser_737f46a40394f7fb142f04cf52341754","1403257814","yes");
INSERT INTO wp_options VALUES("33433","_site_transient_browser_737f46a40394f7fb142f04cf52341754","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"35.0.1916.114\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("36896","_site_transient_timeout_browser_95d0083943ccc9d51de44d12ec4bf603","1406194027","yes");
INSERT INTO wp_options VALUES("36897","_site_transient_browser_95d0083943ccc9d51de44d12ec4bf603","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"35.0.1916.153\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("36932","job_manager_job_dashboard_page_slug","","yes");
INSERT INTO wp_options VALUES("37425","_site_transient_timeout_browser_00556b0801fc900830c4816319ef64ed","1411557632","yes");
INSERT INTO wp_options VALUES("37426","_site_transient_browser_00556b0801fc900830c4816319ef64ed","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"37.0.2062.120\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("49734","_site_transient_timeout_browser_09bf974da0437925889a226ba456ba86","1412662813","yes");
INSERT INTO wp_options VALUES("49735","_site_transient_browser_09bf974da0437925889a226ba456ba86","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"37.0.2062.124\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("52054","_site_transient_timeout_browser_bb1188c24caf0735ac8baf653734af25","1412681118","yes");
INSERT INTO wp_options VALUES("52055","_site_transient_browser_bb1188c24caf0735ac8baf653734af25","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"24.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("52122","_site_transient_timeout_browser_8efa52fbb9c4c46940e54b0dae76d8ba","1412682019","yes");
INSERT INTO wp_options VALUES("52123","_site_transient_browser_8efa52fbb9c4c46940e54b0dae76d8ba","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"32.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("67081","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.0.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.0.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.0.1\";s:7:\"version\";s:5:\"4.0.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.0.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.0.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.0.1\";s:7:\"version\";s:5:\"4.0.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";s:12:\"notify_email\";s:1:\"1\";s:13:\"support_email\";s:26:\"updatehelp40@wordpress.org\";}}s:12:\"last_checked\";i:1416972628;s:15:\"version_checked\";s:5:\"3.9.3\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("67183","_site_transient_timeout_browser_a4ea0db2b94a6cf44d272efba3913ead","1417436877","yes");
INSERT INTO wp_options VALUES("67184","_site_transient_browser_a4ea0db2b94a6cf44d272efba3913ead","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"39.0.2171.65\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("67200","_transient_timeout_plugin_slugs","1417008177","no");
INSERT INTO wp_options VALUES("67201","_transient_plugin_slugs","a:10:{i:0;s:19:\"akismet/akismet.php\";i:1;s:9:\"hello.php\";i:2;s:19:\"jetpack/jetpack.php\";i:3;s:41:\"mojo-marketplace-vps/mojo-marketplace.php\";i:4;s:43:\"nivo-slider-for-wordpress/nivoslider4wp.php\";i:5;s:49:\"nivo-slider-simplified/nivo_slider_simplified.php\";i:6;s:41:\"wordpress-importer/wordpress-importer.php\";i:7;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:8;s:33:\"wp-job-manager/wp-job-manager.php\";i:9;s:27:\"wp-super-cache/wp-cache.php\";}","no");
INSERT INTO wp_options VALUES("68532","_site_transient_timeout_browser_f05cbaddf52af981235a6b0eed2888e5","1417500618","yes");
INSERT INTO wp_options VALUES("68533","_site_transient_browser_f05cbaddf52af981235a6b0eed2888e5","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"38.0.2125.111\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("70412","_site_transient_timeout_browser_eee3e4bdb5f0463dbfd12ae3f16cdc42","1417515668","yes");
INSERT INTO wp_options VALUES("70413","_site_transient_browser_eee3e4bdb5f0463dbfd12ae3f16cdc42","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"33.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("72283","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1416930463","yes");
INSERT INTO wp_options VALUES("72284","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"4690\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"2907\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"2823\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2344\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2238\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1804\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1619\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1591\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1569\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1533\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1496\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1485\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1403\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1236\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1183\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1133\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1081\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1027\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1018\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"849\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"844\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"838\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"806\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"798\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"747\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"710\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"709\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"673\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"663\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"631\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"626\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"623\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"619\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"613\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"600\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"572\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"564\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"561\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"554\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"553\";}}","yes");
INSERT INTO wp_options VALUES("72312","nivoslider4wp_width","770","yes");
INSERT INTO wp_options VALUES("72313","nivoslider4wp_height","372","yes");
INSERT INTO wp_options VALUES("72314","nivoslider4wp_colsBox","4","yes");
INSERT INTO wp_options VALUES("72315","nivoslider4wp_rowsBox","2","yes");
INSERT INTO wp_options VALUES("72316","nivoslider4wp_animSpeed","500","yes");
INSERT INTO wp_options VALUES("72317","nivoslider4wp_effect","boxRandom","yes");
INSERT INTO wp_options VALUES("72318","nivoslider4wp_pauseTime","3000","yes");
INSERT INTO wp_options VALUES("72319","nivoslider4wp_directionNav","true","yes");
INSERT INTO wp_options VALUES("72320","nivoslider4wp_directionNavHide","true","yes");
INSERT INTO wp_options VALUES("72321","nivoslider4wp_controlNav","false","yes");
INSERT INTO wp_options VALUES("72322","nivoslider4wp_keyboardNav","true","yes");
INSERT INTO wp_options VALUES("72323","nivoslider4wp_pauseOnHover","true","yes");
INSERT INTO wp_options VALUES("72324","nivoslider4wp_manualAdvance","false","yes");
INSERT INTO wp_options VALUES("72325","nivoslider4wp_backgroundCaption","000000","yes");
INSERT INTO wp_options VALUES("72326","nivoslider4wp_colorCaption","ffffff","yes");
INSERT INTO wp_options VALUES("72327","nivoslider4wp_captionOpacity","0.8","yes");
INSERT INTO wp_options VALUES("72328","nivoslider4wp_nivoslider4wp_js","footer","yes");
INSERT INTO wp_options VALUES("72329","nivoslider4wp_imageQuality","80","yes");
INSERT INTO wp_options VALUES("72403","nivoslider4wp_js","head","yes");
INSERT INTO wp_options VALUES("77259","_site_transient_timeout_theme_roots","1416974428","yes");
INSERT INTO wp_options VALUES("77260","_site_transient_theme_roots","a:4:{s:6:\"freely\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}","yes");
INSERT INTO wp_options VALUES("77261","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1416972630;s:7:\"checked\";a:4:{s:6:\"freely\";s:5:\"1.2.0\";s:14:\"twentyfourteen\";s:3:\"1.0\";s:14:\"twentythirteen\";s:3:\"1.1\";s:12:\"twentytwelve\";s:3:\"1.3\";}s:8:\"response\";a:3:{s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfourteen\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.2.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentythirteen\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.1.3.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:41:\"https://wordpress.org/themes/twentytwelve\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.1.5.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("77262","_site_transient_update_plugins","O:8:\"stdClass\":3:{s:12:\"last_checked\";i:1416972629;s:8:\"response\";a:5:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.0.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.0.3.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.2.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.2.1.zip\";}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"37091\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.1.8\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.1.8.zip\";}s:33:\"wp-job-manager/wp-job-manager.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41501\";s:4:\"slug\";s:14:\"wp-job-manager\";s:6:\"plugin\";s:33:\"wp-job-manager/wp-job-manager.php\";s:11:\"new_version\";s:6:\"1.18.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-job-manager/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/wp-job-manager.1.18.0.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:14:\"upgrade_notice\";s:91:\"Fixed &quot;acceptable file list&quot; and no caching for GET queries bugs in last release.\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.2.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("78200","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1417026838","no");
INSERT INTO wp_options VALUES("78201","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:51:\"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 19:04:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=4.1-beta2-30575\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.0.1 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 18:55:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3363\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"WordPress 4.0.1 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>WordPress 4.0.1 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be updated to 3.9.3, 3.8.5, or 3.7.5 to keep everything secure. (We don’t support older versions, so please update to 4.0.1 for the latest and greatest.)</p>\n<p>WordPress versions 3.9.2 and earlier are affected by a critical cross-site scripting vulnerability, which could enable anonymous users to compromise a site. This was reported by <a href=\"http://klikki.fi/\">Jouko Pynnonen</a>. This issue does not affect version 4.0, but version 4.0.1 does address these eight security issues:</p>\n<ul>\n<li>Three cross-site scripting issues that a contributor or author could use to compromise a site. Discovered by <a href=\"http://joncave.co.uk/\">Jon Cave</a>, <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, and <a href=\"https://johnblackbourn.com/\">John Blackbourn</a> of the WordPress security team.</li>\n<li>A cross-site request forgery that could be used to trick a user into changing their password.</li>\n<li>An issue that could lead to a denial of service when passwords are checked. Reported by <a href=\"http://www.behindthefirewalls.com/\">Javier Nieto Arevalo</a> and <a href=\"http://www.devconsole.info/\">Andres Rojas Guerrero</a>.</li>\n<li>Additional protections for server-side request forgery attacks when WordPress makes HTTP requests. Reported by Ben Bidner (vortfu).</li>\n<li>An extremely unlikely hash collision could allow a user&#8217;s account to be compromised, that also required that they haven&#8217;t logged in since 2008 (I wish I were kidding). Reported by <a href=\"http://david.dw-perspective.org.uk\">David Anderson</a>.</li>\n<li>WordPress now invalidates the links in a password reset email if the user remembers their password, logs in, and changes their email address. Reported separately by <a href=\"https://twitter.com/MomenBassel\">Momen Bassel</a>, <a href=\"http://c0dehouse.blogspot.in/\">Tanoy Bose</a>, and <a href=\"https://managewp.com/\">Bojan Slavković of ManageWP</a>.</li>\n</ul>\n<p>Version 4.0.1 also fixes 23 bugs with 4.0, and we&#8217;ve made two hardening changes, including better validation of EXIF data we are extracting from uploaded photos. Reported by <a href=\"http://www.securesolutions.no/\">Chris Andrè Dale</a>.</p>\n<p>We appreciated the <a href=\"https://codex.wordpress.org/FAQ_Security\">responsible disclosure</a> of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.0.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.0?rev=30475&amp;stop_rev=29710\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.0.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click “Update Now”.</p>\n<p><em>Already testing WordPress 4.1? The second beta is now available (<a href=\"https://wordpress.org/wordpress-4.1-beta2.zip\">zip</a>) and it contains these security fixes. For more on 4.1, see <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">the beta 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.1 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 22:35:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3352\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"Welcome, everyone, to WordPress 4.1 Beta 1! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the WordPress Beta Tester plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3409:\"<p>Welcome, everyone, to WordPress 4.1 Beta 1!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"//wordpress.org/wordpress-4.1-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.1 is due for release next month, so we need your help with testing. Here are some highlights of what to test:</p>\n<ul>\n<li>Our beautiful new default theme, <a href=\"https://make.wordpress.org/core/2014/09/09/twenty-fifteen/\">Twenty Fifteen</a>. It&#8217;s a clean, mobile-first, blog-focused theme designed through simplicity.</li>\n<li>A new <a href=\"https://make.wordpress.org/core/2014/11/11/focus-v2-demo-video/\">distraction-free writing mode for the editor</a>. It&#8217;s enabled by default for beta, and we&#8217;d love feedback on it.</li>\n<li>The ability to automatically install new language packs right from the General Settings screen (available as long as your site&#8217;s filesystem is writable).</li>\n<li>A new inline formatting toolbar for images embedded into posts.</li>\n</ul>\n<p>There have been a lot of changes for developers to test as well:</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2014/10/20/update-on-query-improvements-in-4-1/\">Improvements to meta, date, comment, and taxonomy queries</a>, including complex (nested, multiple relation) queries; and querying comment types (<a href=\"https://core.trac.wordpress.org/ticket/12668\">#12668</a>).</li>\n<li>A single term shared across multiple taxonomies is now split into two when updated. For more, <a href=\"https://make.wordpress.org/core/2014/11/12/an-update-on-the-taxonomy-roadmap/\">see this post</a>, <a href=\"https://core.trac.wordpress.org/ticket/5809\">#5809</a>, and <a href=\"https://core.trac.wordpress.org/ticket/30335\">#30335</a>.</li>\n<li>A new and better way for <a href=\"https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/\">themes to handle title tags</a>.</li>\n<li>Several <a href=\"https://make.wordpress.org/core/2014/10/27/toward-a-complete-javascript-api-for-the-customizer/\">improvements to the Customizer API</a>, including contextual panels and sections, and JavaScript templates for controls.</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.1, <a href=\"https://make.wordpress.org/core/tag/week-in-core/\">check out the weekly review posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.1\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Twenty Fifteen theme</em><br />\n<em> The beautiful face which hides</em><br />\n<em> Many improvements</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Watch WordCamp San Francisco Livestream\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/10/wcsf-livestream/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/10/wcsf-livestream/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Oct 2014 20:18:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3341\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordCamp San Francisco is the official annual WordPress conference, gathering the community every year since 2006. This is the time when Matt Mullenweg addresses the community in his annual State of the Word presentation – a recap of  the year in WordPress and giving us a glimpse into its future. This year the speaker lineup is stellar. There will be talks by [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nikolay Bachiyski\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1975:\"<p><a title=\"2014 edition\" href=\"http://2014.sf.wordcamp.org\">WordCamp San Francisco</a> is the official annual WordPress conference, gathering the community every year <a title=\"An old website for a WordPress long time ago\" href=\"http://2006.sf.wordcamp.org\">since 2006</a>. This is the time when Matt Mullenweg addresses the community in his annual <a href=\"http://wordpress.tv/?s=state+of+the+word\">State of the Word</a> presentation – a recap of  the year in WordPress and giving us a glimpse into its future.</p>\n<p>This year the speaker lineup is stellar. There will be talks by three of the lead WordPress developers: <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-andrew-nacin\">Andrew Nacin</a>, <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-helen-hou-sandi\">Helen Hou-Sandí</a>, and <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-mark-jaquith\">Mark Jaquith</a>. We’re also looking forward to speakers like <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jenny-lawson\">Jenny Lawson</a>, also known as The Bloggess, and <a href=\"http://2014.sf.wordcamp.org/speaker/chris-lema/\">Chris Lema</a>. If you’re at all interested in the web, you will appreciate the appearance of <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jeff-veen\">Jeff Veen</a> – one of the creators of Google Analytics and co-founder of Typekit.</p>\n<p>Even though San Francisco is far far away for most of you, you can still be part of the fun and watch all presentations in real-time via livestream:</p>\n<p><a href=\"http://2014.sf.wordcamp.org/tickets/\">Get a livestream ticket and watch all talks from WordCamp San Francisco live</a></p>\n<p>If you hurry, you can get one of the special livestream tickets, including a WordCamp San Francisco 2104 t-shirt. You can find all the technical details and start times <a href=\"http://2014.sf.wordcamp.org/live-stream/\">at the WordCamp San Francisco website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/10/wcsf-livestream/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.0 “Benny”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2014/09/benny/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/news/2014/09/benny/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Sep 2014 17:05:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3296\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader Benny Goodman, is available for download or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23538:\"<p>Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader <a href=\"http://en.wikipedia.org/wiki/Benny_Goodman\">Benny Goodman</a>, is available <a href=\"https://wordpress.org/download/\">for download</a> or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience we think you&#8217;ll enjoy.</p>\n<div id=\"v-bUdzKMro-1\" class=\"video-player\"><embed id=\"v-bUdzKMro-1-video\" src=\"https://v0.wordpress.com/player.swf?v=1.03&amp;guid=bUdzKMro&amp;isDynamicSeeking=true\" type=\"application/x-shockwave-flash\" width=\"692\" height=\"388\" title=\"Introducing WordPress 4.0 &quot;Benny&quot;\" wmode=\"direct\" seamlesstabbing=\"true\" allowfullscreen=\"true\" allowscriptaccess=\"always\" overstretch=\"true\"></embed></div>\n<hr />\n<h2 style=\"text-align: center\">Manage your media with style</h2>\n<p><img class=\"alignnone size-full wp-image-3316\" src=\"https://wordpress.org/news/files/2014/09/media.jpg\" alt=\"Media Library\" width=\"1000\" height=\"586\" />Explore your uploads in a beautiful, endless grid. A new details preview makes viewing and editing any amount of media in sequence a snap.</p>\n<hr />\n<h2 style=\"text-align: center\">Working with embeds has never been easier</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3296-1\" width=\"632\" height=\"445\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/embed.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/embed.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/embed.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.0/embed.mp4\">//s.w.org/images/core/4.0/embed.mp4</a></video></div>\n<p>Paste in a YouTube URL on a new line, and watch it magically become an embedded video. Now try it with a tweet. Oh yeah — embedding has become a visual experience. The editor shows a true preview of your embedded content, saving you time and giving you confidence.</p>\n<p>We’ve expanded the services supported by default, too — you can embed videos from CollegeHumor, playlists from YouTube, and talks from TED. <a href=\"https://codex.wordpress.org/Embeds\">Check out all of the embeds</a> that WordPress supports.</p>\n<hr />\n<h2 style=\"text-align: center\">Focus on your content</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-3296-2\" width=\"632\" height=\"356\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/focus.mp4?_=2\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/focus.webm?_=2\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/focus.ogv?_=2\" /><a href=\"//s.w.org/images/core/4.0/focus.mp4\">//s.w.org/images/core/4.0/focus.mp4</a></video></div>\n<p>Writing and editing is smoother and more immersive with an editor that expands to fit your content as you write, and keeps the formatting tools available at all times.</p>\n<hr />\n<h2 style=\"text-align: center\">Finding the right plugin</h2>\n<p><img class=\"aligncenter size-large wp-image-3309\" src=\"https://wordpress.org/news/files/2014/09/add-plugin1-1024x600.png\" alt=\"Add plugins\" width=\"692\" height=\"405\" /></p>\n<p>There are more than 30,000 free and open source plugins in the WordPress plugin directory. WordPress 4.0 makes it easier to find the right one for your needs, with new metrics, improved search, and a more visual browsing experience.</p>\n<hr />\n<h2 style=\"text-align: center\">The Ensemble</h2>\n<p>This release was led by <a href=\"http://helenhousandi.com\">Helen Hou-Sandí</a>, with the help of these fine individuals. There are 275 contributors with props in this release, a new high. Pull up some Benny Goodman on your music service of choice, as a bandleader or in one of his turns as a classical clarinetist, and check out some of their profiles:</p>\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/alexanderrohmann\">Alexander Rohmann</a>, <a href=\"https://profiles.wordpress.org/aliso\">Alison Barrett</a>, <a href=\"https://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"https://profiles.wordpress.org/amit\">Amit Gupta</a>, <a href=\"https://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrezrv\">Andres Villarreal</a>, <a href=\"https://profiles.wordpress.org/zamfeer\">Andrew Mowe</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro (sumobi)</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/arnee\">arnee</a>, <a href=\"https://profiles.wordpress.org/aubreypwd\">Aubrey Portwood</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/camdensegal\">Camden Segal</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">chrisl27</a>, <a href=\"https://profiles.wordpress.org/caxelsson\">Christian Axelsson</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/boda1982\">Christopher Spires</a>, <a href=\"https://profiles.wordpress.org/clifgriffin\">Clifton Griffin</a>, <a href=\"https://profiles.wordpress.org/jupiterwise\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/ghost1227\">Dan Griffiths</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danielhuesken\">Daniel Husken</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"https://profiles.wordpress.org/dkotter\">Darin Kotter</a>, <a href=\"https://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dnaber-de\">David Naber</a>, <a href=\"https://profiles.wordpress.org/davidthemachine\">DavidTheMachine</a>, <a href=\"https://profiles.wordpress.org/debaat\">DeBAAT</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donncha\">Donncha O Caoimh</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustyn\">Dustyn Doyle</a>, <a href=\"https://profiles.wordpress.org/eddiemoya\">Eddie Moya</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/edwin-at-studiojoyocom\">Edwin Siebel</a>, <a href=\"https://profiles.wordpress.org/ehg\">ehg</a>, <a href=\"https://profiles.wordpress.org/tmeister\">Enrique Chavez</a>, <a href=\"https://profiles.wordpress.org/erayalakese\">erayalakese</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/ejdanderson\">Evan Anderson</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fab1en</a>, <a href=\"https://profiles.wordpress.org/fahmiadib\">Fahmi Adib</a>, <a href=\"https://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/garhdez\">garhdez</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/garza\">garza</a>, <a href=\"https://profiles.wordpress.org/gauravmittal1995\">gauravmittal1995</a>, <a href=\"https://profiles.wordpress.org/gavra\">Gavrisimo</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/vancoder\">Grant Mangham</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/harrym\">harrym</a>, <a href=\"https://profiles.wordpress.org/hebbet\">hebbet</a>, <a href=\"https://profiles.wordpress.org/hinnerk\">Hinnerk Altenburg</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/iljoja\">iljoja</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/issuu\">issuu</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jackreichert\">Jack Reichert</a>, <a href=\"https://profiles.wordpress.org/jacobdubail\">Jacob Dubail</a>, <a href=\"https://profiles.wordpress.org/janhenkg\">JanHenkG</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/jwenerd\">Jared Wenerd</a>, <a href=\"https://profiles.wordpress.org/jaza613\">Jaza613</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/slimndap\">Jeroen Schmit</a>, <a href=\"https://profiles.wordpress.org/jerrysarcastic\">Jerry Bates (jerrysarcastic)</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jesper800\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jessepollak\">Jesse Pollak</a>, <a href=\"https://profiles.wordpress.org/jgadbois\">jgadbois</a>, <a href=\"https://profiles.wordpress.org/jartes\">Joan Artes</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnzanussi\">John Zanussi</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/softmodeling\">Jordi Cabot</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/tai\">JOTAKI Taisuke</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kaito</a>, <a href=\"https://profiles.wordpress.org/kapeels\">kapeels</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kworthington\">Kevin Worthington</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">krogsgard</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"https://profiles.wordpress.org/layotte\">Lew Ayotte</a>, <a href=\"https://profiles.wordpress.org/lritter\">lritter</a>, <a href=\"https://profiles.wordpress.org/lukecarbis\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/m_i_n\">m_i_n</a>, <a href=\"https://profiles.wordpress.org/funkatronic\">Manny Fleurmond</a>, <a href=\"https://profiles.wordpress.org/targz-1\">Manuel Schmalstieg</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/sivel\">Matt Martz</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mdbitz\">Matthew Denton</a>, <a href=\"https://profiles.wordpress.org/mattheweppelsheimer\">Matthew Eppelsheimer</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/meekyhwang\">meekyhwang</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/midxcat\">midxcat</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikemanger\">Mike Manger</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mrmist\">mrmist</a>, <a href=\"https://profiles.wordpress.org/m_uysl\">Mustafa Uysal</a>, <a href=\"https://profiles.wordpress.org/muvimotv\">MuViMoTV</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/namibia\">Namibia</a>, <a href=\"https://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"https://profiles.wordpress.org/nd987\">nd987</a>, <a href=\"https://profiles.wordpress.org/neil_pie\">Neil Pie</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/schoenwaldnils\">Nils Schonwald</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/nvwd\">Nowell VanHoesen</a>, <a href=\"https://profiles.wordpress.org/compute\">Patrick Hesselberg</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pdclark\">Paul Clark</a>, <a href=\"https://profiles.wordpress.org/paulschreiber\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/philipjohn\">Philip John</a>, <a href=\"https://profiles.wordpress.org/senlin\">Piet Bos</a>, <a href=\"https://profiles.wordpress.org/psoluch\">Piotr Soluch</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/purzlbaum\">purzlbaum</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/rob1n\">rob1n</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/harmr\">RobertHarm</a>, <a href=\"https://profiles.wordpress.org/rohan013\">Rohan Rawat</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sammybeats\">Sam Brodie</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sathishn\">Sathish Nagarajan</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/greglone\">ScreenfeedFr</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/nessworthy\">Sean Nessworthy</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej Muller</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanebp\">shanebp</a>, <a href=\"https://profiles.wordpress.org/sharonaustin\">Sharon Austin</a>, <a href=\"https://profiles.wordpress.org/shaunandrews\">Shaun Andrews</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/simonp303\">simonp303</a>, <a href=\"https://profiles.wordpress.org/slobodanmanic\">Slobodan Manic</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"https://profiles.wordpress.org/sphoid\">sphoid</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stompweb\">Steven Jones</a>, <a href=\"https://profiles.wordpress.org/strangerstudios\">strangerstudios</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/t4k1s\">t4k1s</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/taylorde\">Taylor Dewey</a>, <a href=\"https://profiles.wordpress.org/thomasvanderbeek\">Thomas van der Beek</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till</a>, <a href=\"https://profiles.wordpress.org/codenameeli\">Tim \'Eli\' Dalbey</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/willmot\">Tom Willmot</a>, <a href=\"https://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"https://profiles.wordpress.org/torresga\">torresga</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/treyhunner\">treyhunner</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/vinod-dalvi\">Vinod Dalvi</a>, <a href=\"https://profiles.wordpress.org/vlajos\">vlajos</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/winterdev\">winterDev</a>, <a href=\"https://profiles.wordpress.org/wojtekszkutnik\">Wojtek Szkutnik</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, and <a href=\"https://profiles.wordpress.org/zoerooney\">Zoe Rooney</a>. Also thanks to <a href=\"http://michaelpick.wordpress.com/\">Michael Pick</a> for producing the release video, and Helen with <a href=\"http://adriansandi.com\">Adrián Sandí</a> for the music.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.1!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/news/2014/09/benny/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.0 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Aug 2014 12:20:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3287\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"The first release candidate for WordPress 4.0 is now available! In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the Beta 1 announcement post for more details on those features. We hope to ship WordPress 4.0 next week, but we need your help to get there. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2134:\"<p>The first release candidate for WordPress 4.0 is now available!</p>\n<p>In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">Beta 1 announcement post</a> for more details on those features. We hope to ship WordPress 4.0 <em>next week</em>, but we need your help to get there. If you haven’t tested 4.0 yet, there’s no time like the present. (Please, not on a production site, unless you’re adventurous.)</p>\n<p><strong>Think you’ve found a bug? </strong>Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.0 RC1, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-RC1.zip\">download the release candidate here</a> (zip). If you’d like to learn more about what’s new in WordPress 4.0, visit the awesome About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png?w=692\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar).</p>\n<p><strong>Developers,</strong> please test your plugins and themes against WordPress 4.0 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.0 before next week. If you find compatibility problems, please be sure to post any issues to the support forums so we can figure those out before the final release. You also may want to <a href=\"https://make.wordpress.org/core/2014/08/21/introducing-plugin-icons-in-the-plugin-installer/\">give your plugin an icon</a>, which we launched last week and will appear in the dashboard along with banners.</p>\n<p><em>It is almost time</em><br />\n<em> For the 4.0 release</em><br />\n<em> And its awesomeness</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 15 Aug 2014 05:06:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3280\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:353:\"The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made more than 250 changes in the past month, including: Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes. Better handling of small screens in the media library modals. A separate bulk selection mode [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2003:\"<p>The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?rev=29496&amp;stop_rev=29229&amp;limit=300\">more than 250 changes</a> in the past month, including:</p>\n<ul>\n<li>Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes.</li>\n<li>Better handling of small screens in the media library modals.</li>\n<li>A separate bulk selection mode for the media library grid view.</li>\n<li>Improvements to the installation language selector.</li>\n<li>Visual tweaks to plugin details and customizer panels.</li>\n</ul>\n<p><strong>We need your help</strong>. We’re still aiming for a release this month, which means the next week will be critical for identifying and squashing bugs. If you’re just joining us, please see <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">the Beta 1 announcement post</a> for what to look out for.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums, where friendly moderators are standing by. <b>Plugin developers</b><strong>,</strong> if you haven’t tested WordPress 4.0 yet, now is the time — and be sure to update the “tested up to” version for your plugins so they’re listed as compatible with 4.0.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.0, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-beta4.zip\">download the beta here</a> (zip).</p>\n<p><em>We are working hard</em><br />\n<em>To finish up 4.0<br />\n</em><em>Will you help us too?</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 3.9.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2014 19:04:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3269\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately. This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by Nir Goldshlager of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2353:\"<p>WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately.</p>\n<p>This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by <a href=\"https://twitter.com/nirgoldshlager\">Nir Goldshlager</a> of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress security team and David Rothstein of the <a href=\"https://www.drupal.org/SA-CORE-2014-004\">Drupal security team</a>. This is the first time our two projects have coordinated joint security releases.</p>\n<p>WordPress 3.9.2 also contains other security changes:</p>\n<ul>\n<li>Fixes a possible but unlikely code execution when processing widgets (WordPress is not affected by default), discovered by <a href=\"http://www.buayacorp.com/\">Alex Concha</a> of the WordPress security team.</li>\n<li>Prevents information disclosure via XML entity attacks in the external GetID3 library, reported by <a href=\"http://onsec.ru/en/\">Ivan Novikov</a> of ONSec.</li>\n<li>Adds protections against brute attacks against CSRF tokens, reported by <a href=\"http://systemoverlord.com/\">David Tomaschik</a> of the Google Security Team.</li>\n<li>Contains some additional security hardening, like preventing cross-site scripting that could be triggered only by administrators.</li>\n</ul>\n<p>We appreciated responsible disclosure of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_3.9.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/3.9?stop_rev=29383&amp;rev=29411\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 3.9.2</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now&#8221;.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 3.9.2 within 12 hours. (If you are still on WordPress 3.8.3 or 3.7.3, you will also be updated to 3.8.4 or 3.7.4. We don&#8217;t support older versions, so please update to 3.9.2 for the latest and greatest.)</p>\n<p>Already testing WordPress 4.0? The third beta is <a href=\"https://wordpress.org/wordpress-4.0-beta3.zip\">now available</a> (zip) and it contains these security fixes.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Jul 2014 21:15:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3261\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"WordPress 4.0 Beta 2 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can download the beta here (zip). For more of what’s new in version 4.0, check out [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1745:\"<p>WordPress 4.0 Beta 2 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-beta2.zip\">download the beta here</a> (zip).</p>\n<p>For more of what’s new in version 4.0, <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">check out the Beta 1 blog post</a>. Some of the changes in Beta 2 include:</p>\n<ul>\n<li>Further refinements for the the plugin installation and media library experiences.</li>\n<li>Updated TinyMCE, which now includes better indentation for lists and the restoration of the color picker.</li>\n<li>Cookies are now tied to a session internally, so if you have trouble logging in, <a href=\"https://core.trac.wordpress.org/ticket/20276\">#20276</a> may be the culprit.</li>\n<li>Various bug fixes (there were <a href=\"https://core.trac.wordpress.org/log?rev=29228&amp;stop_rev=29060&amp;limit=200\">nearly 170 changes</a> since last week).</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.0\">everything we’ve fixed</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jul 2014 10:17:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3248\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.0 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.0, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4031:\"<p>WordPress 4.0 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.0, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-beta1.zip\">download the beta here</a> (zip).</p>\n<p>4.0 is due out next month, but to get there, we need your help testing what we&#8217;ve been working on:</p>\n<ul>\n<li><strong>Previews of <a href=\"https://codex.wordpress.org/Embeds\">embedding via URLs</a></strong> in the visual editor and the &#8220;Insert from URL&#8221; tab in the media modal. Try pasting a URL (such as a <a href=\"http://wordpress.tv/\">WordPress.tv</a> or YouTube video) onto its own line in the visual editor. (<a href=\"https://core.trac.wordpress.org/ticket/28195\">#28195</a>, <a href=\"https://core.trac.wordpress.org/ticket/15490\">#15490</a>)</li>\n<li>The <strong>Media Library</strong> now has a &#8220;grid&#8221; view in addition to the existing list view. Clicking on an item takes you into a modal where you can see a larger preview and edit information about that attachment, and you can navigate between items right from the modal without closing it. (<a href=\"https://core.trac.wordpress.org/ticket/24716\">#24716</a>)</li>\n<li>We&#8217;re freshening up the <strong>plugin install experience</strong>. You&#8217;ll see some early visual changes as well as more information when searching for plugins and viewing details. (<a href=\"https://core.trac.wordpress.org/ticket/28785\">#28785</a>, <a href=\"https://core.trac.wordpress.org/ticket/27440\">#27440</a>)</li>\n<li><strong>Selecting a language</strong> when you run the installation process. (<a href=\"https://core.trac.wordpress.org/ticket/28577\">#28577</a>)</li>\n<li>The <strong>editor</strong> intelligently resizes and its top and bottom bars pin when needed. Browsers don&#8217;t like to agree on where to put things like cursors, so if you find a bug here, please also let us know your browser and operating system. (<a href=\"https://core.trac.wordpress.org/ticket/28328\">#28328</a>)</li>\n<li>We&#8217;ve made some improvements to how your keyboard and cursor interact with <strong>TinyMCE views</strong> such as the gallery preview. Much like the editor resizing and scrolling improvements, knowing about your setup is particularly important for bug reports here. (<a href=\"https://core.trac.wordpress.org/ticket/28595\">#28595</a>)</li>\n<li><strong>Widgets in the Customizer</strong> are now loaded in a separate panel. (<a href=\"https://core.trac.wordpress.org/ticket/27406\">#27406</a>)</li>\n<li>We&#8217;ve also made some changes to some <strong>formatting</strong> functions, so if you see quotes curling in the wrong direction, please file a bug report.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.0\">everything we’ve fixed</a> so far.</p>\n<p><strong>Developers:</strong> Never fear, we haven&#8217;t forgotten you. There&#8217;s plenty for you, too &#8211; more on that in upcoming posts. In the meantime, check out the <a href=\"https://make.wordpress.org/core/2014/07/08/customizer-improvements-in-4-0/#customizer-panels\">API for panels in the Customizer</a>.</p>\n<p>Happy testing!</p>\n<p><em>Plugins, editor</em><br />\n<em>Media, things in between</em><br />\n<em>Please help look for bugs</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 3.9.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/05/wordpress-3-9-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/05/wordpress-3-9-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 May 2014 18:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3241\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"After three weeks and more than 9 million downloads of WordPress 3.9, we&#8217;re pleased to announce that WordPress 3.9.1 is now available. This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We&#8217;ve also made some improvements to the new audio/video [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3106:\"<p>After three weeks and more than 9 million downloads of <a title=\"WordPress 3.9 “Smith”\" href=\"https://wordpress.org/news/2014/04/smith/\">WordPress 3.9</a>, we&#8217;re pleased to announce that WordPress 3.9.1 is now available.</p>\n<p>This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We&#8217;ve also made some improvements to the new audio/video playlists feature and made some adjustments to improve performance. For a full list of changes, consult the <a href=\"https://core.trac.wordpress.org/query?milestone=3.9.1\">list of tickets</a> and the <a href=\"https://core.trac.wordpress.org/log/branches/3.9?rev=28353&amp;stop_rev=28154\">changelog</a>.</p>\n<p>If you are one of the millions already running WordPress 3.9, we&#8217;ve started rolling out automatic background updates for 3.9.1. For sites <a href=\"https://wordpress.org/plugins/background-update-tester/\">that support them</a>, of course.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 3.9.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now.&#8221;</p>\n<p>Thanks to all of these fine individuals for contributing to 3.9.1: <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/ehg\">Chris Blower</a>, <a href=\"https://profiles.wordpress.org/jupiterwise\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/m_i_n\">m_i_n</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius Jensen</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, and <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/05/wordpress-3-9-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Nov 2014 06:33:58 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 20 Nov 2014 19:04:36 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20140613153416\";}","no");
INSERT INTO wp_options VALUES("78202","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1417026838","no");
INSERT INTO wp_options VALUES("78203","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1416983638","no");
INSERT INTO wp_options VALUES("78204","_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c","1417026839","no");
INSERT INTO wp_options VALUES("78205","_transient_feed_867bd5c64f85878d03a060509cd2f92c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WordPress Theme Design Challenge Weekend December 13-14th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34438\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/wordpress-theme-design-challenge-weekend-december-13-14th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2948:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/DesignChallengeFeaturedImage.png\" rel=\"prettyphoto[34438]\"><img class=\"size-full wp-image-34443\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/DesignChallengeFeaturedImage.png?resize=639%2C200\" alt=\"Design Challenge Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/ashleyrosex/4156758226/\">ashley rose,</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>In an effort to inspire WordPress theme designers and add a variety of new themes to the directory, the WordPress Theme Review Team is hosting a <a title=\"https://make.wordpress.org/themes/2014/11/24/design-challenge-weekend/\" href=\"https://make.wordpress.org/themes/2014/11/24/design-challenge-weekend/\">Design Challenge Weekend</a>, December 13-14th. The challenge is meant to do the following:</p>\n<ul>\n<li>Raise the design standard of the WordPress.org theme directory.</li>\n<li>Match developers to designers.</li>\n<li>Encourage designers to create themes.</li>\n<li>Offer resources for designers to learn how to make themes.</li>\n<li>Educate developers in design.</li>\n</ul>\n<p>Leading up to the event, the team will hold a few <em>learnups</em> on <a title=\"https://slack.com/\" href=\"https://slack.com/\">Slack</a>. Learnups are mini classes related to theme design. Dates have not been set but three individuals have been chosen to act as teachers.</p>\n<ul>\n<li><a class=\"mention\" href=\"https://profiles.wordpress.org/greenshady\">@greenshady</a> aka Justin Tadlock on making a child theme.</li>\n<li><a class=\"mention\" href=\"https://profiles.wordpress.org/karmatosed\">@karmatosed</a> aka Tammie Lister will do one on the <a title=\"http://underscores.me/\" href=\"http://underscores.me/\">Underscores</a> framework.</li>\n<li><a class=\"mention\" href=\"https://profiles.wordpress.org/melchoyce\">@melchoyce</a> aka Mel Choyce on design principles for developers</li>\n</ul>\n<p>Starting next week, things will get underway to establish a series of relationships between the following:</p>\n<ol>\n<li><strong>Designers looking for developers.</strong></li>\n<li><strong>Developers looking for designers.</strong></li>\n<li><strong>Designers doing it for themselves.</strong></li>\n</ol>\n<p>Work will begin on a theme once pairs are established. Throughout the event, <a title=\"https://slack.com/\" href=\"https://slack.com/\">Slack</a> (<strong>#themereview</strong>) will be used as the primary communication method to provide design critiques and updates. As Lister points out, &#8220;The main focus of the weekend is going to be helping each other and reveling in theme design.&#8221; If you have any questions or concerns, the best place to ask is in the comments of the <a title=\"https://make.wordpress.org/themes/2014/11/24/design-challenge-weekend/\" href=\"https://make.wordpress.org/themes/2014/11/24/design-challenge-weekend/\">official announcement post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Nov 2014 00:40:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: A Glimpse Into Serbia’s Rapidly Growing WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34372\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/a-glimpse-into-serbias-rapidly-growing-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10403:\"<p>After the dissolution of socialist Yugoslavia in the early 90&#8217;s, Serbia and its neighboring nations had an uphill climb to reach stability in their newly found autonomy. Transitioning from a <a href=\"http://en.wikipedia.org/wiki/Planned_economy\" target=\"_blank\">planned economy</a> to a market-driven economy was a challenge that Serbians have vigorously embraced over the past 20 years. Belgrade is now a growing center for information technology in Eastern Europe. In 2013, Serbia&#8217;s IT industry growth outpaced the rest of the economy <a href=\"http://www.ft.com/cms/s/0/7d899fac-3a42-11e3-9243-00144feab7de.html#axzz3K6V1o15X\" target=\"_blank\">by nearly 200%</a>.</p>\n<p>It&#8217;s no surprise then that the WordPress community in Serbia is growing in tandem and bursting at the seams. While a small country in the Balkan Peninsula may seem like an unlikely place for a thriving WordPress community, conditions are now ripe for the very first <a href=\"http://2015.belgrade.wordcamp.org/\" target=\"_blank\">WordCamp Belgrade</a>. The organizers&#8217; budget was approved last week and the event is officially set for the weekend of April 18-19.</p>\n<p>At <a href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\" target=\"_blank\">WordCamp Europe</a> I had the opportunity to meet several members of the Serbian WordPress community. While passing through Belgrade on my way out, I stopped in to spend time with community leaders <a href=\"http://www.prelovac.com/vladimir/\" target=\"_blank\">Vladamir Prelovac</a> and <a href=\"http://lanche86.com/\" target=\"_blank\">Milan Ivanović</a>, who offered a glimpse into Serbia&#8217;s growing WordPress community.</p>\n<h3>From Zero to WordCamp in Under Two Years</h3>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/4-wpserbia-meetup.jpg\" rel=\"prettyphoto[34372]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/4-wpserbia-meetup.jpg?resize=1025%2C684\" alt=\"4-wpserbia-meetup\" class=\"aligncenter size-full wp-image-34402\" /></a></p>\n<p>Prelovac is a prolific plugin developer and founder of <a href=\"https://managewp.com/\" target=\"_blank\">ManageWP</a>, which was host to the first Serbian WordPress meetup in early 2013. Over the past two years, he&#8217;s watched the community go from virtually non-existent to hundreds of people.</p>\n<p>&#8220;The WordPress community in Serbia is very, very young. It all started with a meetup held in the ManageWP&#8217;s office in early 2013, which hosted around 30 interested people,&#8221; he said. &#8220;But then it all went very fast from there. Three more meetups were organized since, with around 100 people attending each meetup.&#8221;</p>\n<p>In a couple of weeks, the number of Serbian WP meetups will expand to five. The use of Meetup.com is not very popular in Serbia, so Facebook has been instrumental for organizing events. The <a href=\"https://www.facebook.com/groups/613503768679500/\" target=\"_blank\">WP Serbia Facebook group</a> counts nearly 600 members, many of whom will be in attendance at the upcoming WordCamp.</p>\n<p>&#8220;WordPress has been quickly recognized as a project that is easy to get involved with,&#8221; Prelovac said, commenting on the community&#8217;s growth. &#8220;People were eager to find out more on how they can contribute or start a business based on WordPress. For example, on the very first meetup we had the <a href=\"http://www.themeskingdom.com/\" target=\"_blank\">Themes Kingdom</a> guys speaking about their theme business, which spawned a couple of theme-based businesses, some of which are already very successful.&#8221;</p>\n<p>He also attributes the community&#8217;s growth to the energy and dedication of its organizers. &#8220;Milan Ivanović is leading the organization effort, as well as Marko Heijnen, who is playing an important role in making this community better known and recognized in the broader WordPress community. Our COO Ivan Bjelajac is also helping with logistics, promotion and local speakers.&#8221;</p>\n<p>Milan Ivanović has been working with WordPress for six years. He is currently the Frontend Team Lead at <a href=\"http://www.razor.rs/\" target=\"_blank\">Razor Communications</a>, a Serbian-based digital agency, and is one of the organizers for WordCamp Serbia.</p>\n<p>&#8220;People in Serbia saw the opportunity in getting hired remotely and that&#8217;s got to be the key to our rapid growth,&#8221; he said. &#8220;The open and helping community was also a solid foundation.&#8221;</p>\n<p>During the first WordCamp Europe in 2013, Ivanović met <a href=\"https://twitter.com/markoheijnen\" target=\"_blank\">Marko Heijnen</a>, and the two agreed to put more effort into pushing the local WordPress community. &#8220;At that very same WordCamp, I met <a href=\"https://twitter.com/dinicmilan\" target=\"_blank\">Milan Dinić</a> who, for the past seven years, has been helping with the Serbian version of WordPress and everything that comes with it,&#8221; he said.</p>\n<p>Shortly after that time, the group started organizing and formed a team of people to help with future meetups. &#8220;Up to the second WordPress Meetup we wasn&#8217;t sure how many people would attend and we were shocked when around 100 showed up. We saw the same number of attendees at the following meetups,&#8221; Ivanović said.</p>\n<p>In May 2014, WordCamp Serbia organizers were approved to work on hosting a WordCamp in Belgrade. At the moment, they have capacity for 200 attendees.</p>\n<h3>Growing Job Market for WordPress Professionals in Serbia</h3>\n<p>The Belgrade metro area is home to approximately 1.65 million people, nestled between the Sava and Danube rivers. <a href=\"http://www.heritage.org/index/country/serbia\" target=\"_blank\">Economic freedom is on the upswing</a>, which is one of the factors that make it an excellent place for businesses to thrive.</p>\n<p>While the area has many WordPress-based businesses, Prelovac said that most WordPress professionals elect to be freelancers, finding ample opportunities in the very diverse commercial market created by WordPress.</p>\n<p>&#8220;<span class=\"pullquote alignleft\">It only took a couple of known WordPress local businesses to make the initial spark, and the community basically exploded from there</span>, growing, maturing and becoming an organization on its own in a very short period of time.&#8221;</p>\n<p>Ivanović shares the same outlook on Serbia&#8217;s job market for WordPress professionals. &#8220;Programming and development in general are blooming in Serbia and this whole region in the last couple of years. WordPress just caught that wave.</p>\n<p>&#8220;More people are turning to freelancing or starting their own business each day,&#8221; he said. &#8220;Although there are lot of companies and start-ups specialized in building either clients websites or selling premium themes, through WP Meetups I can see that overall interest in WordPress is growing fast and we will work and try our best to bring WordPress to even more people in Serbia and the region.&#8221;</p>\n<p>According to Prelovac, Serbian companies are very open to using open source software, especially startups. He has been at the helm of several successful commercial endeavors and believes that the region is ripe for entrepreneurs. &#8220;I&#8217;d say it was never better. The tech and startup scene in Serbia is blooming, giving a lot of opportunities to energetic, smart, and capable people.&#8221;</p>\n<p>Ivanović echos that recommendation. &#8220;My advice for all of them is to start WordPress business ASAP! No matter how hard we try, still there are lots of websites that needs redesigning, and WordPress is the best solution for clients, nine out of ten times,&#8221; he said.</p>\n<p>The entrepreneurial spirit is alive and well in Serbia and top talent seems to be readily available to companies in the region. WordPress is becoming one of the most important factors in the improved economic outlook for freelancers and small businesses.</p>\n<h3>Working Together with Neighboring Tech Communities</h3>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/WP-unites-countries.png\" rel=\"prettyphoto[34372]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/WP-unites-countries.png?resize=1024%2C682\" alt=\"WordPress Communities of Serbia, Croatia, Slovenia, and Bosnia at WordCamp Europe 2014\" class=\"size-full wp-image-34426\" /></a>WordPress Communities of Serbia, Croatia, Slovenia, and Bosnia\n<p>The WordPress community in Serbia has a healthy relationship with neighboring communities, especially those in Croatia, Romania, and Bulgaria that share a similar history. &#8220;Our best relationship we have is with the PHP community in Serbia, but that one came pretty naturally for all of us,&#8221; Ivanović said. &#8220;There&#8217;s a large percentage of the same visitors attending WordPress and PHP conferences and meetups.&#8221;</p>\n<p>The WordPress community also receives enormous support from the <a href=\"http://startit.rs/\" target=\"_blank\">Serbian Startup</a> community, which serves to encourage the local IT community to start innovative and successful entrepreneurial endeavors.</p>\n<p>The community is also well connected with <a href=\"https://twitter.com/wpcroatia\" target=\"_blank\">WP Croatia</a>, and the two groups are working on organizing a special event to bring the communities together.</p>\n<h3>The Future of the Serbian WordPress Community</h3>\n<p>Organizing the first WordCamp Belgrade comes with its own set of unique challenges, which Prelovac identified as &#8220;inviting interesting speakers, attracting people wanting to visit Serbia and meet with this new community as well as discover the beauties of our country.&#8221; Belgrade isn&#8217;t yet a popular tourist destination, so the event is likely to be very focused on the local community.</p>\n<p>&#8220;The WordCamp will no doubt be a huge deal for the further expansion of the community. I expect it to have several thousand members by the end of the next year,&#8221; he predicted.</p>\n<p>Ivanović said he also predicts exponential growth as the result of bringing together the regional community for the event. &#8220;It feels like all the people here in Serbia and the whole region have been waiting for something to happen to make that small push over the edge and into community.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2014 23:23:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: Where to Find WordPress Related Black Friday Deals\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34422\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/where-to-find-wordpress-related-black-friday-deals\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1405:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/BlackfridayFeaturedImage.png\" rel=\"prettyphoto[34422]\"><img class=\"size-full wp-image-34430\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/BlackfridayFeaturedImage.png?resize=638%2C200\" alt=\"Black Friday Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/pagedooley/6575053747/\">kevin dooley</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a>\n<p>This is a great time of year if you&#8217;re in the market for themes, plugins, or webhosting. Black Friday is the day after Thanksgiving where many retailers offer deep discounts. In the past 2-3 years, WordPress businesses have done the same by offering substantial discounts for plugins and themes.</p>\n<p><a title=\"http://wplift.com/wordpress-thanksgiving-sales\" href=\"http://wplift.com/wordpress-thanksgiving-sales\">WPLift has a great roundup</a> of deals covering themes, plugins, and webhosting. Several companies are offering 50% off themes and memberships. <a title=\"http://www.wpmayor.com/black-friday-cyber-monday-deals/\" href=\"http://www.wpmayor.com/black-friday-cyber-monday-deals/\">WP Mayor also has a collection</a> of black Friday deals. Keep in mind that many of the deals and coupon codes will expire this weekend. If you have an offer not listed on either site linked above, tell us about it in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2014 23:13:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Life Hack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://ma.tt/2014/11/life-hack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"<p>Life Hack: Put leftovers on top of your Mac Pro to keep them warm.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2014 18:06:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Override WordPress Comment Deadline Settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34334\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wptavern.com/override-wordpress-comment-deadline-settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3137:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/comments.png\" rel=\"prettyphoto[34334]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/comments.png?resize=984%2C455\" alt=\"comments\" class=\"aligncenter size-full wp-image-28128\" /></a></p>\n<p>Many WordPress users elect to automatically close comments on older posts in order to keep the constant deluge of spam at bay. This method works, but it comes with a couple of drawbacks. The option, found under the Settings → Discussion screen, is essentially an an all-or-nothing choice on older posts.</p>\n<p>The comment deadline setting is an unsparing guillotine that drops after a set number of days to cut off discussion, without regard for any conversations still in progress. The reality is that not all older content automatically becomes irrelevant after a set number of days. Certain posts may take months or even years to get found in the vast sea of content on the web. Moreover, some posts may not gain traction or ignite conversation until well after they were originally published.</p>\n<p>The <a href=\"https://wordpress.org/plugins/override-comment-deadline/\" target=\"_blank\">Override Comment Deadline</a> plugin was created to offer authors a little more flexibility to leave comments open on select posts after the deadline set in the discussion settings. It adds a new metabox to the post edit screen where you can check a box to keep comments open.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/override-comment-deadline.png\" rel=\"prettyphoto[34334]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/override-comment-deadline.png?resize=500%2C290\" alt=\"override-comment-deadline\" class=\"aligncenter size-large wp-image-34336\" /></a></p>\n<p><a href=\"http://scottnelle.com/\" target=\"_blank\">Scott Nelle</a>, Application Developer at Union Street Media, created the plugin to do one simple thing- to keep comments open indefinitely on select posts. There&#8217;s no settings screen or anything else that needs to be configured. However, you will need to have assigned a number of days for automatically closing comments in the discussion settings in order for the plugin to be effective.</p>\n<p>Many large blogs are <a href=\"http://wptavern.com/why-comments-still-matter\" target=\"_blank\">turning off comments</a> because of the time-consuming tasks of moderation and spam management. With the help of Override Comment Deadline, you can still close the door to hordes of spam on older, less relevant posts, while keeping comments open on posts where the conversation is still going strong.</p>\n<p>If you have a strong readership surrounding your blog, the comments can oftentimes be more important than the original post. They become a treasure trove of information and interaction that transform your blog into a community, as opposed to just a soapbox. If you want the option to keep the conversation going on your most important posts, install the <a href=\"https://wordpress.org/plugins/override-comment-deadline/\" target=\"_blank\">Override Comment Deadline</a> plugin from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2014 17:09:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: 6 WordPress Things I’m Thankful For\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34298\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://wptavern.com/6-wordpress-things-im-thankful-for\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3446:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png\" rel=\"prettyphoto[34298]\"><img class=\"size-full wp-image-34331\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png?resize=796%2C267\" alt=\"Billion Thanks Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/opensourceway/7007768456/\">opensourceway</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">cc</a>\n<p>As the US gets ready to celebrate Thanksgiving, it&#8217;s the time of year where I stop to think about what I&#8217;m thankful for regarding WordPress. In no particular order, here are six things I&#8217;m thankful for when it comes to WordPress.</p>\n<h2>The Community</h2>\n<p>The WordPress community is a large reason for the project&#8217;s continued success. It&#8217;s filled with smart, passionate people, democratizing publishing on a global scale. WordPress is like an engine and the community is the oil. Without the community, the project would likely not be as large and successful as it is today.</p>\n<h2>WordPress, Plugin, and Theme Developers</h2>\n<p>Developers are the people who create solutions to problems. Thank you for everything that you do to help WordPress be a better project whether it&#8217;s through themes, plugins, or core contributions. I especially thank those who contribute to the project without being paid for it. WordPress wouldn&#8217;t be the same if it weren&#8217;t for the generosity of so many developers.</p>\n<h2>Support Forum Volunteers</h2>\n<p>The people who volunteer time on the <a title=\"https://wordpress.org/support/\" href=\"https://wordpress.org/support/\">WordPress support forums</a> are special. To millions of users, they represent the front line of the project. Most of them are not paid and provide support as a means of contributing to WordPress. Several support queries are resolved each week because of their dedication.</p>\n<h2>Meetup/WordCamp Organizers</h2>\n<p>Meetups bring users together to interact and learn about WordPress. They&#8217;re an important part of the community and project. WordCamps are a huge undertaking and provide great opportunities for local communities to learn about WordPress. Not everyone has the skills to organize these events. It takes someone with passion, dedication, energy, and time. Thank you to everyone who has played a role in organizing either a meetup or WordCamp.</p>\n<h2>Mike Little and Matt Mullenweg</h2>\n<p>If Matt Mullenweg and Mike Little did not <a title=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\" href=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\">fork of b2 in 2003</a>, WordPress may not exist. Thank you both for getting the ball rolling in 2003.</p>\n<h2>WP Tavern Supporters</h2>\n<p>Last but not least, thank you to those who continue to read the Tavern on a daily basis and support the work we do. Whether it&#8217;s commenting on articles, interacting with us on Twitter, or listening to <a title=\"http://wptavern.com/category/wordpress-weekly\" href=\"http://wptavern.com/category/wordpress-weekly\">WordPress Weekly</a>, your involvement with the Tavern is an important part of the site&#8217;s success.</p>\n<h2>What Are You Thankful For?</h2>\n<p>Even if you don&#8217;t celebrate Thanksgiving, there&#8217;s probably a few things you&#8217;re thankful for when it comes to WordPress. Tell us about them in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2014 03:05:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: BuddyPress 2.2 on Track to Provide a Basic Member Type API\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33950\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/buddypress-2-2-on-track-to-provide-a-basic-member-type-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3403:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg\" rel=\"prettyphoto[33950]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg?resize=1024%2C492\" alt=\"photo credit: Dunechaser - cc\" class=\"size-full wp-image-30565\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/dunechaser/6042984689/\">Dunechaser</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>BuddyPress 2.2 is under active development and contributors are close to having the basics of a new Member Type API on board for the upcoming release. The new API would allow developers to separate users into different types, a common request for many BuddyPress-powered communities. User types make it possible to create some interesting community features, such as restricting content, filtering the member directory, assigning different permissions, and displaying profiles in a unique way for different types of members.</p>\n<p>BuddyPress lead developer <a href=\"http://boone.gorg.es/\" target=\"_blank\">Boone Gorges</a> proposed the enhancement in a <a href=\"https://buddypress.trac.wordpress.org/ticket/6006\" target=\"_blank\">ticket</a> that outlines developers&#8217; need for this API. <strong>&#8220;It&#8217;s time for BP to provide the basics of a User Type API, so that plugin devs and site builders will have some common tools for building the user type functionality required by their implementation,&#8221;</strong> Gorges said.</p>\n<p>In the past, Gorges, like many others, used xprofile, taxonomies, and usermeta to create user types. For BuddyPress 2.2, he is proposing that BP register a private taxonomy <code>\'bp_user_type\'</code>. Registering a member type would require a new function. Gorges&#8217; first pass at the member type API adds <code>bp_register_member_type( $type, $args )</code>, with syntax similar to what you might use to register a custom post type or a custom taxonomy. Gorges provided an <a href=\"https://buddypress.trac.wordpress.org/attachment/ticket/6006/bp-member-type-test.php\" target=\"_blank\">example mu-plugin</a> to demonstrate how simple it will be to register a new member type.</p>\n<p>At the moment, the UI for the Member Type API is very basic. When member types have been registered, you will see a meta box added to the community profile screen in the admin. This will allow admins to change a user&#8217;s member type, which is currently limited to one. The 2.2 release may ship with support for one member type or it may support multiple types, depending on how the feature evolves during this development cycle.</p>\n<p>The Member Type API won&#8217;t actually do anything visible for users in the first iteration. It&#8217;s purely a feature for developers that will enable them to build their own interfaces for creating and managing user types. The idea has been well-received by BuddyPress developers who are excited to have a standard way to accomplish user type requests that are common to building niche social networks.</p>\n<p>BuddyPress 2.2 is expected at the end of January 2015. The Member Type API isn&#8217;t yet a lock but appears to be on track for inclusion in the next release. If you have any feedback to offer, feel free to jump in on the relevant ticket (<a href=\"https://buddypress.trac.wordpress.org/ticket/6006\" target=\"_blank\">#6006</a>) on BuddyPress trac.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 23:36:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WooThemes Launches Storefront, A Free WordPress Theme with WooCommerce Integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34038\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/woothemes-launches-storefront-a-free-wordpress-theme-with-woocommerce-integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5737:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/storefront-featured.jpg\" rel=\"prettyphoto[34038]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/storefront-featured.jpg?resize=1025%2C498\" alt=\"photo credit: WooThemes\" class=\"size-full wp-image-34274\" /></a>photo credit: <a href=\"http://www.woothemes.com/2014/11/say-hello-storefront/\">WooThemes</a>\n<p><a href=\"http://www.woothemes.com/woocommerce/\" target=\"_blank\">WooCommerce</a> recently passed five million downloads, shortly before the Woo team kicked off the first <a href=\"http://wptavern.com/wooconf-the-first-ever-conference-dedicated-to-woocommerce-deemed-a-success\" target=\"_blank\">WooConf</a> earlier this month. The conference, devoted solely to WooCommerce, sold out with 300 attendees. The plugin had 294 contributors on its most recent 2.2 release and is currently being used on 18% of all e-commerce sites on the web.</p>\n<p>Building on the global success of the plugin and its many commercial <a href=\"http://www.woothemes.com/product-category/woocommerce-extensions/\" target=\"_blank\">extensions</a>, the folks at WooThemes are now branching out into selling theme extensions for the new official WooCommerce theme. <a href=\"http://www.woothemes.com/storefront/\" target=\"_blank\">Storefront</a> landed in the WordPress Themes Directory last week and already has three commercial <a href=\"http://www.woothemes.com/product-category/storefront-extensions/\" target=\"_blank\">extensions</a> available.</p>\n<p>Although the theme appears to be very plain, it&#8217;s meant to be a starting place that includes deep WooCommerce integration. Storefront was designed to be lean, extensible, and an example of WooCommerce theme development standards.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/storefront.png\" rel=\"prettyphoto[34038]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/storefront.png?resize=880%2C660\" alt=\"storefront\" class=\"aligncenter size-full wp-image-34259\" /></a></p>\n<p>The theme does not include any sliders, shortcodes, or page builders but exists to promote a more modular approach building e-commerce sites. Instead of dumping a bunch of functionality into the theme, WooThemes opted to keep it a simple foundation for building WooCommerce projects.</p>\n<p>That doesn&#8217;t mean that Storefront is completely bare bones. In fact, it includes an impressive array of options built into WordPress&#8217; native customizer. Users can easily customize the background color/image, header image, footer colors (header, text, link, and background), button colors, and site layout. Storefront was built to be responsive and offers multiple widget areas for further customization, including sidebar, header, and four areas in the footer. The <a href=\"http://demo2.woothemes.com/storefront/\" target=\"_blank\">live demo</a> features example products and a custom header in place.</p>\n<p>WooThemes used the <a href=\"http://underscores.me\" target=\"_blank\">Underscores</a> starter theme to build Storefront. Users can upload a custom logo by adding Jetpack, as the theme includes support for the new <a href=\"http://wptavern.com/jetpack-3-2-released-introduces-new-site-logo-feature-for-theme-developers\" target=\"_blank\">site logo feature</a>.</p>\n<p>With the help of WooTheme&#8217;s free <a href=\"https://wordpress.org/plugins/homepage-control/\" target=\"_blank\">Homepage Control</a> plugin, it&#8217;s easy to customize the appearance and arrangement of featured products, categories, recent products, sale items, popular products, etc.</p>\n<p>Storefront also includes deep integration for WooCommerce&#8217;s most popular extensions, including the following:</p>\n<ul>\n<li><a href=\"http://www.woothemes.com/products/woocommerce-bookings/\" target=\"_blank\">WooCommerce Bookings</a></li>\n<li><a href=\"http://www.woothemes.com/products/woocommerce-wishlists/\" target=\"_blank\">WooCommerce Wishlists</a></li>\n<li><a href=\"http://www.woothemes.com/products/brands/\" target=\"_blank\">WooCommerce Brands</a></li>\n<li><a href=\"http://www.woothemes.com/products/woocommerce-subscriptions/\" target=\"_blank\">WooCommerce Subscriptions</a></li>\n</ul>\n<p>Theme developers looking to build products that integrate with these extensions need look no further than the official Storefront theme. It was created to be a prime example.</p>\n<p>The WooCommerce team built Storefront with data portability in mind, so that users will be able to easily switch themes without losing their content. That&#8217;s why they opted not to include any extra functionality in the theme, as explained in the release announcement:</p>\n<blockquote><p>By not including these features you’re free to add them via whichever plugin you prefer, and if/when you switch themes later on down the road all of those features will remain. We firmly believe that building Storefront this way means you will be less likely to need or want to switch, but at the same time wholeheartedly encourage the entrepreneurial opportunity that WooCommerce offers for theme developers far and wide.</p></blockquote>\n<p>With WooCommerce leading the WordPress e-commerce market, this theme should help to provide a standard reference for developers integrating the plugin&#8217;s features and its extensions with themes. If the popularity of the core plugin and its extensions are any indication, the launch of Storefront should accelerate the creation of new designs and ignite developers to start building new products for the theme. Check out Storefront on <a href=\"https://github.com/woothemes/storefront\" target=\"_blank\">GitHub</a> or <a href=\"https://wordpress.org/themes/storefront\" target=\"_blank\">download </a>it via WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 19:26:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: WordPress 4.1 to Remove Custom Background and Header Admin Screens\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34041\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/wordpress-4-1-to-remove-custom-background-and-header-admin-screens\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3078:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/admin-header-screen.png\" rel=\"prettyphoto[34041]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/admin-header-screen.png?resize=1025%2C469\" alt=\"admin-header-screen\" class=\"aligncenter size-full wp-image-34226\" /></a></p>\n<p>WordPress theme developers will be pleased to know that the upcoming 4.1 release will remove the custom background and header screens in the admin. These screens will be <a href=\"https://core.trac.wordpress.org/changeset/30459\" target=\"_blank\">replaced with deep-links to the customizer</a>. To be clear, header and background menus will still appear in the admin, but they will be deep-linked to the customizer.</p>\n<p>This is good news for WordPress theme developers, because they will no longer have to style the custom header and background screens.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Hey WordPress theme makers, no more wasting time on styling the Appearance → Header page!&#10;&#10;<a href=\"https://t.co/cHxyvZW7sU\">https://t.co/cHxyvZW7sU</a>&#10;&#10;<a href=\"https://t.co/Jb9y3y0q9r\">https://t.co/Jb9y3y0q9r</a></p>\n<p>&mdash; Philip Arthur Moore (@philip_arthur) <a href=\"https://twitter.com/philip_arthur/status/535588990267576320\">November 21, 2014</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/devinsays\">@devinsays</a> Finally. I hated styling the Custom Header screen. Good riddance!</p>\n<p>&mdash; Justin Tadlock (@justintadlock) <a href=\"https://twitter.com/justintadlock/status/535490971052826624\">November 20, 2014</a></p></blockquote>\n<p></p>\n<p>When exploring different solutions in discussion on the <a href=\"https://core.trac.wordpress.org/ticket/25571\" target=\"_blank\">ticket</a>, Nick Halsey <a href=\"https://core.trac.wordpress.org/timeline?from=2014-04-17T18%3A57%3A14Z&precision=second\" target=\"_blank\">noted</a> that new users expect to find that functionality in the customizer with the other options:</p>\n<blockquote><p>The key issue to consider is whether hiding these pages will cause issues for updating users. New users actually tend to have trouble with the separate headers page, expecting that functionality to be in the customizer.</p></blockquote>\n<p>Header upload was <a href=\"https://core.trac.wordpress.org/ticket/21355\" target=\"_blank\">pulled out of the customizer</a> in WordPress 3.4, due to issues with cropping header images. For the past two years, the extra admin pages were confusing for users. With some theme controls in the customizer and others available in the admin, the experience of customizing themes was inconsistent and divided between the front and back ends.</p>\n<p>Changes coming in 4.1 will replace the custom background/header screen links in admin menu and toolbar with deep-links to the customizer on the frontend. The widgets screen will also display a link to the customizer widgets panel. In the future, the plan is to remove these admin links entirely in favor of streamlining everything to the customizer.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Nov 2014 02:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Hierarchy Plugin Enhances WordPress as a CMS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34072\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wptavern.com/hierarchy-plugin-enhances-wordpress-as-a-cms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4420:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy.png\" rel=\"prettyphoto[34072]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy.png?resize=1025%2C486\" alt=\"hierarchy\" class=\"aligncenter size-full wp-image-34129\" /></a></p>\n<p>WordPress 3.0 introduced the ability for developers to register their own <a href=\"http://codex.wordpress.org/Post_Types#Custom_Post_Types\" target=\"_blank\">custom post types</a>, enabling the software to be used more easily as a CMS. Custom post types ushered in a new era that allowed plugin developers to create and organize content in a more modular way.</p>\n<p>If you&#8217;ve ever tried to explain the concept of custom post types to someone, you may have found that they are more easily understood as <em>custom content types</em>. One thing that makes them confusing is the fact that are usually found floating around in the admin as top level menu items. Custom post types often have no context, which makes it difficult to know how they will appear on the frontend of your site.</p>\n<p>The <a href=\"https://wordpress.org/plugins/hierarchy/\" title=\"Hierarchy Plugin\" target=\"_blank\">Hierarchy</a> plugin aims to solve this problem by moving custom post type admin menus into your pages list. Ordinarily, CPTs have their own menu items and the page menu structure doesn&#8217;t accurately reflect where the content is located, as shown in the example below.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/cpt-admin.png\" rel=\"prettyphoto[34072]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/cpt-admin.png?resize=1025%2C642\" alt=\"cpt-admin\" class=\"aligncenter size-full wp-image-34153\" /></a></p>\n<p>Custom post types are often used to power various sections of a website. Hierarchy works to improve the content editing workflow by intelligently including custom post type admin links within the page structure. In place of the Pages menu in the admin you&#8217;ll see a new Content menu, with custom post types, such as locations, people, and knowledgebase, added under their corresponding pages.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-in-action.png\" rel=\"prettyphoto[34072]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-in-action.png?resize=1025%2C642\" alt=\"hierarchy-in-action\" class=\"aligncenter size-full wp-image-34182\" /></a></p>\n<p>Version 1.0 of the plugin includes Dashicons support and a button to add a new page. Each content type is displayed with contextual links within the hierarchical view of content. You can hover over an entry to display the edit, view, and taxonomy links.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-contextual-links.png\" rel=\"prettyphoto[34072]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-contextual-links.png?resize=1025%2C267\" alt=\"hierarchy-contextual-links\" class=\"aligncenter size-full wp-image-34188\" /></a></p>\n<p>Hierarchy also includes a settings page that allows you to designate which custom post types will be included in the hierarchy display, as well as the ability to disable new entries and set the menu order. You can also elect to hide CPTs from the admin menu so that they only show up within the Hierarchy structure.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-settings.png\" rel=\"prettyphoto[34072]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/hierarchy-settings.png?resize=1025%2C986\" alt=\"hierarchy-settings\" class=\"aligncenter size-full wp-image-34189\" /></a></p>\n<p>When WordPress is used primarily as a CMS, pages often become the backbone for organizing the site&#8217;s content. This plugin addresses the lack of hierarchical structure in the admin. <a href=\"https://mondaybynoon.com/\" target=\"_blank\">Jonathan Christopher</a>, founder of <a href=\"https://searchwp.com/\" target=\"_blank\">SearchWP</a>, wrote Hierarchy two years ago and has found it to be indispensable when creating websites for clients. He released version 1.0 of the plugin this week, which is essentially a complete rewrite of the previous version. If you&#8217;re looking to simplify CPT admin menus and streamline editing, check out <a href=\"https://wordpress.org/plugins/hierarchy/\" target=\"_blank\">Hierarchy</a> on WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Nov 2014 21:35:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: WordPress 4.0.1 Exposes Bad Development Practices Used in Some Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34160\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/wordpress-4-0-1-exposes-bad-development-practices-used-in-some-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4650:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/PluginsBrokenFeaturedImage.png\" rel=\"prettyphoto[34160]\"><img class=\"size-full wp-image-34170\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/PluginsBrokenFeaturedImage.png?resize=640%2C300\" alt=\"Plugins Broken Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/davidglover/2845720033/\">David Glover</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>With the <a title=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability\" href=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability\">release of WordPress 4.0.1</a> less than 24 hours old, we&#8217;ve received <a title=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability#comments\" href=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability#comments\">reports</a> of plugins breaking due to the update. For example, <a title=\"https://wordpress.org/plugins/cool-video-gallery/\" href=\"https://wordpress.org/plugins/cool-video-gallery/\">Cool Video Gallery</a> is broken because of the way it handles custom shortcode attribute parsing instead of using the <a title=\"http://codex.wordpress.org/Shortcode_API\" href=\"http://codex.wordpress.org/Shortcode_API\">Shortcode API</a> built into WordPress. Mika Epstein, who is a support forum volunteer, <a title=\"https://wordpress.org/support/topic/issues-with-wordpress-401-and-shortcodes\" href=\"https://wordpress.org/support/topic/issues-with-wordpress-401-and-shortcodes\">published a post</a> in the support forum that explains the problem and the best way to fix it.</p>\n<blockquote><p>If you&#8217;ve upgraded to WordPress 4.0.1 and a feature using shortcodes has broken (like a slider, or a visual composer), the reason is that code wasn&#8217;t properly using the WP Shortcode API.</p>\n<p>Code that parsed shortcodes themselves, instead of using the normal add_shortcode handlers and such, may be surprised by the new behavior of texturize, because the quote marks in what WP thinks isn&#8217;t a shortcode get texturized now like everything else. So their filters, which probably come after texturize, don&#8217;t get the expected quote marks.</p>\n<p>For users, the best way to fix this is upgrade. Many plugins have already released fixes, more are on the way. While it is possible to downgrade to WP 4.0, we really hope you don&#8217;t because of how serious the security fixes were. If you absolutely MUST downgrade, please nag your plugin/theme devs a lot to fix this STAT. Or stop using their stuff. It&#8217;s that big.</p>\n<p>For developers, if you&#8217;re making shortcodes, use the <a href=\"http://codex.wordpress.org/Shortcode_API\">Shortcode API</a> instead of rolling your own.</p></blockquote>\n<p><a title=\"https://core.trac.wordpress.org/ticket/29557\" href=\"https://core.trac.wordpress.org/ticket/29557\">Ticket 29557</a> in Trac describes the issue in detail. Unfortunately, <a title=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability#comment-60870\" href=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability#comment-60870\">some users</a> have downgraded to WordPress 4.0 in order to fix plugin&#8217;s they rely on. Considering that 4.0.1 is a critical update filled with security and bug fixes, it&#8217;s <strong>strongly recommended</strong> that you <strong>don&#8217;t downgrade to 4.0</strong>. Instead, use the plugin&#8217;s support forum and notify the developer of the issues you&#8217;re having.</p>\n<h2>But Point Releases Are Not Supposed to Break Anything</h2>\n<p>The biggest concern users have with auto updates is the fear something will break. By default, WordPress 3.7 and above is configured to automatically update WordPress for point releases which generally contain security and or bug fixes. These kind of updates normally don&#8217;t break anything but in this case, several of the plugins were already broken and the update exposed bad development practices used by plugin authors.</p>\n<p>All it takes is one bad experience during an auto update to lose trust in the system. With <a title=\"https://wordpress.org/about/stats/\" href=\"https://wordpress.org/about/stats/\">over half of WordPress installs</a> tracked using 3.6 or earlier, we can ill afford to have anymore users disable automatic updates.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Nov 2014 18:22:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WPTavern: CyberChimps is Looking For Investors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://wptavern.com/cyberchimps-is-looking-for-investors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2858:\"<p>CyberChimps, founded by Trent Lapinski, is <a title=\"http://cyberchimps.com/2014/11/cyberchimps-is-seeking-acquisition-too-big-too-fast/\" href=\"http://cyberchimps.com/2014/11/cyberchimps-is-seeking-acquisition-too-big-too-fast/\">seeking acquisition offers</a>. Lapinski cites the reason as becoming too big too fast. CyberChimps owns and maintains <a title=\"https://wordpress.org/themes/responsive\" href=\"https://wordpress.org/themes/responsive\">Responsive</a>, one of the most popular themes in the WordPress theme directory. CyberChimps also maintains <a title=\"https://wordpress.org/themes/ifeature/stats/\" href=\"https://wordpress.org/themes/ifeature/stats/\">iFeature</a>, another popular theme closing in on 1M downloads. The core of the business is services, paid memberships, and commercial add-ons for themes and plugins. The company has over 1M free users of its products and over 34,000 paying customers.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/ResponsiveScreenshot.png\" rel=\"prettyphoto[34158]\"><img class=\"size-full wp-image-34162\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/ResponsiveScreenshot.png?resize=1025%2C684\" alt=\"Screenshot of Responsive\" /></a>Screenshot of Responsive\n<p>Despite living in San Francisco for two years and speaking with several investors, Lapinski has yet to find a proper fit. &#8220;We have tapped our social networks, explored every possible opportunity, and after four years of bootstrapping and massive traction we need a new strategy.&#8221;</p>\n<p>An acquisition would help propel the company to new heights while maintaining existing products and customer relationships. &#8220;This is the right time both for the CyberChimps team and the CyberChimps community to make a change. What we are able to do for the company and for the community has simply plateaued. It’s time to pass the torch onto someone else.&#8221; Lapinski said.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/responsive-ii-screen.png\" rel=\"prettyphoto[34158]\"><img class=\"size-full wp-image-34163\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/responsive-ii-screen.png?resize=1025%2C612\" alt=\"Responsive 2 Screenshot\" /></a>Responsive 2\n<p>CyberChimps customers don&#8217;t need to worry about any immediate changes. Lapinski promises to notify customers well in advance when negotiations are finalized. &#8220;We’ll be sure to announce well in advance the date that the final transfer will take place along with any changes to be aware of if applicable. We’ll do our best to make this transition as smooth as possible for everyone involved, especially our customers and community.&#8221;</p>\n<p>If you have a serious offer or would like to learn more about the company, you can contact Lapinski directly via email: trent at cyberchimps.com.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Nov 2014 17:11:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Science of Hits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44532\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2014/11/science-of-hits/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:675:\"<p>&#8220;Because the most-popular songs now stay on the charts for months, the relative value of a hit has exploded. The top 1 percent of bands and solo artists now earn 77 percent of all revenue from recorded music, media researchers report. And even though the amount of digital music sold has surged, the 10 best-selling tracks command 82 percent more of the market than they did a decade ago. The advent of do-it-yourself artists in the digital age may have grown music’s long tail, but its fat head keeps getting fatter.&#8221; &#8212; <a href=\"http://www.theatlantic.com/magazine/archive/2014/12/the-shazam-effect/382237/?single_page=true\">The Shazam Effect</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Nov 2014 05:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WPWeekly Episode 171 – Interview With WP101 Founder, Shawn Hesketh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=34117&preview_id=34117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/wpweekly-episode-171-interview-with-wp101-founder-shawn-hesketh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2863:\"<p>In this episode, <a href=\"http://marcuscouch.com/\" title=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss WordPress 4.1 beta 1, the delay of Composer by SIDEKICK, and a revamped WP eCommerce plugin. Later in the show, we&#8217;re joined by the founder of <a href=\"https://www.wp101.com/\" title=\"https://www.wp101.com/\">WP101</a>, Shawn Hesketh. Hesketh shares his work process, the equipment used to record videos, and what parts of WordPress user&#8217;s struggle with the most.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-1-beta-1-now-available-for-testing\" title=\"http://wptavern.com/wordpress-4-1-beta-1-now-available-for-testing\">WordPress 4.1 Beta 1 Now Available for Testing</a><br />\n<a href=\"http://wptavern.com/wptavern.com/sidekick-delays-the-release-of-composer\" title=\"wptavern.com/sidekick-delays-the-release-of-composer\">SIDEKICK Delays The Release of Composer</a><br />\n<a href=\"http://wptavern.com/wp-ecommerce-has-a-new-home\" title=\"http://wptavern.com/wp-ecommerce-has-a-new-home\">WP eCommerce Has a New Home</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/bulk-deactivate/\" title=\"https://wordpress.org/plugins/bulk-deactivate/\">Bulk Deactivate</a> is fantastic for discovering plugin conflicts and fixing support items. This let&#8217;s you deactivate your plugins in bulk so you can isolate the problem.</p>\n<p><a href=\"https://wordpress.org/plugins/jm-twitter-cards/\" title=\"https://wordpress.org/plugins/jm-twitter-cards/\">JM Twitter Cards</a> adds the appropriate metadata on a WordPress website allowing you to get Twitter cards for posts based on its settings.</p>\n<p><a href=\"https://wordpress.org/plugins/google-news-editors-picks-news-feeds/\" title=\"https://wordpress.org/plugins/google-news-editors-picks-news-feeds/\">Google News Editors Picks Feed Generator</a> generates not one but two, highly customizable Google News Editors’ Picks RSS Feeds. You can customize required feed images, names, titles, descriptions and more! You can also exclude articles from feeds and enter custom meta descriptions from the lightweight, custom meta box located on post.php (edit) screens.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, November 26th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #171:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Nov 2014 02:33:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WP Engine Partners with 10up to Launch Enterprise HHVM WordPress Hosting Platform\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/wp-engine-partners-with-10up-to-launch-enterprise-hhvm-wordpress-hosting-platform\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6537:\"<p><a href=\"http://wpengine.com/\" target=\"_blank\">WP Engine</a> is launching its high availability enterprise hosting platform today. The new product is called <a href=\"http://wpengine.com/2014/11/19/hhvm-project-mercury/\" target=\"_blank\">Mercury</a> and it&#8217;s built to provide HHVM (with PHP-FPM failover) to customers who require better PHP performance.</p>\n<p>WP Engine is one of the first WordPress managed hosts to offer <a href=\"http://hhvm.com/\" target=\"_blank\">HHVM</a> (HipHop Virtual Machine), a PHP execution engine originally <a href=\"https://www.facebook.com/notes/facebook-engineering/the-hiphop-virtual-machine/10150415177928920\" target=\"_blank\">created by Facebook</a> to help make its infrastructure more efficient. Since HHVM is still new and isn&#8217;t 100% stable in production environments, WP Engine has opted to provide automatic fallback to its default PHP stack. This failover protection is invisible to visitors and is only in use 0.1% of the time while HHVM restarts.</p>\n<p>WP Engine partnered with <a href=\"http://10up.com/\" target=\"_blank\">10up</a>, a WordPress development agency, to design and create a system to bring HHVM to customers. Benchmarks reported by 10up indicate staggering performance improvements of up to 600%.</p>\n<p>On a generic WordPress + bbPress installation with no page caching, HHVM delivers on average a 5.6 faster response time over multiple tests:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WPE-bbPress-hhvm.jpg\" rel=\"prettyphoto[34036]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WPE-bbPress-hhvm.jpg?resize=800%2C356\" alt=\"WPE Charts\" class=\"aligncenter size-full wp-image-34084\" /></a></p>\n<p>When testing bbPress with 250 concurrent logged-in users, HHVM consistently delivers a 3.6x faster response time. A regular WordPress site with a custom theme and plugins resulted in approximately 3.9 times faster response time with HHVM as compared to PHP-FPM. At the moment, HHVM <a href=\"https://twitter.com/tnpuig/status/535441283443994624\" target=\"_blank\">doesn&#8217;t play well with BuddyPress</a> but WP Engine plans to discuss this with John James Jacoby in the near future to see what can be done.</p>\n<p>10up founder Jake Goldman believes that HHVM will perform even better over time and become more affordable:</p>\n<blockquote><p>Mirroring the history of air travel, Mercury will invariably become smoother, more affordable, and more accessible with time. We’re already excited by the early results: bbPress response times up to 5.6x faster, 3.6x faster at just 740ms with 250 concurrent visitors.</p></blockquote>\n<p>10up volunteered its site as the first test case and is currently running on the new Mercury platform.</p>\n<p>Other developers have also been experimenting with WordPress on HHVM since earlier this year, achieving similar results in terms of performance improvement:</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Just got a dynamic WordPress page to load (no HTML output caching) and transfer to the browser in 58ms using HHVM. Ping to the server: 27ms.</p>\n<p>&mdash; Mark Jaquith (@markjaquith) <a href=\"https://twitter.com/markjaquith/status/458294601129144320\">April 21, 2014</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/ryanhellyer\">@ryanhellyer</a> <a href=\"https://twitter.com/MarkGavalda\">@MarkGavalda</a> The same page is about 145ms via PHP-FPM.</p>\n<p>&mdash; Mark Jaquith (@markjaquith) <a href=\"https://twitter.com/markjaquith/status/458297336410951680\">April 21, 2014</a></p></blockquote>\n<p></p>\n<h3>The Future of HHVM and WordPress Hosting</h3>\n<p>How long will it be before HHVM is the most common PHP engine for all WordPress managed hosts? Given how new and unstable it currently is, most hosts are not rushing to provide HHVM. However, the advances made by the collaboration between 10up and WP Engine should help to move other hosts along.</p>\n<p>&#8220;I think it is important to note that the Facebook HHVM open source team is really responsive to issues, thoughts, and feedback,&#8221; WP Engine representative Tomas Puig told the Tavern. &#8220;So it bodes super well for the future of us moving more WordPress systems to the technology.&#8221;</p>\n<p>Puig is optimistic that WP Engine and 10up&#8217;s work with HHVM will help to provide valuable feedback for WordPress core. &#8220;I deeply believe in Matt&#8217;s recent statements on WordPress as an application framework and the API work the core team is doing,&#8221; Puig said. &#8220;I think that HHVM enables us to build more rich experiences with WordPress in a more performant manner and that&#8217;s exciting. So really we want to elevate the community as a whole to getting our code ready for it.&#8221;</p>\n<p>Mercury customers will be given a Vagrant configuration to use for local development, and Puig said that the company is wiling to provide the configuration to anyone who requests it.</p>\n<p>One challenge for developers using HHVM is knowing what plugins are compatible with it. &#8220;Something I&#8217;d love to see is an option to mark plugins and themes in the official repository as HHVM tested,&#8221; Puig said. WP Engine is starting to conduct a large round of basic testing to find out which popular plugins are compatible with HHVM. &#8220;We&#8217;ll be releasing that list to the community as a whole so people know where to look and are also working with plugin developers and theme shops to get their code ready,&#8221; he said.</p>\n<p>On the HHVM side, WP Engine has been instrumental in paving the way for other open source projects to take advantage of it. Paul Tarjan, Facebook&#8217;s head of Open Source for HHVM, highlighted the importance of this partnership in the Mercury announcement:</p>\n<blockquote><p>The WP Engine Labs team has done an impressive job in democratizing HHVM for the open-source community. We are excited to work alongside the Labs team to fine-tune the stack to reach HHVM’s full potential and drastically speed up PHP execution. PHP is the bedrock of Facebook, as well as much of the Internet, and this announcement should come as a major fillip for the entire developer community.</p></blockquote>\n<p>The launch of Mercury means that many more WordPress users will have the opportunity to have their sites running on HHVM. As WordPress-specific issues are ironed out through WP Engine&#8217;s collaboration with the HHVM developers, it should become more stable over time.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 22:00:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: WordPress 4.0.1 is a Critical Security Release that Fixes a Cross-Site Scripting Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=34049\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2196:\"<p>WordPress core contributors released a security update today. All users who have not yet received the automatic update are encouraged to update as soon as possible. WordPress 4.0.1 is a critical security release that provides a fix for a critical cross-site scripting vulnerability, originally reported by <a href=\"http://klikki.fi/\" target=\"_blank\">Jouko Pynnonen</a> on September 26th.</p>\n<p>Sites running WordPress versions 3.9.2 and earlier are affected by the vulnerability. Although installs running 4.0 are not specifically affected, this security update also includes fixes for <a href=\"https://core.trac.wordpress.org/log/branches/4.0?rev=30475&stop_rev=29710\" target=\"_blank\">23 bugs and eight security issues</a>.</p>\n<p>According to the official <a href=\"https://wordpress.org/about/stats/\" target=\"_blank\">WordPress version usage stats</a>, only 14.4% of sites are currently running 4.0. This means that the vast majority of WordPress sites and in need of this critical update. A large number of those sites are also running versions that pre-date the automatic background updates that were introduced in WordPress 3.7.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-versions.jpg\" rel=\"prettyphoto[34049]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-versions.jpg?resize=690%2C584\" alt=\"wp-versions\" class=\"aligncenter size-full wp-image-34057\" /></a></p>\n<p>If you want to keep your site on the cutting edge of security updates, it&#8217;s critical to have automatic background updates enabled. If you haven&#8217;t manually turned them off, WordPress 3.7+ has automatic updates enabled for minor releases by default. This includes maintenance, security, and translation file updates.</p>\n<p>Millions of WordPress sites around the web are being updated to 4.0.1 right now and older releases will be updated to 3.9.3, 3.8.5, or 3.7.5, as outlined in Andrew Nacin&#8217;s security release <a href=\"https://wordpress.org/news/2014/11/wordpress-4-0-1/\" target=\"_blank\">announcement</a>. If you don&#8217;t want to wait for the automatic update, you can always go to Dashboard → Updates in the admin and update immediately.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 19:36:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: DigitalOcean Is Now the Third Largest Hosting Provider, WordPress Droplets Account for 23%\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33991\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://wptavern.com/digitalocean-is-now-the-third-largest-hosting-provider-wordpress-droplets-account-for-23\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3263:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/digital-ocean.jpg\" rel=\"prettyphoto[33991]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/digital-ocean.jpg?resize=660%2C305\" alt=\"digital-ocean\" class=\"aligncenter size-full wp-image-34027\" /></a></p>\n<p>In just under two years, <a href=\"https://www.digitalocean.com/\" target=\"_blank\">DigitalOcean</a> has managed to sail past competitors to become the world&#8217;s third largest hosting provider, according to a recent <a href=\"http://trends.netcraft.com/www.digitalocean.com\" target=\"_blank\">report published by Netcraft</a>. The company&#8217;s SSD-based cloud hosting products cater to developers and other tech-savvy customers.</p>\n<p>As of November, DigitalOcean counts a total 187,866 active users running a cloud server (or “Droplet”), thanks in large part to the company&#8217;s affordable pricing structure, which starts at $5/month.</p>\n<h4>How many DigitalOcean customers are running WordPress?</h4>\n<p>I spoke with Tyler Hoffman, a DigitalOcean representative, who reports that the the company hosts <strong>13,000 active 1-click WordPress droplets</strong>, a number which continues to grow each day. &#8220;These WordPress sites account for 3.74% of our total active &#8216;droplets,\'&#8221; he said.</p>\n<p>These figures are based solely on users who have deployed DigitalOcean&#8217;s <a href=\"https://www.digitalocean.com/community/tutorials/one-click-install-wordpress-on-ubuntu-14-04-with-digitalocean\" target=\"_blank\">1-click WordPress images</a> and do not take into account any custom WordPress images. The total number of WordPress droplets is likely much higher. In fact, at the end of October, Netcraft <a href=\"http://news.netcraft.com/archives/2014/10/31/digitalocean-4th-largest-hosting-company-in-under-2-years.html\" target=\"_blank\">reported</a> that <strong>&#8220;more than 23% of the active sites hosted at DigitalOcean are running WordPress, compared with less than 10% of all other active sites around the world.&#8221;</strong></p>\n<p>At the moment, the company doesn&#8217;t seem to be actively trying to attract WordPress customers. Nevertheless, Hoffman reports that WordPress customers are on the rise. In October 2014, DigitalOcean users launched an average of 220 WordPress droplets per day via the 1-click method, roughly 6,600 per month. As WordPress currently powers <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">more than 23% of the web</a>, it will be interesting to see how much of that market the company will be able to capture.</p>\n<p>Netcraft reports that DigitalOcean is currently netting more than 68,000 new customers per month. In general, developers seem to appreciate the speed of deployment, the simplicity of the hosting interface, and the API for managing droplets and resources.</p>\n<p>The company is still relatively new to the hosting industry and caters heavily to developers, which makes its rise to being the third largest provider all the more remarkable. Although DigitalOcean&#8217;s products don&#8217;t necessarily cater to the average non-developer WordPress user, the company seems to have no problem adding WordPress customers to its user base.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 00:23:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Dailybolt – It’s Like WordPress Planet For The Genesis Framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33930\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/dailybolt-its-like-wordpress-planet-for-the-genesis-framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2346:\"<p>If you have trouble keeping up with everything that&#8217;s happening in the Genesis WordPress community, you might be interested in a new site created by Andrea Whitmer called <a title=\"http://dailybolt.com/\" href=\"http://dailybolt.com/\">The Dailybolt</a>. The Dailybolt publishes excerpts from sites that routinely write about the <a title=\"http://my.studiopress.com/themes/genesis/\" href=\"http://my.studiopress.com/themes/genesis/\">Genesis Framework</a> by <a title=\"http://www.studiopress.com/\" href=\"http://www.studiopress.com/\">StudioPress</a>. It&#8217;s powered by WordPress and uses the <a title=\"http://my.studiopress.com/themes/whitespace/\" href=\"http://my.studiopress.com/themes/whitespace/\">Whitespace Pro</a> theme.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/TheDailyBoltWebsite.png\" rel=\"prettyphoto[33930]\"><img class=\"size-full wp-image-33956\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/TheDailyBoltWebsite.png?resize=1025%2C784\" alt=\"The Daily Bolt\" /></a>The Daily Bolt\n<p>The site allows Whitmer to conveniently read material <em>mostly</em> devoted to Genesis without having to use social media or a Feedreader. &#8220;Yes, I know how RSS works, but I subscribe to a lot of blogs in several different niches. I kept thinking it would be awesome to have a way to access the latest Genesis tutorials or articles without hunting them down on social media or in my RSS reader,&#8221; Whitmer said.</p>\n<p>I asked Whitmer if she plans to manually curate articles so the site contains more content dedicated to Genesis, &#8220;I created the site after polling my mailing list several months ago and they seemed interested in all the content coming from the community. So as of right now, I don’t plan to cull the other posts. However, I may remove some sites if they consistently publish articles about non-Genesis topics.&#8221;</p>\n<p>You can subscribe to the site via <a title=\"http://dailybolt.com/feed/\" href=\"http://dailybolt.com/feed/\">RSS</a> or email. Those who subscribe by email will receive a daily digest of headlines. Aside from being a cool domain, it&#8217;s a convenient way to keep tabs on the Genesis WordPress community which has become a cottage industry. Are there any sites you&#8217;d like to see added to The Dailybolt? Give us a link in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Nov 2014 20:37:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: New WordPress Plugin Boilerplate Generator Speeds Plugin Creation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33934\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/new-wordpress-plugin-boilerplate-generator-speeds-plugin-creation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2937:\"<p>When <a href=\"http://wptavern.com/wordpress-plugin-boilerplate-3-0-released-with-new-community-website\">version 3.0</a> of the <a href=\"https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate\" target=\"_blank\">WordPress Plugin Boilerplate</a> was released, it came with a brand new <a href=\"http://wppb.io/\" target=\"_blank\">community website</a>. After three years of continual improvement, creator Tom McFarlin felt that the project had finally matured enough to warrant its own branding and website.</p>\n<p>As the boilerplate gained traction, McFarlin started receiving numerous requests for a generator to simplify the process of searching and replacing text strings throughout the boilerplate&#8217;s codebase. Although the boilerplate greatly speeds the process of structuring a new plugin to use a standardized, object-oriented foundation, it still requires the developer to manually replace strings for the plugin name, slug, URI and author info.</p>\n<p>Fans of the boilerplate have tried different approaches while attempting to come up with a generator, including one that uses a <a href=\"http://wptavern.com/a-generator-for-the-wordpress-plugin-boilerplate\" target=\"_blank\">grunt-init template to generate a plugin from the boilerplate</a>. While this solution generates a plugin in about 30 seconds flat, grunt isn&#8217;t necessarily a part of every developer&#8217;s workflow.</p>\n<p>Today, McFarlin introduced a new generator option created by <a href=\"https://enriquechavez.co/\" target=\"_blank\">Enrique Chavez</a>, which provides the simplest approach to date. The <a href=\"http://wppb.me/\" target=\"_blank\">WordPress Plugin Boilerplate Generator</a> is a web app that generates a plugin without you having to replace any text strings.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/wpb-generator.jpg\" rel=\"prettyphoto[33934]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/wpb-generator.jpg?resize=902%2C638\" alt=\"wpb-generator\" class=\"aligncenter size-full wp-image-33970\" /></a></p>\n<p>Simply enter your plugin information into the form on the site. When you click the &#8220;Build&#8221; button, the app will pull the code from the Boilerplate&#8217;s master branch on GitHub and will automatically replace all the necessary text strings. The result is your customized plugin delivered in a tidy zip file. If you use the WordPress Plugin Boilerplate as a starting point for your new plugins, this generator is a handy site to bookmark.</p>\n<p>The <a href=\"https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate\" target=\"_blank\">WordPress Plugin Boilerplate</a> has now been starred more than 2,400 times on GitHub and has been forked more than 600 times. The project currently boasts 46 contributors and continues to grow. McFarlin plans to add more helpful resources to the boilerplate&#8217;s community site in early 2015 along with detailed documentation.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Nov 2014 20:02:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WPTavern: WP eCommerce Has a New Home\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33796\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wptavern.com/wp-ecommerce-has-a-new-home\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6302:\"<p>In what has been a long time coming, WP eCommerce has changed the URL of its website from <a title=\"https://wpecommerce.org/\" href=\"https://wpecommerce.org/\">GetShopped.org</a> to <a title=\"https://wpecommerce.org/\" href=\"https://wpecommerce.org/\">WPEcommerce.org</a>. Between the <a title=\"https://shopplugin.net/\" href=\"https://shopplugin.net/\">Shopp</a> e-commerce plugin and Getshopped.org, it was confusing as to which product the site represented. The move to a more recognizable URL is the pinnacle of a series of improvements the project has undergone in the past few years.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WPEcommerceWebsite.png\" rel=\"prettyphoto[33796]\"><img class=\"size-full wp-image-33941\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WPEcommerceWebsite.png?resize=1025%2C815\" alt=\"WP Ecommerce Website\" /></a>WP eCommerce Has a New Home\n<h2>A Multi-Year Rewrite of WP eCommerce</h2>\n<p>At nearly a decade old, WP eCommerce has gone through its share of ups and downs. It has a reputation among some developers in the WordPress community as being bloated and poorly coded. &#8220;The purpose of the rewrite is to bring us back up to latest WP coding standards,&#8221; Dan Milward, Founder of WP eCommerce, told the Tavern. &#8220;When we first released ​WP eCommerce, WordPress had sketchy coding standards at best (WordPress was at v1.5)​. As such, ​making a complex eCommerce Plugin back in the day was difficult and we had to do things in ways that are now frowned upon.&#8221;</p>\n<p>To put this in perspective, custom post types, taxonomies, and many of the hooks and filters developers rely on today simply didn’t exist. The legacy code has plagued the project from the beginning and is largely responsible for its negative reputation.</p>\n<p>Not having a robust set of WordPress coding standards to develop from allowed other eCommerce plugins to enter the market and leap frog over WP eCommerce. &#8220;We feel like those days are behind us and that it&#8217;s our turn to do some leap frogging.&#8221; Milward said. The alignment with today&#8217;s coding standards means WP eCommerce has a smaller footprint, runs faster, and is easier to maintain.</p>\n<h2>A Team Effort</h2>\n<p>Gary Cao, who previously lead the development of WP eCommerce, helped pave the way towards aligning it with today&#8217;s <a title=\"https://make.wordpress.org/core/handbook/coding-standards/\" href=\"https://make.wordpress.org/core/handbook/coding-standards/\">coding standards</a>. Justin Sainton, co-founder of WP eCommerce, has taken over the role and is leading the development of WP eCommerce. Sainton is a well known developer in the WordPress community and has an impressive array of core contributions to WordPress.</p>\n<p>Sainton and Milward approach problems from very different yet, complimentary angles. The relationship has helped create a better business allowing each to focus on their core strengths. The WP eCommerce support team has been instrumental in being the front line of the company. &#8220;These folks are the front line and they are turning public opinion around in the WordPress.org forums and in premium support​. They are doing a great job at serving the WP community,&#8221; Milward said.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/PippinContributesToWPECommerce.png\" rel=\"prettyphoto[33796]\"><img class=\"size-full wp-image-33940\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/PippinContributesToWPECommerce.png?resize=1002%2C440\" alt=\"Pippin Williamson of EDD With 45 Commits to WP eCommerce\" /></a>Pippin Williamson of EDD With 45 Commits to WP eCommerce\n<p>Contributions have come from non WP eCommerce core developers as well, including the competition. Pippin Williamson, founder of <a title=\"https://easydigitaldownloads.com/\" href=\"https://easydigitaldownloads.com/\">Easy Digital Downloads</a>, has <a title=\"https://github.com/wp-e-commerce/WP-e-Commerce/commits?author=pippinsplugins\" href=\"https://github.com/wp-e-commerce/WP-e-Commerce/commits?author=pippinsplugins\">45 commits</a> to the project since 2013. In early 2013, <a title=\"https://pippinsplugins.com/why-i-contribute-to-wpec/\" href=\"https://pippinsplugins.com/why-i-contribute-to-wpec/\">Williamson explained</a> in detail why he contributes to WP eCommerce.</p>\n<blockquote><p>I empathize with projects attempting to overcome a bad reputation when they clearly want to <strong>earn</strong> a better reputation. If you write bad code and never actually try to improve your project then I have a hard time believing you actually care about your users’ experience. The team behind WP e-Commerce is NOT one of those teams that doesn’t care about improving their plugin. They are one of the most down to earth, caring team of developers I’ve met. They really, really care about their users and customers, and they truly want to make WPEC a kick ass plugin again.</p></blockquote>\n<p>Ben​ Huson​, Lee​ Willis​, Jeff​ Shutzman​,​ and Curtis McHale, <a title=\"https://github.com/wp-e-commerce/WP-e-Commerce/graphs/contributors\" href=\"https://github.com/wp-e-commerce/WP-e-Commerce/graphs/contributors\">among others</a> also contribute to the project.</p>\n<h2>The Future of WP eCommerce</h2>\n<p>With the launch of the new site complete, Milward says the next feature they&#8217;re working on is implementing a theme engine based on the work John James Jacoby put into bbPress and BuddyPress. New object-oriented APIs and integration with the upcoming WP-API are among some of the other features planned for a future release. There will also be improvements to the WP eCommerce marketplace ecosystem for developers.</p>\n<h2>Time to Give it Another Chance?</h2>\n<p>WP eCommerce is nine years old and continues to chip away at legacy code, but has made substantial improvements over the past two years. Perhaps it&#8217;s time developers and users give it another chance. WP eCommerce is free to use and <a title=\"https://wordpress.org/plugins/wp-e-commerce/\" href=\"https://wordpress.org/plugins/wp-e-commerce/\">available</a> in the WordPress plugin directory. If you&#8217;ve recently launched a project or use WP eCommerce, feel free to share your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Nov 2014 18:30:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Automattic Open Sources Its DMCA Process Docs on GitHub\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33856\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2791:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/automattic-offices.jpg\" rel=\"prettyphoto[33856]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/automattic-offices.jpg?resize=1025%2C478\" alt=\"photo credit: Peter Slutsky\" class=\"size-full wp-image-22370\" /></a>photo credit: <a href=\"http://peterslutsky.com/2013/05/14/pics-touring-automattics-new-office/\">Peter Slutsky</a>\n<p>A couple months ago, <a href=\"http://automattic.com/\" target=\"_blank\">Automattic</a> made headlines with its public dismissal of Janet Jackson&#8217;s spurious claims of trademark and copyright infringement. Jackson is now a fixture in the company&#8217;s <a href=\"http://transparency.automattic.com/2014/09/01/sorry-ms-jackson/\" target=\"_blank\">Hall of Shame</a>, along with others who have issued abusive takedown demands. Automattic considers these a threat to freedom of speech and has even taken to the courts to <a href=\"http://en.blog.wordpress.com/2013/11/21/striking-back-against-censorship/\" target=\"_blank\">protect users from DMCA abuse</a>.</p>\n<p>Today, the company is <a href=\"http://transparency.automattic.com/2014/11/18/open-sourcing-our-dmca-process/\" target=\"_blank\">open sourcing its DMCA process docs</a> under the <a href=\"https://github.com/Automattic/legalmattic\" target=\"_blank\">Legalmattic</a> repository on GitHub, which sports the tagline <em>&#8220;Democratizing WordPress.com legalese since 2014.&#8221;</em> This collection of documents contains more than two dozen &#8216;predefined replies&#8217; that Automattic uses when corresponding to various parties in the event of a complaint. It also includes a copy of the <a href=\"http://automattic.com/dmca-notice/\" target=\"_blank\">DMCA Takedown Notice</a> and <a href=\"http://automattic.com/dmca-counter-notice/\" target=\"_blank\">Counter Notice</a> documents.</p>\n<p>The team at Automattic hopes that the open source <a href=\"https://github.com/Automattic/legalmattic\" target=\"_blank\">DMCA process docs</a> will help others to more easily implement their own processes for dealing with takedown notices. These documents are a valuable resource for small businesses and individuals who don&#8217;t have a legal team at their disposal to draft up appropriate replies to complaints. The DMCA process docs are released under the <a href=\"http://creativecommons.org/licenses/by-sa/3.0/legalcode\" target=\"_blank\">Creative Commons Attribution-ShareAlike 3.0 license</a> and users are encouraged to re-use and edit them for their own purposes.</p>\n<p>Whether you administer a large blogging network or simply maintain a small  blog of your own, Automattic&#8217;s predefined responses may provide a good starting point for getting a grasp on the language and the process of dealing with DMCA complaints.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 23:04:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: I18n and RTL Support Are Top Priorities For Web Savvy Marketing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33898\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/i18n-and-rtl-support-are-top-priorities-for-web-savvy-marketing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3461:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/globe.jpg\" rel=\"prettyphoto[33898]\"><img class=\"size-full wp-image-23969\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/globe.jpg?resize=800%2C368\" alt=\"photo credit: Sarah Elizabeth Altendorf - cc\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/sarah_elizabeth_simpson/6263928301/\">Sarah Elizabeth Altendorf</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc/2.0/\">cc</a>\n<p>This year&#8217;s <a title=\"http://wptavern.com/matt-mullenwegs-state-of-the-word-highlights-internationalization-mobile-and-new-tools-for-wordpress-contributors\" href=\"http://wptavern.com/matt-mullenwegs-state-of-the-word-highlights-internationalization-mobile-and-new-tools-for-wordpress-contributors\">State of the Word</a> at WordCamp San Francisco emphasized WordPress going global through improvements to internationalization. This year also marks the first time non-English downloads of WordPress have surpassed its English counterpart.</p>\n<h2>Catering to Customer&#8217;s Needs</h2>\n<p>With WordPress raising the bar, it won&#8217;t be long until users and customers <strong>expect</strong> themes and plugins to be translatable and available in multiple languages. Rebecca Gill, of Web Savvy Marketing, <a title=\"http://www.web-savvy-marketing.com/2014/11/wordpress-internationalization/\" href=\"http://www.web-savvy-marketing.com/2014/11/wordpress-internationalization/\">announced</a> its catalog of themes are now translatable and coded for localization and multilingual use.</p>\n<p>In her post, Gill explains the thought process behind the move.</p>\n<blockquote><p>If 50% of our product sales are internationally based, then I need to spend time making sure these buyers are being taken care of and clearly I wasn’t. I was expecting this to be handled by Genesis, the WordPress core, or translation plugins.</p>\n<p>I didn’t realize how badly I was ignoring the needs of our international customer base. And for that, I am truly sorry.</p></blockquote>\n<p>The work was completed through a collaborated effort between Carrie Dils, Nir Rosenbaum, and Gary Jones. Each theme has been updated to include <a title=\"http://codex.wordpress.org/I18n_for_WordPress_Developers\" href=\"http://codex.wordpress.org/I18n_for_WordPress_Developers\">I18n</a> and <a title=\"http://codex.wordpress.org/Right-to-Left_Language_Support\" href=\"http://codex.wordpress.org/Right-to-Left_Language_Support\">RTL</a> (Right to Left) support. Files included in each theme are:</p>\n<ul>\n<li><strong> POT File</strong> – A file with i18n ready strings.</li>\n<li><strong>en_US.po File</strong> – A file with translated strings and English strings.</li>\n<li><strong>en_US.mo File</strong> – A file converted to a format optimized to be read by machines.</li>\n<li><strong>RTL Style Sheet</strong> – Overwrites horizontal positioning attributes of your CSS stylesheet in a separate stylesheet file named rtl.css.</li>\n</ul>\n<p>Ever theme is an opportunity to learn techniques, code, and best-practices. I believe the quickest way to make an impact and to raise awareness is for commercial theme companies to support and advertise I18n and RTL as cool features.</p>\n<p>The fact these improvements are part of a smart business move doesn&#8217;t detract from their importance. The more theme developers and companies who place I18n and RTL near the top of the priority list, the better.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 23:02:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WPTavern: 20 Reasons To Attend a WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33784\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://wptavern.com/20-reasons-to-attend-a-wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Ask twenty people why you should go to a WordCamp and you&#8217;ll likely receive 20 different answers. A <a title=\"http://www.cloudways.com/blog/wordpress-thought-leaders-wordcamps/\" href=\"http://www.cloudways.com/blog/wordpress-thought-leaders-wordcamps/\">recent post</a> by Waseem Abbas, of <a title=\"http://www.cloudways.com/blog/wordpress-thought-leaders-wordcamps/\" href=\"http://www.cloudways.com/blog/wordpress-thought-leaders-wordcamps/\">Cloudways</a>, is proof positive. He asked 20 different members of the WordPress community, including yours truly, why you should attend a WordCamp. He&#8217;s compiled the answers into a slidehsare document.</p>\n<p> </p>\n<div></div>\n<p>Like <a title=\"http://bluesteelesolutions.com/\" href=\"http://bluesteelesolutions.com/\">Heather Baker Steele</a>, I view WordCamps as family reunions with family members <strong>I want</strong> to socialize with! The WordPress family continues to grow rapidly every year and WordCamps are opportunities to not only strengthen relationships but also to create new ones.</p>\n<p>Check out the <a title=\"http://central.wordcamp.org/schedule/\" href=\"http://central.wordcamp.org/schedule/\">official WordCamp schedule</a> to see if there&#8217;s an event near you. Also check <a title=\"http://www.meetup.com/\" href=\"http://www.meetup.com/\">Meetup.com</a> to see if there&#8217;s a WordPress meetup close by. WordPress meetups are like WordCamps but on a much smaller scale.</p>\n<p>Last but not least, if you&#8217;re planning on going to your first WordCamp, read this <a title=\"http://www.carriedils.com/wordcamp-tips/\" href=\"http://www.carriedils.com/wordcamp-tips/\">survival guide</a> by Carrie Dils. The guide contains advice that improves the chance you&#8217;ll have a great experience.</p>\n<p>What&#8217;s your reason for attending a WordCamp?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 20:59:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Postmatic Now Supports 1-Click Migration of Subscribers from Jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33854\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/postmatic-now-supports-1-click-migration-of-subscribers-from-jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2990:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/postmatic1.jpg\" rel=\"prettyphoto[33854]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/postmatic1.jpg?resize=810%2C378\" alt=\"postmatic\" class=\"aligncenter size-full wp-image-33866\" /></a></p>\n<p><a href=\"http://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is hoping to revolutionize WordPress comments by giving readers a way to subscribe to new posts/comments via email and leave a comment by simply hitting reply. Since email is usually the way most people find out about comments, having the ability to reply without leaving your inbox in convenient, especially when you&#8217;re on the go.</p>\n<p>Postmatic&#8217;s post and comment subscriptions feature is quite similar to <a href=\"http://jetpack.me/support/subscriptions/\" target=\"_blank\">Jetpack&#8217;s subscriptions module</a>. Jetpack is the plugin&#8217;s strongest competitor. While both plugins are free and perform similar functions, Postmatic includes the added ability to reply by email, subscription invitations, and a mobile-friendly email template that is fully customizable.</p>\n<p>Today, Postmatic&#8217;s co-founder Jason Lemieux <a href=\"http://gopostmatic.com/2014/11/beta6/\" target=\"_blank\">announced</a> that the plugin now supports single-click migration of subscribers from Jetpack. The beta 6 version of the plugin introduces a secure importer that will copy over all of your new post notification Jetpack subscribers in a matter of seconds.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/postmatic-jetpack-import.png\" rel=\"prettyphoto[33854]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/postmatic-jetpack-import.png?resize=929%2C340\" alt=\"postmatic-jetpack-import\" class=\"aligncenter size-full wp-image-33876\" /></a></p>\n<p>Beta 6 adds a native Postmatic exporter to allow users to export their subscribers, along with subscription preferences, to a CSV file. Postmatic&#8217;s creators are also gradually adding to a <a href=\"http://gopostmatic.com/faq/postmatic-render-shortcodes/\" target=\"_blank\">shortcode whitelist</a> that will allow the display of third-party shortcode content in emails.</p>\n<p>The <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">plugin</a> is available on WordPress.org and is production ready but is still in limited-release beta. Postmatic is releasing a few hundred API keys per week to those who <a href=\"http://gopostmatic.com/beta/\" target=\"_blank\">sign up for beta access</a>.</p>\n<p>In the future, the Postmatic creators hope to monetize the plugin by offering paid delivery of outgoing mail for larger sites, Lemieux told Post Status in a recent <a href=\"http://www.poststat.us/postmatic-wordpress-email/\" target=\"_blank\">interview</a>. They also have an extensive list of planned features. The basic Postmatic plugin, however, will remain free for any number of blogs with any number of posts and subscribers.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 20:08:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Gigaom’s Blazing Fast WordPress Search is Enhanced by Sphinx and Scriblio\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/gigaoms-blazing-fast-wordpress-search-is-enhanced-by-sphinx-and-scriblio\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5021:\"<p><a href=\"https://gigaom.com\" target=\"_blank\">Gigaom</a> has been pumping out a steady stream of news and analysis on technology since 2006. The WordPress-powered site attracts 6.5 million monthly unique visitors with topics ranging from science and energy to cloud businesses, media and mobile.</p>\n<p>With years of articles buried in its archives, it&#8217;s important for Gigaom to have a solid search experience. The site&#8217;s engineering team, led by <a href=\"https://profiles.wordpress.org/misterbisson/\" target=\"_blank\">Casey Bisson</a>, opted to utilize Sphinx in order to improve upon WordPress&#8217; native searching capabilities.</p>\n<p>The result is a super fast dedicated search page at <a href=\"http://search.gigaom.com/\" title=\"Gigaom Search\" target=\"_blank\">search.gigaom.com</a> that features the ability to further narrow results based on available terms.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/gigaom-search.png\" rel=\"prettyphoto[33789]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/gigaom-search.png?resize=1025%2C1023\" alt=\"gigaom-search\" class=\"aligncenter size-full wp-image-33809\" /></a></p>\n<p>The advanced search feature was built using a combination of several open source plugins built by Bisson. These plugins integrate Sphinx and taxonomy filtering to help users more easily explore Gigaom&#8217;s wealth of content. All the tools are open source and were contributed back to the community for anyone to use.</p>\n<h4>What is Sphinx?</h4>\n<p><a href=\"http://sphinxsearch.com/\" target=\"_blank\">Sphinx</a> is a GPL-licensed full text search server that was created to be highly performant while returning the most relevant results. In order to integrate it with WordPress, Bisson developed <a href=\"https://wordpress.org/plugins/go-sphinx/\" target=\"_blank\">Gigaom Sphinx</a>. The plugin pulls WordPress posts into Sphinx and then queries them using the standard <a href=\"https://developer.wordpress.org/reference/classes/wp_query/\" target=\"_blank\">WP_Query</a> class.</p>\n<p>Gigaom Sphinx requires that you first <a href=\"http://sphinxsearch.com/docs/current/installation.html\" target=\"_blank\">install Sphinx</a> and then set it up with the sample config file, which includes parameters to index the site&#8217;s content. Once the site is fully indexed in Sphinx, WordPress query performance will be greatly improved.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/sphinx-config.png\" rel=\"prettyphoto[33789]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/sphinx-config.png?resize=700%2C531\" alt=\"sphinx-config\" class=\"aligncenter size-full wp-image-33825\" /></a></p>\n<h4>Scriblio</h4>\n<p>In order to further filter results, Gigaom uses <a href=\"https://wordpress.org/plugins/scriblio/\" title=\"Scriblio plugin\" target=\"_blank\">Scriblio</a>, a plugin that provides faceted searching and browsing of WordPress posts, pages, and custom post types. This enables users to further narrow down results based on taxonomies and their available terms. The facets are easily added via configurable widgets, which you can include on your site&#8217;s search, tag and category archives, and other archive pages.</p>\n<p>Search results can be filtered using multiple terms. This allows visitors to quickly nail down the most relevant content.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/example-search.png\" rel=\"prettyphoto[33789]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/example-search.png?resize=1025%2C821\" alt=\"example-search\" class=\"aligncenter size-full wp-image-33833\" /></a></p>\n<p>The facets can be displayed as either tag clouds or lists, as shown above. Scriblio&#8217;s search editor widget will show the selected search terms and allows the user to easily add or remove terms while automatically updating results.</p>\n<p>The plugin also includes live search suggestions as you type. These recommendations are based on all available taxonomies as well as post titles.</p>\n<h4>bCMS</h4>\n<p>The last plugin required to create Gigaom&#8217;s unique search experience is <a href=\"https://wordpress.org/plugins/bcms/\" target=\"_blank\">bCMS</a>, which was also developed by Bisson. It enhances WordPress&#8217; CMS capabilities in a number of ways and includes a setting to enable full text keyword indexing.</p>\n<p>For a full rundown of Gigaom&#8217;s searching capabilities, check out the <a href=\"http://search.gigaom.com/faq/\" target=\"_blank\">FAQ item devoted to search</a>. Thanks to Bisson and the Gigaom team, these tools are available for any WordPress site administrator to use. If you need more fine-grained sorting capabilities for search results, the combination of <a href=\"https://wordpress.org/plugins/go-sphinx/\" target=\"_blank\">Gigaom Sphinx</a>, <a href=\"https://wordpress.org/plugins/scriblio/\" target=\"_blank\">Scriblio</a> and <a href=\"https://wordpress.org/plugins/bcms/\" target=\"_blank\">bCMS</a> is a solid option.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 05:56:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"WPTavern: Installatron Partners With Clef to Add Two-Factor Authentication to Automated Installs of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"http://wptavern.com/installatron-partners-with-clef-to-add-two-factor-authentication-to-automated-installs-of-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2729:\"<p>In a bid to protect as many users as possible by default, <a title=\"https://getclef.com/\" href=\"https://getclef.com/\">Clef</a> has partnered with <a title=\"http://installatron.com/\" href=\"http://installatron.com/\">Installatron</a>. Founded in 2004, Installatron is one of the most popular script installers used on the web. Similar to <a title=\"https://www.netenberg.com/fantastico.php\" href=\"https://www.netenberg.com/fantastico.php\">Fantastico</a> and <a title=\"http://www.softaculous.com/\" href=\"http://www.softaculous.com/\">Softaculous</a>, Installatron is a script installer that enables users to quickly install more than <a title=\"http://installatron.com/apps\" href=\"http://installatron.com/apps\">170 different applications </a>including, WordPress, Drupal, and Joomla.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/InstallatronApps.png\" rel=\"prettyphoto[33735]\"><img class=\"size-full wp-image-33780\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/InstallatronApps.png?resize=650%2C200\" alt=\"Installatron Apps\" /></a>Installatron Apps\n<p><a title=\"https://getclef.com/\" href=\"https://getclef.com/\">Clef</a> is a mobile app that replaces usernames and passwords, enabling users to log in easily with their smartphones. The <a title=\"https://wordpress.org/plugins/wpclef/\" href=\"https://wordpress.org/plugins/wpclef/\">Clef WordPress plugin</a> is growing rapidly in popularity, with over 130,000 downloads and over 15,000 sites using the service. The partnership enables automated WordPress installs from Installatron to have Clef support out of the box. The partnership also enables webhosts that use Installatron to be added to Clef&#8217;s <a title=\"http://getclef.com/safer-hosts\" href=\"http://getclef.com/safer-hosts\">Safer Hosts Program</a>.</p>\n<p>“Making two-factor accessible around the web is a critical step in securing our lives online,” said Brennen Byrne, CEO at Clef. “Protecting new users by default, instead of requiring research and expertise, is how we will build a safer Internet. Installatron has been a leader in providing secure infrastructure for their huge customer base and we’re excited to be a big part of it.”</p>\n<p>Earlier this year, <a title=\"http://wptavern.com/clef-partners-with-softaculous-to-provide-2-step-authentication-for-automated-wordpress-installs\" href=\"http://wptavern.com/clef-partners-with-softaculous-to-provide-2-step-authentication-for-automated-wordpress-installs\">Clef partnered with Softaculous</a> to provide two-factor authentication to automated WordPress installs. By leveraging partnerships with companies like Softaculous and Installatron, Clef is rapidly making a huge impact in securing the web by default.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 00:21:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WPTavern: SIDEKICK Delays The Release of Composer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wptavern.com/sidekick-delays-the-release-of-composer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5566:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/SIDEKICKBalanceFeaturedImage.png\" rel=\"prettyphoto[33730]\"><img class=\"size-full wp-image-33731\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/SIDEKICKBalanceFeaturedImage.png?resize=632%2C298\" alt=\"SIDEKICK Balance Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/dandiffendale/3342770174/\">diffendale</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Among the festivities at <a title=\"http://2014.toronto.wordcamp.org/\" href=\"http://2014.toronto.wordcamp.org/\">WordCamp Toronto 2014,</a> was the planned release of <a title=\"http://www.sidekick.pro/composer/\" href=\"http://www.sidekick.pro/composer/\">Composer</a> by <a title=\"http://www.sidekick.pro/\" href=\"http://www.sidekick.pro/\">SIDEKICK</a>. Instead, Composer has been delayed and the release date is <em>to be determined</em>. According to the <a title=\"http://www.sidekick.pro/blog/learn-through-doing/launching-composer-tomorrow/\" href=\"http://www.sidekick.pro/blog/learn-through-doing/launching-composer-tomorrow/\">announcement</a>, the plugin and its architecture are not ready for customers just yet. In a FAQ accompanying the post, SIDEKICK Co-founder, Ben Fox, gives more details on what&#8217;s not ready.</p>\n<blockquote><p>A little bit of everything really. The new architecture which is going to power SIDEKICK Composer and the new version of our Player is kick-ass and working but the integration between it, the new account centre, the billing system and Composer itself is still “fragile”.  Add to that the fact that the new version of our website, which is necessary to power the front-end of the new Account Center, isn’t complete yet and we have a recipe for launch disaster.</p></blockquote>\n<p>Although it is disappointing to those who expected to purchase Composer over the weekend, at least one person cites the news as a good example of what to do when you&#8217;re not ready to launch a product.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>This is what you do when your software isn’t quite ready to go by launch date: <a href=\"http://t.co/pEkKNbPvUw\">http://t.co/pEkKNbPvUw</a></p>\n<p>&mdash; Aaron Hockley (@ahockley) <a href=\"https://twitter.com/ahockley/status/533427677831901184\">November 15, 2014</a></p></blockquote>\n<p></p>\n<p>Since the news broke, SIDEKICK has received an unexpected outpouring of support. &#8220;Something like 30 direct emails, numerous tweets and FaceBook messages plus we were approached at WordCamp Toronto by many people who offered their support for our choice,&#8221; Fox told the Tavern. Several people have commended SIDEKICK for its transparency. &#8220;What really got me though was not just the understanding our customers and community have shown but also the praise for our direct and transparent communication.&#8221;</p>\n<h2>Finding The Balance Between Good Enough and Don&#8217;t Ship</h2>\n<p>Despite a lot of talk in the WordPress community around the idea of &#8220;<a title=\"http://wordpress.tv/2014/10/28/keynote-speaker-cory-miller-what-it-means-to-click-publish/\" href=\"http://wordpress.tv/2014/10/28/keynote-speaker-cory-miller-what-it-means-to-click-publish/\">just ship it</a>&#8220;, SIDEKICK decided to hold off to fix a few loose ends. In an essay by Matt Mullenweg entitled &#8220;<a title=\"http://ma.tt/2010/11/one-point-oh/\" href=\"http://ma.tt/2010/11/one-point-oh/\">1.0 Is The Loneliest Number</a>,&#8221; he uses Apple as an example of a company that&#8217;s not afraid to ship a rudimentary version 1.0 to the public. The essay goes on to describe the idea of <em>ship early, iterate often</em> and how it&#8217;s the approach used to develop WordPress.</p>\n<blockquote><p>By shipping early and often you have the unique competitive advantage of hearing from real people what they think of your work, which in best case helps you anticipate market direction, and in worst case gives you a few people rooting for you that you can email when your team pivots to a new idea. Nothing can recreate the crucible of real usage.</p>\n<p>You think your business is different, that you’re only going to have one shot at press and everything needs to be perfect for when Techcrunch brings the world to your door. But if you only have one shot at getting an audience, you’re doing it wrong.</p></blockquote>\n<p>The challenge of releasing the first version of a product or service is one many companies are familiar with. Composer is not ready for prime time but the question is, how will Fox and his team determine when it&#8217;s ready? &#8220;SIDEKICK will never be perfect in our eyes and we waited until the last possible moment to make the call because we wanted to make sure we weren&#8217;t releasing simply out of a need for perfection,&#8221; Fox told the Tavern. &#8220;I can&#8217;t speak for the entire community or other startups but I can tell you that while we&#8217;re not afraid to release a product that&#8217;s not &#8216;perfect&#8217;, we will never release something that doesn&#8217;t work as advertised just for the sake of making a release date.&#8221;</p>\n<h2>Where is The Happy Medium?</h2>\n<p>When it comes to releasing a product, there appears to be a happy medium of being good enough for consumer adoption but not bad enough to delay the release. As a product developer or service provider, how do you determine when your product or service has reached the happy medium and what factors go into the decision? Let us know in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2014 00:09:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Peak Beard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44527\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://ma.tt/2014/11/peak-beard/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:537:\"<p>&#8220;If, like me, you are a staunch pogonophile and do not believe there is a single man who cannot be improved with a beard, these are happy times indeed.&#8221; The Guardian asks <a href=\"http://www.theguardian.com/fashion/2013/jul/24/have-we-reached-peak-beard\">Have we reached peak beard?</a>. Also check out <a href=\"http://www.theguardian.com/commentisfree/2014/nov/14/lumbersexual-beard-plaid-male-fashion\">their take on the lumbersexual</a>, which a closet full of plaid shirts might indicate I&#8217;m trending toward.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Nov 2014 19:53:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WP Slack Plugin Sends Notifications to Slack Based on Events Triggered in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33712\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://wptavern.com/wp-slack-plugin-sends-notifications-to-slack-based-on-events-triggered-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5580:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-slack.png\" rel=\"prettyphoto[33712]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-slack.png?resize=1025%2C483\" alt=\"wp-slack\" class=\"aligncenter size-full wp-image-33724\" /></a></p>\n<p>In a matter of months, <a href=\"https://slack.com/\" target=\"_blank\">Slack</a> has managed to become the favorite communication tool for thousands of businesses, boasting more than <a href=\"http://techcrunch.com/2014/10/23/slack-is-raising-another-round-at-up-to-a-1b-valuation/\" target=\"_blank\">250,000 daily active users</a>, with roughly 30% of them paying for the service. The company recently acquired $120 million to fund further growth and is now valued at $1.1 billion dollars.</p>\n<p>While Slack helps teams get things done together, much of the actual work happens outside of the app. That&#8217;s why the <a href=\"https://api.slack.com/\" target=\"_blank\">Slack API</a> offers the ability to add new <a href=\"https://my.slack.com/services/new/incoming-webhook\" target=\"_blank\">Incoming WebHooks</a> to integrate outside services. With WordPress powering 23%+ of the world&#8217;s websites, it&#8217;s important to have an easy way to bring in notices from those sites.</p>\n<p>Self-hosted WordPress installations have the option of using the <a href=\"https://wordpress.org/plugins/slack/\" target=\"_blank\">Slack plugin</a>, created by <a href=\"http://gedex.web.id/\" target=\"_blank\">Akeda Bagus</a>, a developer with X-team. Last week we featured the <a href=\"http://wptavern.com/bbpress-slack-integration-send-new-topics-and-replies-to-a-slack-channel\" target=\"_blank\">bbPress Slack Integration</a> plugin, which allows you to send notifications of new bbPress topics and replies to your Slack channel of choice. WP Slack performs a similar function for general WordPress events.</p>\n<p>The plugin is capable of notifying Slack, based on a few basic events:</p>\n<ul>\n<li>When a post needs review (status transitioned to &#8216;pending&#8217;)</li>\n<li>When a post is published</li>\n<li>When there&#8217;s a new comment</li>\n</ul>\n<p>Additionally, it includes a <code>slack_get_events</code> filter for adding more events. The <a href=\"http://gedex.web.id/wp-slack/\" target=\"_blank\">documentation</a> provides an example of creating a new event that will notify Slack when a user is logged in:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">add_filter( \'slack_get_events\', function( $events ) {\n    $events[\'user_login\'] = array(\n        \'action\'      =&gt; \'wp_login\',\n        \'description\' =&gt; __( \'When user logged in\', \'slack\' ),\n        \'message\'     =&gt; function( $user_login ) {\n            return sprintf( \'%s is logged in\', $user_login );\n        }\n    );\n\n    return $events;\n} );</pre>\n<p>Configuration inside the WordPress admin is simple. Once you&#8217;ve set up the webhook with Slack, you simply paste it into the Service URL field when setting up an integration:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-integration.png\" rel=\"prettyphoto[33712]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-integration.png?resize=843%2C524\" alt=\"slack-integration\" class=\"aligncenter size-full wp-image-33756\" /></a></p>\n<p>WP Slack allows you to set up multiple integrations so you can send notices to different channels. Notices can also be temporarily deactivated and turned back on a later time. When you finish setting up an integration, the plugin allows you to fire off a test notification to ensure that it&#8217;s working correctly.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/channel-notification.png\" rel=\"prettyphoto[33712]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/channel-notification.png?resize=843%2C227\" alt=\"channel-notification\" class=\"aligncenter size-full wp-image-33758\" /></a></p>\n<p>Bagus has also developed a suite of free extensions that notify Slack based on events triggered by other plugins:</p>\n<ul>\n<li><a href=\"http://wordpress.org/plugins/slack-edd\" target=\"_blank\">Slack EDD</a></li>\n<li><a href=\"http://wordpress.org/plugins/slack-woocommerce\" target=\"_blank\">Slack WooCommerce</a></li>\n<li><a href=\"http://wordpress.org/plugins/slack-contact-form-7\" target=\"_blank\">Slack Contact Form 7</a></li>\n<li><a href=\"http://wordpress.org/plugins/slack-gravityforms\" target=\"_blank\">Slack Gravity Forms</a></li>\n</ul>\n<p>These plugins make it possible to keep your team notified of new orders on a WooCommerce or EDD-powered store, or even website inquiries from your site&#8217;s contact form. Each extension requires the Slack plugin to be installed first.</p>\n<p>While the plugin author hasn&#8217;t announced plans to add this feature, it might be useful to have support for <a href=\"https://my.slack.com/services/new/outgoing-webhook\" target=\"_blank\">Outgoing Webhooks</a> as well. That would make it possible for WordPress to get information back from Slack based on public triggers used in the channel. The possibilities for this could be interesting. For example, you could set up a trigger that automatically creates a new draft or perhaps publishes a one-sentence summary of a quick meeting.</p>\n<p>The <a href=\"https://wordpress.org/plugins/slack/\" title=\"WordPress Slack plugin\" target=\"_blank\">Slack plugin for WordPress</a> is available in the official Plugin Directory. You can also find the project on <a href=\"https://github.com/gedex/wp-slack\" target=\"_blank\">GitHub</a> where pull requests are welcome.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Nov 2014 18:35:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: Munchery is Eating the Restaurant\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44307\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://ma.tt/2014/11/munchery-is-eating-the-restaurant/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:285:\"<p><a href=\"http://stavreas.com/munchery-is-eating-the-restaurant/\">Munchery is Eating the Restaurant</a>, a cool write-up of Munchery which I&#8217;ve been a long-time fan of and is an <a href=\"http://audrey.co/\">Audrey</a> company. Whenever I&#8217;m in SF I order from Munchery.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 16 Nov 2014 18:32:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Matt: Government Going Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44520\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://ma.tt/2014/11/government-going-open-source/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:195:\"<p><a href=\"http://www.techrepublic.com/article/as-open-source-goes-mainstream-institutions-collaborate-differently/\">As open source goes mainstream, institutions collaborate differently</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Nov 2014 16:56:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: WordPress 4.1 Beta 1 Now Available for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33564\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wptavern.com/wordpress-4-1-beta-1-now-available-for-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3042:\"<p>WordPress 4.1 beta 1 was <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\" target=\"_blank\">released</a> into the hands of eager testers today, just in time for the weekend. John Blackbourn announced the beta and outlined a list of features and improvements that you&#8217;ll want to put through the paces. The most visible items include the following:</p>\n<ul>\n<li>The new Twenty Fifteen default theme</li>\n<li>New distraction-free writing mode for the editor, enabled by default for beta</li>\n<li>The ability to automatically install new language packs right from the General Settings screen (available as long as your site&#8217;s file system is writable).</li>\n<li>A new inline formatting toolbar for images embedded into posts.</li>\n</ul>\n<p>The items listed do not include everything that&#8217;s coming in 4.1, but rather the features that require the most testing before the official release. There are also many improvements under the hood for developers to test:</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2014/10/20/update-on-query-improvements-in-4-1/\" target=\"_blank\">Improvements to meta, date, comment, and taxonomy queries</a>, including complex (nested, multiple relation) queries; and querying comment types</li>\n<li>A single term shared across multiple taxonomies is now split into two when updated.</li>\n<li>A new and better way for themes to handle <a href=\"http://wptavern.com/wordpress-4-1-to-introduce-theme-support-for-the-title-tag\" target=\"_blank\">title tags</a>.</li>\n<li><a href=\"https://make.wordpress.org/core/2014/10/27/toward-a-complete-javascript-api-for-the-customizer/\" target=\"_blank\">Improvements to the Customizer API</a>, including contextual panels and sections, and JavaScript templates for controls.</li>\n</ul>\n<p>The <a href=\"http://wptavern.com/focus-project-and-session-ui-approved-for-merge-into-wordpress-4-1\" target=\"_blank\">Focus project (the new DFW) was merged into core along with the user session UI</a>. So far, reaction to the new distraction-free writing mode has been mixed, with the most vocal feedback coming from those who are not looking forward to turning the feature off on multiple sites. WordPress core contributors will be gathering feedback during the beta period in order to determine whether or not the new DFW mode will be shipped as &#8220;on&#8221; by default. Having it off by default decreases users&#8217; ability to discover the new DFW mode, but it would also help it to be more universally well-received.</p>\n<p>If you want to jump in and help test 4.1 beta 1 with all its exciting improvements, the easiest way is to get hooked up with the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin. This will allow you to update your test install to use the “bleeding edge nightlies.&#8221; The other option is to download the zip file from Blackbourn&#8217;s <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\" target=\"_blank\">beta 1 announcement</a> post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 23:15:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Embrace HTTPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://ma.tt/2014/11/embrace-https/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"<p><a href=\"http://open.blogs.nytimes.com/2014/11/13/embracing-https/\">9 Reasons Why News Media Sites Should Embrace HTTPS in 2015</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 22:09:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: DevriX and Emil Uzelac Team Up to Produce Masonry, A Free WordPress Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33643\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/devrix-and-emil-uzelac-team-up-to-produce-masonry-a-free-wordpress-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5454:\"<p><a href=\"https://wordpress.org/themes/masonry\" target=\"_blank\">Masonry</a> is a new free WordPress theme with an elegant 1-column design. You&#8217;d be hard-pressed to find a theme that is easier to set up. It offers just a handful of options built into the native customizer, including the ability to customize the header colors and header background image.</p>\n<p>The theme is mobile-friendly, with a hidden sidebar that houses the primary navigation and widgets. It also has support for a footer menu and a social links menu at the top. With the help of the <a href=\"https://wordpress.org/plugins/regenerate-thumbnails/\" target=\"_blank\">Regenerate Thumbnails</a> plugin, you can have an existing site looking just like the Masonry demo in a matter of a couple minutes.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/masonry.png\" rel=\"prettyphoto[33643]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/masonry.png?resize=880%2C660\" alt=\"masonry\" class=\"aligncenter size-full wp-image-33648\" /></a></p>\n<h3>The Story Behind Masonry: A WordPress.org Theme Collaboration</h3>\n<p>There&#8217;s a unique story behind the creation of this theme. Masonry was started as a collaboration project between WordPress theme designer <a href=\"http://uzelac.com/\" target=\"_blank\">Emil Uzelac</a> and <a href=\"http://devrix.com/\" target=\"_blank\">DeviX</a>, a development company founded by Mario Peshev and Stanko Metodiev.</p>\n<p>Uzelac is most well-known for his work on the <a href=\"http://wptavern.com/a-day-in-the-life-of-a-wordpress-theme-reviewer\" target=\"_blank\">WordPress.org Theme Review Team</a> and his popular free <a href=\"http://wordpress.org/themes/responsive\" target=\"_blank\">Responsive theme</a> that was eventually <a href=\"http://mattreport.com/trent-lapinski-cyberchimps/\" target=\"_blank\">acquired by CyberChimps</a>. He put out a tweet, announcing his availability:</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>You have a WordPress project and I have 2 weeks free, let’s talk! <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a></p>\n<p>&mdash; Emil Uzelac (@emiluzelac) <a href=\"https://twitter.com/emiluzelac/status/508451598620979200\">September 7, 2014</a></p></blockquote>\n<p></p>\n<p>Uzelac was Peshev&#8217;s mentor for the Theme Review Team in 2011 before he promoted him to a reviewer. This was back in the days when you had to pass more than a dozen test reviews before moving on. &#8220;Emil is super dedicated to the WPTRT and a great person and should not be left unemployed at any time,&#8221; Peshev said. He responded to his tweet, and a theme collaboration was born.</p>\n<p>DevriX set out some ideas for the theme and then hired Uzelac to design and develop it. &#8220;We have added several things and will keep maintaining it, but we paid him for a full zip file that was (almost) ready to go on WordPress.org,&#8221; Peshev said. &#8220;Since he&#8217;s one of the TRT admins, it was the easiest way to cover the hundreds of requirements there.&#8221;</p>\n<p>Peshev said that DevriX gets no practical business benefit from the theme, as the company doesn&#8217;t perform customization or installation services. He saw it as a good way to give back to the community while also helping volunteers to find more work for their expertise.</p>\n<h3>Making the Theme Review Team More Visible</h3>\n<p>As a result of this collaboration experience, Peshev discovered that there is no easy way for people to find and hire those who are skilled at preparing a theme for approval on WordPress.org. He suggested that a directory of Theme Review team members might be a good idea for promoting the folks who have  these abilities.</p>\n<blockquote><p>There is no clear way to hire any of them for theme reviews or building a theme following the WordPress.org guidelines. I assume that small and medium agencies would be willing to pay for professional reviews or getting themes built for any reason, which would support both parties. I&#8217;ve had several clients paying for code reviews and fixing themes in order to get them in the WordPress.org Theme Directory.</p></blockquote>\n<p>In the past, themes have sometimes taken months to go through the process, after getting rejected a few times and then finally gaining approval. Hiring someone to help prepare a theme to pass WordPress.org guidelines can save a company a good chunk of time. <strong>&#8220;Given the 4-6 week period to get a theme reviewed, that&#8217;s a valuable service,&#8221;</strong> Peshev said.</p>\n<p>A directory would help people in the community to be able to identify the qualified Theme Review Team volunteers available to hire for code review, even for products that are marketed outside of WordPress.org. &#8220;Same goes for all the other teams that don&#8217;t get props in the Core releases, such as docs, polyglots and accessibility&#8221; Peshev said. &#8220;In this case, theme reviewers are not listed anywhere and not publicly available for hire (for new themes or professional reviews).&#8221;</p>\n<p>In the case of Uzelac and Peshev&#8217;s collaboration, the end result is a nice free theme for the community to enjoy. With all the volunteer hours put into reviewing themes for WordPress.org, do you think reviewers could benefit from being listed in a directory? Or would this needlessly complicate the relationship between reviewers and submissions on WordPress.org?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 22:09:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Flynn O’Connor on Organizing and Marketing a WordCamp for Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33505\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/flynn-oconnor-on-organizing-and-marketing-a-wordcamp-for-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7717:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WordCampVancouver2014FeaturedImage.png\" rel=\"prettyphoto[33505]\"><img class=\"aligncenter size-full wp-image-33641\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WordCampVancouver2014FeaturedImage.png?resize=680%2C296\" alt=\"WordCamp Vancouver Featured Image\" /></a></p>\n<p>One topic to come out of the discussion surrounding the <a title=\"http://wptavern.com/loopconf-sparks-controversy-with-tickets-priced-at-800\" href=\"http://wptavern.com/loopconf-sparks-controversy-with-tickets-priced-at-800\">cost to attend LoopConf</a> is the idea that WordCamps can&#8217;t be developer focused. One of the most exciting aspects of LoopConf is the chance to dive deep into technical discussions. WordCamps generally cater to a wide range of skill levels, which some feel prevent these types of discussions from occurring.</p>\n<p>There&#8217;s nothing in the <a title=\"http://plan.wordcamp.org/\" href=\"http://plan.wordcamp.org/\">WordCamp guidelines</a> that state WordCamps have to cater to all experience levels, it&#8217;s just what most organizers do based on the needs of their local community. In 2011, <a title=\"http://mor10.com/\" href=\"http://mor10.com/\">Morten Rand-Hendriksen</a> organized an event called <a title=\"https://web.archive.org/web/20110926234935/http://wordcampdevelopers.com/\" href=\"https://web.archive.org/web/20110926234935/http://wordcampdevelopers.com/\">WordCamp Developers</a> held in Vancouver, BC. WordPress developers and designers interested in learning about practical, applied WordPress development by industry leaders and local WordPress practitioners attended the event.</p>\n<p>Earlier this year, Flynn O&#8217;Connor co-organized <a title=\"http://2014.vancouver.wordcamp.org/\" href=\"http://2014.vancouver.wordcamp.org/\">WordCamp Vancouver, BC Developer Edition</a>. It was a one day event <a title=\"http://2014.vancouver.wordcamp.org/sessions/\" href=\"http://2014.vancouver.wordcamp.org/sessions/\">filled with WordPress developer topics</a> including, an introduction to the command line, advanced custom fields, and getting started with unit tests. I interviewed O&#8217;Connor to find out how he marketed the event and what he did to achieve a relevant audience.</p>\n<h2>Interview With Flynn O&#8217;Connor</h2>\n<p><strong>At what point did you realize you needed to have a Developer Edition of WordCamp Vancouver?</strong></p>\n<p>This is something that our team discussed after the previous year&#8217;s WordCamp completed. There was a desire to not only create a camp for WordPress developers but also a WordPress focused event that would be of interest to the larger tech community within Vancouver to see what WordPress could do. While attending other events like <a title=\"http://2014.cascadiajs.com/\" href=\"http://2014.cascadiajs.com/\">CascadiaJS</a> conference, I found myself correcting a lot of people&#8217;s old pre-conceived notions of what WordPress is and can do now.</p>\n<p><strong>How did you market WordCamp Vancouver Developer Edition so that a majority of the attendees are developer or designer oriented?</strong></p>\n<p>We tried to be clear with our content that this event was going to focus on building with WordPress and not necessarily about end user topics. In emails, on the website, social media and in community posts like the one <a title=\"http://wptavern.com/wordcamp-vancouver-to-hold-developer-edition-in-july\" href=\"http://wptavern.com/wordcamp-vancouver-to-hold-developer-edition-in-july\">WPTavern published</a> about our event we tried to get the message out that if you can or wanted to know how to build on WordPress, this would be an event for you.</p>\n<p>We also connected with other tech related meet up groups and asked for the assistance in getting the word out about our event and reached out to several schools that offered web development programs and offered their students discount tickets. Even so, there are some people who are going to attend because they&#8217;re aware of WordPress and want to see what it&#8217;s all about but don&#8217;t know how to design or develop for it. From our experience, we&#8217;ve found you can&#8217;t really stop that.</p>\n<p><strong>What type of feedback did you get after the event? Did some attendees complain that the content was over their head?</strong></p>\n<p>Yes, we did get some people who said some of the talks were advanced for them. But from the ones I talked to that brought this up, quite of a few of them were not discouraged by this. We can’t cater to everyone and make everyone happy but if we provide our attendees content that will challenge them, then hopefully, we are encouraging them to learn more and helping them to become better developers.</p>\n<p><strong>What advice can you give to organizers who want to put on a developer focused WordCamp?</strong></p>\n<p>Reach out to the tech community beyond WordPress, not only for attendees but also speakers. Many of them will be happy to help. Don’t be afraid of the content being too advanced for some attendees but try to balance out the talks so that less experienced developers don’t feel overwhelmed the entire time.</p>\n<p>Talk to meet up and smaller local event planners to get a sense for your community&#8217;s general skill level so you can better anticipate likely attendance levels for the more advanced talks. I am one of the co-organizers for the Vancouver meet up and I focus on the dev branch, so I had a decent idea of how many high level developers in our community would actually attend these events.</p>\n<h2>Understanding The Needs Of The Local Community</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/LocalImage.png\" rel=\"prettyphoto[33505]\"><img class=\"size-full wp-image-33651\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/LocalImage.png?resize=640%2C126\" alt=\"Local Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/arimoore/1232161364/\">arimoore</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Organizers are <a title=\"https://make.wordpress.org/community/2013/08/20/organizing-a-non-wordcamp/\" href=\"https://make.wordpress.org/community/2013/08/20/organizing-a-non-wordcamp/\">encouraged to experiment</a> and break from the mold while still following the guidelines. WordCamp Vancouver Developer Edition proves it&#8217;s possible and if you look at <a title=\"http://i0.wp.com/2014.vancouver.wordcamp.org/files/2014/07/WordCamp-Vancouver-2014-Public-Budget-Sheet11.png\" href=\"http://i0.wp.com/2014.vancouver.wordcamp.org/files/2014/07/WordCamp-Vancouver-2014-Public-Budget-Sheet11.png\" rel=\"prettyphoto[33505]\">their budget sheet</a>, it cost just over $18,000. So not only can organizers create a WordPress developer centric event using the WordCamp branding, the financial support of doing so makes it much more affordable.</p>\n<p>One of the keys to the success of WordCamp Vancouver for developers and designers is understanding the needs of the local WordPress community. If there is sufficient demand and the community is large enough, consider organizing an event in your area. There&#8217;s also no rules in the guidelines that limit the amount of WordCamps per year in a given city. This means organizers can continue to have traditional WordCamps while organizing a separate event catered to developers.</p>\n<p>I want to know from those who have organized 500-1,000 person WordCamps if you plan to branch out and create smaller, niche events while using the WordCamp branding? If so, please let us know in the comments. Also feel free to share concerns, ideas, or ask questions related to organizing a niche event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 20:33:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WPWeekly Episode 170 – I’ve Got Your Drama Right Here\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=33629&preview_id=33629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/wpweekly-episode-170-ive-got-your-drama-right-here\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3719:\"<p>Since our guest couldn&#8217;t make it due to illness, <a title=\"http://marcuscouch.com/\" href=\"http://marcuscouch.com/\">Marcus Couch</a> and I took the opportunity to thank all of the wonderful listeners who responded to our call to action in <a title=\"http://wptavern.com/wpweekly-episode-169-wordpress-is-now-a-verb\" href=\"http://wptavern.com/wpweekly-episode-169-wordpress-is-now-a-verb\">episode 169</a>. I followed up the first segment with a 10-15 minute rant beginning at <strong>13:25</strong> on WP Drama. Marcus and I agree that it&#8217;s a dismissive term and doesn&#8217;t offer anything productive to the WordPress ecosystem. After the rant, we discuss the news of the week and Marcus gives his two-word review of Ghost.</p>\n<h2>Stories Discussed:</h2>\n<p><a title=\"http://wptavern.com/wooconf-the-first-ever-conference-dedicated-to-woocommerce-deemed-a-success\" href=\"http://wptavern.com/wooconf-the-first-ever-conference-dedicated-to-woocommerce-deemed-a-success\">WooConf, The First Ever Conference Dedicated to WooCommerce Deemed a Success</a><br />\n<a title=\"http://wptavern.com/why-wordpress-doesnt-need-to-fear-ghost-yet\" href=\"http://wptavern.com/why-wordpress-doesnt-need-to-fear-ghost-yet\">Why WordPress Doesn’t Need to Fear Ghost, Yet</a><br />\n<a title=\"http://wptavern.com/john-james-jacoby-launches-indiegogo-campaign-to-fund-buddypress-bbpress-and-glotpress-development\" href=\"http://wptavern.com/john-james-jacoby-launches-indiegogo-campaign-to-fund-buddypress-bbpress-and-glotpress-development\">John James Jacoby Launches Indiegogo Campaign to Fund BuddyPress, bbPress, and GlotPress Development</a><br />\n<a title=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\" href=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\">Happy Joe Uses WordPress to Train and Help Veterans Find Careers in Web Technology</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a title=\"https://wordpress.org/plugins/google-webfont-optimizer/\" href=\"https://wordpress.org/plugins/google-webfont-optimizer/\">Google Webfont Optimizer</a> finds every Google Fonts request and bulks them together so the site only asks Google once for the fonts instead of multiple times.</p>\n<p><a title=\"https://wordpress.org/plugins/note/\" href=\"https://wordpress.org/plugins/note/\">Note</a> is a simple and easy to use widget for editing bits of text, live, in your WordPress front-end Customizer. Note was <a title=\"http://wptavern.com/note-by-slocum-studio-is-a-real-time-customizable-text-widget\" href=\"http://wptavern.com/note-by-slocum-studio-is-a-real-time-customizable-text-widget\">recently reviewed</a> on WP Tavern.</p>\n<p><a title=\"https://wordpress.org/plugins/baw-login-logout-menu/\" href=\"https://wordpress.org/plugins/baw-login-logout-menu/\">BAW Login/Logout menu</a> enables you to add a real login/logout item menu that autoswitches when a user is logged in or out. You can also configure a redirect for the login/logout action.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, November 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #170:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 15:01:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: US Internet Competition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44355\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://ma.tt/2014/11/us-internet-competition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:741:\"<blockquote><p>In the United States, the Federal Communications Commission in 2002 reclassified high-speed Internet access as an information service, which is unregulated, rather than as telecommunications, which is regulated. Its hope was that Internet providers would compete with one another to provide the best networks. That didn’t happen. The result has been that they have mostly stayed out of one another’s markets.\n</p></blockquote>\n<p><a href=\"http://www.nytimes.com/2014/10/31/upshot/why-the-us-has-fallen-behind-in-internet-speed-and-affordability.html?_r=1&abt=0002&abg=0\">Why the U.S. Has Fallen Behind in Internet Speed and Affordability</a>. Also has one of my favorite animated GIFs I&#8217;ve seen in a Times story.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 02:05:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Get Jetpack’s Markdown Module Without Using Jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=18338\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/get-jetpacks-markdown-module-without-using-jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3464:\"<p><a href=\"http://about.me/ahspw/\" target=\"_blank\">Anas H. Sulaiman</a> is a WordPress plugin developer who has created several extensions that extract modules from <a href=\"http://jetpack.me/\" target=\"_blank\">Jetpack</a> so that they can be used independently. He recently renamed his WordPress.org profile to &#8220;JP Bot&#8221; and is gradually adding to his collection of Jetpack-extractions:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/jp-bot-plugins.jpg\" rel=\"prettyphoto[18338]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/jp-bot-plugins.jpg?resize=700%2C222\" alt=\"jp-bot-plugins\" class=\"aligncenter size-full wp-image-33603\" /></a></p>\n<p>One of his most popular plugins is <a href=\"https://wordpress.org/plugins/jetpack-markdown/\" target=\"_blank\">JP Markdown</a>, which essentially duplicates Jetpack&#8217;s <a href=\"http://jetpack.me/support/markdown/\" target=\"_blank\">Markdown module</a>. It allows you to compose WordPress content in Markdown and have it published as HTML. I gave the plugin a test run and found that it works as advertised:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/markdown-test.jpg\" rel=\"prettyphoto[18338]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/markdown-test.jpg?resize=660%2C540\" alt=\"markdown-test\" class=\"aligncenter size-full wp-image-33614\" /></a></p>\n<p>JP Markdown even includes the &#8220;Use Markdown for Comments&#8221; feature that you can enable under <strong>Settings > Discussion</strong>. This plugin is a solid option if you like the Markdown module in Jetpack but don&#8217;t want everything else that comes with it.</p>\n<p>The JP Bot family of plugins extracted from Jetpack currently includes:</p>\n<ul>\n<li><a href=\"http://wordpress.org/plugins/jetpack-sharing/\" target=\"_blank\">JP Sharing</a> &#8211; Share content with Facebook, Twitter, et al.</li>\n<li><a href=\"http://wordpress.org/plugins/jetpack-widget-visibility/\" target=\"_blank\">JP Widget Visibility</a> &#8211; Control what pages your widgets appear on.</li>\n<li><a href=\"http://wordpress.org/plugins/jetpack-markdown/\" target=\"_blank\">JP Markdown</a> &#8211; Write in Markdown, publish in HTML.</li>\n<li><a href=\"http://wordpress.org/plugins/jp-custom-css/\" target=\"_blank\">JP Custom CSS</a> &#8211; Customize your site’s CSS without modifying your theme.</li>\n<li><a href=\"https://wordpress.org/plugins/jetpack-gravatar-hovercards/\" target=\"_blank\">JP Gravatar Hovercards</a> &#8211; Show a pop-up business card of your users&#8217; gravatar profiles in comments.</li>\n<li><a href=\"https://wordpress.org/plugins/jetpack-omnisearch/\" target=\"_blank\">JP Omnisearch</a> &#8211; A single search box, that lets you search many different things.</li>\n</ul>\n<p>Using Jetpack requires being connected to WordPress.com. While some users appreciate the convenience and professional support they receive from the Jetpack team, there are many who have reservations about hooking their site up to another third-party service. JP Bot&#8217;s <a href=\"https://profiles.wordpress.org/wpjp/\" target=\"_blank\">collection of Jetpack-extraction plugins</a> offer you an alternative to many of Jetpack&#8217;s most popular modules. For more alternatives to Jetpack, check out <a href=\"http://wptavern.com/15-plugins-to-get-jetpack-functionality-without-using-jetpack\" target=\"_blank\">15+ Plugins To Get Jetpack Functionality Without Using Jetpack</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 00:22:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Taxonomy Filter: A Simple Plugin to Filter Taxonomies in the WordPress Admin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wptavern.com/taxonomy-filter-a-simple-plugin-to-filter-taxonomies-in-the-wordpress-admin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3323:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/postit-notes.jpg\" rel=\"prettyphoto[33566]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/postit-notes.jpg?resize=1024%2C532\" alt=\"photo credit: H. Michael Arrighi - cc\" class=\"size-full wp-image-25350\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/arrighi/8562416557/\">H. Michael Arrighi</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a>\n<p>When WordPress is used heavily as a content management system, taxonomies play a very important role for grouping information. While your standard blog might only have a handful of categories, more content-heavy sites can include hundreds of terms within custom taxonomies.</p>\n<p>Scrolling through an impossibly long list of categories or terms can be a clunky experience in the post editor. <a href=\"https://wordpress.org/plugins/taxonomy-filter/\" target=\"_blank\">Taxonomy Filter</a> is a new solution for this, created by Andrea Landonio, a software engineer at Condé Nast in Milan.</p>\n<p>The plugin allows users to filter hierarchical term taxonomies inside the WordPress admin. Specifically, it adds a custom input field for filtering taxonomies when a user is assigning them in the post editor. Here&#8217;s an example with the default category taxonomy:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/category-filter.jpg\" rel=\"prettyphoto[33566]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/category-filter.jpg?resize=282%2C357\" alt=\"category-filter\" class=\"aligncenter size-full wp-image-33578\" /></a></p>\n<p>Categories are automatically narrowed down as you type, so that you can easily locate the one you&#8217;re looking for.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/category-filtering.jpg\" rel=\"prettyphoto[33566]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/category-filtering.jpg?resize=282%2C279\" alt=\"category-filtering\" class=\"aligncenter size-full wp-image-33579\" /></a></p>\n<p>The Taxonomy Filter plugin has a settings page that allows you configure which taxonomies you want to make filterable. Currently, it only works with hierarchical taxonomies, including default categories and <a href=\"http://codex.wordpress.org/Custom_Taxonomies\" target=\"_blank\">custom taxonomies</a>. (It does not support non-hierarchical tags.)</p>\n<p>The settings page gives you two options:</p>\n<ul>\n<li>Enable on post management pages (allow you to turn on/off filter field)</li>\n<li>Hide filter field if taxonomy is empty</li>\n</ul>\n<p>I tested the plugin and found that it works as advertised to quickly filter taxonomies. One added benefit is that it&#8217;s likely to keep users from impatiently creating new categories when they overlook an existing category due to too much scrolling. The instinct is to just create a new one which may have a similar name to one that already exists. This further bloats the list and makes categories less effective for grouping content.</p>\n<p>Installing the Taxonomy Filter plugin is one small way that you can make assigning a taxonomy a little more convenient and less clunky in the admin. <a href=\"https://wordpress.org/plugins/taxonomy-filter/\" target=\"_blank\">Download</a> it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Nov 2014 20:55:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Lorelle on WP: WordPress Vancouver Social Meetup Sunday, Nov 16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://lorelle.wordpress.com/?p=12005\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://lorelle.wordpress.com/2014/11/13/wordpress-vancouver-social-meetup-sunday-nov-16/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:474:\"The next WordPress Social Meetup in Vancouver, Washington, is this Sunday, November 16 at 4-7PM. Reserve your spot now on the WordPress PDX Meetup page. We will be getting our social WordPress on in the the Parkway Plaza Building near the Vancouver Mall, a quick hop for those crossing I-205 from Portland or up I-5 [&#8230;]<img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=lorelle.wordpress.com&blog=72&post=12005&subd=lorelle&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Nov 2014 16:24:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Lorelle VanFossen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Focus Project and Session UI Approved for Merge Into WordPress 4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33514\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/focus-project-and-session-ui-approved-for-merge-into-wordpress-4-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4571:\"<p>John Blackbourn announced this afternoon that he will be merging the Focus Project into WordPress core ahead of the upcoming 4.1 release. Last week Jeff Chandler explored <a href=\"http://wptavern.com/how-the-focus-project-plans-to-enhance-distraction-free-writing-in-wordpress\" target=\"_blank\">how the Focus Project plans to enhance distraction-free writing</a> in WordPress. If you haven&#8217;t been following the project, it&#8217;s essentially a complete re-think of the way WordPress has approached the DFW feature.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/dfw.jpg\" rel=\"prettyphoto[33514]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/dfw.jpg?resize=417%2C395\" alt=\"dfw\" class=\"alignright size-full wp-image-33545\" /></a>Mark Jaquith posted a <a href=\"https://make.wordpress.org/core/2014/11/11/focus-v2-demo-video/\" target=\"_blank\">demo video</a> of the feature earlier this week when proposing it to be <a href=\"https://core.trac.wordpress.org/ticket/29806\" target=\"_blank\">merged into core</a> for 4.1. If you haven&#8217;t tested it yet, this video gives you a good idea of how the feature will work.</p>\n<p>In general, WordPress users have found distraction-free writing to be a valuable experience but are dissatisfied with the disconnect of being separated from the rest of the publishing tools in the editor. The Focus Project minimizes the transition, automatically fading the non-essential parts of the editor when you start typing. It keeps the the publishing tools just a mouse swipe away.</p>\n<p>The old DFW button is now changed to be a disabling toggle. For the 4.1 beta, this new feature will be automatically on, and WordPress core contributors will use this time to gather feedback and decide whether or not it should be on or off by default. If left on by default, it will be the most visible new feature in 4.1, since it impacts anyone who uses the content editor.</p>\n<h3>Session UI Approved to Merge Into Core</h3>\n<p>The second item approved for merge into 4.1 is the <a href=\"https://core.trac.wordpress.org/ticket/30264\" target=\"_blank\">user session UI</a>, which is essentially a button that displays when a user has more than one active session. When clicked, the button will log the user out of all other sessions.</p>\n<p>During today&#8217;s core development chat, Blackbourn also outlined plans for the putting the session UI feature on track for future improvements. &#8220;We&#8217;ll use the <a href=\"https://github.com/johnbillion/wp-session-manager\" target=\"_blank\">session UI repo on GitHub</a> for future iterations (and we&#8217;ll do it as a proper feature plugin too if necessary),&#8221; he said. &#8220;Or it might just not be developed any further.&#8221;</p>\n<p>He also clarified that planned improvements to extension installation and update screens will not make it into this release. &#8220;So unfortunately due to the work that some core folks have been doing on 4.0.1, the improvements that were slated for the plugin and theme install (and update) screens has not progressed past mockups, so that has been shelved for 4.1,&#8221; Blackbourn said.</p>\n<h3>Shared Terms Will be Split in WordPress 4.1</h3>\n<p>Under the hood, developers can look forward to progress on the taxonomy roadmap. Boone Gorges has made <a href=\"https://make.wordpress.org/core/2014/11/12/an-update-on-the-taxonomy-roadmap/\" target=\"_blank\">huge strides in fixing issues with shared terms</a>. Unraveling this knot was an extraordinary feat, not unlike navigating through a minefield, when it comes to backwards compatibility.</p>\n<p>As of 4.1, updating a shared term will cause it to be split into two separate terms. This solves a common problem where you update a term and have the others changed unintentionally. It also paves the way for more exciting improvements to taxonomy meta and post relationships, as Andrew Nacin <a href=\"https://make.wordpress.org/core/2013/07/28/potential-roadmap-for-taxonomy-meta-and-post-relationships/\" target=\"_blank\">outlined</a> last year.</p>\n<p>The new <a href=\"http://wptavern.com/twenty-fifteen-officially-added-to-the-development-version-of-wordpress\" target=\"_blank\">Twenty Fifteen default theme</a> should also ship in this release, ready just in time for the new year. Blackbourn and contributors are aiming to have WordPress 4.1 beta 1 available Thursday around lunchtime GMT. The official release is <a href=\"https://make.wordpress.org/core/version-4-1-project-schedule/\" target=\"_blank\">scheduled</a> for the week of December 8th.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Nov 2014 00:28:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: bbPress Slack Integration: Send New Topics and Replies to a Slack Channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33359\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/bbpress-slack-integration-send-new-topics-and-replies-to-a-slack-channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3290:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\" rel=\"prettyphoto[33359]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>WordPress recently adopted <a href=\"https://slack.com/\" target=\"_blank\">Slack</a> as its primary communication tool for contributor teams, largely replacing IRC. When trac tickets are mentioned in Slack, they are automatically linked up, which helps contributors reference and connect discussions. So far, the app has been enthusiastically received, especially since it offers a far more mobile-friendly option for asynchronous communication.</p>\n<p>WordPress-related projects outside of core have also started using Slack for team collaboration. Contributors to the <a href=\"http://pods.io/\" target=\"_blank\">Pods Framework</a> are finding Slack to be instrumental for staying connected. That&#8217;s why <a href=\"http://joshpress.net/\" target=\"_blank\">Josh Pollock</a>, community manager for the project, created <a href=\"https://wordpress.org/plugins/bbpress-slack-integration/\" target=\"_blank\">bbPress Slack Integration</a>. This new plugin allows you to send notifications of new bbPress topics and replies to your Slack channel of choice.</p>\n<h3>Staying on Top of Support Requests</h3>\n<p>The Pods team already had GitHub and Asana integrations with their channels. These were working well, but they were missing updates from their bbPress-powered <a href=\"http://pods.io/forums\" target=\"_blank\">support forums</a> in the team&#8217;s support channel.</p>\n<p>&#8220;The external integrations help keep us aware of what’s happening, while we’re working,&#8221; Pollock said. &#8220;This plugin does the same thing for support requests and makes us more responsive when we are in &#8216;Pods Mode.\'&#8221;</p>\n<p>The bbPress Slack Integration plugin uses the <a href=\"http://codex.wordpress.org/HTTP_API\" target=\"_blank\">WordPress HTTP API</a> and a Slack webhook to send notifications from the forum where it is installed.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/bbpress-slack.png\" rel=\"prettyphoto[33359]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/bbpress-slack.png?resize=607%2C108\" alt=\"bbpress-slack\" class=\"aligncenter size-full wp-image-33501\" /></a></p>\n<p>In order to use the plugin with your own bbPress forums, you&#8217;ll first need to add a new Slack webhook by visiting:</p>\n<p><code>https://your-team-name.slack.com/services/new/incoming-webhook</code></p>\n<p>Set a channel to receive the notifications, copy the URL for the webhook, and paste it into the plugin&#8217;s settings page (Settings->bbPress Slack). You&#8217;ll be all set to start receiving bbPress notifications within your specified slack channel.</p>\n<p>If you think that bbPress integration will help your team communicate better on Slack, you can <a href=\"https://wordpress.org/plugins/bbpress-slack-integration/\" target=\"_blank\">download</a> the plugin for free from WordPress.org. bbPress Slack Integration is also available on <a href=\"https://github.com/Shelob9/jp-bbpress-slack-integration\" target=\"_blank\">GitHub</a> if you want to contribute.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Nov 2014 21:44:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Happy Joe Uses WordPress to Train and Help Veterans Find Careers in Web Technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33365\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8167:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/VeteransDayFeaturedImage.png\" rel=\"prettyphoto[33365]\"><img class=\"size-full wp-image-33378\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/VeteransDayFeaturedImage.png?resize=638%2C285\" alt=\"Veterans Day Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/soldiersmediacenter/6343590279/\">The U.S. Army</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a>\n<p>One of the toughest battles a U.S. military veteran faces after returning from active duty is finding a job and reentering the work force. The battle is so tough that in 2011, First Lady Michelle Obama and Dr. Jill Biden came together to launch <a title=\"http://www.whitehouse.gov/joiningforces\" href=\"http://www.whitehouse.gov/joiningforces\">Joining Forces</a>. Joining Forces is a nationwide initiative calling all Americans to rally around service members, veterans, and their families and support them through wellness, education, and employment opportunities.</p>\n<p><a title=\"http://www.jamesdalman.com/\" href=\"http://www.jamesdalman.com/\">James Dalman</a>, who honorably served in the Oklahoma National Guard, is doing his part to help veterans find jobs in the web technology industry through his non-profit organization, <a title=\"https://www.happyjoe.org\" href=\"https://www.happyjoe.org\">Happy Joe</a>.</p>\n<h2>The Happy Joe Mission</h2>\n<p>Happy Joe is a 501 c3 non-profit organization that helps U.S. veterans with entrepreneurship and employment opportunities. Training initiatives prepare veterans not only for a career in the web technology industry, but also provide the skills necessary to start their own businesses. Most of the <a title=\"http://www.happyjoe.org/happy-joe-team/\" href=\"http://www.happyjoe.org/happy-joe-team/\">team behind the organization</a> is either in active duty or has previous military experience.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/HappyJoeLogo.png\" rel=\"prettyphoto[33365]\"><img class=\"aligncenter size-full wp-image-33486\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/HappyJoeLogo.png?resize=385%2C111\" alt=\"Happy Joe Logo\" /></a></p>\n<p>The organization&#8217;s mission is to give back to veterans in a measurable way that makes a deep impact.</p>\n<blockquote><p>Happy Joe provides career placement and job training in the web technology industry free of charge to our veterans. We help them navigate their re-entry into the civilian marketplace and advocate for the rights that they’ve earned the right to. And we partner with the best companies and resources to ensure that our military veterans have every opportunity to become successful after their commitment to service is over.</p></blockquote>\n<p>Training and job placement programs are funded primarily by the <a title=\"https://www.happyjoe.org/donate/\" href=\"https://www.happyjoe.org/donate/\">Happy Joe Scholarship Fund</a>. 100% of the donations and contributions go towards the efforts of working with veterans. Funds are also obtained through a sponsorship program several companies routinely contribute to, including <a title=\"http://automattic.com/\" href=\"http://automattic.com/\">Automattic</a> and <a title=\"http://ithemes.com/\" href=\"http://ithemes.com/\">iThemes</a>.</p>\n<h2>WordPress&#8217; Role at Happy Joe</h2>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/WPBootCamp.png\" rel=\"prettyphoto[33365]\"><img class=\"size-full wp-image-33462\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/WPBootCamp.png?resize=639%2C200\" alt=\"WordPress Boot Camp\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/vamcmag/3098352208/\">MizGingerSnaps</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>WordPress is the cornerstone used to help veterans learn a valuable skill. By learning WordPress, veterans can take advantage of valuable opportunities to work in the field either as an employee or through contract work. Dalman tells the Tavern that in 2015, as part of the training initiative, he&#8217;ll launch WP Bootcamps. &#8220;WP Bootcamps will be tailored to the military community and help our Armed Forces veterans to set up resume style websites on WordPress so that they can be seen as technology relevant.&#8221;</p>\n<h2>Success Stories</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/10/SuccessFeaturedImage.png\" rel=\"prettyphoto[33365]\"><img class=\"size-full wp-image-32204\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/10/SuccessFeaturedImage.png?resize=636%2C278\" alt=\"Success Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/seeveeaar/2035597695/\">seeveeaar</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nd/2.0/\">cc</a>\n<p>When asked if there are any success stories, Dalman points to himself as an example, &#8220;Personally, WordPress has allowed me as a veteran to launch very successful businesses in the marketplace, in addition to helping other veterans do the same. I am not the most tech savvy person in the world, but WordPress has provided me with the ability to make a great living, doing work I love to do.&#8221;</p>\n<p>Learning and working with WordPress affords him the opportunity to travel and meet amazing people in the community. When asked by veterans if they can make a living in web technology using WordPress, Dalman responds, &#8220;I tell them if I can do it, they certainly can!&#8221; Some of the veterans taking advantage of Happy Joe are homeless or in deep financial trouble but are using WordPress to make a better life for themselves. Dalman notes that success stories of members will soon be shared on the Happy Joe website.</p>\n<h2>Happy Joe Needs Your Financial Support</h2>\n<p>While spreading the word about Happy Joe is appreciated, Dalman says the organization first and foremost needs financial assistance. &#8220;We need people to help fund the training and mentoring of our veterans. We have a lot of people who are sharing the story and mission of Happy Joe and we are <strong>VERY</strong> appreciative of that. However, we need sponsorships and donations to make a true difference.&#8221;</p>\n<p>Happy Joe is working with around a dozen veterans with more on the way. According to Dalman, there are a half-dozen companies willing and ready to hire veterans. However, the organization can&#8217;t make it happen without funding. &#8220;There is work that we need to do to get veterans up to speed and ready. This takes time, money, and commitment. So please, go and <a title=\"https://www.happyjoe.org/donate/\" href=\"https://www.happyjoe.org/donate/\">donate</a> to Happy Joe today so that we <strong>ALL</strong> can make a difference.&#8221;</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/HappyJoeCorporateSponsorLevels.png\" rel=\"prettyphoto[33365]\"><img class=\"size-full wp-image-33472\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/HappyJoeCorporateSponsorLevels.png?resize=1025%2C83\" alt=\"Happy Joe Corporate Sponsor Levels\" /></a>Happy Joe Corporate Sponsor Levels\n<p>If you&#8217;re interested in contributing financial support to the Happy Joe project, you can do so via the <a title=\"https://www.happyjoe.org/donate/\" href=\"https://www.happyjoe.org/donate/\">donations page</a>. Keep in mind that it&#8217;s a 501c3 non-profit organization meaning <strong>donations are tax-deductible</strong>. 100% of public donations and contributions go directly to helping the veterans Happy Joe works with. There&#8217;s also a <a title=\"https://www.happyjoe.org/sponsors/\" href=\"https://www.happyjoe.org/sponsors/\">sponsorship page</a> that explains not only how companies can get involved but also the benefits each sponsorship level provides. For example, Alpha Team sponsors which are the highest tier receive VIP access to trained and dependable veterans.</p>\n<p>Veterans day in the U.S. is a reminder for Americans to remember and thank those who honorably serve or served in the military, it&#8217;s organizations like Happy Joe that think of them and give back year round.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Nov 2014 21:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: Novice to Master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44273\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2014/11/novice-to-master/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"<p><a href=\"http://blog.djmnet.org/2013/01/14/from-novice-to-master-and-back-again/\">From Novice to Master, and Back Again</a>, by David Mackenzie.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Nov 2014 14:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Note by Slocum Studio is a Real-Time Customizable Text Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/note-by-slocum-studio-is-a-real-time-customizable-text-widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3832:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NoteFeaturedImage.png\" rel=\"prettyphoto[33400]\"><img class=\"aligncenter size-full wp-image-33449\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NoteFeaturedImage.png?resize=663%2C254\" alt=\"Note by Slocum Studio Featured Image\" /></a></p>\n<p><a title=\"https://wordpress.org/plugins/note/\" href=\"https://wordpress.org/plugins/note/\">Note</a> is a simple and easy to use widget for editing bits of text, within the widget via the customizer developed by <a title=\"http://www.slocumstudio.com/\" href=\"http://www.slocumstudio.com/\">Slocum Studio</a>. Although you can edit text widgets in the customizer, it&#8217;s a boring experience and requires HTML knowledge to format text. Note enables you to add and edit content live from within the widget similar to a frontend editor.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NoteWidgetinAction2.png\" rel=\"prettyphoto[33400]\"><img class=\"size-full wp-image-33442\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NoteWidgetinAction2.png?resize=990%2C390\" alt=\"Note Widget in Action\" /></a>Note Widget in Action\n<p>From within the customizer, you can add a Title, apply a CSS class, or click the button which is like a shortcut to edit the widget&#8217;s content. One thing I noticed immediately is that applying a title doesn&#8217;t match the behavior of other widgets in WordPress. As you can see in the screenshot, the widget title doesn&#8217;t inherit the same style as the others. According to Matt Medeiros of Slocum Studio, this behavior is intentional.</p>\n<blockquote><p>We wanted the writing experience to be as pure as possible when using Note. We decided to omit displaying widget titles as part of that experience in the first version, but plan to revisit that in an upcoming release.</p></blockquote>\n<p>It may be intentional, but it gives me a sense that either the widget or my theme is broken. At its most basic level, Note should function the same way as a default text widget. Hopefully in a future version, the team will change the behavior to match that of a regular widget with an option to show or hide the title.</p>\n<p>Not only can you edit the widget&#8217;s content without visiting the backend, you can do it in style. Simply highlight text within the widget and a toolbar shows up allowing you to format the text. Note has a <strong>What You See Is What You Get</strong> interface. This is convenient since you no longer have to edit content, click save and publish, then refresh the page to see the changes.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NotesToolbar.png\" rel=\"prettyphoto[33400]\"><img class=\"size-full wp-image-33443\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/NotesToolbar.png?resize=598%2C117\" alt=\"Note Toolbar\" /></a>Note Toolbar\n<p>One feature missing from Note is the ability to add media, but Medeiros confirmed it will be added in a future release. While testing Note, I encountered a bug that added a / to every word that has an apostrophe. For example, I&#8217;ve turned into I/&#8217;ve. The bug presents itself when the customizer is open and a page refresh occurs. The team is aware of the bug and is working on a fix.</p>\n<p>Overall, I like what I see from Note. Once a few bugs are squashed and the ability to display the widget title is added, it will be a great replacement for the default Text widget. Note is <a title=\"https://wordpress.org/plugins/note/\" href=\"https://wordpress.org/plugins/note/\">available for free</a> on the WordPress plugin directory. You can also follow development of Note <a title=\"https://github.com/sdsweb/note/\" href=\"https://github.com/sdsweb/note/\">on Github</a> where you can also file bug reports and contribute patches.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2014 22:44:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: Shortcake: A UI for WordPress Shortcodes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33308\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wptavern.com/shortcake-a-ui-for-wordpress-shortcodes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3172:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/shortcake.jpg\" rel=\"prettyphoto[33308]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/shortcake.jpg?resize=1024%2C502\" alt=\"photo credit: kendiala - cc\" class=\"size-full wp-image-33434\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/kendiala/97929388/\">kendiala</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc/2.0/\">cc</a>\n<p>The <a href=\"https://codex.wordpress.org/Shortcode_API\" target=\"_blank\">Shortcode API</a> was introduced in 2008 when <a href=\"https://wordpress.org/news/2008/03/wordpress-25-brecker/\" target=\"_blank\">WordPress 2.5</a> was released. Over the past six years, the UI for adding shortcodes has changed very little, despite the fact that they remain a big part of how many WordPress users structure complex content.</p>\n<p><a href=\"https://github.com/fusioneng/Shortcake\" target=\"_blank\">Shortcake</a> is a new project created by the folks at <a href=\"http://next.fusion.net/2014/11/10/introducing-shortcake/\" target=\"_blank\">Fusion</a> with the aim of bringing new life to shortcodes. The plugin is aptly named, as it was designed to make shortcodes a piece of cake for users.</p>\n<p>Shortcake gives developers an easy way to register a UI for their shortcodes by utilizing 4.0&#8217;s <a href=\"https://core.trac.wordpress.org/changeset/29178\" target=\"_blank\">changes to TinyMCE views</a>. Developers can use the Shortcake plugin alongside add_shortcode to create a user-friendly interface for adding shortcode content and attributes to pages/posts.</p>\n<p>The Fusion team provided a before and after example of editing a shortcode for a pullquote, with an <a href=\"https://github.com/fusioneng/Shortcode-UI/blob/master/dev.php\" target=\"_blank\">example file</a> to show you how to use it:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/shortcake-example.png\" rel=\"prettyphoto[33308]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/11/shortcake-example.png?resize=645%2C655\" alt=\"shortcake-example\" class=\"aligncenter size-full wp-image-33427\" /></a></p>\n<p>The plugin currently supports the following input types: text, checkbox, textarea, radio, select, email, url, number, and date. The team behind it plans to improve it to support data sources and will also be publishing more documentation and example usages.</p>\n<p>The VIP team at Automattic liked the plugin so much that they have now made it available for all WordPress.com VIP customers, which is a testament to its quality. Fusion plans to present the project at the next <a href=\"http://www.meetup.com/Big-Media-WordPress-Meetup/\" target=\"_blank\">Big Media &amp; Enterprise WordPress meetup</a> in New York.</p>\n<p>Gone are the days when you can afford to torture your users with complex shortcodes. Shortcake is a new tool for your toolbox that enables you to provide your users/clients with a more intuitive UI that is less overwhelming. Check the project out on <a href=\"https://github.com/fusioneng/Shortcake\" target=\"_blank\">GitHub</a>, find out what you can create with it, and watch for improvements in the near future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2014 20:54:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: Michael Jordan on Big Data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44336\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://ma.tt/2014/11/michael-jordan-on-big-data/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1861:\"<blockquote><p>I like to use the analogy of building bridges. If I have no principles, and I build thousands of bridges without any actual science, lots of them will fall down, and great disasters will occur.</p>\n<p>Similarly here, if people use data and inferences they can make with the data without any concern about error bars, about heterogeneity, about noisy data, about the sampling pattern, about all the kinds of things that you have to be serious about if you’re an engineer and a statistician—then you will make lots of predictions, and there’s a good chance that you will occasionally solve some real interesting problems. But you will occasionally have some disastrously bad decisions. And you won’t know the difference a priori. You will just produce these outputs and hope for the best.</p></blockquote>\n<p>Today I learned there&#8217;s another <a href=\"http://www.cs.berkeley.edu/~jordan/\">Michael Jordan</a> that is as awesome in machine learning as <a href=\"http://www.csnchicago.com/bulls/why-did-michael-jordan-choose-no-23\">#23</a> is at basketball.  <a href=\"http://spectrum.ieee.org/robotics/artificial-intelligence/machinelearning-maestro-michael-jordan-on-the-delusions-of-big-data-and-other-huge-engineering-efforts\">IEEE&#8217;s article Machine-Learning Maestro Michael Jordan on the Delusions of Big Data and Other Huge Engineering Efforts</a> is worth a read and a re-read.</p>\n<p>It&#8217;s also worth noting that Professor Jordan <a href=\"http://www.reddit.com/r/MachineLearning/comments/2fxi6v/ama_michael_i_jordan/\">did an AMA on Reddit</a>, and actually disagreed with the title and characterization of the IEEE interview and <a href=\"https://amplab.cs.berkeley.edu/2014/10/22/big-data-hype-the-media-and-other-provocative-words-to-put-in-a-title/\">wrote a follow-up and response on a WordPress-powered blog</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2014 20:49:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"WPTavern: John James Jacoby Launches Indiegogo Campaign to Fund BuddyPress, bbPress, and GlotPress Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33368\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"http://wptavern.com/john-james-jacoby-launches-indiegogo-campaign-to-fund-buddypress-bbpress-and-glotpress-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4376:\"<p><a href=\"http://johnjamesjacoby.wordpress.com/\" target=\"_blank\">John James Jacoby</a> launched an <a href=\"https://www.indiegogo.com/projects/buddypress-bbpress-glotpress-development\" target=\"_blank\">Indiegogo campaign</a> today with the goal of raising $50,000 to fund six months of full-time work on WordPress&#8217; three sister projects: BuddyPress, bbPress, and GlotPress. While WordPress core has many contributors who are sponsored by companies, the sister projects have yet to receive this kind of investment from the community.</p>\n<p>Jacoby is a longtime WordPress developer/contributor and the project lead on <a href=\"https://buddypress.org\" target=\"_blank\">BuddyPress</a> and <a href=\"http://bbpress.org\" target=\"_blank\">bbPress</a>. WordPress depends heavily on the continued maintenance and improvement of the sister projects and he believes that they can benefit from having a dedicated developer.</p>\n<p>BuddyPress is the plugin that powers the 16 million WordPress.org profiles, activity stream, and badge system. The WordPress.org support forums, along with the thousands of plugin and theme support forums, are all powered by bbPress. <a href=\"http://blog.glotpress.org/\" target=\"_blank\">GlotPress</a> is a BackPress-powered application that enabled WordPress, BuddyPress, and bbPress to be translated into different languages. Improvements to GlotPress are critical for WordPress&#8217; global mission to democratize publishing.</p>\n<p>&#8220;<span class=\"pullquote alignleft\">WordPress is more community than software, yet the software that powers the community has nobody working on it full time</span>,&#8221; Jacoby said. &#8220;I want to change this.&#8221;</p>\n<p>The campaign came about after developer <a href=\"https://twitter.com/miss_jwo\" target=\"_blank\">Jenny Wong</a> made the suggestion during events surrounding WordCamp San Francisco. Wong has been instrumental in organizing community contribution days and has a passion for bringing people together. <strong>&#8220;I think a lot more would be done if there are dedicated people all over the community,&#8221;</strong> she said.</p>\n<p>Jacoby had considered the idea before but didn&#8217;t think there would be enough people interested in supporting it. With the suggestion and support from Wong and others at WCSF, he decided to give it a try. &#8220;BuddyPress, bbPress, and GlotPress came up so frequently, and I was pulled into so many discussions. I felt happy for how important those projects are to everyone, and sad that I haven’t found a way to truly dedicate myself to them,&#8221; Jacoby told the Tavern.</p>\n<p>&#8220;Near the end of the first day of the contributor summit, I was more emotional about it than I expected to be, and had a hard time translating that into words. Thankfully, Jen Mylo (who has always been super supportive to me) summed it up really nicely, and Jenny Wong followed up with the idea of raising money via Indiegogo.&#8221;</p>\n<p>Jacoby&#8217;s aim is to work on the projects &#8220;while remaining an independent and impartial entity with a dedicated period of distraction-free time.&#8221; Specifically, he plans to target the following items:</p>\n<ul>\n<li>Query and caching performance improvements to both BuddyPress and bbPress (to help them power the almost 20 million user profiles and the immense amount of activity going into them from all of the support forums)</li>\n<li>Media and Attachment support in BuddyPress</li>\n<li>Per-forum moderation in bbPress to help with plugin and theme moderation on WordPress.org.</li>\n</ul>\n<p>Progress on the sister projects has been slow, since current contributions are all volunteer-driven from folks who have other obligations. Jacoby was originally reluctant to attempt a fundraising campaign but recognizes the necessity of having the money available for distraction-free work. If the goal is not met, he will prorate the funds and will work in a dedicated capacity on the projects for as long as the funds allow.</p>\n<p>Within the first few hours of launching the campaign, Jacoby has already surpassed 20% of the goal. Check out the video and <a href=\"https://www.indiegogo.com/projects/buddypress-bbpress-glotpress-development\" target=\"_blank\">donate to the campaign</a> if you want to support a talented developer in giving WordPress&#8217; sister projects a chance to thrive.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2014 19:47:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Open Source Emoji\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2014/11/open-source-emoji/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:483:\"<p>I&#8217;m as likely to give Twitter a hard time as anyone, but today I want to tell you about something great they did: <a href=\"https://blog.twitter.com/2014/open-sourcing-twitter-emoji-for-everyone\">Twitter open sourced their emoji set for anyone to use</a>. We&#8217;ve been working with them behind the scenes on this and <a href=\"http://en.blog.wordpress.com/2014/11/06/emoji-everywhere/\">launched the emoji for WP.com as well</a>. Support will be coming to Jetpack soon.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2014 02:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: LoopConf Sparks Controversy with Tickets Priced at $800\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=33290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/loopconf-sparks-controversy-with-tickets-priced-at-800\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9269:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/loopconf.jpg\" rel=\"prettyphoto[33290]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/loopconf.jpg?resize=1025%2C485\" alt=\"loopconf\" class=\"aligncenter size-full wp-image-33347\" /></a></p>\n<p>Last week <a href=\"http://loopconf.io/\" target=\"_blank\">LoopConf</a> announced that <a href=\"http://us9.campaign-archive1.com/?u=d852b760c6208bf25844e3b3d&id=d49b632196\" target=\"_blank\">early bird tickets will go on sale November 20th</a>. The conference is aimed at developers and organizers are planning for 700 &#8211; 1,000 attendees in Las Vegas on the weekend of May 7-8, 2015.</p>\n<p>A bit of controversy has surfaced regarding the ticket pricing, as LoopConf emerges as one of the most expensive WordPress-oriented conferences to date. With early bird tickets priced at $600 and regular tickets at $800, the combined sponsorship donations and estimated ticket sales have the potential to bring the total event budget just shy of a million dollars.</p>\n<p>Although events in this price range are not unheard of in the web industry, with many charging ticket prices in the thousands, WordPress-oriented conferences have traditionally been inexpensive. Because LoopConf is not endorsed by or affiliated with the WordPress Foundation, it doesn&#8217;t have to follow the <a href=\"http://plan.wordcamp.org/\" target=\"_blank\">guidelines</a> set for WordCamps. Organizers of WP Foundation-sponsored events must <a href=\"http://plan.wordcamp.org/agreement-among-wordcamp-organizers-speakers-sponsors-and-volunteers/\" target=\"_blank\">agree</a> to make the event &#8220;accessible to as many people as possible, regardless of financial status.&#8221;</p>\n<p>LoopConf ticket pricing poses a stark contrast to traditional WordPress-oriented events, drawing sharp criticism for catering to an elite segment of developers, while pricing out the vast majority of others in the community.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>So <a href=\"https://twitter.com/loopconf\">@loopconf</a> tickets are $600 for early bird and $800 regular? Wow. Good luck with that. You just priced out 90% of the WP community.</p>\n<p>&mdash; Brad Williams (@williamsba) <a href=\"https://twitter.com/williamsba/status/531210414055759873\">November 8, 2014</a></p></blockquote>\n<p></p>\n<p>Supporters of LoopConf ticket prices count it as a step forward in legitimizing WordPress as a mainstream career opportunity. Eric Mann, in a response piece titled  <a href=\"https://eamann.com/biz/wordpress-comes-age/\" target=\"_blank\">WordPress Comes of Age</a>, highlights the fact that some employers have been reluctant to pay for flights and accommodation for a conference with a $25-40 ticket price.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/norcross\">@norcross</a> <a href=\"https://twitter.com/williamsba\">@williamsba</a> That might actually be a big step forward in legitimizing WP as a mainstream career opportunity.</p>\n<p>&mdash; TJ List (@TJList) <a href=\"https://twitter.com/TJList/status/531213651579912192\">November 8, 2014</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/williamsba\">@williamsba</a> <a href=\"https://twitter.com/loopconf\">@loopconf</a> that’s what a tech conference costs in any other field. WP is the odd duck with cheap conferences</p>\n<p>&mdash; curtismchale (@curtismchale) <a href=\"https://twitter.com/curtismchale/status/531218846594920449\">November 8, 2014</a></p></blockquote>\n<p></p>\n<p>I spoke with Brad Williams, one of the most vocal community members questioning the ticket prices, to find out if <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> would be sending any of its employees to LoopConf. &#8220;Most likely not, unfortunately,&#8221; he said. &#8220;It&#8217;s a lot of money even for an agency to cover without understanding the value of it.&#8221;</p>\n<p>Williams said he was not opposed to the conference, but that it&#8217;s tough to assess the value that an attendee will receive. &#8220;If it&#8217;s pricey, but justified, it might be worth sending some of our devs,&#8221; he said.  <strong>&#8220;Honestly it&#8217;s tough to say because we could also send them to 10+ WordCamps for that price.&#8221;</strong></p>\n<p>When LoopConf posted ticket prices, the email announcement said, &#8220;Think of it as more of a celebration of WordPress than a conference.&#8221; Without a full list of speakers and topics, aside from the generally well-known WordPress speakers featured on the homepage, onlookers are left scratching their heads.</p>\n<p>Amid controversy surrounding the high ticket prices, the organizers of the LoopConf posted a detailed <a href=\"http://loopconf.io/faq/\" target=\"_blank\">FAQ</a> section to the site to answer some of the public&#8217;s most pressing questions. The document helps to clarify what the organizers believe to be the value of the ticket price.</p>\n<p>When <a href=\"https://twitter.com/ryandonsullivan\" target=\"_blank\">Ryan Sullivan</a> set out to create a WordPress conference for developers, he had no idea that LoopConf would be pioneering a new segment of WordPress events. The organizing team, which includes a couple of experienced ng-conf organizers, was surprised to learn of the controversy surrounding the ticket pricing.</p>\n<p>Unlike a WordCamp, LoopConf is a for-profit endeavor and the team has no obligation to be financially transparent. &#8220;We won&#8217;t be publishing our budget,&#8221; Sullivan told the Tavern. &#8220;This is a for-profit endeavor but not to the degree most people think. Our margins are actually not very big, and basically cover our time and efforts for putting on the event itself.</p>\n<p>&#8220;Our number one goal is that everyone leaves feeling like it was a great investment, and if it ends up we risk a portion of our profits to make that a reality, then we&#8217;re fine with that.&#8221;</p>\n<p>He also doesn&#8217;t see any realistic way that the budget will reach a million dollars. &#8220;We are planning much more conservatively than that,&#8221; he said. What does he say to critics who believe the ticket prices to be exorbitant?</p>\n<blockquote><p>The ticket price is for the experience itself. Compared to other tech conferences outside of WordPress our prices are actually average or below average. I wish I had a way to illustrate how amazing this event will be without just having to say &#8220;this event is going to be amazing&#8221;, but that&#8217;s where we&#8217;re at right now I suppose. From hack nights, to an amazing party, to swag, to meals, to a premier conference space at a secluded resort, we&#8217;re truly trying to deliver in every way we can. It&#8217;s going to be a fantastic place to learn and connect with friends and colleagues who have truly common interests.</p></blockquote>\n<p>The LoopConf team hopes to announce speakers by Wednesday of this week. Of the 28 speakers lined up, Sullivan estimates that 6 or 7 will be from outside the WordPress community, with the majority of others having spoken previously at other WordPress events.</p>\n<p>&#8220;I think is important to mention is that even if these speakers have spoken at WordCamps before, it&#8217;s not likely they&#8217;ve given talks like they&#8217;ll be giving at LoopConf,&#8221; he said. <strong>&#8220;With a very developer focused audience a lot of these presenters will be able to give talks that they&#8217;re really excited about, which creates a very unique energy and environment for higher learning.&#8221;</strong></p>\n<p>The conference structure is also very different from what one might expect of a WordCamp. LoopConf doesn&#8217;t have a team of volunteers supporting the event but instead utilizes a paid event coordinator to manage the majority of the logistics with the venue, vendors, sponsors, etc. Sullivan expects that he and the other organizers will have a few months of working 20-30 hours per week leading up to the event.</p>\n<p>Those who are unable to attend LoopConf can watch all sessions via a global live stream for free. Videos of the sessions will also be available within minutes after sessions are finished and will be offered for free to anyone who wants to learn from the event&#8217;s speakers.</p>\n<p>WordPress conferences that fall under the WordCamp name have traditionally been inexpensive events, designed to bring together a local community. Because Sullivan and his team are pioneering a different event structure, they have endured a healthy amount of criticism. The team&#8217;s goal to bring in top developers from the larger community would not be possible within the confines of a traditional WordCamp.</p>\n<p>Sullivan hopes that other conference organizers will also be inspired to break out of the box and host more unique events. &#8220;I would love to see more niche conferences that are WordPress specific. There are already great conferences out there like WooConf, Pressnomics, Prestige, and some others that I&#8217;m probably forgetting,&#8221; he said. &#8220;If there&#8217;s an opportunity to get together for a good time and learn from each other in the process, count me in.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Nov 2014 22:32:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Nov 2014 06:33:59 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"212875\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 26 Nov 2014 06:15:14 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20140613153416\";}","no");
INSERT INTO wp_options VALUES("78206","_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c","1417026840","no");
INSERT INTO wp_options VALUES("78207","_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c","1416983640","no");
INSERT INTO wp_options VALUES("78208","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1417026840","no");
INSERT INTO wp_options VALUES("78209","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Nov 2014 06:08:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:15:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"arnee\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 10 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"BackWPup Free - WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/backwpup/#post-11392\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jun 2009 11:31:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"11392@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Schedule complete automatic backups of your WordPress installation. Decide which content will be stored (Dropbox, S3…). This is the free version\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Daniel Hüsken\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WPtouch Mobile Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wptouch/#post-5468\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 May 2008 04:58:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5468@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Create a slick mobile WordPress website with just a few clicks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"BraveNewCode Inc.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Redirection\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/redirection/#post-2286\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Sep 2007 04:45:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2286@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Redirection is a WordPress plugin to manage 301 redirections and keep track of 404 errors without requiring knowledge of Apache .htaccess files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"John Godley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Nov 2014 06:34:00 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"expires\";s:29:\"Wed, 26 Nov 2014 06:43:15 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Wed, 26 Nov 2014 06:08:15 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20140613153416\";}","no");
INSERT INTO wp_options VALUES("78210","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1417026840","no");
INSERT INTO wp_options VALUES("78211","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1416983640","no");
INSERT INTO wp_options VALUES("78212","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1417026840","no");
INSERT INTO wp_options VALUES("78213","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2014/11/wordpress-4-0-1/\'>WordPress 4.0.1 Security Release</a> <span class=\"rss-date\">November 20, 2014</span><div class=\"rssSummary\">WordPress 4.0.1 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be […]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/wordpress-theme-design-challenge-weekend-december-13-14th\' title=\'photo credit: ashley rose, – cc In an effort to inspire WordPress theme designers and add a variety of new themes to the directory, the WordPress Theme Review Team is hosting a Design Challenge Weekend, December 13-14th. The challenge is meant to do the following: Raise the design standard of the WordPress.org theme directory. Match developers to designers.\'>WPTavern: WordPress Theme Design Challenge Weekend December 13-14th</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/a-glimpse-into-serbias-rapidly-growing-wordpress-community\' title=\'After the dissolution of socialist Yugoslavia in the early 90’s, Serbia and its neighboring nations had an uphill climb to reach stability in their newly found autonomy. Transitioning from a planned economy to a market-driven economy was a challenge that Serbians have vigorously embraced over the past 20 years. Belgrade is now a growing center for informatio\'>WPTavern: A Glimpse Into Serbia’s Rapidly Growing WordPress Community</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/where-to-find-wordpress-related-black-friday-deals\' title=\'photo credit: kevin dooley – cc This is a great time of year if you’re in the market for themes, plugins, or webhosting. Black Friday is the day after Thanksgiving where many retailers offer deep discounts. In the past 2-3 years, WordPress businesses have done the same by offering substantial discounts for plugins and themes. WPLift has a great roundup of de\'>WPTavern: Where to Find WordPress Related Black Friday Deals</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/woocommerce/\' class=\'dashboard-news-plugin-link\'>WooCommerce - excelling eCommerce</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=c3cef080a7&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'WooCommerce - excelling eCommerce\'>Install</a>)</span></li></ul></div>","no");
INSERT INTO wp_options VALUES("78245","_transient_timeout_feed_a41fbee65e190c85018f9081fcc3dfc4","1417027023","no");
INSERT INTO wp_options VALUES("78246","_transient_feed_a41fbee65e190c85018f9081fcc3dfc4","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:51:\"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress Training » News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://members.wpacademy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 13:01:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Three fantastic web development courses for up to 95% off!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://members.wpacademy.com/2014/11/three-web-development/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://members.wpacademy.com/2014/11/three-web-development/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 12:52:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19954\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:596:\"<p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price! Get the bestselling WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course with discounts up to 95%.  Buy these courses from the links below: WordPress eCommerce with WooCommerce Sale Price [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4191:\"<p></p><p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price!</p>\n<p>Get the bestselling <strong>WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course</strong> with discounts up to 95%.  Buy these courses from the links below:</p>\n<h2>WordPress eCommerce with WooCommerce</h2>\n<p>Sale Price – $10 (Normally $17)</p>\n<p>An online course that will give you an understanding of WooCommerce in under 90 minutes.</p>\n<p>Developed by Marc Beneteau, the course offers many professional made guides.</p>\n<p>It features:</p>\n<ul>\n<li><strong>Quick Start Section</strong> – Gives you a basic understanding of WooCommerce by introducing layouts, shortcodes, adding products, PayPal configuration, and more.</li>\n<li><strong>Reference Section</strong> – Advanced product types, configuring tax, coupons, inventory management, product reviews, and more.</li>\n<li><strong>WooCommerce Styling and Programming Section</strong> – creating custom email templates,</li>\n</ul>\n<p>The course normally retails at $17, but you can purchase it for only $10 using the link below. This course is also included in the web development bundle listed later.</p>\n<p><a href=\"https://edurila.com/course/wordpress-ecommerce-with-woocommerce/?couponCode=marc10&amp;affcode=518i\">Purchase here</a></p>\n<h2>Swift Developer Bundle</h2>\n<p>Sale Price – $19 (Normally $446)</p>\n<p>Swift Developer Bundle: Swift is the programming language developed by Apple. The language is used to create applications for their mobile operating system iOS and their desktop operating system OS X.</p>\n<p>The Swift Developer Bundle shows you how to create a fully functional calculator application that you can publish in the apple app store.</p>\n<p>The courses will teach you:</p>\n<ul>\n<li>Initial Setup and Swift Basics</li>\n<li>Operators, Strings, Characters, and Collection Types</li>\n<li>Evolving from Objective C</li>\n<li>Control Flow</li>\n</ul>\n<p>The courses included in the bundle are:</p>\n<ul>\n<li>Swift – Learn Apple’s New Programming Language by Examples (Original Price: $199)</li>\n<li>Hands on Swift Language. Visual way with Light Programming (Original Price: $49)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n</ul>\n<p>The bundle normally retails at $446, but you can purchase it for only $19 using the link below.</p>\n<p><a href=\"https://edurila.com/course/Swift-Developer-Bundle/?couponCode=marc19&amp;affcode=518i\">Purchase here</a></p>\n<h2>The Beginner Web Dev Bundle</h2>\n<p>Sale Price – $29 (Normally $638)</p>\n<p>The beginner web development bundle includes <em>nine complete courses!</em>  Each course is jam-packed with tutorials and video guides.</p>\n<p>The package includes the following courses:</p>\n<ul>\n<li>Learn Complete Web Development From Scratch (Original Price: $149)</li>\n<li>Learn Responsive Web Development from Scratch (Original Price: $99)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n<li>Become a WordPress Nirvana, WordPress Expert Bundle (Original Price: $99)</li>\n<li>WordPress eCommerce with WooCommerce (Original Price: $17)</li>\n<li>WordPress Theme Selection &amp; Customization (Original Price: $27)</li>\n<li>Basics Of Web Application Penetration Testing (FREE)</li>\n<li>WordPress Tutorial for Beginners (Original Price: $49)</li>\n<li>The bundle normally retails at $638, but you can purchase it for only $29 using the link below.</li>\n</ul>\n<p><a href=\"https://edurila.com/course/the-beginner-web-dev-bundle/?couponCode=Marc29&amp;affcode=518i\">Purchase here</a></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://members.wpacademy.com/2014/11/three-web-development/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Jeff Walker: Product launches for “newbies”…\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://members.wpacademy.com/2014/11/jeff-walker/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://members.wpacademy.com/2014/11/jeff-walker/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Nov 2014 15:25:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19932\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:571:\"<p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate $500 million in product launches (this is money for his clients, not for him!) Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1893:\"<p></p><p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate <strong>$500 million in product launches</strong> (this is money for his clients, not for him!)</p>\n<p>Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone can use it to create an new business from scratch &#8211; starting with NO list and NO product</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Get the videos here</a> &lt;&lt;</strong></p>\n<p>He also reveals how he used &#8220;Launch Stacking&#8221; to go from Mr. Mom (with $400 per year in disposable income) to his first $1,000,000 in sales &#8211; it&#8217;s a crazy story.</p>\n<p>And the amazing thing is this strategy will work with almost ANY type of business.</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Core Elements of the &#8220;No Fail&#8221; launch</a> &lt;&lt;</strong></p>\n<p>These videos are all pure content&#8230; the only &#8220;catch&#8221; is you need to opt-in to get them, but make sure you do &#8211; it&#8217;s totally worth it.</p>\n<p>Watch them soon &#8212; they are only good for the next 6 days.  And they only come out every 12-18 months&#8230; this is the latest and greatest of Jeff&#8217;s revolutionary business model.</p>\n<p>To Your Success,</p>\n<p>Marc Beneteau</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://members.wpacademy.com/2014/11/jeff-walker/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Christine Kane Free Training: the New Class of Entrepreneur\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Sep 2014 05:50:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19898\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:660:\"<p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here: Discover the success secrets of the &#8220;new class of entrepreneurs&#8221; &#60;&#8211; (After registering and confirming your email address, you will be directed to the landing page, [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4397:\"<p></p><p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Discover the success secrets of the &#8220;new class of entrepreneurs&#8221;</a> &lt;&#8211;</strong></p>\n<p><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\"><img class=\"alignright size-full wp-image-19899\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/7-new-laws-of-gravity.jpg\" alt=\"7-new-laws-of-gravity\" width=\"300\" height=\"403\" /></a>(After registering and confirming your email address, you will be directed to the landing page, and from there you can watch all the videos and also download the free report &#8220;7 New Laws of Gravity&#8221;).</p>\n<h3>But what defines a &#8220;new entrepreneur&#8221;?</h3>\n<p>Here is an extract from the third video (you can get the full video <a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">here</a>, including the interviews).  The &#8220;new entrepreneurs&#8221; are:</p>\n<p><em>First</em>, they are <em>relentlessly</em> self-aware</p>\n<p>They know themselves and how to manage their power</p>\n<p>They &#8220;right&#8221; their mindset when it&#8217;s needed</p>\n<p>They are no longer burdened by the emotional stories they tell themselves, and this removes struggle and it creates effortlessness in their work</p>\n<p><em>Second</em>, the new class of entrepreneurs are REAL.. they are a refreshing force field in their industries.</p>\n<p><em>Third</em>, they are IN.  they know how to be fully in relationshiop with their business, their money and their clients.  They use fear as a tool for expansion.  And they use their full presence as a powerful tool for breakthroughs that need to happen.</p>\n<p>And last, they are wildly successful.  They are pioneers.  They are &#8220;defying gravity&#8221;.</p>\n<p>mm&#8230; you are probably thinking:</p>\n<h3>Marc, I have heard this type of &#8220;woo-woo&#8221; talk before.  It doesn&#8217;t work.</h3>\n<p>Maybe.  Maybe you have heard things that sound &#8220;similar&#8221;.  But take it from me, this is the &#8220;real deal&#8221;.</p>\n<p>I have sent so many people to Christine Kane to create new passion businesses, or to double and triple existing businesses, I can&#8217;t tell you.  I suggest you put aside some time today and watch these videos:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Find out how some entrepreneurs are &#8220;Defying Gravity&#8221;</a> &lt;&#8211;</strong></p>\n<p>In fact, I met many of these entrepreneurs, graduates of WP Academy programs, at Christine&#8217;s live event in Atlanta last June.  All of the ones I spoke with found it beneficial, and most were utterly transformed.</p>\n<h3>And here is the best thing of all:</h3>\n<p>Christine is launching her new program, entitled &#8220;Becoming 360&#8243;, <strong>for about one-third of the price of her previous program</strong>s (about $500).  This is, in my humble opinion, the best small-business development training available anywhere, at any price.  <strong>Especially since it actually includes a free ticket to a live event happening in Asheville, NC, in February 2015</strong> (live event may be sold-out &#8212; you will need to check with her prior to registering, if this is important to you).</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Get Access to the LIVESTREAM training on Tuesday Sept 30</a> &lt;&#8211;</strong></p>\n<p>PS: I want to hear your thoughts about this&#8230; just reply to this email if you have any questions. I stand 100% behind all the trainings and resources that I recommend.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Website Design Packages available again (very limited supply)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Sep 2014 09:21:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:626:\"<p>We are taking on 4 more website design packages in September.  Details here. A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1810:\"<p></p><p>We are taking on 4 more website design packages in September.  Details <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production services.  For this purpose we have created a very compellingly-priced optimal mix of on-shore marketing, design and copywriting services, and off-shore production assistance.  We don&#8217;t just make your site, we also give you advice on many topics that you are simply not going to get from your average web designer &#8212; let alone an offshore web designer.</p>\n<p><strong>&gt;&gt; <a href=\"http://wpacademy.com/websites\">View your options for Starter Website Packages Here</a> &lt;&lt;</strong></p>\n<p><em><strong>However, there is a catch</strong></em> &#8212; we only sell a very limited number of these per production cycle, so you will need to jump on this fast.  Schedule your appointment or purchase a package directly as soon as possible, if you wish to take advantage of this offer.</p>\n<p>Here are some of the sites we made in our last production run:</p>\n<p><img class=\"alignnone size-full wp-image-19873\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/websites-all.jpg\" alt=\"websites-all\" width=\"600\" height=\"577\" /></p>\n<p>Order yours <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Sep 2014 07:50:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19861\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>Some of you already know this, but in July I moved to Thailand to run my business and study yoga. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea. [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5879:\"<p></p><p><strong><img class=\"alignright size-medium wp-image-19863\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/porch2-300x225.jpg\" alt=\"porch2\" width=\"300\" height=\"225\" />Some of you already know this, but in July I moved to Thailand to run my business and study yoga</strong>. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea.</p>\n<p>As such I know quite a bit about creating a &#8220;lifestyle business&#8221;.  But there is someone who knows even more than me.  Her name is Natalie Sisson (the &#8220;Suitcase entrepreneur&#8221;), and<strong> she is giving a free webinar on Thursday, Sept. 18 at 3pm EST.  You can register <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">here.</a></strong></p>\n<p>Here is what she has to say about it:</p>\n<p>There are three (big) reasons you should consider creating a “lifestyle business” &#8211; one that gives you major freedom, on your own terms and allows you to live how you want to live.</p>\n<p>1) <strong>You get to make your own hours</strong>. Maybe you like to work early, stay up late. Do half-days, break up your day, do yoga in the middle &#8211; whatever you choose.</p>\n<p>2) <strong>You get to decide where you work</strong> (some like it hot, some like it cold), and not ever be tied down to one location unless you choose it. Mountain climbing, surfing or fly fishing can absolutely be a part of your ideal day.</p>\n<p>3) <strong>When YOU are in control and are running your business</strong> (instead of your business running you), you will be happier, have greater freedom and be able to rekindle those dreams you may have pushed aside, making it all a reality.</p>\n<p>Lots of people think that to be a successful entrepreneur you need to treat your business as a &#8220;job&#8221;.  That’s the world we live in and we’re taught to just follow “the rules,” work our way up and out, slaving away and THIS will eventually equal happiness.</p>\n<p><strong>Not.</strong></p>\n<p>You can’t start a business, treat it like a job and expect yourself to have a ton of freedom and flexibility.  You ought to factor in your lifestyle aspirations, your needs and wants and preferences, your preferred working style and environment, your (realistic) income needs, etc.,  from the beginning.  And (of course) you need practical and actionable traffic-getting and income-generating strategies.   Otherwise&#8230; oye, it might be a tough slog.  If you can get to the end at all (most people who try don&#8217;t, I am one of the lucky ones).</p>\n<p>Entrepreneurship is growing more rapidly than any other profession on the planet. Technology has given us freedom and most people aren’t finding happiness in a job. They want more.</p>\n<p>Now, we can literally work anywhere in the world, doing whatever we darn well please.</p>\n<p><strong>But how do you do it?</strong> How do you make it really work and create real revenue and STILL have freedom?</p>\n<p>My friend and awesome entrepreneur brainchild Natalie Sisson, Founder of The Suitcase Entrepreneur, is hosting a really cool never-done-before training on <strong>“How to Uncover Your Fastest Path To Making Real Revenue, Creating a Business Working Anywhere in the World and Never Again Be Tied Down To A Boss”.</strong></p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Register to the free training here</a> &lt;&lt;</strong></p>\n<p>Natalie is a #1 best-selling author, has grown a tribe of over 16,000 hungry Freedom Seekers on her blog, has a top Podcast on iTunes and gets paid to speak around the world on freedom + entrepreneurship.</p>\n<p>She’ll be giving us FIRST DIBS on on her behind-the-scenes tactics she’s used to be able to travel the world, meet all sorts of amazing people all while creating a six figure business.</p>\n<p><strong>In this exclusive live training, we’re going to be covering:</strong></p>\n<p>1) The #1 Mistake People Make When Designing a Business Online That Keeps Them Stuck, Under-earning and Tied Down</p>\n<p>2) How You Can Find Your &#8220;Sweet Spot&#8221;, Actually Get Paid To Do What You Love, Are Good At and Turn That Into A Real Business</p>\n<p>3) Natalie’s Unique Three-Stage Plan She’s Developed To Build Her Completely Location Independent 6-figure Business</p>\n<p>4) The FOUR Things It Really Takes to Be Free and Which of These is The Most Overlooked (Yet CRITICALLY Important) For Living Life On Your Own Terms</p>\n<p>5) How YOU Can Design, Create &amp; IMPLEMENT Your PERFECT Online Lifestyle Business In Eight Weeks Or Less!</p>\n<p>If you’re ready to become a Freedom Fighter in your own life, stand for something more, making real revenue, rekindle those childhood dreams of exploring the world and going on the next big adventure, then I invite you to join us!</p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Click here to register and claim your free spot</a> &lt;&lt;</strong></p>\n<p>P.S. Oh, one last thing! Natalie is also going to be giving everyone who attends a really cool bonus. It’s a<strong> Freedom Formula Checklist</strong> &#8211; “Your First Steps To Designing Your Ultimate Lifestyle Business In Just Eight Weeks.” <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Join us live now</a>!</p>\n<p><span style=\"font-size: 12pt; font-family: arial;\"><br />\n</span></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"[LIVE] 4 simple ways to drive more sales and conversions. . .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Jul 2014 17:49:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19831\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:579:\"<p>If you’re looking to boost your sales before the end of the year. . . Or you believe your site should be generating significantly higher revenue than it is now. . . We just heard about an all-new live training that you need to see. This week, the lead generation experts at LeadPages are hosting [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3002:\"<p></p><p>If you’re looking to boost your sales before the end of the year. . .</p>\n<p>Or you believe your site should be generating significantly higher revenue than it is now. . .</p>\n<p>We just heard about an all-new live training that you need to see.</p>\n<p>This week, the lead generation experts at LeadPages are hosting a new live training entitled: <i>“How to Transform Your Site into a Lead Generation Machine that Drives More Sales.”</i></p>\n<p>This live webinar is happening Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">As a student in our course, you’re invited to attend.</a>&lt;&#8211;</p>\n<p>If you’re not familiar with LeadPages, this lead generation platform creates all the landing pages that you’ve seen on our website. (We can’t recommend LeadPages highly enough.)</p>\n<p>With over 20,000 customers just like us, LeadPages is constantly testing to discover which landing page designs and elements generate the most sales and conversions.</p>\n<p>Through all that research, LeadPages has discovered specific techniques that you can use to boost conversions and drive more sales.</p>\n<p>During Thursday’s live training, LeadPages Conversion Educator Tim Paige will reveal four of these simple techniques.</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Register for Thursday’s all-new live training right now. </a>&lt;&#8211;</p>\n<p>Inside Thursday’s live training, you’ll also discover. . .</p>\n<ul>\n<li>The 4 most critical, yet overlooked elements of your site (and how to tweak them to drive more sales).</li>\n</ul>\n<ul>\n<li>A simple, proven way to create the highest performing lead magnet you will likely ever use &#8212; that only takes 30 minutes to set up.</li>\n</ul>\n<ul>\n<li>3 unusual but simple ways to turn your Facebook fans into potential customers.</li>\n</ul>\n<p>There’s no telling when this live training will be available again.</p>\n<p>Again, if you’re interested in boosting your sales this year, we highly encourage you to join this all-new webinar on Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Don’t wait. Register for this live training right now. </a>&lt;&#8211;</p>\n<p>We’ll see you at Thursday’s live training.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone wp-image-19324 size-full\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n<a href=\"http://www.wpacademy.com\">WP Academy</a></p>\n<p>P.S. Only 1,000 people can be on this webinar at any one time. We recommend you register now and show up early on Thursday to claim your spot.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WP Academy joins the gift economy + New services\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://members.wpacademy.com/2014/07/wp-academy-joins-the-gift-economy-new-services/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://members.wpacademy.com/2014/07/wp-academy-joins-the-gift-economy-new-services/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Jul 2014 16:42:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19797\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:609:\"<p>I will keep this short with two fabulous news items. WP Encyclopedia 2014 is now ready!&#160; The WordPress Business Encyclopedia, 2014 Edition, is now being offered through the gift economy.&#160; This means that you can access all of the resources inside this incredible system for a donation amount that you choose.&#160; Click here for details. [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/07/wp-academy-joins-the-gift-economy-new-services/\">WP Academy joins the gift economy + New services</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2797:\"<p></p><p>I will keep this short with two fabulous news items.</p>\n<p><strong>WP Encyclopedia 2014 is now ready!</strong>&#160; </p>\n<p>The WordPress Business Encyclopedia, 2014 Edition, is now being offered through the gift economy.&#160; This means that you can access all of the resources inside this incredible system for a donation amount that you choose.&#160; Click <a href=\"http://wpencyclopedia.com\">here</a> for details.</p>\n<p>Over 3 years in the making, the WP Encyclopedia 2014 Edition is the most comprehensive video training system for making a <strong>WordPress business website or Blog</strong> ever created. Included in WP Encyclopedia are <strong>8 short courses</strong> including our immensely popular <strong>WordPress Essentials for Business</strong>, <strong>WordPress Theme Selection and Customization</strong>, the new <strong>Plugin Reviews</strong> section, and 6 more.&#160; The plugin reviews section is currently the most comprehensive WordPress plugin review site on the net.</p>\n<p>You can access all these resources through a <a href=\"http://wpencyclopedia.com\">simple donation</a> (if you have already donated, please ignore that link).&#160; </p>\n<p><a href=\"http://wpencyclopedia.com\"><img title=\"wpenc-dvd-splash-small\" style=\"border-top: 0px; border-right: 0px; background-image: none; border-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; display: inline; padding-right: 0px\" border=\"0\" alt=\"wpenc-dvd-splash-small\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/07/wpenc-dvd-splash-small.jpg\" width=\"244\" height=\"184\" /></a></p>\n<p><strong>WP Live training just $45/mth</strong></p>\n<p>WP Live is our award-winning live training program, that includes live coaching by our experts, themes worth $1350, stock photos and ticket support.&#160; Previously available only to graduates of our programs, you can get it now for a subscription.&#160; Click <a href=\"http://www.wpacademy.com/wordpress-training/\">here</a> for details.</p>\n<p><strong>Only 2 website design packages remaining!</strong></p>\n<p>We have sold 8 of our new trial product, an assisted website design product.&#160; Click <a href=\"http://www.wpacademy.com/websites/\">here</a> if you are looking for some serious assistance in getting your site done before September.&#160; But act soon!</p>\n<p>To your success,</p>\n<p><img border=\"0\" src=\"https://d1yoaun8syyxxt.cloudfront.net/gt121-6abc1e07-2a24-4224-9ceb-2de5b32743e7-v2\" width=\"150\" align=\"bottom\" height=\"150\" /></p>\n<p>Your Small-Biz Web Technology Mentor</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/07/wp-academy-joins-the-gift-economy-new-services/\">WP Academy joins the gift economy + New services</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://members.wpacademy.com/2014/07/wp-academy-joins-the-gift-economy-new-services/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Super-affordable Website Design Packages are now available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Jun 2014 14:43:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19754\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:565:\"<p>This is a big moment for WP Academy. For years, people have asked us: do we do websites?  And we had to say &#8220;No, but we will teach you how to do it&#8221;.  And we did just that &#8212; over 500 people have attended our live courses, while 10,000+ took one of our courses on [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\">Super-affordable Website Design Packages are now available</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3776:\"<p></p><p>This is a big moment for WP Academy.</p>\n<p>For years, people have asked us: do we do websites?  And we had to say &#8220;No, but we will teach you how to do it&#8221;.  And we did just that &#8212; over 500 people have attended our live courses, while 10,000+ took one of our courses on <a href=\"http://wpencyclopedia.com\">WP Encyclopedia</a> or on Udemy.  But many people in our do-it-yourself training needed either a little extra help, or to be told directly what to do.</p>\n<p>If you need a new website that looks professional and gets you business; or if you already have a website but it needs more work than you have either the desire or the skills for, then this mail will be of interest to you.</p>\n<p>&gt;&gt; <a href=\"http://wpacademy.com/websites\">View our super-affordable Website Design Starter Package here</a> &lt;&lt;</p>\n<p><strong>Who are these sites for?</strong></p>\n<p>&nbsp;</p>\n<p>These sites are for entrepreneurs on a money- and time-budget who want a quick website that does the job and looks professional.  They don&#8217;t want to mess with all the technical details of setting it up.  They probably have their sales copy ready but need the opinion of a professional marketer.  They may already know a little WordPress but want to learn how a professional does it, so that they can do it again on their own later.</p>\n<p><strong>Does your site pass the &#8220;5 second test&#8221;?</strong></p>\n<p>Statistics show that most visitors to your site will leave unless your website answers the following questions within 5 seconds:</p>\n<ul>\n<li>Who are you?</li>\n<li>What product or service do you provide?</li>\n<li>&#8220;What&#8217;s in it for me&#8221;?</li>\n</ul>\n<p>Many website development projects fail because the sites are not designed or written for a clear business purpose.  And many traditional website designers (and particularly offshore contractors) can&#8217;t help you with this.</p>\n<p>&gt;&gt; <a href=\"http://wpacademy.com/websites\">See other reasons why website development projects fail</a> &lt;&lt;</p>\n<p>Myself and my associates Christopher Staser and George Plumley have a combined 25 years of website development and internet marketing experiences.  Each starter website package includes 2 hours direct one-on-one consultation with one of us &#8212; this time is likely to be a very valuable investment for you.</p>\n<p><strong>Very limited availability during June and July</strong></p>\n<p>During June and July we are prototyping this model, to make sure that we have everything in place when this service officially launches in September.  As such, we can only offer 10 of these packages right now.  Getting on the beta program for these sites is to your advantage, as we will be making double-sure that you are taken care of (we want that testimonial!).  But you will need to act fast as the packages will likely sell out quickly.</p>\n<p>&nbsp;</p>\n<p><strong>Book a free 15 minute consultation and website diagnosis</strong></p>\n<p>Curious to find out more?  Then book yourself a free 15-minute consultation and website diagnosis <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p><strong>PS: We do higher-end sites too</strong>, with optional full verbal and visual branding and messaging.  Simply respond to this email for details.</p>\n<p>To Your Success,</p>\n<p><img src=\"https://d1yoaun8syyxxt.cloudfront.net/gt121-6abc1e07-2a24-4224-9ceb-2de5b32743e7-v2\" alt=\"\" width=\"150\" height=\"150\" align=\"bottom\" border=\"0\" /></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\">Super-affordable Website Design Packages are now available</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WP Encyclopedia has joined the gift economy!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-has-joined-the-gift-economy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-has-joined-the-gift-economy/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jun 2014 20:52:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19782\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:601:\"<p>The WordPress Business Encyclopedia, 2014 Edition, is now being offered through the gift economy.&#160; This means that you can access all of the resources inside this incredible system for a donation amount that you choose.&#160; Click here for details. Over 3 years in the making, the WP Encyclopedia 2014 Edition is the most comprehensive video [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/06/wp-encyclopedia-has-joined-the-gift-economy/\">WP Encyclopedia has joined the gift economy!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2858:\"<p></p><p><a href=\"http://wpacademy.com/enc\" target=\"_blank\"><img title=\"wpenc2104-case\" style=\"border-top: 0px; border-right: 0px; background-image: none; border-bottom: 0px; float: right; padding-top: 0px; padding-left: 0px; border-left: 0px; display: inline; padding-right: 0px\" border=\"0\" alt=\"wpenc2104-case\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/06/wpenc2104-case.jpg\" width=\"240\" align=\"right\" height=\"179\" /></a>The WordPress Business Encyclopedia, 2014 Edition, is now being offered through the gift economy.&#160; This means that you can access all of the resources inside this incredible system for a donation amount that you choose.&#160; Click <a href=\"http://wpacademy.com/enc\" target=\"_blank\">here</a> for details.</p>\n<p>Over 3 years in the making, the WP Encyclopedia 2014 Edition is the most comprehensive video training system for making a <strong>WordPress business website or Blog</strong> ever created. Designed for beginner to advanced level users, it will teach you how to <strong>make an attractive website</strong>; to <strong>market your site</strong> with the full power of email marketing, search-engine optimization, social media and online video; and finally how to<strong> monetize your site</strong> with a shopping cart or membership system. </p>\n<p>Included in WP Encyclopedia are <strong>8 short courses</strong> including our immensely popular <a href=\"http://wpencyclopedia.com/index.htm?wordpress_essentials_training.htm\" target=\"_blank\">WordPress Essentials for Business</a>, <a href=\"http://wpencyclopedia.com/index.htm?theme_selection__customization.htm\" target=\"_blank\">WordPress Theme Selection and Customization</a>, the new <a href=\"http://wpencyclopedia.com/index.htm?plugin_reviews.htm\" target=\"_blank\">Plugin Reviews</a> section, and 6 more.&#160; The plugin reviews section is currently the most comprehensive WordPress plugin review site on the net.</p>\n<p>You can access all these resources through a <a href=\"http://wpacademy.com/enc\" target=\"_blank\">simple donation</a>.&#160; </p>\n<p>This is a major milestone for WP Academy.&#160; We decided to join the gift economy after seeing other businesses with a social mission succeed with it.&#160; We are confident that with the support of our users we will be able to continue to put out world-class training content for entrepreneurs and small business owners worldwide.</p>\n<p>To your success,</p>\n<p><img border=\"0\" src=\"https://d1yoaun8syyxxt.cloudfront.net/gt121-6abc1e07-2a24-4224-9ceb-2de5b32743e7-v2\" width=\"150\" align=\"bottom\" height=\"150\" /></p>\n<p>Your Small-Biz Web Technology Mentor</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/06/wp-encyclopedia-has-joined-the-gift-economy/\">WP Encyclopedia has joined the gift economy!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-has-joined-the-gift-economy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WP Encyclopedia 2014 is almost ready!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://members.wpacademy.com/2014/05/wp-encyclopedia-2014-is-almost-ready/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://members.wpacademy.com/2014/05/wp-encyclopedia-2014-is-almost-ready/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 May 2014 13:43:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19764\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:587:\"<p>Great news!  The WordPress Business Encyclopedia, 2014 Edition, is almost ready.  In particular the plugin reviews section is nearly complete (I am just tying up loose ends).  It is now the most comprehensive plugin reviews site on the web: 350+ plugins in 52 categories, with reviews and recommendations.  The list should include all the most [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/05/wp-encyclopedia-2014-is-almost-ready/\">WP Encyclopedia 2014 is almost ready!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2122:\"<p></p><p><img class=\"alignright size-medium wp-image-19770\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/06/be_cd2-300x300.jpg\" alt=\"WP Encyclopedai 2014\" width=\"300\" height=\"300\" />Great news!  <strong>The WordPress Business Encyclopedia, 2014 Edition</strong>, is almost ready.  In particular the <a href=\"http://wpencyclopedia.com/index.htm?plugin_reviews.htm\" target=\"_blank\">plugin reviews</a> section is nearly complete (I am just tying up loose ends).  It is now the most comprehensive plugin reviews site on the web: 350+ plugins in 52 categories, with reviews and recommendations.  The list should include all the most popular WordPress plugins.  Enjoy!</p>\n<p>I wish to thank our generous crowd funders for making this possible.  Thanks to them, the review articles are free for everyone.  If you have already donated, you can also access all the videos including our <a href=\"http://wpencyclopedia.com/index.htm?theme_selection__customization.htm\" target=\"_blank\">WordPress Theme Selection</a> course and the <a href=\"http://wpencyclopedia.com/index.htm?wp_live_course_recordings.htm\" target=\"_blank\">WP Live Course Recordings</a>.  If you have not yet donated to WP Encyclopedia, you can still access all these resources at the discounted rate of $30 <a href=\"http://wpacademy.com/enc/\" target=\"_blank\">here</a> – but only for the next 10 days or so, when we release the final product for $47.</p>\n<p>(Note: if you donated to the DVD version last year, I will be emailing you within the next 2 weeks).</p>\n<p>A reminder also that our new, super-affordable <strong>Starter Website Packages</strong> are doing well – and we only have 7 left (out of 10) for the summer production cycle.  I anticipate they will sell out within a week, so <a href=\"http://www.wpacademy.com/websites/\" target=\"_blank\">get yours now</a> if you want your site ready by Labor day.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/05/wp-encyclopedia-2014-is-almost-ready/\">WP Encyclopedia 2014 is almost ready!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://members.wpacademy.com/2014/05/wp-encyclopedia-2014-is-almost-ready/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:48:\"http://members.wpacademy.com/category/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:4:\"date\";s:29:\"Wed, 26 Nov 2014 06:37:02 GMT\";s:6:\"server\";s:9:\"LiteSpeed\";s:10:\"connection\";s:5:\"close\";s:12:\"x-powered-by\";s:10:\"PHP/5.4.31\";s:10:\"set-cookie\";a:5:{i:0;s:55:\"wlmdebug=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT\";i:1;s:210:\"wc_session_cookie_d0fb3bf6a09f702cdfb97e4d2c564710=g2q2VBEExlNnanJSwpdX7RKtlAzZOmn6%7C%7C1417156622%7C%7C1417153022%7C%7Ca82252c2ff6dab12ebd7ea22ea0b65b7; expires=Fri, 28-Nov-2014 06:37:02 GMT; path=/; httponly\";i:2;s:74:\"woocommerce_items_in_cart=0; expires=Wed, 26-Nov-2014 05:37:02 GMT; path=/\";i:3;s:70:\"woocommerce_cart_hash=0; expires=Wed, 26-Nov-2014 05:37:02 GMT; path=/\";i:4;s:76:\"wfvt_1871270157=5475750ee2c2f; expires=Wed, 26-Nov-2014 07:07:02 GMT; path=/\";}s:10:\"x-pingback\";s:39:\"http://members.wpacademy.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Mon, 24 Nov 2014 13:01:58 GMT\";s:4:\"etag\";s:34:\"\"4742f58c40e6505dc02036d3c4244557\"\";s:12:\"x-robots-tag\";s:14:\"noindex,follow\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";}s:5:\"build\";s:14:\"20140613153416\";}","no");
INSERT INTO wp_options VALUES("78247","_transient_timeout_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1417027023","no");
INSERT INTO wp_options VALUES("78248","_transient_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1416983823","no");
INSERT INTO wp_options VALUES("78266","rewrite_rules","a:121:{s:8:\"folio/?$\";s:25:\"index.php?post_type=folio\";s:38:\"folio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=folio&feed=$matches[1]\";s:33:\"folio/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=folio&feed=$matches[1]\";s:25:\"folio/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=folio&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:31:\"folio/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"folio/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"folio/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"folio/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"folio/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:24:\"folio/(.+?)/trackback/?$\";s:32:\"index.php?folio=$matches[1]&tb=1\";s:44:\"folio/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?folio=$matches[1]&feed=$matches[2]\";s:39:\"folio/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?folio=$matches[1]&feed=$matches[2]\";s:32:\"folio/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?folio=$matches[1]&paged=$matches[2]\";s:39:\"folio/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?folio=$matches[1]&cpage=$matches[2]\";s:24:\"folio/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?folio=$matches[1]&page=$matches[2]\";s:15:\"testimonials/?$\";s:32:\"index.php?post_type=testimonials\";s:45:\"testimonials/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:40:\"testimonials/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:32:\"testimonials/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=testimonials&paged=$matches[1]\";s:48:\"clients/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?clients=$matches[1]&feed=$matches[2]\";s:43:\"clients/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?clients=$matches[1]&feed=$matches[2]\";s:36:\"clients/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&paged=$matches[2]\";s:18:\"clients/([^/]+)/?$\";s:29:\"index.php?clients=$matches[1]\";s:47:\"skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?skills=$matches[1]&feed=$matches[2]\";s:42:\"skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?skills=$matches[1]&feed=$matches[2]\";s:35:\"skills/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?skills=$matches[1]&paged=$matches[2]\";s:17:\"skills/([^/]+)/?$\";s:28:\"index.php?skills=$matches[1]\";s:38:\"testimonials/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"testimonials/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"testimonials/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"testimonials/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"testimonials/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"testimonials/(.+?)/trackback/?$\";s:39:\"index.php?testimonials=$matches[1]&tb=1\";s:51:\"testimonials/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:46:\"testimonials/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:39:\"testimonials/(.+?)/page/?([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&paged=$matches[2]\";s:46:\"testimonials/(.+?)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&cpage=$matches[2]\";s:31:\"testimonials/(.+?)(/[0-9]+)?/?$\";s:51:\"index.php?testimonials=$matches[1]&page=$matches[2]\";s:7:\"gall/?$\";s:24:\"index.php?post_type=gall\";s:37:\"gall/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=gall&feed=$matches[1]\";s:32:\"gall/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=gall&feed=$matches[1]\";s:24:\"gall/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=gall&paged=$matches[1]\";s:30:\"gall/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"gall/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"gall/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"gall/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"gall/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:23:\"gall/(.+?)/trackback/?$\";s:31:\"index.php?gall=$matches[1]&tb=1\";s:43:\"gall/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?gall=$matches[1]&feed=$matches[2]\";s:38:\"gall/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?gall=$matches[1]&feed=$matches[2]\";s:31:\"gall/(.+?)/page/?([0-9]{1,})/?$\";s:44:\"index.php?gall=$matches[1]&paged=$matches[2]\";s:38:\"gall/(.+?)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?gall=$matches[1]&cpage=$matches[2]\";s:23:\"gall/(.+?)(/[0-9]+)?/?$\";s:43:\"index.php?gall=$matches[1]&page=$matches[2]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=204&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");



DROP TABLE wp_postmeta;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2012 DEFAULT CHARSET=utf8;

INSERT INTO wp_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("6","6","_wp_attached_file","2012/08/img_01.jpg");
INSERT INTO wp_postmeta VALUES("7","6","_wp_attachment_metadata","a:5:{s:5:\"width\";i:770;s:6:\"height\";i:415;s:4:\"file\";s:18:\"2012/08/img_01.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"img_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"img_01-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:16:\"img_01-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("8","7","_wp_attached_file","2012/08/img_02.jpg");
INSERT INTO wp_postmeta VALUES("9","7","_wp_attachment_metadata","a:5:{s:5:\"width\";i:770;s:6:\"height\";i:415;s:4:\"file\";s:18:\"2012/08/img_02.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"img_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"img_02-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:16:\"img_02-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("10","8","_wp_attached_file","2012/08/img_03.jpg");
INSERT INTO wp_postmeta VALUES("11","8","_wp_attachment_metadata","a:5:{s:5:\"width\";i:770;s:6:\"height\";i:415;s:4:\"file\";s:18:\"2012/08/img_03.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"img_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"img_03-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:16:\"img_03-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("12","9","_wp_attached_file","2012/08/img_04.jpg");
INSERT INTO wp_postmeta VALUES("13","9","_wp_attachment_metadata","a:5:{s:5:\"width\";i:770;s:6:\"height\";i:415;s:4:\"file\";s:18:\"2012/08/img_04.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"img_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"img_04-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:16:\"img_04-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("14","10","_wp_attached_file","2012/08/img_05.jpg");
INSERT INTO wp_postmeta VALUES("15","10","_wp_attachment_metadata","a:5:{s:5:\"width\";i:770;s:6:\"height\";i:415;s:4:\"file\";s:18:\"2012/08/img_05.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"img_05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"img_05-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:16:\"img_05-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("16","29","_wp_attached_file","2012/08/blog_img_01.jpg");
INSERT INTO wp_postmeta VALUES("17","29","_wp_attachment_metadata","a:5:{s:5:\"width\";i:721;s:6:\"height\";i:302;s:4:\"file\";s:23:\"2012/08/blog_img_01.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_01-300x125.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"blog_img_01-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("18","30","_wp_attached_file","2012/08/blog_img_02.jpg");
INSERT INTO wp_postmeta VALUES("19","30","_wp_attachment_metadata","a:5:{s:5:\"width\";i:721;s:6:\"height\";i:302;s:4:\"file\";s:23:\"2012/08/blog_img_02.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_02-300x125.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"blog_img_02-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("20","31","_wp_attached_file","2012/08/blog_img_03.jpg");
INSERT INTO wp_postmeta VALUES("21","31","_wp_attachment_metadata","a:5:{s:5:\"width\";i:345;s:6:\"height\";i:220;s:4:\"file\";s:23:\"2012/08/blog_img_03.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_03-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"blog_img_03-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("22","32","_wp_attached_file","2012/08/blog_img_04.jpg");
INSERT INTO wp_postmeta VALUES("23","32","_wp_attachment_metadata","a:5:{s:5:\"width\";i:345;s:6:\"height\";i:220;s:4:\"file\";s:23:\"2012/08/blog_img_04.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_04-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"blog_img_04-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("24","33","_wp_attached_file","2012/08/blog_img_05.jpg");
INSERT INTO wp_postmeta VALUES("25","33","_wp_attachment_metadata","a:5:{s:5:\"width\";i:345;s:6:\"height\";i:220;s:4:\"file\";s:23:\"2012/08/blog_img_05.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_05-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"blog_img_05-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("26","34","_wp_attached_file","2012/08/item_img_1.jpg");
INSERT INTO wp_postmeta VALUES("27","34","_wp_attachment_metadata","a:5:{s:5:\"width\";i:232;s:6:\"height\";i:130;s:4:\"file\";s:22:\"2012/08/item_img_1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"item_img_1-150x130.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:20:\"item_img_1-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("28","35","_wp_attached_file","2012/08/item_img_2.jpg");
INSERT INTO wp_postmeta VALUES("29","35","_wp_attachment_metadata","a:5:{s:5:\"width\";i:232;s:6:\"height\";i:130;s:4:\"file\";s:22:\"2012/08/item_img_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"item_img_2-150x130.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:20:\"item_img_2-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("30","36","_wp_attached_file","2012/08/item_img_3.jpg");
INSERT INTO wp_postmeta VALUES("31","36","_wp_attachment_metadata","a:5:{s:5:\"width\";i:232;s:6:\"height\";i:130;s:4:\"file\";s:22:\"2012/08/item_img_3.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"item_img_3-150x130.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:20:\"item_img_3-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("32","81","_wp_attached_file","2012/08/beautiful-customer-support.jpg");
INSERT INTO wp_postmeta VALUES("33","81","_wp_attachment_metadata","a:5:{s:5:\"width\";i:539;s:6:\"height\";i:371;s:4:\"file\";s:38:\"2012/08/beautiful-customer-support.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"beautiful-customer-support-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"beautiful-customer-support-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:36:\"beautiful-customer-support-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D3X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1292322483;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("34","82","_wp_attached_file","2012/08/business-development-hands-holding-seedling-in-a-group.jpg");
INSERT INTO wp_postmeta VALUES("35","82","_wp_attachment_metadata","a:5:{s:5:\"width\";i:548;s:6:\"height\";i:365;s:4:\"file\";s:66:\"2012/08/business-development-hands-holding-seedling-in-a-group.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:66:\"business-development-hands-holding-seedling-in-a-group-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:66:\"business-development-hands-holding-seedling-in-a-group-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:64:\"business-development-hands-holding-seedling-in-a-group-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D3X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1253876431;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("36","83","_wp_attached_file","2012/08/business-woman-pointing-at-you.jpg");
INSERT INTO wp_postmeta VALUES("37","83","_wp_attachment_metadata","a:5:{s:5:\"width\";i:532;s:6:\"height\";i:375;s:4:\"file\";s:42:\"2012/08/business-woman-pointing-at-you.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"business-woman-pointing-at-you-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"business-woman-pointing-at-you-300x211.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:211;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:40:\"business-woman-pointing-at-you-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.5;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D3X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1299067304;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("38","84","_wp_attached_file","2012/08/glass-globe-or-earth-in-grass.jpg");
INSERT INTO wp_postmeta VALUES("39","84","_wp_attachment_metadata","a:5:{s:5:\"width\";i:548;s:6:\"height\";i:364;s:4:\"file\";s:41:\"2012/08/glass-globe-or-earth-in-grass.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"glass-globe-or-earth-in-grass-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"glass-globe-or-earth-in-grass-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:39:\"glass-globe-or-earth-in-grass-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996447286321199499070644378662109375;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D90\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1272119804;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"55\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.001\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("40","85","_wp_attached_file","2012/08/group-of-happy-business-people-laughing.jpg");
INSERT INTO wp_postmeta VALUES("41","85","_wp_attachment_metadata","a:5:{s:5:\"width\";i:455;s:6:\"height\";i:439;s:4:\"file\";s:51:\"2012/08/group-of-happy-business-people-laughing.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"group-of-happy-business-people-laughing-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:51:\"group-of-happy-business-people-laughing-300x289.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:289;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:49:\"group-of-happy-business-people-laughing-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:6.29999999999999982236431605997495353221893310546875;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Hasselblad H3D II-39\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1206269827;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"120\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:16:\"0.00624999962747\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("42","86","_wp_attached_file","2012/08/mature-couple-using-laptop-computer-and-smiling-.jpg");
INSERT INTO wp_postmeta VALUES("43","86","_wp_attachment_metadata","a:5:{s:5:\"width\";i:544;s:6:\"height\";i:368;s:4:\"file\";s:60:\"2012/08/mature-couple-using-laptop-computer-and-smiling-.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:60:\"mature-couple-using-laptop-computer-and-smiling--150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:60:\"mature-couple-using-laptop-computer-and-smiling--300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:58:\"mature-couple-using-laptop-computer-and-smiling--55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:22:\"Canon EOS-1Ds Mark III\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1252686469;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("44","87","_wp_attached_file","2012/08/perfect-customer-support.jpg");
INSERT INTO wp_postmeta VALUES("45","87","_wp_attachment_metadata","a:5:{s:5:\"width\";i:548;s:6:\"height\";i:365;s:4:\"file\";s:36:\"2012/08/perfect-customer-support.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"perfect-customer-support-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"perfect-customer-support-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:34:\"perfect-customer-support-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.5;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D3X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1292322730;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("46","88","_wp_attached_file","2012/08/relaxed-business-man-smiling.jpg");
INSERT INTO wp_postmeta VALUES("47","88","_wp_attachment_metadata","a:5:{s:5:\"width\";i:542;s:6:\"height\";i:369;s:4:\"file\";s:40:\"2012/08/relaxed-business-man-smiling.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"relaxed-business-man-smiling-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"relaxed-business-man-smiling-300x204.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:204;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:38:\"relaxed-business-man-smiling-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON D3X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1299069987;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("48","141","_thumbnail_id","6");
INSERT INTO wp_postmeta VALUES("49","141","_edit_last","1");
INSERT INTO wp_postmeta VALUES("50","141","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("51","141","portfolio_url","");
INSERT INTO wp_postmeta VALUES("52","141","portfolio_date","");
INSERT INTO wp_postmeta VALUES("53","141","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("54","141","portfolio_client","");
INSERT INTO wp_postmeta VALUES("55","141","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("56","141","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("57","141","page_top","");
INSERT INTO wp_postmeta VALUES("58","141","page_bottom","");
INSERT INTO wp_postmeta VALUES("59","141","meta_title","");
INSERT INTO wp_postmeta VALUES("60","141","meta_keywords","");
INSERT INTO wp_postmeta VALUES("61","141","meta_description","");
INSERT INTO wp_postmeta VALUES("62","141","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("63","141","pagebg_color","");
INSERT INTO wp_postmeta VALUES("64","141","pagebg_image","");
INSERT INTO wp_postmeta VALUES("65","141","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("66","141","page_slider","");
INSERT INTO wp_postmeta VALUES("67","141","page_slider_type","");
INSERT INTO wp_postmeta VALUES("68","142","_edit_last","1");
INSERT INTO wp_postmeta VALUES("69","142","_thumbnail_id","81");
INSERT INTO wp_postmeta VALUES("70","142","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("71","142","portfolio_url","");
INSERT INTO wp_postmeta VALUES("72","142","portfolio_date","");
INSERT INTO wp_postmeta VALUES("73","142","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("74","142","portfolio_client","");
INSERT INTO wp_postmeta VALUES("75","142","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("76","142","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("77","142","page_top","");
INSERT INTO wp_postmeta VALUES("78","142","page_bottom","");
INSERT INTO wp_postmeta VALUES("79","142","meta_title","");
INSERT INTO wp_postmeta VALUES("80","142","meta_keywords","");
INSERT INTO wp_postmeta VALUES("81","142","meta_description","");
INSERT INTO wp_postmeta VALUES("82","142","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("83","142","pagebg_color","");
INSERT INTO wp_postmeta VALUES("84","142","pagebg_image","");
INSERT INTO wp_postmeta VALUES("85","142","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("86","142","page_slider","");
INSERT INTO wp_postmeta VALUES("87","142","page_slider_type","");
INSERT INTO wp_postmeta VALUES("88","143","_edit_last","1");
INSERT INTO wp_postmeta VALUES("89","143","_thumbnail_id","82");
INSERT INTO wp_postmeta VALUES("90","143","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("91","143","portfolio_url","");
INSERT INTO wp_postmeta VALUES("92","143","portfolio_date","");
INSERT INTO wp_postmeta VALUES("93","143","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("94","143","portfolio_client","");
INSERT INTO wp_postmeta VALUES("95","143","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("96","143","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("97","143","page_top","");
INSERT INTO wp_postmeta VALUES("98","143","page_bottom","");
INSERT INTO wp_postmeta VALUES("99","143","meta_title","");
INSERT INTO wp_postmeta VALUES("100","143","meta_keywords","");
INSERT INTO wp_postmeta VALUES("101","143","meta_description","");
INSERT INTO wp_postmeta VALUES("102","143","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("103","143","pagebg_color","");
INSERT INTO wp_postmeta VALUES("104","143","pagebg_image","");
INSERT INTO wp_postmeta VALUES("105","143","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("106","143","page_slider","");
INSERT INTO wp_postmeta VALUES("107","143","page_slider_type","");
INSERT INTO wp_postmeta VALUES("108","144","_thumbnail_id","83");
INSERT INTO wp_postmeta VALUES("109","144","_edit_last","1");
INSERT INTO wp_postmeta VALUES("110","144","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("111","144","portfolio_url","");
INSERT INTO wp_postmeta VALUES("112","144","portfolio_date","");
INSERT INTO wp_postmeta VALUES("113","144","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("114","144","portfolio_client","");
INSERT INTO wp_postmeta VALUES("115","144","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("116","144","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("117","144","page_top","");
INSERT INTO wp_postmeta VALUES("118","144","page_bottom","");
INSERT INTO wp_postmeta VALUES("119","144","meta_title","");
INSERT INTO wp_postmeta VALUES("120","144","meta_keywords","");
INSERT INTO wp_postmeta VALUES("121","144","meta_description","");
INSERT INTO wp_postmeta VALUES("122","144","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("123","144","pagebg_color","");
INSERT INTO wp_postmeta VALUES("124","144","pagebg_image","");
INSERT INTO wp_postmeta VALUES("125","144","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("126","144","page_slider","");
INSERT INTO wp_postmeta VALUES("127","144","page_slider_type","");
INSERT INTO wp_postmeta VALUES("128","145","_edit_last","1");
INSERT INTO wp_postmeta VALUES("129","145","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("130","145","portfolio_url","");
INSERT INTO wp_postmeta VALUES("131","145","portfolio_date","");
INSERT INTO wp_postmeta VALUES("132","145","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("133","145","portfolio_client","");
INSERT INTO wp_postmeta VALUES("134","145","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("135","145","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("136","145","page_top","");
INSERT INTO wp_postmeta VALUES("137","145","page_bottom","");
INSERT INTO wp_postmeta VALUES("138","145","meta_title","");
INSERT INTO wp_postmeta VALUES("139","145","meta_keywords","");
INSERT INTO wp_postmeta VALUES("140","145","meta_description","");
INSERT INTO wp_postmeta VALUES("141","145","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("142","145","pagebg_color","");
INSERT INTO wp_postmeta VALUES("143","145","pagebg_image","");
INSERT INTO wp_postmeta VALUES("144","145","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("145","145","page_slider","");
INSERT INTO wp_postmeta VALUES("146","145","page_slider_type","");
INSERT INTO wp_postmeta VALUES("147","145","_thumbnail_id","84");
INSERT INTO wp_postmeta VALUES("148","146","_edit_last","1");
INSERT INTO wp_postmeta VALUES("149","146","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("150","146","portfolio_url","");
INSERT INTO wp_postmeta VALUES("151","146","portfolio_date","");
INSERT INTO wp_postmeta VALUES("152","146","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("153","146","portfolio_client","");
INSERT INTO wp_postmeta VALUES("154","146","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("155","146","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("156","146","page_top","");
INSERT INTO wp_postmeta VALUES("157","146","page_bottom","");
INSERT INTO wp_postmeta VALUES("158","146","meta_title","");
INSERT INTO wp_postmeta VALUES("159","146","meta_keywords","");
INSERT INTO wp_postmeta VALUES("160","146","meta_description","");
INSERT INTO wp_postmeta VALUES("161","146","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("162","146","pagebg_color","");
INSERT INTO wp_postmeta VALUES("163","146","pagebg_image","");
INSERT INTO wp_postmeta VALUES("164","146","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("165","146","page_slider","");
INSERT INTO wp_postmeta VALUES("166","146","page_slider_type","");
INSERT INTO wp_postmeta VALUES("167","146","_thumbnail_id","85");
INSERT INTO wp_postmeta VALUES("168","147","_edit_last","1");
INSERT INTO wp_postmeta VALUES("169","147","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("170","147","portfolio_url","");
INSERT INTO wp_postmeta VALUES("171","147","portfolio_date","");
INSERT INTO wp_postmeta VALUES("172","147","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("173","147","portfolio_client","");
INSERT INTO wp_postmeta VALUES("174","147","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("175","147","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("176","147","page_top","");
INSERT INTO wp_postmeta VALUES("177","147","page_bottom","");
INSERT INTO wp_postmeta VALUES("178","147","meta_title","");
INSERT INTO wp_postmeta VALUES("179","147","meta_keywords","");
INSERT INTO wp_postmeta VALUES("180","147","meta_description","");
INSERT INTO wp_postmeta VALUES("181","147","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("182","147","pagebg_color","");
INSERT INTO wp_postmeta VALUES("183","147","pagebg_image","");
INSERT INTO wp_postmeta VALUES("184","147","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("185","147","page_slider","");
INSERT INTO wp_postmeta VALUES("186","147","page_slider_type","");
INSERT INTO wp_postmeta VALUES("187","147","_thumbnail_id","86");
INSERT INTO wp_postmeta VALUES("188","148","_edit_last","1");
INSERT INTO wp_postmeta VALUES("189","148","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("190","148","portfolio_url","");
INSERT INTO wp_postmeta VALUES("191","148","portfolio_date","");
INSERT INTO wp_postmeta VALUES("192","148","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("193","148","portfolio_client","");
INSERT INTO wp_postmeta VALUES("194","148","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("195","148","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("196","148","page_top","");
INSERT INTO wp_postmeta VALUES("197","148","page_bottom","");
INSERT INTO wp_postmeta VALUES("198","148","meta_title","");
INSERT INTO wp_postmeta VALUES("199","148","meta_keywords","");
INSERT INTO wp_postmeta VALUES("200","148","meta_description","");
INSERT INTO wp_postmeta VALUES("201","148","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("202","148","pagebg_color","");
INSERT INTO wp_postmeta VALUES("203","148","pagebg_image","");
INSERT INTO wp_postmeta VALUES("204","148","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("205","148","page_slider","");
INSERT INTO wp_postmeta VALUES("206","148","page_slider_type","");
INSERT INTO wp_postmeta VALUES("207","148","_thumbnail_id","87");
INSERT INTO wp_postmeta VALUES("208","149","_edit_last","1");
INSERT INTO wp_postmeta VALUES("209","149","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("210","149","portfolio_url","");
INSERT INTO wp_postmeta VALUES("211","149","portfolio_date","");
INSERT INTO wp_postmeta VALUES("212","149","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("213","149","portfolio_client","");
INSERT INTO wp_postmeta VALUES("214","149","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("215","149","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("216","149","page_top","");
INSERT INTO wp_postmeta VALUES("217","149","page_bottom","");
INSERT INTO wp_postmeta VALUES("218","149","meta_title","");
INSERT INTO wp_postmeta VALUES("219","149","meta_keywords","");
INSERT INTO wp_postmeta VALUES("220","149","meta_description","");
INSERT INTO wp_postmeta VALUES("221","149","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("222","149","pagebg_color","");
INSERT INTO wp_postmeta VALUES("223","149","pagebg_image","");
INSERT INTO wp_postmeta VALUES("224","149","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("225","149","page_slider","");
INSERT INTO wp_postmeta VALUES("226","149","page_slider_type","");
INSERT INTO wp_postmeta VALUES("227","149","_thumbnail_id","88");
INSERT INTO wp_postmeta VALUES("228","161","_edit_last","1");
INSERT INTO wp_postmeta VALUES("229","161","_thumbnail_id","81");
INSERT INTO wp_postmeta VALUES("230","161","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("231","161","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("232","161","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("233","161","portfolio_url_title","Theme Forest");
INSERT INTO wp_postmeta VALUES("234","161","portfolio_client","");
INSERT INTO wp_postmeta VALUES("235","161","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("236","161","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("237","161","page_top","");
INSERT INTO wp_postmeta VALUES("238","161","page_bottom","");
INSERT INTO wp_postmeta VALUES("239","161","meta_title","");
INSERT INTO wp_postmeta VALUES("240","161","meta_keywords","");
INSERT INTO wp_postmeta VALUES("241","161","meta_description","");
INSERT INTO wp_postmeta VALUES("242","161","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("243","161","pagebg_color","");
INSERT INTO wp_postmeta VALUES("244","161","pagebg_image","");
INSERT INTO wp_postmeta VALUES("245","161","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("246","161","page_slider","");
INSERT INTO wp_postmeta VALUES("247","161","page_slider_type","");
INSERT INTO wp_postmeta VALUES("248","162","_edit_last","1");
INSERT INTO wp_postmeta VALUES("249","162","_thumbnail_id","82");
INSERT INTO wp_postmeta VALUES("250","162","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("251","162","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("252","162","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("253","162","portfolio_url_title","Code Canyon");
INSERT INTO wp_postmeta VALUES("254","162","portfolio_client","");
INSERT INTO wp_postmeta VALUES("255","162","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("256","162","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("257","162","page_top","");
INSERT INTO wp_postmeta VALUES("258","162","page_bottom","");
INSERT INTO wp_postmeta VALUES("259","162","meta_title","");
INSERT INTO wp_postmeta VALUES("260","162","meta_keywords","");
INSERT INTO wp_postmeta VALUES("261","162","meta_description","");
INSERT INTO wp_postmeta VALUES("262","162","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("263","162","pagebg_color","");
INSERT INTO wp_postmeta VALUES("264","162","pagebg_image","");
INSERT INTO wp_postmeta VALUES("265","162","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("266","162","page_slider","");
INSERT INTO wp_postmeta VALUES("267","162","page_slider_type","");
INSERT INTO wp_postmeta VALUES("268","163","_edit_last","1");
INSERT INTO wp_postmeta VALUES("269","163","_thumbnail_id","83");
INSERT INTO wp_postmeta VALUES("270","163","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("271","163","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("272","163","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("273","163","portfolio_url_title","Photo Dune");
INSERT INTO wp_postmeta VALUES("274","163","portfolio_client","");
INSERT INTO wp_postmeta VALUES("275","163","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("276","163","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("277","163","page_top","");
INSERT INTO wp_postmeta VALUES("278","163","page_bottom","");
INSERT INTO wp_postmeta VALUES("279","163","meta_title","");
INSERT INTO wp_postmeta VALUES("280","163","meta_keywords","");
INSERT INTO wp_postmeta VALUES("281","163","meta_description","");
INSERT INTO wp_postmeta VALUES("282","163","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("283","163","pagebg_color","");
INSERT INTO wp_postmeta VALUES("284","163","pagebg_image","");
INSERT INTO wp_postmeta VALUES("285","163","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("286","163","page_slider","");
INSERT INTO wp_postmeta VALUES("287","163","page_slider_type","");
INSERT INTO wp_postmeta VALUES("288","164","_edit_last","1");
INSERT INTO wp_postmeta VALUES("289","164","_thumbnail_id","84");
INSERT INTO wp_postmeta VALUES("290","164","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("291","164","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("292","164","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("293","164","portfolio_url_title","Theme Forest");
INSERT INTO wp_postmeta VALUES("294","164","portfolio_client","");
INSERT INTO wp_postmeta VALUES("295","164","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("296","164","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("297","164","page_top","");
INSERT INTO wp_postmeta VALUES("298","164","page_bottom","");
INSERT INTO wp_postmeta VALUES("299","164","meta_title","");
INSERT INTO wp_postmeta VALUES("300","164","meta_keywords","");
INSERT INTO wp_postmeta VALUES("301","164","meta_description","");
INSERT INTO wp_postmeta VALUES("302","164","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("303","164","pagebg_color","");
INSERT INTO wp_postmeta VALUES("304","164","pagebg_image","");
INSERT INTO wp_postmeta VALUES("305","164","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("306","164","page_slider","");
INSERT INTO wp_postmeta VALUES("307","164","page_slider_type","");
INSERT INTO wp_postmeta VALUES("308","165","_edit_last","1");
INSERT INTO wp_postmeta VALUES("309","165","_thumbnail_id","85");
INSERT INTO wp_postmeta VALUES("310","165","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("311","165","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("312","165","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("313","165","portfolio_url_title","Code Canyon");
INSERT INTO wp_postmeta VALUES("314","165","portfolio_client","");
INSERT INTO wp_postmeta VALUES("315","165","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("316","165","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("317","165","page_top","");
INSERT INTO wp_postmeta VALUES("318","165","page_bottom","");
INSERT INTO wp_postmeta VALUES("319","165","meta_title","");
INSERT INTO wp_postmeta VALUES("320","165","meta_keywords","");
INSERT INTO wp_postmeta VALUES("321","165","meta_description","");
INSERT INTO wp_postmeta VALUES("322","165","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("323","165","pagebg_color","");
INSERT INTO wp_postmeta VALUES("324","165","pagebg_image","");
INSERT INTO wp_postmeta VALUES("325","165","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("326","165","page_slider","");
INSERT INTO wp_postmeta VALUES("327","165","page_slider_type","");
INSERT INTO wp_postmeta VALUES("328","166","_edit_last","1");
INSERT INTO wp_postmeta VALUES("329","166","_thumbnail_id","86");
INSERT INTO wp_postmeta VALUES("330","166","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("331","166","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("332","166","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("333","166","portfolio_url_title","Photo Dune");
INSERT INTO wp_postmeta VALUES("334","166","portfolio_client","");
INSERT INTO wp_postmeta VALUES("335","166","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("336","166","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("337","166","page_top","");
INSERT INTO wp_postmeta VALUES("338","166","page_bottom","");
INSERT INTO wp_postmeta VALUES("339","166","meta_title","");
INSERT INTO wp_postmeta VALUES("340","166","meta_keywords","");
INSERT INTO wp_postmeta VALUES("341","166","meta_description","");
INSERT INTO wp_postmeta VALUES("342","166","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("343","166","pagebg_color","");
INSERT INTO wp_postmeta VALUES("344","166","pagebg_image","");
INSERT INTO wp_postmeta VALUES("345","166","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("346","166","page_slider","");
INSERT INTO wp_postmeta VALUES("347","166","page_slider_type","");
INSERT INTO wp_postmeta VALUES("348","167","_edit_last","1");
INSERT INTO wp_postmeta VALUES("349","167","_thumbnail_id","87");
INSERT INTO wp_postmeta VALUES("350","167","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("351","167","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("352","167","portfolio_date","10/10/2012");
INSERT INTO wp_postmeta VALUES("353","167","portfolio_url_title","Theme Forest");
INSERT INTO wp_postmeta VALUES("354","167","portfolio_client","");
INSERT INTO wp_postmeta VALUES("355","167","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("356","167","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("357","167","page_top","");
INSERT INTO wp_postmeta VALUES("358","167","page_bottom","");
INSERT INTO wp_postmeta VALUES("359","167","meta_title","");
INSERT INTO wp_postmeta VALUES("360","167","meta_keywords","");
INSERT INTO wp_postmeta VALUES("361","167","meta_description","");
INSERT INTO wp_postmeta VALUES("362","167","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("363","167","pagebg_color","");
INSERT INTO wp_postmeta VALUES("364","167","pagebg_image","");
INSERT INTO wp_postmeta VALUES("365","167","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("366","167","page_slider","");
INSERT INTO wp_postmeta VALUES("367","167","page_slider_type","");
INSERT INTO wp_postmeta VALUES("368","168","_edit_last","1");
INSERT INTO wp_postmeta VALUES("369","168","_thumbnail_id","88");
INSERT INTO wp_postmeta VALUES("370","168","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("371","168","portfolio_url","http://themeforest.net");
INSERT INTO wp_postmeta VALUES("372","168","portfolio_date","10/12/2012");
INSERT INTO wp_postmeta VALUES("373","168","portfolio_url_title","Code Canyon");
INSERT INTO wp_postmeta VALUES("374","168","portfolio_client","");
INSERT INTO wp_postmeta VALUES("375","168","portfolio_tools","dreamweaver, adobe photoshop");
INSERT INTO wp_postmeta VALUES("376","168","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("377","168","page_top","");
INSERT INTO wp_postmeta VALUES("378","168","page_bottom","");
INSERT INTO wp_postmeta VALUES("379","168","meta_title","");
INSERT INTO wp_postmeta VALUES("380","168","meta_keywords","");
INSERT INTO wp_postmeta VALUES("381","168","meta_description","");
INSERT INTO wp_postmeta VALUES("382","168","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("383","168","pagebg_color","");
INSERT INTO wp_postmeta VALUES("384","168","pagebg_image","");
INSERT INTO wp_postmeta VALUES("385","168","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("386","168","page_slider","");
INSERT INTO wp_postmeta VALUES("387","168","page_slider_type","");
INSERT INTO wp_postmeta VALUES("388","202","_wp_attached_file","2012/08/no_avatar.png");
INSERT INTO wp_postmeta VALUES("389","202","_wp_attachment_metadata","a:5:{s:5:\"width\";i:122;s:6:\"height\";i:122;s:4:\"file\";s:21:\"2012/08/no_avatar.png\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"no_avatar-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("390","203","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("391","203","_edit_last","1");
INSERT INTO wp_postmeta VALUES("392","204","_edit_last","1");
INSERT INTO wp_postmeta VALUES("393","204","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("394","204","portfolio_url","");
INSERT INTO wp_postmeta VALUES("395","204","portfolio_date","");
INSERT INTO wp_postmeta VALUES("396","204","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("397","204","portfolio_client","");
INSERT INTO wp_postmeta VALUES("398","204","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("399","204","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("400","204","page_top","");
INSERT INTO wp_postmeta VALUES("401","204","page_bottom","");
INSERT INTO wp_postmeta VALUES("402","204","meta_title","");
INSERT INTO wp_postmeta VALUES("403","204","meta_keywords","");
INSERT INTO wp_postmeta VALUES("404","204","meta_description","");
INSERT INTO wp_postmeta VALUES("405","204","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("406","204","pagebg_color","");
INSERT INTO wp_postmeta VALUES("407","204","pagebg_image","");
INSERT INTO wp_postmeta VALUES("408","204","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("409","204","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("410","204","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("411","204","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("464","14","_edit_last","1");
INSERT INTO wp_postmeta VALUES("465","14","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("466","14","portfolio_url","");
INSERT INTO wp_postmeta VALUES("467","14","portfolio_date","");
INSERT INTO wp_postmeta VALUES("468","14","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("469","14","portfolio_client","");
INSERT INTO wp_postmeta VALUES("470","14","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("471","14","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("472","14","page_top","");
INSERT INTO wp_postmeta VALUES("473","14","page_bottom","");
INSERT INTO wp_postmeta VALUES("474","14","meta_title","Rama Slider Title");
INSERT INTO wp_postmeta VALUES("475","14","meta_keywords","rama, slider, keywords");
INSERT INTO wp_postmeta VALUES("476","14","meta_description","Rama slider description here");
INSERT INTO wp_postmeta VALUES("477","14","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("478","14","pagebg_color","");
INSERT INTO wp_postmeta VALUES("479","14","pagebg_image","");
INSERT INTO wp_postmeta VALUES("480","14","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("481","14","page_slider","");
INSERT INTO wp_postmeta VALUES("482","14","page_slider_type","rama");
INSERT INTO wp_postmeta VALUES("483","14","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("484","16","_edit_last","1");
INSERT INTO wp_postmeta VALUES("485","16","_thumbnail_id","8");
INSERT INTO wp_postmeta VALUES("486","16","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("487","16","portfolio_url","");
INSERT INTO wp_postmeta VALUES("488","16","portfolio_date","");
INSERT INTO wp_postmeta VALUES("489","16","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("490","16","portfolio_client","");
INSERT INTO wp_postmeta VALUES("491","16","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("492","16","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("493","16","page_top","");
INSERT INTO wp_postmeta VALUES("494","16","page_bottom","");
INSERT INTO wp_postmeta VALUES("495","16","meta_title","Mosaic Slider Title");
INSERT INTO wp_postmeta VALUES("496","16","meta_keywords","mosaic, slider, keywords");
INSERT INTO wp_postmeta VALUES("497","16","meta_description","Mosaic slider description");
INSERT INTO wp_postmeta VALUES("498","16","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("499","16","pagebg_color","");
INSERT INTO wp_postmeta VALUES("500","16","pagebg_image","");
INSERT INTO wp_postmeta VALUES("501","16","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("502","16","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("503","16","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("504","16","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("505","72","_edit_last","1");
INSERT INTO wp_postmeta VALUES("506","72","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("507","72","portfolio_url","");
INSERT INTO wp_postmeta VALUES("508","72","portfolio_date","");
INSERT INTO wp_postmeta VALUES("509","72","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("510","72","portfolio_client","");
INSERT INTO wp_postmeta VALUES("511","72","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("512","72","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("513","72","page_top","");
INSERT INTO wp_postmeta VALUES("514","72","page_bottom","");
INSERT INTO wp_postmeta VALUES("515","72","meta_title","");
INSERT INTO wp_postmeta VALUES("516","72","meta_keywords","");
INSERT INTO wp_postmeta VALUES("517","72","meta_description","");
INSERT INTO wp_postmeta VALUES("518","72","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("519","72","pagebg_color","");
INSERT INTO wp_postmeta VALUES("520","72","pagebg_image","");
INSERT INTO wp_postmeta VALUES("521","72","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("522","72","page_slider","");
INSERT INTO wp_postmeta VALUES("523","72","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("524","72","_wp_page_template","template-blog.php");
INSERT INTO wp_postmeta VALUES("525","130","_edit_last","1");
INSERT INTO wp_postmeta VALUES("526","130","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("527","130","portfolio_url","");
INSERT INTO wp_postmeta VALUES("528","130","portfolio_date","");
INSERT INTO wp_postmeta VALUES("529","130","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("530","130","portfolio_client","");
INSERT INTO wp_postmeta VALUES("531","130","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("532","130","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("533","130","page_top","");
INSERT INTO wp_postmeta VALUES("534","130","page_bottom","");
INSERT INTO wp_postmeta VALUES("535","130","meta_title","");
INSERT INTO wp_postmeta VALUES("536","130","meta_keywords","");
INSERT INTO wp_postmeta VALUES("537","130","meta_description","");
INSERT INTO wp_postmeta VALUES("538","130","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("539","130","pagebg_color","");
INSERT INTO wp_postmeta VALUES("540","130","pagebg_image","");
INSERT INTO wp_postmeta VALUES("541","130","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("542","130","page_slider","");
INSERT INTO wp_postmeta VALUES("543","130","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("544","130","_wp_page_template","template-blog-alternate.php");
INSERT INTO wp_postmeta VALUES("545","139","_edit_last","1");
INSERT INTO wp_postmeta VALUES("546","139","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("547","139","portfolio_url","");
INSERT INTO wp_postmeta VALUES("548","139","portfolio_date","");
INSERT INTO wp_postmeta VALUES("549","139","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("550","139","portfolio_client","");
INSERT INTO wp_postmeta VALUES("551","139","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("552","139","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("553","139","page_top","");
INSERT INTO wp_postmeta VALUES("554","139","page_bottom","");
INSERT INTO wp_postmeta VALUES("555","139","meta_title","");
INSERT INTO wp_postmeta VALUES("556","139","meta_keywords","");
INSERT INTO wp_postmeta VALUES("557","139","meta_description","");
INSERT INTO wp_postmeta VALUES("558","139","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("559","139","pagebg_color","");
INSERT INTO wp_postmeta VALUES("560","139","pagebg_image","");
INSERT INTO wp_postmeta VALUES("561","139","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("562","139","page_slider","");
INSERT INTO wp_postmeta VALUES("563","139","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("564","139","_wp_page_template","template-gallery.php");
INSERT INTO wp_postmeta VALUES("565","151","_edit_last","1");
INSERT INTO wp_postmeta VALUES("566","151","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("567","151","portfolio_url","");
INSERT INTO wp_postmeta VALUES("568","151","portfolio_date","");
INSERT INTO wp_postmeta VALUES("569","151","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("570","151","portfolio_client","");
INSERT INTO wp_postmeta VALUES("571","151","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("572","151","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("573","151","page_top","");
INSERT INTO wp_postmeta VALUES("574","151","page_bottom","");
INSERT INTO wp_postmeta VALUES("575","151","meta_title","");
INSERT INTO wp_postmeta VALUES("576","151","meta_keywords","");
INSERT INTO wp_postmeta VALUES("577","151","meta_description","");
INSERT INTO wp_postmeta VALUES("578","151","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("579","151","pagebg_color","");
INSERT INTO wp_postmeta VALUES("580","151","pagebg_image","");
INSERT INTO wp_postmeta VALUES("581","151","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("582","151","page_slider","");
INSERT INTO wp_postmeta VALUES("583","151","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("584","151","_wp_page_template","template-portfolio-1.php");
INSERT INTO wp_postmeta VALUES("585","153","_edit_last","1");
INSERT INTO wp_postmeta VALUES("586","153","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("587","153","portfolio_url","");
INSERT INTO wp_postmeta VALUES("588","153","portfolio_date","");
INSERT INTO wp_postmeta VALUES("589","153","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("590","153","portfolio_client","");
INSERT INTO wp_postmeta VALUES("591","153","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("592","153","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("593","153","page_top","");
INSERT INTO wp_postmeta VALUES("594","153","page_bottom","");
INSERT INTO wp_postmeta VALUES("595","153","meta_title","");
INSERT INTO wp_postmeta VALUES("596","153","meta_keywords","");
INSERT INTO wp_postmeta VALUES("597","153","meta_description","");
INSERT INTO wp_postmeta VALUES("598","153","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("599","153","pagebg_color","");
INSERT INTO wp_postmeta VALUES("600","153","pagebg_image","");
INSERT INTO wp_postmeta VALUES("601","153","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("602","153","page_slider","");
INSERT INTO wp_postmeta VALUES("603","153","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("604","153","_wp_page_template","template-portfolio-2.php");
INSERT INTO wp_postmeta VALUES("605","155","_edit_last","1");
INSERT INTO wp_postmeta VALUES("606","155","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("607","155","portfolio_url","");
INSERT INTO wp_postmeta VALUES("608","155","portfolio_date","");
INSERT INTO wp_postmeta VALUES("609","155","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("610","155","portfolio_client","");
INSERT INTO wp_postmeta VALUES("611","155","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("612","155","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("613","155","page_top","");
INSERT INTO wp_postmeta VALUES("614","155","page_bottom","");
INSERT INTO wp_postmeta VALUES("615","155","meta_title","");
INSERT INTO wp_postmeta VALUES("616","155","meta_keywords","");
INSERT INTO wp_postmeta VALUES("617","155","meta_description","");
INSERT INTO wp_postmeta VALUES("618","155","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("619","155","pagebg_color","");
INSERT INTO wp_postmeta VALUES("620","155","pagebg_image","");
INSERT INTO wp_postmeta VALUES("621","155","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("622","155","page_slider","");
INSERT INTO wp_postmeta VALUES("623","155","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("624","155","_wp_page_template","template-portfolio-3.php");
INSERT INTO wp_postmeta VALUES("625","169","_edit_last","1");
INSERT INTO wp_postmeta VALUES("626","169","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("627","169","portfolio_url","");
INSERT INTO wp_postmeta VALUES("628","169","portfolio_date","");
INSERT INTO wp_postmeta VALUES("629","169","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("630","169","portfolio_client","");
INSERT INTO wp_postmeta VALUES("631","169","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("632","169","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("633","169","page_top","");
INSERT INTO wp_postmeta VALUES("634","169","page_bottom","");
INSERT INTO wp_postmeta VALUES("635","169","meta_title","");
INSERT INTO wp_postmeta VALUES("636","169","meta_keywords","");
INSERT INTO wp_postmeta VALUES("637","169","meta_description","");
INSERT INTO wp_postmeta VALUES("638","169","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("639","169","pagebg_color","");
INSERT INTO wp_postmeta VALUES("640","169","pagebg_image","");
INSERT INTO wp_postmeta VALUES("641","169","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("642","169","page_slider","");
INSERT INTO wp_postmeta VALUES("643","169","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("644","169","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("665","209","_edit_last","1");
INSERT INTO wp_postmeta VALUES("666","209","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("667","209","portfolio_url","");
INSERT INTO wp_postmeta VALUES("668","209","portfolio_date","");
INSERT INTO wp_postmeta VALUES("669","209","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("670","209","portfolio_client","");
INSERT INTO wp_postmeta VALUES("671","209","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("672","209","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("673","209","page_top","");
INSERT INTO wp_postmeta VALUES("674","209","page_bottom"," [one_third]\r\n\r\n[columnpost post_id=\"70\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost]\r\n\r\n[/one_third] [one_third]\r\n\r\n[columnpost post_id=\"68\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost]\r\n\r\n[/one_third] [one_third_last]\r\n\r\n[columnpost post_id=\"66\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost]\r\n\r\n[/one_third_last] ");
INSERT INTO wp_postmeta VALUES("675","209","meta_title","");
INSERT INTO wp_postmeta VALUES("676","209","meta_keywords","");
INSERT INTO wp_postmeta VALUES("677","209","meta_description","");
INSERT INTO wp_postmeta VALUES("678","209","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("679","209","pagebg_color","");
INSERT INTO wp_postmeta VALUES("680","209","pagebg_image","");
INSERT INTO wp_postmeta VALUES("681","209","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("682","209","page_slider","");
INSERT INTO wp_postmeta VALUES("683","209","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("684","209","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("685","217","_edit_last","1");
INSERT INTO wp_postmeta VALUES("686","217","portfolio_date","");
INSERT INTO wp_postmeta VALUES("687","217","portfolio_url","");
INSERT INTO wp_postmeta VALUES("688","217","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("689","217","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("690","217","portfolio_client","");
INSERT INTO wp_postmeta VALUES("691","217","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("692","217","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("693","217","page_top","");
INSERT INTO wp_postmeta VALUES("694","217","page_bottom","");
INSERT INTO wp_postmeta VALUES("695","217","meta_title","");
INSERT INTO wp_postmeta VALUES("696","217","meta_keywords","");
INSERT INTO wp_postmeta VALUES("697","217","meta_description","");
INSERT INTO wp_postmeta VALUES("698","217","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("699","217","pagebg_color","");
INSERT INTO wp_postmeta VALUES("700","217","pagebg_image","");
INSERT INTO wp_postmeta VALUES("701","217","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("702","217","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("703","217","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("704","217","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("705","219","_edit_last","1");
INSERT INTO wp_postmeta VALUES("706","219","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("707","219","portfolio_url","");
INSERT INTO wp_postmeta VALUES("708","219","portfolio_date","");
INSERT INTO wp_postmeta VALUES("709","219","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("710","219","portfolio_client","");
INSERT INTO wp_postmeta VALUES("711","219","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("712","219","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("713","219","page_top","");
INSERT INTO wp_postmeta VALUES("714","219","page_bottom","");
INSERT INTO wp_postmeta VALUES("715","219","meta_title","");
INSERT INTO wp_postmeta VALUES("716","219","meta_keywords","");
INSERT INTO wp_postmeta VALUES("717","219","meta_description","");
INSERT INTO wp_postmeta VALUES("718","219","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("719","219","pagebg_color","");
INSERT INTO wp_postmeta VALUES("720","219","pagebg_image","");
INSERT INTO wp_postmeta VALUES("721","219","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("722","219","page_slider","");
INSERT INTO wp_postmeta VALUES("723","219","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("724","219","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("725","222","_edit_last","1");
INSERT INTO wp_postmeta VALUES("726","222","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("727","222","portfolio_url","");
INSERT INTO wp_postmeta VALUES("728","222","portfolio_date","");
INSERT INTO wp_postmeta VALUES("729","222","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("730","222","portfolio_client","");
INSERT INTO wp_postmeta VALUES("731","222","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("732","222","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("733","222","page_top","");
INSERT INTO wp_postmeta VALUES("734","222","page_bottom","");
INSERT INTO wp_postmeta VALUES("735","222","meta_title","");
INSERT INTO wp_postmeta VALUES("736","222","meta_keywords","");
INSERT INTO wp_postmeta VALUES("737","222","meta_description","");
INSERT INTO wp_postmeta VALUES("738","222","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("739","222","pagebg_color","");
INSERT INTO wp_postmeta VALUES("740","222","pagebg_image","");
INSERT INTO wp_postmeta VALUES("741","222","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("742","222","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("743","222","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("744","222","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("745","224","_edit_last","1");
INSERT INTO wp_postmeta VALUES("746","224","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("747","224","portfolio_url","");
INSERT INTO wp_postmeta VALUES("748","224","portfolio_date","");
INSERT INTO wp_postmeta VALUES("749","224","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("750","224","portfolio_client","");
INSERT INTO wp_postmeta VALUES("751","224","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("752","224","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("753","224","page_top","");
INSERT INTO wp_postmeta VALUES("754","224","page_bottom","");
INSERT INTO wp_postmeta VALUES("755","224","meta_title","");
INSERT INTO wp_postmeta VALUES("756","224","meta_keywords","");
INSERT INTO wp_postmeta VALUES("757","224","meta_description","");
INSERT INTO wp_postmeta VALUES("758","224","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("759","224","pagebg_color","");
INSERT INTO wp_postmeta VALUES("760","224","pagebg_image","");
INSERT INTO wp_postmeta VALUES("761","224","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("762","224","page_slider","");
INSERT INTO wp_postmeta VALUES("763","224","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("764","224","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("765","226","_edit_last","1");
INSERT INTO wp_postmeta VALUES("766","226","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("767","226","portfolio_url","");
INSERT INTO wp_postmeta VALUES("768","226","portfolio_date","");
INSERT INTO wp_postmeta VALUES("769","226","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("770","226","portfolio_client","");
INSERT INTO wp_postmeta VALUES("771","226","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("772","226","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("773","226","page_top","");
INSERT INTO wp_postmeta VALUES("774","226","page_bottom","");
INSERT INTO wp_postmeta VALUES("775","226","meta_title","");
INSERT INTO wp_postmeta VALUES("776","226","meta_keywords","");
INSERT INTO wp_postmeta VALUES("777","226","meta_description","");
INSERT INTO wp_postmeta VALUES("778","226","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("779","226","pagebg_color","");
INSERT INTO wp_postmeta VALUES("780","226","pagebg_image","");
INSERT INTO wp_postmeta VALUES("781","226","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("782","226","page_slider","");
INSERT INTO wp_postmeta VALUES("783","226","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("784","226","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("785","228","_edit_last","1");
INSERT INTO wp_postmeta VALUES("786","228","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("787","228","portfolio_url","");
INSERT INTO wp_postmeta VALUES("788","228","portfolio_date","");
INSERT INTO wp_postmeta VALUES("789","228","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("790","228","portfolio_client","");
INSERT INTO wp_postmeta VALUES("791","228","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("792","228","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("793","228","page_top","");
INSERT INTO wp_postmeta VALUES("794","228","page_bottom","");
INSERT INTO wp_postmeta VALUES("795","228","meta_title","");
INSERT INTO wp_postmeta VALUES("796","228","meta_keywords","");
INSERT INTO wp_postmeta VALUES("797","228","meta_description","");
INSERT INTO wp_postmeta VALUES("798","228","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("799","228","pagebg_color","");
INSERT INTO wp_postmeta VALUES("800","228","pagebg_image","");
INSERT INTO wp_postmeta VALUES("801","228","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("802","228","page_slider","");
INSERT INTO wp_postmeta VALUES("803","228","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("804","228","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("805","230","_edit_last","1");
INSERT INTO wp_postmeta VALUES("806","230","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("807","230","portfolio_url","");
INSERT INTO wp_postmeta VALUES("808","230","portfolio_date","");
INSERT INTO wp_postmeta VALUES("809","230","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("810","230","portfolio_client","");
INSERT INTO wp_postmeta VALUES("811","230","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("812","230","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("813","230","page_top","");
INSERT INTO wp_postmeta VALUES("814","230","page_bottom","");
INSERT INTO wp_postmeta VALUES("815","230","meta_title","");
INSERT INTO wp_postmeta VALUES("816","230","meta_keywords","");
INSERT INTO wp_postmeta VALUES("817","230","meta_description","");
INSERT INTO wp_postmeta VALUES("818","230","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("819","230","pagebg_color","");
INSERT INTO wp_postmeta VALUES("820","230","pagebg_image","");
INSERT INTO wp_postmeta VALUES("821","230","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("822","230","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("823","230","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("824","230","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("825","232","_edit_last","1");
INSERT INTO wp_postmeta VALUES("826","232","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("827","232","portfolio_url","");
INSERT INTO wp_postmeta VALUES("828","232","portfolio_date","");
INSERT INTO wp_postmeta VALUES("829","232","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("830","232","portfolio_client","");
INSERT INTO wp_postmeta VALUES("831","232","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("832","232","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("833","232","page_top","");
INSERT INTO wp_postmeta VALUES("834","232","page_bottom","");
INSERT INTO wp_postmeta VALUES("835","232","meta_title","");
INSERT INTO wp_postmeta VALUES("836","232","meta_keywords","");
INSERT INTO wp_postmeta VALUES("837","232","meta_description","");
INSERT INTO wp_postmeta VALUES("838","232","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("839","232","pagebg_color","");
INSERT INTO wp_postmeta VALUES("840","232","pagebg_image","");
INSERT INTO wp_postmeta VALUES("841","232","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("842","232","page_slider","");
INSERT INTO wp_postmeta VALUES("843","232","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("844","232","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("845","234","_edit_last","1");
INSERT INTO wp_postmeta VALUES("846","234","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("847","234","portfolio_url","");
INSERT INTO wp_postmeta VALUES("848","234","portfolio_date","");
INSERT INTO wp_postmeta VALUES("849","234","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("850","234","portfolio_client","");
INSERT INTO wp_postmeta VALUES("851","234","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("852","234","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("853","234","page_top","");
INSERT INTO wp_postmeta VALUES("854","234","page_bottom","");
INSERT INTO wp_postmeta VALUES("855","234","meta_title","");
INSERT INTO wp_postmeta VALUES("856","234","meta_keywords","");
INSERT INTO wp_postmeta VALUES("857","234","meta_description","");
INSERT INTO wp_postmeta VALUES("858","234","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("859","234","pagebg_color","");
INSERT INTO wp_postmeta VALUES("860","234","pagebg_image","");
INSERT INTO wp_postmeta VALUES("861","234","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("862","234","page_slider","");
INSERT INTO wp_postmeta VALUES("863","234","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("864","234","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("865","235","_edit_last","1");
INSERT INTO wp_postmeta VALUES("876","235","_thumbnail_id","88");
INSERT INTO wp_postmeta VALUES("877","42","_edit_last","1");
INSERT INTO wp_postmeta VALUES("878","42","_thumbnail_id","6");
INSERT INTO wp_postmeta VALUES("879","42","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("880","42","portfolio_url","");
INSERT INTO wp_postmeta VALUES("881","42","portfolio_date","");
INSERT INTO wp_postmeta VALUES("882","42","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("883","42","portfolio_client","");
INSERT INTO wp_postmeta VALUES("884","42","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("885","42","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("886","42","page_top","");
INSERT INTO wp_postmeta VALUES("887","42","page_bottom","");
INSERT INTO wp_postmeta VALUES("888","42","meta_title","");
INSERT INTO wp_postmeta VALUES("889","42","meta_keywords","");
INSERT INTO wp_postmeta VALUES("890","42","meta_description","");
INSERT INTO wp_postmeta VALUES("891","42","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("892","42","pagebg_color","");
INSERT INTO wp_postmeta VALUES("893","42","pagebg_image","");
INSERT INTO wp_postmeta VALUES("894","42","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("895","42","page_slider","");
INSERT INTO wp_postmeta VALUES("896","42","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("925","54","_edit_last","1");
INSERT INTO wp_postmeta VALUES("926","54","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("927","54","portfolio_url","");
INSERT INTO wp_postmeta VALUES("928","54","portfolio_date","");
INSERT INTO wp_postmeta VALUES("929","54","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("930","54","portfolio_client","");
INSERT INTO wp_postmeta VALUES("931","54","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("932","54","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("933","54","page_top","");
INSERT INTO wp_postmeta VALUES("934","54","page_bottom","");
INSERT INTO wp_postmeta VALUES("935","54","meta_title","");
INSERT INTO wp_postmeta VALUES("936","54","meta_keywords","");
INSERT INTO wp_postmeta VALUES("937","54","meta_description","");
INSERT INTO wp_postmeta VALUES("938","54","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("939","54","pagebg_color","");
INSERT INTO wp_postmeta VALUES("940","54","pagebg_image","");
INSERT INTO wp_postmeta VALUES("941","54","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("942","54","page_slider","");
INSERT INTO wp_postmeta VALUES("943","54","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("946","54","_thumbnail_id","7");
INSERT INTO wp_postmeta VALUES("949","54","_wp_old_slug","2");
INSERT INTO wp_postmeta VALUES("958","56","_edit_last","1");
INSERT INTO wp_postmeta VALUES("959","56","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("960","56","portfolio_url","");
INSERT INTO wp_postmeta VALUES("961","56","portfolio_date","");
INSERT INTO wp_postmeta VALUES("962","56","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("963","56","portfolio_client","");
INSERT INTO wp_postmeta VALUES("964","56","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("965","56","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("966","56","page_top","");
INSERT INTO wp_postmeta VALUES("967","56","page_bottom","");
INSERT INTO wp_postmeta VALUES("968","56","meta_title","");
INSERT INTO wp_postmeta VALUES("969","56","meta_keywords","");
INSERT INTO wp_postmeta VALUES("970","56","meta_description","");
INSERT INTO wp_postmeta VALUES("971","56","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("972","56","pagebg_color","");
INSERT INTO wp_postmeta VALUES("973","56","pagebg_image","");
INSERT INTO wp_postmeta VALUES("974","56","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("975","56","page_slider","");
INSERT INTO wp_postmeta VALUES("976","56","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("979","56","_thumbnail_id","8");
INSERT INTO wp_postmeta VALUES("982","56","_wp_old_slug","3");
INSERT INTO wp_postmeta VALUES("991","58","_edit_last","1");
INSERT INTO wp_postmeta VALUES("992","58","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("993","58","portfolio_url","");
INSERT INTO wp_postmeta VALUES("994","58","portfolio_date","");
INSERT INTO wp_postmeta VALUES("995","58","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("996","58","portfolio_client","");
INSERT INTO wp_postmeta VALUES("997","58","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("998","58","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("999","58","page_top","");
INSERT INTO wp_postmeta VALUES("1000","58","page_bottom","");
INSERT INTO wp_postmeta VALUES("1001","58","meta_title","");
INSERT INTO wp_postmeta VALUES("1002","58","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1003","58","meta_description","");
INSERT INTO wp_postmeta VALUES("1004","58","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1005","58","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1006","58","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1007","58","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1008","58","page_slider","");
INSERT INTO wp_postmeta VALUES("1009","58","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1012","58","_thumbnail_id","9");
INSERT INTO wp_postmeta VALUES("1015","58","_wp_old_slug","4");
INSERT INTO wp_postmeta VALUES("1024","60","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1025","60","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1026","60","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1027","60","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1028","60","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1029","60","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1030","60","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1031","60","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1032","60","page_top","");
INSERT INTO wp_postmeta VALUES("1033","60","page_bottom","");
INSERT INTO wp_postmeta VALUES("1034","60","meta_title","");
INSERT INTO wp_postmeta VALUES("1035","60","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1036","60","meta_description","");
INSERT INTO wp_postmeta VALUES("1037","60","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1038","60","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1039","60","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1040","60","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1041","60","page_slider","");
INSERT INTO wp_postmeta VALUES("1042","60","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1045","60","_thumbnail_id","10");
INSERT INTO wp_postmeta VALUES("1048","60","_wp_old_slug","5");
INSERT INTO wp_postmeta VALUES("1055","62","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1056","62","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1057","62","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1058","62","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1059","62","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1060","62","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1061","62","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1062","62","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1063","62","page_top","");
INSERT INTO wp_postmeta VALUES("1064","62","page_bottom","");
INSERT INTO wp_postmeta VALUES("1065","62","meta_title","");
INSERT INTO wp_postmeta VALUES("1066","62","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1067","62","meta_description","");
INSERT INTO wp_postmeta VALUES("1068","62","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1069","62","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1070","62","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1071","62","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1072","62","page_slider","");
INSERT INTO wp_postmeta VALUES("1073","62","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1076","62","_thumbnail_id","29");
INSERT INTO wp_postmeta VALUES("1079","62","_wp_old_slug","6");
INSERT INTO wp_postmeta VALUES("1086","64","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1087","64","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1088","64","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1089","64","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1090","64","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1091","64","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1092","64","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1093","64","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1094","64","page_top","");
INSERT INTO wp_postmeta VALUES("1095","64","page_bottom","");
INSERT INTO wp_postmeta VALUES("1096","64","meta_title","");
INSERT INTO wp_postmeta VALUES("1097","64","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1098","64","meta_description","");
INSERT INTO wp_postmeta VALUES("1099","64","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1100","64","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1101","64","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1102","64","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1103","64","page_slider","");
INSERT INTO wp_postmeta VALUES("1104","64","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1107","64","_thumbnail_id","30");
INSERT INTO wp_postmeta VALUES("1110","64","_wp_old_slug","7");
INSERT INTO wp_postmeta VALUES("1117","66","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1118","66","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1119","66","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1120","66","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1121","66","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1122","66","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1123","66","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1124","66","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1125","66","page_top","");
INSERT INTO wp_postmeta VALUES("1126","66","page_bottom","");
INSERT INTO wp_postmeta VALUES("1127","66","meta_title","");
INSERT INTO wp_postmeta VALUES("1128","66","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1129","66","meta_description","");
INSERT INTO wp_postmeta VALUES("1130","66","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1131","66","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1132","66","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1133","66","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1134","66","page_slider","");
INSERT INTO wp_postmeta VALUES("1135","66","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1138","66","_thumbnail_id","84");
INSERT INTO wp_postmeta VALUES("1141","66","_wp_old_slug","8");
INSERT INTO wp_postmeta VALUES("1150","68","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1151","68","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1152","68","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1153","68","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1154","68","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1155","68","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1156","68","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1157","68","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1158","68","page_top","");
INSERT INTO wp_postmeta VALUES("1159","68","page_bottom","");
INSERT INTO wp_postmeta VALUES("1160","68","meta_title","");
INSERT INTO wp_postmeta VALUES("1161","68","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1162","68","meta_description","");
INSERT INTO wp_postmeta VALUES("1163","68","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1164","68","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1165","68","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1166","68","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1167","68","page_slider","");
INSERT INTO wp_postmeta VALUES("1168","68","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1171","68","_thumbnail_id","86");
INSERT INTO wp_postmeta VALUES("1174","68","_wp_old_slug","9");
INSERT INTO wp_postmeta VALUES("1179","70","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1180","70","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1181","70","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1182","70","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1183","70","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1184","70","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1185","70","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1186","70","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1187","70","page_top","");
INSERT INTO wp_postmeta VALUES("1188","70","page_bottom","");
INSERT INTO wp_postmeta VALUES("1189","70","meta_title","");
INSERT INTO wp_postmeta VALUES("1190","70","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1191","70","meta_description","");
INSERT INTO wp_postmeta VALUES("1192","70","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1193","70","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1194","70","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1195","70","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1196","70","page_slider","");
INSERT INTO wp_postmeta VALUES("1197","70","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1200","70","_thumbnail_id","88");
INSERT INTO wp_postmeta VALUES("1203","70","_wp_old_slug","10");
INSERT INTO wp_postmeta VALUES("1208","135","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1209","136","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1210","137","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1211","290","page_top","");
INSERT INTO wp_postmeta VALUES("1212","290","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1213","290","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1214","290","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1215","290","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1216","290","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1217","290","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1218","290","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1219","290","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1220","290","page_bottom","");
INSERT INTO wp_postmeta VALUES("1221","290","meta_title","");
INSERT INTO wp_postmeta VALUES("1222","290","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1223","290","meta_description","");
INSERT INTO wp_postmeta VALUES("1224","290","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1225","290","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1226","290","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1227","290","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1228","290","page_slider","");
INSERT INTO wp_postmeta VALUES("1229","290","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1230","290","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1231","310","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1232","310","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1233","310","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1234","310","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1235","310","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1236","310","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1237","310","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1238","310","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1239","310","page_top","");
INSERT INTO wp_postmeta VALUES("1240","310","page_bottom","");
INSERT INTO wp_postmeta VALUES("1241","310","meta_title","");
INSERT INTO wp_postmeta VALUES("1242","310","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1243","310","meta_description","");
INSERT INTO wp_postmeta VALUES("1244","310","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1245","310","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1246","310","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1247","310","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1248","310","page_slider","");
INSERT INTO wp_postmeta VALUES("1249","310","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1250","310","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1371","326","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1372","326","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1373","326","_menu_item_object_id","169");
INSERT INTO wp_postmeta VALUES("1374","326","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1375","326","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1376","326","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1377","326","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1378","326","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1522","355","_wp_attached_file","2014/04/BTA-Logo.png");
INSERT INTO wp_postmeta VALUES("1523","355","_wp_attachment_metadata","a:5:{s:5:\"width\";i:240;s:6:\"height\";i:176;s:4:\"file\";s:20:\"2014/04/BTA-Logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"BTA-Logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:18:\"BTA-Logo-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1535","204","_edit_lock","1416921714:1");
INSERT INTO wp_postmeta VALUES("1545","359","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1546","359","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1547","359","_menu_item_object_id","204");
INSERT INTO wp_postmeta VALUES("1548","359","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1549","359","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1550","359","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1551","359","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1552","359","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1554","204","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1555","141","_edit_lock","1397741811:1");
INSERT INTO wp_postmeta VALUES("1556","371","_wp_attached_file","2014/04/HR.jpg");
INSERT INTO wp_postmeta VALUES("1557","371","_wp_attachment_metadata","a:5:{s:5:\"width\";i:670;s:6:\"height\";i:360;s:4:\"file\";s:14:\"2014/04/HR.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"HR-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"HR-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:12:\"HR-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1558","372","_wp_attached_file","2014/04/human_resources.jpg");
INSERT INTO wp_postmeta VALUES("1559","372","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:27:\"2014/04/human_resources.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"human_resources-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"human_resources-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:25:\"human_resources-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:11;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:22:\"Canon EOS-1Ds Mark III\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1310467418;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"100\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:16:\"0.00555555555556\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1560","376","_wp_attached_file","2014/04/BTA-Logo1.png");
INSERT INTO wp_postmeta VALUES("1561","376","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:147;s:4:\"file\";s:21:\"2014/04/BTA-Logo1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"BTA-Logo1-150x147.png\";s:5:\"width\";i:150;s:6:\"height\";i:147;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"BTA-Logo1-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1563","209","_edit_lock","1412059114:1");
INSERT INTO wp_postmeta VALUES("1565","137","_edit_lock","1412333347:1");
INSERT INTO wp_postmeta VALUES("1566","2","_edit_lock","1412080415:1");
INSERT INTO wp_postmeta VALUES("1567","2","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1568","2","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1569","2","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1570","2","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1571","2","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1572","2","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1573","2","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1574","2","page_top","");
INSERT INTO wp_postmeta VALUES("1575","2","page_bottom","");
INSERT INTO wp_postmeta VALUES("1576","2","meta_title","");
INSERT INTO wp_postmeta VALUES("1577","2","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1578","2","meta_description","");
INSERT INTO wp_postmeta VALUES("1579","2","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1580","2","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1581","2","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1582","2","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1583","2","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1584","2","page_slider","");
INSERT INTO wp_postmeta VALUES("1585","2","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1586","16","_edit_lock","1416921579:1");
INSERT INTO wp_postmeta VALUES("1587","16","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1588","449","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1589","449","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1590","449","_menu_item_object_id","16");
INSERT INTO wp_postmeta VALUES("1591","449","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1592","449","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1593","449","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1594","449","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1595","449","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1599","454","_wp_attached_file","2014/05/meeting.jpg");
INSERT INTO wp_postmeta VALUES("1600","454","_wp_attachment_metadata","a:5:{s:5:\"width\";i:122;s:6:\"height\";i:122;s:4:\"file\";s:19:\"2014/05/meeting.jpg\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:17:\"meeting-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1601","455","_wp_attached_file","2014/05/stand-out.jpg");
INSERT INTO wp_postmeta VALUES("1602","455","_wp_attachment_metadata","a:5:{s:5:\"width\";i:122;s:6:\"height\";i:122;s:4:\"file\";s:21:\"2014/05/stand-out.jpg\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"stand-out-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1605","457","_wp_attached_file","2014/05/work.jpg");
INSERT INTO wp_postmeta VALUES("1606","457","_wp_attachment_metadata","a:5:{s:5:\"width\";i:122;s:6:\"height\";i:122;s:4:\"file\";s:16:\"2014/05/work.jpg\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:14:\"work-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1607","219","_edit_lock","1416892749:1");
INSERT INTO wp_postmeta VALUES("1608","219","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1609","14","_edit_lock","1416911267:1");
INSERT INTO wp_postmeta VALUES("1610","88","_edit_lock","1400836322:1");
INSERT INTO wp_postmeta VALUES("1611","9","_edit_lock","1400499911:1");
INSERT INTO wp_postmeta VALUES("1614","472","_wp_attached_file","2014/05/c.e.o.jpg");
INSERT INTO wp_postmeta VALUES("1615","472","_wp_attachment_metadata","a:5:{s:5:\"width\";i:122;s:6:\"height\";i:122;s:4:\"file\";s:17:\"2014/05/c.e.o.jpg\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:15:\"c.e.o-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1616","486","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1617","486","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1618","486","_menu_item_object_id","219");
INSERT INTO wp_postmeta VALUES("1619","486","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1620","486","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1621","486","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1622","486","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1623","486","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1625","209","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1626","232","_edit_lock","1400509323:1");
INSERT INTO wp_postmeta VALUES("1627","232","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1628","14","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1629","228","_edit_lock","1400510735:1");
INSERT INTO wp_postmeta VALUES("1630","228","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1633","1","_edit_lock","1400563003:1");
INSERT INTO wp_postmeta VALUES("1634","1","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1637","1","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1638","1","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1639","1","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1640","1","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1641","1","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1642","1","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1643","1","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1644","1","page_top","");
INSERT INTO wp_postmeta VALUES("1645","1","page_bottom","");
INSERT INTO wp_postmeta VALUES("1646","1","meta_title","");
INSERT INTO wp_postmeta VALUES("1647","1","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1648","1","meta_description","");
INSERT INTO wp_postmeta VALUES("1649","1","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1650","1","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1651","1","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1652","1","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1653","1","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1654","1","page_slider","");
INSERT INTO wp_postmeta VALUES("1655","1","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1661","70","_edit_lock","1400563099:1");
INSERT INTO wp_postmeta VALUES("1664","70","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1665","68","_edit_lock","1400563266:1");
INSERT INTO wp_postmeta VALUES("1668","68","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1671","66","_edit_lock","1400563333:1");
INSERT INTO wp_postmeta VALUES("1674","66","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1675","64","_edit_lock","1400563947:1");
INSERT INTO wp_postmeta VALUES("1678","64","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1683","136","_edit_lock","1412332285:1");
INSERT INTO wp_postmeta VALUES("1684","135","_edit_lock","1412332183:1");
INSERT INTO wp_postmeta VALUES("1685","169","_edit_lock","1416915888:1");
INSERT INTO wp_postmeta VALUES("1686","169","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1687","230","_edit_lock","1401092376:1");
INSERT INTO wp_postmeta VALUES("1688","230","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1689","203","_edit_lock","1402666788:1");
INSERT INTO wp_postmeta VALUES("1690","222","_edit_lock","1401092378:1");
INSERT INTO wp_postmeta VALUES("1691","217","_edit_lock","1416916145:1");
INSERT INTO wp_postmeta VALUES("1692","522","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1693","522","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1694","522","_menu_item_object_id","219");
INSERT INTO wp_postmeta VALUES("1695","522","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1696","522","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1697","522","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1698","522","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1699","522","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1737","536","_wp_attached_file","2014/05/agreement.jpg");
INSERT INTO wp_postmeta VALUES("1738","536","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:21:\"2014/05/agreement.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"agreement-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"agreement-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1739","538","_wp_attached_file","2014/05/female-@work.jpg");
INSERT INTO wp_postmeta VALUES("1740","538","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:24:\"2014/05/female-@work.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"female-@work-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:22:\"female-@work-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1743","544","_wp_attached_file","2014/05/te-am.jpg");
INSERT INTO wp_postmeta VALUES("1744","544","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:17:\"2014/05/te-am.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"te-am-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:15:\"te-am-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1745","546","_wp_attached_file","2014/05/about-us.jpg");
INSERT INTO wp_postmeta VALUES("1746","546","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:20:\"2014/05/about-us.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"about-us-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:18:\"about-us-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1747","554","_wp_attached_file","2014/05/history.jpg");
INSERT INTO wp_postmeta VALUES("1748","554","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:19:\"2014/05/history.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"history-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:17:\"history-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1749","556","_wp_attached_file","2014/05/how-we-work.jpg");
INSERT INTO wp_postmeta VALUES("1750","556","_wp_attachment_metadata","a:5:{s:5:\"width\";i:222;s:6:\"height\";i:122;s:4:\"file\";s:23:\"2014/05/how-we-work.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"how-we-work-150x122.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:21:\"how-we-work-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1751","563","_wp_attached_file","2014/05/executive.jpg");
INSERT INTO wp_postmeta VALUES("1752","563","_wp_attachment_metadata","a:5:{s:5:\"width\";i:300;s:6:\"height\";i:150;s:4:\"file\";s:21:\"2014/05/executive.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"executive-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"executive-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1753","203","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1754","203","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1755","203","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1756","203","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1757","203","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1758","203","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1759","203","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1760","203","page_top","");
INSERT INTO wp_postmeta VALUES("1761","203","page_bottom","");
INSERT INTO wp_postmeta VALUES("1762","203","meta_title","");
INSERT INTO wp_postmeta VALUES("1763","203","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1764","203","meta_description","");
INSERT INTO wp_postmeta VALUES("1765","203","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1766","203","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1767","203","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1768","203","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1769","203","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1770","203","page_slider","Home Page");
INSERT INTO wp_postmeta VALUES("1771","203","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1772","568","_wp_attached_file","2014/05/happy-employees.jpg");
INSERT INTO wp_postmeta VALUES("1773","568","_wp_attachment_metadata","a:5:{s:5:\"width\";i:300;s:6:\"height\";i:150;s:4:\"file\";s:27:\"2014/05/happy-employees.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"happy-employees-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:25:\"happy-employees-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1774","570","_wp_attached_file","2014/05/evaluation.jpg");
INSERT INTO wp_postmeta VALUES("1775","570","_wp_attachment_metadata","a:5:{s:5:\"width\";i:300;s:6:\"height\";i:150;s:4:\"file\";s:22:\"2014/05/evaluation.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"evaluation-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:20:\"evaluation-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1776","572","_wp_attached_file","2014/05/illustration.jpg");
INSERT INTO wp_postmeta VALUES("1777","572","_wp_attachment_metadata","a:5:{s:5:\"width\";i:300;s:6:\"height\";i:150;s:4:\"file\";s:24:\"2014/05/illustration.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"illustration-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:22:\"illustration-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1778","230","_thumbnail_id","454");
INSERT INTO wp_postmeta VALUES("1779","222","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1780","217","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1781","372","_edit_lock","1401092361:1");
INSERT INTO wp_postmeta VALUES("1782","596","_wp_attached_file","2014/05/Human-Resource-Management.jpg");
INSERT INTO wp_postmeta VALUES("1783","596","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:37:\"2014/05/Human-Resource-Management.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Human-Resource-Management-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Human-Resource-Management-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:35:\"Human-Resource-Management-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1786","600","_wp_attached_file","2014/05/strategy1.jpg");
INSERT INTO wp_postmeta VALUES("1787","600","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:21:\"2014/05/strategy1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"strategy1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"strategy1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:19:\"strategy1-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1788","636","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1789","636","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1790","636","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1791","636","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1792","636","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1793","636","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1794","636","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1795","636","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1796","636","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1797","636","page_top","");
INSERT INTO wp_postmeta VALUES("1798","636","page_bottom","");
INSERT INTO wp_postmeta VALUES("1799","636","meta_title","");
INSERT INTO wp_postmeta VALUES("1800","636","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1801","636","meta_description","");
INSERT INTO wp_postmeta VALUES("1802","636","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1803","636","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1804","636","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1805","636","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1806","636","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1807","636","page_slider","");
INSERT INTO wp_postmeta VALUES("1808","636","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1809","636","_edit_lock","1401951562:1");
INSERT INTO wp_postmeta VALUES("1882","2","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1883","660","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1884","660","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1885","660","_menu_item_object_id","2");
INSERT INTO wp_postmeta VALUES("1886","660","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1887","660","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1888","660","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1889","660","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1890","660","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1891","699","_wp_attached_file","2014/09/Human-Resource-Management.jpg");
INSERT INTO wp_postmeta VALUES("1892","699","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:37:\"2014/09/Human-Resource-Management.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Human-Resource-Management-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Human-Resource-Management-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:35:\"Human-Resource-Management-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1893","704","_wp_attached_file","2014/09/BUILD-THE-ARK-LOGO-2.jpg");
INSERT INTO wp_postmeta VALUES("1894","704","_wp_attachment_metadata","a:5:{s:5:\"width\";i:762;s:6:\"height\";i:517;s:4:\"file\";s:32:\"2014/09/BUILD-THE-ARK-LOGO-2.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"BUILD-THE-ARK-LOGO-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"BUILD-THE-ARK-LOGO-2-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:30:\"BUILD-THE-ARK-LOGO-2-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1895","705","_wp_attached_file","2014/09/BUILD-THE-ARK-LOGO-21.jpg");
INSERT INTO wp_postmeta VALUES("1896","705","_wp_attachment_metadata","a:5:{s:5:\"width\";i:204;s:6:\"height\";i:139;s:4:\"file\";s:33:\"2014/09/BUILD-THE-ARK-LOGO-21.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"BUILD-THE-ARK-LOGO-21-150x139.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:31:\"BUILD-THE-ARK-LOGO-21-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1897","706","_wp_attached_file","2014/09/logo.png");
INSERT INTO wp_postmeta VALUES("1898","706","_wp_attachment_metadata","a:5:{s:5:\"width\";i:184;s:6:\"height\";i:139;s:4:\"file\";s:16:\"2014/09/logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x139.png\";s:5:\"width\";i:150;s:6:\"height\";i:139;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:14:\"logo-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1899","707","_wp_attached_file","2014/09/favicon.png");
INSERT INTO wp_postmeta VALUES("1900","707","_wp_attachment_metadata","a:5:{s:5:\"width\";i:56;s:6:\"height\";i:43;s:4:\"file\";s:19:\"2014/09/favicon.png\";s:5:\"sizes\";a:1:{s:16:\"featured_preview\";a:4:{s:4:\"file\";s:17:\"favicon-55x43.png\";s:5:\"width\";i:55;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1901","708","_wp_attached_file","2014/09/logo1.png");
INSERT INTO wp_postmeta VALUES("1902","708","_wp_attachment_metadata","a:5:{s:5:\"width\";i:234;s:6:\"height\";i:171;s:4:\"file\";s:17:\"2014/09/logo1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"logo1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:15:\"logo1-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1903","709","_wp_attached_file","2014/09/logo2.png");
INSERT INTO wp_postmeta VALUES("1904","709","_wp_attachment_metadata","a:5:{s:5:\"width\";i:180;s:6:\"height\";i:131;s:4:\"file\";s:17:\"2014/09/logo2.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"logo2-150x131.png\";s:5:\"width\";i:150;s:6:\"height\";i:131;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:15:\"logo2-55x55.png\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1905","780","_wp_attached_file","2012/08/unhappy_employees.jpg");
INSERT INTO wp_postmeta VALUES("1906","780","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:4:\"file\";s:29:\"2012/08/unhappy_employees.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"unhappy_employees-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"unhappy_employees-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:27:\"unhappy_employees-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("1907","834","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1908","834","_edit_lock","1412062073:1");
INSERT INTO wp_postmeta VALUES("1909","834","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1910","834","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1911","834","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1912","834","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1913","834","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1914","834","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1915","834","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1916","834","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1917","834","page_top","");
INSERT INTO wp_postmeta VALUES("1918","834","page_bottom","");
INSERT INTO wp_postmeta VALUES("1919","834","meta_title","");
INSERT INTO wp_postmeta VALUES("1920","834","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1921","834","meta_description","");
INSERT INTO wp_postmeta VALUES("1922","834","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1923","834","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1924","834","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1925","834","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1926","834","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1927","834","page_slider","");
INSERT INTO wp_postmeta VALUES("1928","834","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1929","836","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1930","836","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1931","836","_menu_item_object_id","834");
INSERT INTO wp_postmeta VALUES("1932","836","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1933","836","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1934","836","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1935","836","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1936","836","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1938","837","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1939","837","_edit_lock","1412064003:1");
INSERT INTO wp_postmeta VALUES("1940","837","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1941","837","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1942","837","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1943","837","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1944","837","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1945","837","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1946","837","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1947","837","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1948","837","page_top","");
INSERT INTO wp_postmeta VALUES("1949","837","page_bottom","");
INSERT INTO wp_postmeta VALUES("1950","837","meta_title","");
INSERT INTO wp_postmeta VALUES("1951","837","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1952","837","meta_description","");
INSERT INTO wp_postmeta VALUES("1953","837","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1954","837","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1955","837","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1956","837","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1957","837","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1958","837","page_slider","");
INSERT INTO wp_postmeta VALUES("1959","837","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1960","840","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1961","840","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1962","840","_menu_item_object_id","837");
INSERT INTO wp_postmeta VALUES("1963","840","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1964","840","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1965","840","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1966","840","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1967","840","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("1969","841","_edit_last","1");
INSERT INTO wp_postmeta VALUES("1970","841","_edit_lock","1412064001:1");
INSERT INTO wp_postmeta VALUES("1971","841","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("1972","841","thememakers_gallery","");
INSERT INTO wp_postmeta VALUES("1973","841","portfolio_url","");
INSERT INTO wp_postmeta VALUES("1974","841","portfolio_date","");
INSERT INTO wp_postmeta VALUES("1975","841","portfolio_url_title","");
INSERT INTO wp_postmeta VALUES("1976","841","portfolio_client","");
INSERT INTO wp_postmeta VALUES("1977","841","portfolio_tools","");
INSERT INTO wp_postmeta VALUES("1978","841","thememakers_portfolio","");
INSERT INTO wp_postmeta VALUES("1979","841","page_top","");
INSERT INTO wp_postmeta VALUES("1980","841","page_bottom","");
INSERT INTO wp_postmeta VALUES("1981","841","meta_title","");
INSERT INTO wp_postmeta VALUES("1982","841","meta_keywords","");
INSERT INTO wp_postmeta VALUES("1983","841","meta_description","");
INSERT INTO wp_postmeta VALUES("1984","841","pagebg_type","color");
INSERT INTO wp_postmeta VALUES("1985","841","pagebg_color","");
INSERT INTO wp_postmeta VALUES("1986","841","pagebg_image","");
INSERT INTO wp_postmeta VALUES("1987","841","pagebg_type_image_option","repeat");
INSERT INTO wp_postmeta VALUES("1988","841","page_sidebar_position","default");
INSERT INTO wp_postmeta VALUES("1989","841","page_slider","");
INSERT INTO wp_postmeta VALUES("1990","841","page_slider_type","nivo");
INSERT INTO wp_postmeta VALUES("1991","844","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("1992","844","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("1993","844","_menu_item_object_id","841");
INSERT INTO wp_postmeta VALUES("1994","844","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("1995","844","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("1996","844","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("1997","844","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("1998","844","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("2000","887","_wp_attached_file","2012/08/felista-photo.jpg");
INSERT INTO wp_postmeta VALUES("2001","887","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:25:\"2012/08/felista-photo.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"felista-photo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"featured_preview\";a:4:{s:4:\"file\";s:23:\"felista-photo-55x55.jpg\";s:5:\"width\";i:55;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("2002","699","_edit_lock","1416896934:1");
INSERT INTO wp_postmeta VALUES("2003","142","_edit_lock","1416897035:1");
INSERT INTO wp_postmeta VALUES("2004","926","_edit_last","1");
INSERT INTO wp_postmeta VALUES("2005","926","_edit_lock","1416921361:1");
INSERT INTO wp_postmeta VALUES("2006","926","nivo_slider_simplified_slides","");
INSERT INTO wp_postmeta VALUES("2007","928","_edit_last","1");
INSERT INTO wp_postmeta VALUES("2008","928","_edit_lock","1416921344:1");
INSERT INTO wp_postmeta VALUES("2009","929","_thumbnail_id","600");
INSERT INTO wp_postmeta VALUES("2010","929","_edit_last","1");
INSERT INTO wp_postmeta VALUES("2011","929","_edit_lock","1416921519:1");



DROP TABLE wp_posts;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=931 DEFAULT CHARSET=utf8;

INSERT INTO wp_posts VALUES("1","1","2014-02-13 15:29:33","2014-02-13 15:29:33","<ul style=\"color: #666666;\">\r\n	<li>Identifies hiring need, develops the position description, Recruitment Plan, organizational chart and other recruitment related documents</li>\r\n	<li>May serve as Search Committee Chair and identifies Search Committee members</li>\r\n	<li>Conducts recruitments showing good faith efforts to broaden diversity</li>\r\n	<li>Ensures understanding of collective bargaining agreements’ specific provisions with respect to filling of bargaining unit positions</li>\r\n</ul>","Hiring Management (HM)","","publish","closed","open","","hello-world","","","2014-05-20 05:18:07","2014-05-20 05:18:07","","0","http://buildtheark.co.ke/new/?p=1","0","post","","1");
INSERT INTO wp_posts VALUES("2","1","2014-02-13 15:29:33","2014-02-13 15:29:33","&nbsp;\r\n<ol>\r\n	<li>SACCOs: Nawiri Farmers Sacco, SMEP, Muramati Sacco</li>\r\n	<li>Hotel &amp; Catering Industry : Laico Regency Hotel / Innscor “Pizza Inn”/ Blancos</li>\r\n	<li>Healthcare Sector: Nairobi Hospital, Mater Hospital</li>\r\n	<li>Educational &amp; Training Institutions: IHRM / Rose of Sharon Academy</li>\r\n	<li>Oil &amp; Gas Sector : Bakri Energy Ltd/ Gasoilfields Outsourcing Services Ltd</li>\r\n	<li>NGO Sector: ITDG, Heifer International, Pact (K), Consortium of NGO HR Practitioners, CRS (South Sudan),/MAP Int’l/ ANAW</li>\r\n	<li>Government Constituencies : Mvita Constituency Office</li>\r\n	<li>Fashion Industry: La Casa Fashion House</li>\r\n	<li>Telecommunications and GIS Sector : Linksoft Group of Companies/ Geomaps Africa /</li>\r\n	<li>Private Sector: Ultra Kenya/ Multilateral Organizations: IFC-SSC / UNDP-Rwanda</li>\r\n</ol>\r\n&nbsp;","Our Clients","","publish","open","open","","our-clients","","","2014-09-30 12:35:19","2014-09-30 12:35:19","","0","http://buildtheark.co.ke/new/?page_id=2","0","page","","0");
INSERT INTO wp_posts VALUES("6","1","2012-08-05 22:24:01","2012-08-05 22:24:01","","img_01","","inherit","open","open","","img_01","","","2012-08-05 22:24:01","2012-08-05 22:24:01","","235","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_01.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("7","1","2012-08-05 22:24:03","2012-08-05 22:24:03","","img_02","","inherit","open","open","","img_02","","","2012-08-05 22:24:03","2012-08-05 22:24:03","","235","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_02.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("8","1","2012-08-05 22:24:04","2012-08-05 22:24:04","","img_03","","inherit","open","open","","img_03","","","2012-08-05 22:24:04","2012-08-05 22:24:04","","235","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_03.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("9","1","2012-08-05 22:24:05","2012-08-05 22:24:05","","img_04","","inherit","open","open","","img_04","","","2012-08-05 22:24:05","2012-08-05 22:24:05","","235","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_04.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("10","1","2012-08-05 22:24:06","2012-08-05 22:24:06","","img_05","","inherit","open","open","","img_05","","","2012-08-05 22:24:06","2012-08-05 22:24:06","","235","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_05.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("14","1","2012-08-05 22:40:31","2012-08-05 22:40:31","[one_third]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Dolore eu fugiat nulla pariatu\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third]\n\n[one_third]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"3\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Fugiat nulla pariatu\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third]\n\n[one_third_last]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"2\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third_last]\n\n[divider style=\"solid\"][/divider]\n\n[one_third]\n\n[columnpost post_id=\"66\" show_exert=\"0\" char_count=\"120\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"center\" title_align=\"center\"][/columnpost]\n\n[/one_third]\n\n[one_third]\n\n[columnpost post_id=\"68\" show_exert=\"0\" char_count=\"120\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"center\" title_align=\"center\"][/columnpost]\n\n[/one_third]\n\n[one_third_last]\n\n[columnpost post_id=\"70\" show_exert=\"0\" char_count=\"120\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"center\" title_align=\"center\"][/columnpost]\n\n[/one_third_last]","Rama Slider","","publish","open","closed","","rama-slider","","","2012-08-05 22:40:31","2012-08-05 22:40:31","","16","http://freely.webtemplatemasters.com/?page_id=14","0","page","","0");
INSERT INTO wp_posts VALUES("16","1","2012-08-05 22:42:34","2012-08-05 22:42:34","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2014/05/how-we-work.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"justify\"]Established in October 2005, Build The Ark (BTA) is a Human Resource (HR) consulting firm that provides Human Resource Management services, Human Resource Training &amp; Development services and Executive Recruitment and Placement services.[/hoverbox][/one_third]\r\n\r\n[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2014/05/how-we-work.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"justify\"]<span style=\"color: #716d6d; font-size: 14px;\">Build the Ark Ltd integrates spirituality in the workplace to daily business practice in order to optimize employee motivation and productivity to continuously improve firm performance. </span>\r\n[/hoverbox][/one_third]\r\n\r\n[one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2014/05/about-us.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"justify\" font-size: 14px;]<span style=\"color: #716d6d; font-size: 14px;\">The firm is led by a principal consultant/head-hunter whose forte is HR Management and Development. To expedite service delivery, the principal consultant works with a team of professionals in various management areas. </span>[/hoverbox][/one_third_last] [divider style=\"solid\"][/divider] [one_third] [title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Why Build The Ark?[/title][/one_third] [one_third] [title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"14px\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"] We Have The Best[/title] [/one_third] [one_third_last] [title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Perfection in Our Services[/title]<span style=\"color: #716d6d; font-size: 14px;\"> </span> [/one_third_last]","About","","publish","closed","closed","","about-us","","","2014-11-25 13:21:52","2014-11-25 13:21:52","","0","http://freely.webtemplatemasters.com/?page_id=16","0","page","","0");
INSERT INTO wp_posts VALUES("29","1","2012-08-05 23:10:29","2012-08-05 23:10:29","","blog_img_01","","inherit","open","open","","blog_img_01","","","2012-08-05 23:10:29","2012-08-05 23:10:29","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_01.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("30","1","2012-08-05 23:10:30","2012-08-05 23:10:30","","blog_img_02","","inherit","open","open","","blog_img_02","","","2012-08-05 23:10:30","2012-08-05 23:10:30","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_02.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("31","1","2012-08-05 23:10:31","2012-08-05 23:10:31","","blog_img_03","","inherit","open","open","","blog_img_03","","","2012-08-05 23:10:31","2012-08-05 23:10:31","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_03.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("32","1","2012-08-05 23:10:32","2012-08-05 23:10:32","","blog_img_04","","inherit","open","open","","blog_img_04","","","2012-08-05 23:10:32","2012-08-05 23:10:32","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_04.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("33","1","2012-08-05 23:10:33","2012-08-05 23:10:33","","blog_img_05","","inherit","open","open","","blog_img_05","","","2012-08-05 23:10:33","2012-08-05 23:10:33","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_05.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("34","1","2012-08-05 23:10:56","2012-08-05 23:10:56","","item_img_1","","inherit","open","open","","item_img_1","","","2012-08-05 23:10:56","2012-08-05 23:10:56","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("35","1","2012-08-05 23:10:57","2012-08-05 23:10:57","","item_img_2","","inherit","open","open","","item_img_2","","","2012-08-05 23:10:57","2012-08-05 23:10:57","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("36","1","2012-08-05 23:10:58","2012-08-05 23:10:58","","item_img_3","","inherit","open","open","","item_img_3","","","2012-08-05 23:10:58","2012-08-05 23:10:58","","204","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("42","1","2012-04-06 10:11:43","2012-04-06 10:11:43","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Excepteur sint occaecat","","publish","open","open","","excepteur-sint-occaecat","","","2012-04-06 10:11:43","2012-04-06 10:11:43","","0","http://freely.webtemplatemasters.com/?p=42","0","post","","0");
INSERT INTO wp_posts VALUES("54","1","2012-04-06 10:20:07","2012-04-06 10:20:07","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Lorem ipsum dolor sit amet","","publish","open","open","","lorem-ipsum-dolor-sit-amet","","","2012-04-06 10:20:07","2012-04-06 10:20:07","","0","http://freely.webtemplatemasters.com/?p=54","0","post","","0");
INSERT INTO wp_posts VALUES("56","1","2012-05-06 10:20:16","2012-05-06 10:20:16","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Praesent nibh nibh, sodales eget","","publish","open","open","","praesent-nibh-nibh-sodales-eget","","","2012-05-06 10:20:16","2012-05-06 10:20:16","","0","http://freely.webtemplatemasters.com/?p=56","0","post","","0");
INSERT INTO wp_posts VALUES("58","1","2012-05-06 10:20:25","2012-05-06 10:20:25","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Proin euismod congue aliquet","","publish","open","open","","proin-euismod-congue-aliquet","","","2012-05-06 10:20:25","2012-05-06 10:20:25","","0","http://freely.webtemplatemasters.com/?p=58","0","post","","0");
INSERT INTO wp_posts VALUES("60","1","2012-06-06 10:20:33","2012-06-06 10:20:33","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Sed pharetra fringilla tortor","","publish","open","open","","sed-pharetra-fringilla-tortor","","","2012-06-06 10:20:33","2012-06-06 10:20:33","","0","http://freely.webtemplatemasters.com/?p=60","0","post","","0");
INSERT INTO wp_posts VALUES("62","1","2012-06-06 10:20:44","2012-06-06 10:20:44","<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</blockquote>\n<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n[one_third][list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor [/list][/one_third]\n<p>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia. Lorem ipsum dolor sit amet</p>\n</p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>","Pellentesque ac aliquet orci","","publish","open","open","","pellentesque-ac-aliquet-orci","","","2012-06-06 10:20:44","2012-06-06 10:20:44","","0","http://freely.webtemplatemasters.com/?p=62","0","post","","0");
INSERT INTO wp_posts VALUES("64","1","2012-07-06 10:20:53","2012-07-06 10:20:53","<ul style=\"color: #666666;\">\r\n	<li>Selected by the Hiring Manager and assigned to each recruitment</li>\r\n	<li>Reviews applications, participates in the interview process and recommends final applicant</li>\r\n</ul>","Search Committee (SC)","","publish","open","open","","mauris-ultricies-malesuada-libero","","","2014-05-20 05:33:38","2014-05-20 05:33:38","","0","http://freely.webtemplatemasters.com/?p=64","0","post","","2");
INSERT INTO wp_posts VALUES("66","1","2012-07-06 10:21:01","2012-07-06 10:21:01","<ul style=\"color: #666666;\">\r\n	<li>Reviews position description and assigns the <a class=\"external\" style=\"color: #874e14;\" href=\"http://policy.ucop.edu/doc/4010405\" target=\"_blank\">Job Classification</a></li>\r\n	<li>Conducts Job Analysis upon request</li>\r\n</ul>","Human Resources Classification Analyst (HRCA)","","publish","open","open","","quisque-tempor-tincidunt-felis","","","2014-05-20 05:24:12","2014-05-20 05:24:12","","0","http://freely.webtemplatemasters.com/?p=66","0","post","","1");
INSERT INTO wp_posts VALUES("68","1","2012-08-06 10:21:11","2012-08-06 10:21:11","<ul style=\"color: #666666;\">\r\n	<li>Works with the (HM) to prepare the job description and ensures proper procedures for review and approval are met at the department level</li>\r\n	<li>Initiates recruitment via the ATS</li>\r\n	<li>Posts recruitment on selected job boards</li>\r\n	<li>Routes recruitment to (OHRC/OSCC) for review and routing</li>\r\n	<li>Processes final offer and finalizes the recruitment in the ATS</li>\r\n	<li>Notifies interviewees not selected</li>\r\n</ul>","Departmental Human Resources/Service Center Coordinator (HRC or SCC)","","publish","open","open","","vestibulum-mattis-magna-quis","","","2014-05-20 05:22:40","2014-05-20 05:22:40","","0","http://freely.webtemplatemasters.com/?p=68","0","post","","2");
INSERT INTO wp_posts VALUES("70","1","2012-08-06 10:21:21","2012-08-06 10:21:21","<ul style=\"color: #666666;\">\r\n	<li>Reviews recruitments and provides oversight of the recruitment process</li>\r\n	<li>Routes online recruitment requests to Human Resources for job classification and posting to ATS</li>\r\n</ul>","Organizational Human Resources/Service Center Coordinator (OHRC/SCC)","","publish","open","open","","mauris-dictum-nibh-eget-nunc","","","2014-05-20 05:20:15","2014-05-20 05:20:15","","0","http://freely.webtemplatemasters.com/?p=70","0","post","","4");
INSERT INTO wp_posts VALUES("72","1","2012-08-06 10:23:04","2012-08-06 10:23:04","","Blog","","publish","open","closed","","blog","","","2012-08-06 10:23:04","2012-08-06 10:23:04","","0","http://freely.webtemplatemasters.com/?page_id=72","3","page","","0");
INSERT INTO wp_posts VALUES("81","1","2012-08-06 10:30:33","2012-08-06 10:30:33","Happy female customer care representative looking at you and smiling","beautiful-customer-support","","inherit","open","open","","beautiful-customer-support","","","2012-08-06 10:30:33","2012-08-06 10:30:33","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/beautiful-customer-support.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("82","1","2012-08-06 10:30:34","2012-08-06 10:30:34","Business development - Closeup of hands holding seedling in a group","business-development-hands-holding-seedling-in-a-group","","inherit","open","open","","business-development-hands-holding-seedling-in-a-group","","","2012-08-06 10:30:34","2012-08-06 10:30:34","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-development-hands-holding-seedling-in-a-group.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("83","1","2012-08-06 10:30:35","2012-08-06 10:30:35","Portrait of beautiful business woman pointing at you with colleague in background","business-woman-pointing-at-you","","inherit","open","open","","business-woman-pointing-at-you","","","2012-08-06 10:30:35","2012-08-06 10:30:35","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("84","1","2012-08-06 10:30:36","2012-08-06 10:30:36","glass globe or earth in green grass showing eco concept with copyspace","glass globe or earth in grass","","inherit","open","open","","glass-globe-or-earth-in-grass","","","2012-08-06 10:30:36","2012-08-06 10:30:36","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/glass-globe-or-earth-in-grass.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("85","1","2012-08-06 10:30:37","2012-08-06 10:30:37","Success in business-group of excited people","Group of happy business people laughing","","inherit","open","open","","group-of-happy-business-people-laughing","","","2012-08-06 10:30:37","2012-08-06 10:30:37","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/group-of-happy-business-people-laughing.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("86","1","2012-08-06 10:30:38","2012-08-06 10:30:38","Portrait of mature couple using laptop computer and smiling","mature-couple-using-laptop-computer-and-smiling-","","inherit","open","open","","mature-couple-using-laptop-computer-and-smiling","","","2012-08-06 10:30:38","2012-08-06 10:30:38","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/mature-couple-using-laptop-computer-and-smiling-.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("87","1","2012-08-06 10:30:39","2012-08-06 10:30:39","Portrait of confident business man wearing headset with colleagues in background","perfect-customer-support","","inherit","open","open","","perfect-customer-support","","","2012-08-06 10:30:39","2012-08-06 10:30:39","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("88","1","2012-08-06 10:30:40","2012-08-06 10:30:40","Portrait of happy young business man relaxing with hands behind head","relaxed-business-man-smiling","","inherit","open","open","","relaxed-business-man-smiling","","","2012-08-06 10:30:40","2012-08-06 10:30:40","","66","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("130","1","2012-08-06 11:00:48","2012-08-06 11:00:48","","Blog Alternate","","publish","open","closed","","blog-alternate","","","2012-08-06 11:00:48","2012-08-06 11:00:48","","72","http://freely.webtemplatemasters.com/?page_id=130","0","page","","0");
INSERT INTO wp_posts VALUES("135","1","2012-08-06 11:04:20","2012-08-06 11:04:20","<p style=\"text-align: left;\"><span style=\"color: #ffffff; font-size: 14px;\">\"Our organisation has experienced great success since we started working with Build the Ark. So far, we are very happy with the progress that we have made.\"</span></p>","Brandon","","publish","closed","closed","","brandon-green","","","2014-10-03 10:30:39","2014-10-03 10:30:39","","0","http://freely.webtemplatemasters.com/?post_type=testimonials&#038;p=135","0","testimonials","","0");
INSERT INTO wp_posts VALUES("136","1","2012-08-06 11:06:21","2012-08-06 11:06:21","<p style=\"text-align: right;\"><img class=\"wp-image-887 alignleft\" src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/felista-photo.jpg\" alt=\"felista-photo\" width=\"89\" height=\"89\" /><span style=\"color: #ffffff; font-size: 14px;\">\"We employ a high percentage of temporary staff and use Build the Ark as our agency. The management team at Build the Ark has been instrumental in helping us source for the right people at times on very short notice\"</span></p>","Felista","","publish","closed","closed","","john-resig","","","2014-10-03 10:33:01","2014-10-03 10:33:01","","0","http://freely.webtemplatemasters.com/?post_type=testimonials&#038;p=136","0","testimonials","","0");
INSERT INTO wp_posts VALUES("137","1","2012-08-06 11:06:51","2012-08-06 11:06:51","<span style=\"color: #ffffff; font-size: 14px;\">\"I have been working with Build the Ark Recruitment for a very long time. In this timeframe, they have helped us refine our internal process and develop the right culture in our orgnaisation\"</span>","Racheal","","publish","closed","closed","","amanda-smith","","","2014-10-03 10:35:31","2014-10-03 10:35:31","","0","http://freely.webtemplatemasters.com/?post_type=testimonials&#038;p=137","0","testimonials","","0");
INSERT INTO wp_posts VALUES("139","1","2012-08-06 11:44:35","2012-08-06 11:44:35","","Gallery","","publish","open","closed","","gallery","","","2012-08-06 11:44:35","2012-08-06 11:44:35","","0","http://freely.webtemplatemasters.com/?page_id=139","2","page","","0");
INSERT INTO wp_posts VALUES("141","1","2012-08-06 11:47:50","2012-08-06 11:47:50",""," Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat","","","2012-08-06 11:47:50","2012-08-06 11:47:50","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=141","0","gall","","0");
INSERT INTO wp_posts VALUES("142","1","2012-08-06 11:49:48","2012-08-06 11:49:48","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-2","","","2012-08-06 11:49:48","2012-08-06 11:49:48","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=142","0","gall","","0");
INSERT INTO wp_posts VALUES("143","1","2012-08-06 11:50:38","2012-08-06 11:50:38","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-3","","","2012-08-06 11:50:38","2012-08-06 11:50:38","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=143","0","gall","","0");
INSERT INTO wp_posts VALUES("144","1","2012-08-06 11:51:54","2012-08-06 11:51:54","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-4","","","2012-08-06 11:51:54","2012-08-06 11:51:54","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=144","0","gall","","0");
INSERT INTO wp_posts VALUES("145","1","2012-08-06 11:52:30","2012-08-06 11:52:30","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-5","","","2012-08-06 11:52:30","2012-08-06 11:52:30","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=145","0","gall","","0");
INSERT INTO wp_posts VALUES("146","1","2012-08-06 11:53:04","2012-08-06 11:53:04","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-6","","","2012-08-06 11:53:04","2012-08-06 11:53:04","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=146","0","gall","","0");
INSERT INTO wp_posts VALUES("147","1","2012-08-06 11:53:43","2012-08-06 11:53:43","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-7","","","2012-08-06 11:53:43","2012-08-06 11:53:43","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=147","0","gall","","0");
INSERT INTO wp_posts VALUES("148","1","2012-08-06 11:54:15","2012-08-06 11:54:15","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-8","","","2012-08-06 11:54:15","2012-08-06 11:54:15","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=148","0","gall","","0");
INSERT INTO wp_posts VALUES("149","1","2012-08-06 11:56:12","2012-08-06 11:56:12","","Excepteur sint occaecat","","publish","closed","closed","","excepteur-sint-occaecat-9","","","2012-08-06 11:56:12","2012-08-06 11:56:12","","0","http://freely.webtemplatemasters.com/?post_type=gall&amp;p=149","0","gall","","0");
INSERT INTO wp_posts VALUES("151","1","2012-08-06 12:19:45","2012-08-06 12:19:45","","Portfolio 1 column","","publish","open","closed","","portfolio-1-column","","","2012-08-06 12:19:45","2012-08-06 12:19:45","","139","http://freely.webtemplatemasters.com/?page_id=151","0","page","","0");
INSERT INTO wp_posts VALUES("153","1","2012-08-06 12:20:00","2012-08-06 12:20:00","","Portfolio 2 column","","publish","open","closed","","portfolio-2-column","","","2012-08-06 12:20:00","2012-08-06 12:20:00","","139","http://freely.webtemplatemasters.com/?page_id=153","0","page","","0");
INSERT INTO wp_posts VALUES("155","1","2012-08-06 12:20:21","2012-08-06 12:20:21","","Portfolio 3 column","","publish","open","closed","","portfolio-3-column","","","2012-08-06 12:20:21","2012-08-06 12:20:21","","139","http://freely.webtemplatemasters.com/?page_id=155","0","page","","0");
INSERT INTO wp_posts VALUES("161","1","2012-08-06 12:23:42","2012-08-06 12:23:42","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Excepteur sint occaecat","","publish","open","open","","excepteur-sint-occaecat-10","","","2012-08-06 12:23:42","2012-08-06 12:23:42","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=161","0","folio","","0");
INSERT INTO wp_posts VALUES("162","1","2012-08-06 12:28:25","2012-08-06 12:28:25","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Usmod tempor incididunt ut","","publish","open","open","","usmod-tempor-incididunt-ut","","","2012-08-06 12:28:25","2012-08-06 12:28:25","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=162","0","folio","","0");
INSERT INTO wp_posts VALUES("163","1","2012-08-06 12:31:30","2012-08-06 12:31:30","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Sed do eiusmod tempor","","publish","open","open","","sed-do-eiusmod-tempor","","","2012-08-06 12:31:30","2012-08-06 12:31:30","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=163","0","folio","","0");
INSERT INTO wp_posts VALUES("164","1","2012-08-06 13:11:13","2012-08-06 13:11:13","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Set magna sint occaec","","publish","open","open","","set-magna-sint-occaec","","","2012-08-06 13:11:13","2012-08-06 13:11:13","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=164","0","folio","","0");
INSERT INTO wp_posts VALUES("165","1","2012-08-06 13:12:46","2012-08-06 13:12:46","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Voluptate velit fug","","publish","open","open","","voluptate-velit-fug","","","2012-08-06 13:12:46","2012-08-06 13:12:46","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=165","0","folio","","0");
INSERT INTO wp_posts VALUES("166","1","2012-08-06 13:13:54","2012-08-06 13:13:54","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Set magesseoccaec","","publish","open","open","","set-magesseoccaec","","","2012-08-06 13:13:54","2012-08-06 13:13:54","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=166","0","folio","","0");
INSERT INTO wp_posts VALUES("167","1","2012-08-06 13:14:44","2012-08-06 13:14:44","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Dolore eu na sint ","","publish","open","open","","dolore-eu-na-sint","","","2012-08-06 13:14:44","2012-08-06 13:14:44","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=167","0","folio","","0");
INSERT INTO wp_posts VALUES("168","1","2012-08-06 13:16:16","2012-08-06 13:16:16","Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Magna sint occaecat","","publish","open","open","","magna-sint-occaecat","","","2012-08-06 13:16:16","2012-08-06 13:16:16","","0","http://freely.webtemplatemasters.com/?post_type=folio&amp;p=168","0","folio","","0");
INSERT INTO wp_posts VALUES("169","1","2012-08-06 13:43:00","2012-08-06 13:43:00","<strong>On The Map</strong>\r\n\r\n<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3988.7948163196093!2d36.76502700000001!3d-1.2978219999999967!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f1a6b70c99365%3A0x39dc7e29edbf2587!2sBuild+the+Ark!5e0!3m2!1sen!2s!4v1400829409404\" width=\"728\" height=\"330\" frameborder=\"1\"></iframe>\r\n\r\n[one_half]\r\n<h3>LOCATION</h3>\r\n<ul>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">Build The Ark Limited</li>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">Suite No: 3</li>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">6th Floor</li>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">Silkwood Office Suites</li>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">Ngong Road</li>\r\n	<li style=\"color: #716d6d; font-size: 14px;\">(Above National Bank of Kenya )</li>\r\n</ul>\r\n[divider style=\"dotted\"][/divider]\r\n<h3>CONTACTS</h3>\r\n<span style=\"color: #716d6d; font-size: 14px;\"> </span>\r\n\r\n<span style=\"color: #716d6d; font-size: 14px;\">\r\n</span>\r\n\r\n<address><strong>Address:</strong></address>P.O .Box 52920-00100 Kasuku Centre, Kileleshwa\r\nNairobi,Kenya\r\n\r\n<span style=\"color: #716d6d; font-size: 14px;\">\r\n</span>\r\n\r\n<address><strong>Telephone Contact:</strong></address><span style=\"color: #716d6d; font-size: 14px;\">\r\n+254 727 222 444\r\n</span>\r\n\r\n<address><strong>Email Contact:</strong></address>info[@]buildtheark.co.ke\r\n\r\n<span style=\"color: #716d6d; font-size: 14px;\">\r\n</span>\r\n\r\n<address><strong>Website Address:</strong></address>www.buildtheark.co.ke\r\n\r\n[/one_half] [one_half_last]\r\n<h3>Send Us Mail</h3>\r\n[contactform]Contact Us[/contactform]\r\n\r\n[/one_half_last]","Contact Us","","publish","open","closed","","contact-us","","","2014-11-25 11:44:41","2014-11-25 11:44:41","","0","http://freely.webtemplatemasters.com/?page_id=169","5","page","","0");
INSERT INTO wp_posts VALUES("202","1","2012-08-06 14:32:41","2012-08-06 14:32:41","","no_avatar","","inherit","open","open","","no_avatar","","","2012-08-06 14:32:41","2012-08-06 14:32:41","","0","http://buildtheark.co.ke/new/wp-content/uploads/2012/08/no_avatar.png","0","attachment","image/png","0");
INSERT INTO wp_posts VALUES("203","1","2012-08-05 13:35:44","2012-08-05 13:35:44","<span style=\"color: #787878;\"><h1>Attitudinal Management</h1>Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude in today\'s world of modern Human Resource Training</span>:\r\n<blockquote>Human resources are like natural resources; they\'re often buried deep. You have to go looking for them, they\'re not just lying around on the surface. You have to create the circumstances where they show themselves.</blockquote>\r\nHere at Build the Ark:\r\n<blockquote>We recruit for attitude and train for skill.</blockquote>\r\nWe guarantee to have your staff motivated to help your firm succeed.","Attitudinal and Management","","publish","closed","closed","","attitudinal-and-management","","","2014-06-13 13:28:44","2014-06-13 13:28:44","","219","http://freely.webtemplatemasters.com/?page_id=2","0","page","","0");
INSERT INTO wp_posts VALUES("204","1","2012-08-05 22:39:30","2012-08-05 22:39:30","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Vision Statement[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Our Company Vision</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/executive.jpg[/image]</p>\r\n<p style=\"text-align: justify; font-size: 14px;\">To become a corporate community that integrates spirituality in the workplace and business practice to optimize human resources productivity and enable organizations achieve growth in firm performance</p>\r\n<p style=\"text-align: left;\">[/one_half] [one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Mission Statement[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Company Mission</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/happy-employees.jpg[/image]</p>\r\n<p style=\"text-align: justify; font-size: 14px;\">To bring our vision into reality, we will work to create awareness of the impact of spirituality in the workplace, on business practices, human resource productivity and firm performance.</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider] [one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Our Core Values[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Our Values</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/illustration.jpg[/image]</p>\r\n\r\n<ul>\r\n	<li style=\"font-size: 14px;\">1. Ethical practice</li>\r\n	<li style=\"font-size: 14px;\">2. Integrity</li>\r\n	<li style=\"font-size: 14px;\">3. Excellence in Employee Productivity</li>\r\n	<li style=\"font-size: 14px;\">4. Improved Firm Performance</li>\r\n	<li style=\"font-size: 14px;\">5. Customer Satisfaction</li>\r\n</ul>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Business Philosophy [/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Philosophy</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/evaluation.jpg[/image]</p>\r\n<p style=\"text-align: justify; font-size: 14px;\">Being busy and blessed by applying ethical practices both at a personal and business level, whilst achieving optimal human resource productivity and growth in firm performance</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","publish","closed","closed","","home","","","2014-11-25 13:10:05","2014-11-25 13:10:05","","0","http://freely.webtemplatemasters.com/?page_id=10","0","page","","0");
INSERT INTO wp_posts VALUES("209","1","2012-08-06 14:34:59","2012-08-06 14:34:59","[one_third]\n[circle]Clean Code[/circle]\n<p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.</p>\n<p style=\"text-align: center;\">[button url=\"#\" color=\"green\" size=\"small\"] Read More [/button]</p>\n[/one_third][one_third]\n[circle]Documentation[/circle]\n<p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.</p>\n<p style=\"text-align: center;\">[button url=\"#\" color=\"green\" size=\"small\"] Read More [/button]</p>\n[/one_third][one_third_last]\n[circle]Ongoing Support[/circle]\n<p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.</p>\n<p style=\"text-align: center;\">[button url=\"#\" color=\"green\" size=\"small\"] Read More [/button]</p>\n[/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n\n[one_third]\n<h2>Clean Code</h2>\n<strong><span style=\"color: #719806;\">Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</span></strong>\n\n[list list_type=\"ul\" list_class=\"1\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor`Incididunt ut labore`Set magna et dolore magna.[/list]\n\n[/one_third] [one_third]\n<h2>Documentation</h2>\n<span style=\"color: #719806;\"><strong>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</strong></span>\n\n[list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor`Incididunt ut labore`Set magna et dolore magna.[/list]\n\n[/one_third] [one_third_last]\n<h2>Ongoing Support</h2>\n<span style=\"color: #719806;\"><strong>Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</strong></span>\n\n[list list_type=\"ol\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed do eiusmod tempor`Incididunt ut labore`Set magna et dolore magna.[/list]\n\n[/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n\n[one_third]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon1.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon2.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[/one_third] [one_third]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon3.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon4.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[/one_third] [one_third_last]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon5.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[inlinebox title=\"Excepteur sint\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon6.png\"]Lorem ipsum dolor sit amet, conseceture lit.[/inlinebox]\n\n[/one_third_last]","Services","","publish","open","closed","","services","","","2012-08-06 14:34:59","2012-08-06 14:34:59","","0","http://freely.webtemplatemasters.com/?page_id=205","0","page","","0");
INSERT INTO wp_posts VALUES("217","1","2012-08-06 14:42:02","2012-08-06 14:42:02","<h1>Performance Management</h1>Performance management (PM) includes activities which ensure that goals are consistently being met in an effective and efficient manner. Performance management can focus on the performance of an organization, a department, employee, or even the processes to build a product of service, as well as many other areas.\r\n\r\nPM is also known as a process by which organizations align their resources, systems and employees to strategic objectives and priorities.\r\n\r\nPerformance management originated as a broad term coined by Dr. Aubrey Daniels in the late 1970s to describe a technology (i.e. science imbedded in applications methods) for managing both behavior and results, two critical elements of what is known as performance.A formal definition of performance management, according to Daniels\' is \"a scientifically based, data-oriented management system. It consists of three primary elements-measurement, feedback and positive reinforcement.","Performance Management","","publish","closed","closed","","performance-management","","","2014-05-26 05:45:27","2014-05-26 05:45:27","","219","http://freely.webtemplatemasters.com/?page_id=217","0","page","","0");
INSERT INTO wp_posts VALUES("219","1","2012-08-06 14:42:50","2012-08-06 14:42:50","[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"left\" margin_bottom=\"\"]OUR SERVICES[/title]\r\n\r\nBuild The Ark offers services in:\r\n\r\n	<li>Human Resource Management.</li>\r\n	<li>Human Resource Training and Development.</li>\r\n	<li>Spirituality in the Workplace.</li>\r\n\r\n<p style=\"color: #716d6d; font-size: 14px;\">Service delivery is supported by different approaches, namely ISO 9000:200 Quality Management Systems approach; a Balanced Scorecard approach, a Performance Framework approach.</p>\r\n[divider style=\"dotted\"][/divider]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Human Resource (HR) Management\r\n<ol>\r\n<ol>\r\n<ul>\r\n	<li><span style=\"color: #ff9900; font-size: 17px;\"><strong>“Create extraordinary systems, employ ordinary people”</strong></span></li>\r\n</ul>\r\n</ol>\r\n</ol>\r\n[/title]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"left\" margin_top=\"0\" margin_right=\"20\" margin_bottom=\"15\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/evaluation.jpg[/image]\r\n\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]HR Strategy[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">The development of the HR Strategy is aligned to the Corporate Strategy and Business Plans. HR Strategy is disseminated across the organization via internal training sessions. The monitoring and evaluation of HR strategy is established as on-going process whilst HR Strategy review is done appropriately.</span>\r\n\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]\r\nHR Policy and Procedures Manual Development[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">Comprehensive HR Policy and Procedures are developed using an ISO 9000:200 quality standards approach and are provided complete with cross-referenced forms, checklists, work instructions, schedules and report formats. HR Policy and Procedures are aligned to Corporate Strategy.</span>\r\n\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]\r\nHR Business Process Improvements[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">HR Business processes create an effective HR System that ensures continuous employee growth, improvement and productivity leading to better firm performance. HR Business processes such as Employee Satisfaction Surveys, Job Analyses, Evaluation and Grading; Job Descriptions with Measurable Performance Standards, Performance Management System and Appraisals, Salary Surveys, Salary/Wage, Compensation and Benefits Policy.</span>\r\n\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]\r\nExecutive Recruitment &amp; Selection[/title]\r\n\r\n<span style=\"color: #716d6d; font-size: 14px;\">Build The Ark’s employment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses an extensive referral program to attract and represent the most qualified professionals available to discerning clients. Executive Recruitment &amp; Selection Services are characterized by CV Data-Base Management, Initial Screening and Shortlist Analyses and competency profiling.</span>\r\n\r\n<span style=\"color: #716d6d; font-size: 14px;\"> </span>\r\n\r\n[divider style=\"dotted\"][/divider]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"120\" alt=\"\" align=\"right\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"15\" margin_left=\"20\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/female-@work.jpg[/image]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Human Resource Training and Development\r\n<ol>\r\n<ol>\r\n<ul>\r\n	<li><span style=\"color: #ff9900; font-size: 17px;\"><strong>\"It\'s all to do with the training: you can do a lot if you\'re properly trained.\"</strong></span></li>\r\n	<li><span style=\"color: #ff9900; font-size: 17px;\"><strong>- Elizabeth II, Queen of Great Britain</strong></span>[/title]</li>\r\n</ul>\r\n</ol>\r\n</ol>\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]Training Needs Identification and Analyses[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">HR Training and Development is anchored on the HR strategy which is informed by the Corporate Strategy. Internal or external must be clearly connected to a measurable strategic pillar.</span>\r\n\r\nTraining needs are identified based on strategy guidelines, performance gaps; succession planning and future business plans e.g. regional/international expansion teams, regulatory changes, technological advancements. Training is analyzed and categorized into knowledge attained, skill improvement or attitudinal modification\r\n\r\n&nbsp;\r\n\r\n[title font_size=\"20\"]\r\nStaff Development Programs[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">Build The Ark Ltd offers externally sourced or internally delivered programs depending on clients’ needs.</span>\r\n\r\n[divider style=\"dotted\"][/divider]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Spirituality in the workplace\r\n<ol>\r\n<ol>\r\n<ul>\r\n	<li><span style=\"color: #ff9900; font-size: 17px;\"><strong>\"A career can coexist with the development of the soul when we approach each with balance and determination.\"</strong></span></li>\r\n</ul>\r\n</ol>\r\n</ol>\r\n[/title]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"left\" margin_top=\"0\" margin_right=\"20\" margin_bottom=\"15\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2014/05/te-am.jpg[/image]\r\n\r\n[title font_size=\"20\"]Awareness Sessions[/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">Awareness of Spirituality in the workplace and its impact on employee productivity and firm performance\r\nThis is done through training sessions and shared experiences\r\n</span>\r\n\r\n[title font_size=\"20\"]Mainstreaming Spirituality in the workplace [/title]\r\n<span style=\"color: #716d6d; font-size: 14px;\">Development of Spirituality in the workplace Strategy and its implementation as an extension of the Human Resource function. This will entail Spirituality in the workplace Strategy, Spirituality in the workplace Policy and Procedures Manual Development, Spirituality in the workplace Executive Recruitment &amp; Selection of Industry Spiritual Directors.</span>","Services","","publish","open","closed","","our-services","","","2014-11-25 05:19:07","2014-11-25 05:19:07","","0","http://freely.webtemplatemasters.com/?page_id=219","0","page","","0");
INSERT INTO wp_posts VALUES("222","1","2012-08-06 14:43:11","2012-08-06 14:43:11","<h1>HR Business Process</h1>Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising, and an extensive referral program to attract and represent the most qualified professionals available.\r\n\r\nBuild The Ark endeavours to identify with the growth, change or improvement needs of its clients and as recruiting and headhunting agents, wish to offer services that create a dramatic business advantage to the client in their continuous pursuit for excellence.\r\n\r\nBuild The Ark helps reduce stress related to recruiting employees whilst ensuring timeliness and quality. ","HR Business Process","","publish","closed","closed","","hr-business-process","","","2014-05-26 05:47:38","2014-05-26 05:47:38","","219","http://freely.webtemplatemasters.com/?page_id=222","0","page","","0");
INSERT INTO wp_posts VALUES("224","1","2012-08-06 14:43:26","2012-08-06 14:43:26","[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h1\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H1 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"dotted\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h2\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H2 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"dotted\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H3 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"dotted\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h4\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H4 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"dotted\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H5 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"dotted\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h6\" font_family=\"\" align=\"none\" margin_bottom=\"\"]H6 Lorem ipsum dolor sit amet[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat</p>\n\n[divider style=\"linked\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Ordered Lists[/title]\n\n[one_third]\n\n[list list_type=\"ol\" list_class=\"1\"]Lorem ipsum dolor sit amet`Consectetur adipisicing `Elit sed do eiusmod tempor `Incididunt ut labore`Set magna et dolore magna [/list]\n\n[/one_third]\n\n[one_third]\n\n[list list_type=\"ol\" list_class=\"2\"]Lorem ipsum dolor sit amet`Consectetur adipisicing `Elit sed do eiusmod tempor `Incididunt ut labore`Set magna et dolore magna [/list]\n\n[/one_third]\n\n[one_third_last]\n\n[list list_type=\"ol\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing `Elit sed do eiusmod tempor `Incididunt ut labore`Set magna et dolore magna [/list]\n\n[/one_third_last]\n\n[divider style=\"linked\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Ordered Lists[/title]\n\n[one_third]\n\n[list list_type=\"ul\" list_class=\"1\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"4\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"7\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"10\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed  eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"13\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[/one_third]\n\n[one_third]\n\n[list list_type=\"ul\" list_class=\"2\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"5\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"8\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"11\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed  eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"14\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[/one_third]\n\n[one_third_last]\n\n[list list_type=\"ul\" list_class=\"3\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"6\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"9\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"12\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed  eiusmod tempor [/list]\n\n[list list_type=\"ul\" list_class=\"15\"]Lorem ipsum dolor sit amet`Consectetur adipisicing`Elit sed eiusmod tempor [/list]\n\n[/one_third_last]\n\n[divider style=\"linked\"][/divider]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Paragraph with images[/title]\n\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"20\" margin_bottom=\"15\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_03.jpg[/image]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incidi- dunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud.</p>\n\n<p>Sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. magna aliqua. Ut enim ad minim veniam.</p>\n\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"right\" link_float=\"right\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"15\" margin_left=\"20\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/img_02.jpg[/image]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris.</p>\n\n<p>Consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. magna aliqua. Ut enim ad minim veniam.</p>\n\n[divider style=\"linked\"][/divider]\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Pullquotes[/title]\n\n<p>Sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n[quotes]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat enim ad minim veniam. [/quotes]\n\n<p>Adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n[quotes ]Lorem ipsum dolor sit amet, consectetur adipi- sicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. [/quotes]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>\n\n[quotes ]Lorem ipsum dolor sit amet, consectetur adipi- sicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. [/quotes]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n[divider style=\"linked\"][/divider]\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Dropcaps[/title]\n\n<p>[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]A[/dropcap]\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Lorem ipsum dolor sit amet, consectetur adipisicing Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>\n\n<p>[dropcap style=\"disk\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]A[/dropcap]\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Lorem ipsum dolor sit amet, consectetur adipisicing Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>\n\n<p>[dropcap style=\"circle\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]A[/dropcap]\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Lorem ipsum dolor sit amet, consectetur adipisicing Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>\n\n[divider style=\"linked\"][/divider]\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Notifications[/title]\n[alert type=\"success\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. [/alert]\n[alert type=\"error\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. [/alert]\n[alert type=\"info\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. [/alert]\n[alert type=\"warning\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. [/alert]","Typography","","publish","open","closed","","typography","","","2012-08-06 14:43:26","2012-08-06 14:43:26","","0","http://freely.webtemplatemasters.com/?page_id=224","0","page","","0");
INSERT INTO wp_posts VALUES("226","1","2012-08-06 14:44:53","2012-08-06 14:44:53","[toggle title=\"Consectetur adipisicing elit, sed do eiusmod tempor? \"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/toggle]\n\n[toggle title=\"Adipisicing elit, sed do eiusmod tempor? \"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/toggle]\n\n[toggle title=\"Excepteur sint occaecat cupidatat non proident? \"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/toggle]\n\n[toggle title=\"Sunt in culpa qui officia deserunt? \"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/toggle]\n\n[toggle title=\"Set adipisicing elit, sed do eiusmod tempor? \"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/toggle]","FAQ Toggle","","publish","open","closed","","faq-toggle","","","2012-08-06 14:44:53","2012-08-06 14:44:53","","0","http://freely.webtemplatemasters.com/?page_id=226","0","page","","0");
INSERT INTO wp_posts VALUES("228","1","2012-08-06 14:44:00","2012-08-06 14:44:00","[table heading=\"string:Header 1,string:Header 2,string:Header 3,string:Header 4\" template_name=\"light-gray\" show_row_number=\"0\"]\n\n\'Division 1\', \'Division 1\', \'Division 1\',\'Division 1\'~\n\n\'Division 2\', \'Division 2\', \'Division 2\',\'Division 2\'~\n\n\'Division 3\', \'Division 3\', \'Division 3\',\'Division 3\'~\n\n\'Division 4\', \'Division 4\', \'Division 4\',\'Division 4\'~\n\n\'Division 5\', \'Division 5\', \'Division 5\',\'Division 5\'\n\n[/table]\n\n[table heading=\"string:Header 1,string:Header 2,string:Header 3,string:Header 4\" template_name=\"dark-gray\" show_row_number=\"0\"]\n\n\'Division 1\', \'Division 1\', \'Division 1\',\'Division 1\'~\n\n\'Division 2\', \'Division 2\', \'Division 2\',\'Division 2\'~\n\n\'Division 3\', \'Division 3\', \'Division 3\',\'Division 3\'~\n\n\'Division 4\', \'Division 4\', \'Division 4\',\'Division 4\'~\n\n\'Division 5\', \'Division 5\', \'Division 5\',\'Division 5\'\n\n[/table]\n\n[table heading=\"string:Header 1,string:Header 2,string:Header 3,string:Header 4\" template_name=\"light-green\" show_row_number=\"0\"]\n\n\'Division 1\', \'Division 1\', \'Division 1\',\'Division 1\'~\n\n\'Division 2\', \'Division 2\', \'Division 2\',\'Division 2\'~\n\n\'Division 3\', \'Division 3\', \'Division 3\',\'Division 3\'~\n\n\'Division 4\', \'Division 4\', \'Division 4\',\'Division 4\'~\n\n\'Division 5\', \'Division 5\', \'Division 5\',\'Division 5\'\n\n[/table]\n\n[table heading=\"string:Header 1,string:Header 2,string:Header 3,string:Header 4\" template_name=\"light-orange\" show_row_number=\"0\"]\n\n\'Division 1\', \'Division 1\', \'Division 1\',\'Division 1\'~\n\n\'Division 2\', \'Division 2\', \'Division 2\',\'Division 2\'~\n\n\'Division 3\', \'Division 3\', \'Division 3\',\'Division 3\'~\n\n\'Division 4\', \'Division 4\', \'Division 4\',\'Division 4\'~\n\n\'Division 5\', \'Division 5\', \'Division 5\',\'Division 5\'\n\n[/table]","Tables","","publish","open","closed","","tables","","","2012-08-06 14:44:00","2012-08-06 14:44:00","","0","http://freely.webtemplatemasters.com/?page_id=228","0","page","","0");
INSERT INTO wp_posts VALUES("230","1","2012-08-06 14:44:12","2012-08-06 14:44:12","[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"[/title]\r\n\r\n[divider style=\"dotted\"][/divider]\r\n\r\n<h1>Executive Recruitment</h1>Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising, and an extensive referral program to attract and represent the most qualified professionals available.\r\n\r\nBuild The Ark endeavours to identify with the growth, change or improvement needs of its clients and as recruiting and headhunting agents, wish to offer services that create a dramatic business advantage to the client in their continuous pursuit for excellence.\r\n\r\nBuild The Ark helps reduce stress related to recruiting employees whilst ensuring timeliness and quality. \r\n","Executive Recruitment","","publish","open","closed","","executive-recruitment","","","2014-05-26 05:46:26","2014-05-26 05:46:26","","219","http://freely.webtemplatemasters.com/?page_id=230","0","page","","0");
INSERT INTO wp_posts VALUES("232","1","2012-08-06 14:45:02","2012-08-06 14:45:02","[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Full width[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]1[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Lorem ipsum dolor sit amet, consectetur adipisicing Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.\n\n[divider style=\"dotted\"][/divider]\n\n[two_thirds]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Two-thirds of the column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]1[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\n\n[/two_thirds]\n\n[one_third_last]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]One third column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]2[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad consectetur adipisicing elit, sed do eiusmod tempor incididunt.\n\n[/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n\n[one_third]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]One third column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]1[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad consectetur adipisicing elit, sed do eiusmod tempor incididunt.\n\n[/one_third]\n\n[two_thirds_last]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Two-thirds of the column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]2[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\n\n[/two_thirds_last]\n\n[divider style=\"dotted\"][/divider]\n\n[one_third]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]One third column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]1[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad consectetur adipisicing elit, sed do eiusmod tempor incididunt.\n\n[/one_third]\n\n[one_third]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]One third column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]2[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad consectetur adipisicing elit, sed do eiusmod tempor incididunt.\n\n[/one_third]\n\n[one_third_last]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"0\" type=\"h3\" font_family=\"\" align=\"none\" margin_bottom=\"\"]One third column[/title]\n\n[dropcap style=\"default\" font_family=\"\" color=\"\" font_size=\"\" custom_bg=]3[/dropcap]\n\nmet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad consectetur adipisicing elit, sed do eiusmod tempor incididunt.\n\n[/one_third_last]","Column layout","","publish","open","closed","","column-layout","","","2012-08-06 14:45:02","2012-08-06 14:45:02","","0","http://freely.webtemplatemasters.com/?page_id=232","0","page","","0");
INSERT INTO wp_posts VALUES("234","1","2012-08-06 14:44:36","2012-08-06 14:44:36","[tabs type=\"full\" titles=\"Tab 1, Tab 2, Tab 3, Tab 4\"][tab] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. [/tab] [tab] Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Aenean ultricies, magna in facilisis commodo, lacus orci bibendum enim, quis pellentesque dui sapien dignissim risus. In hac habitasse platea dictumst. Sed sed libero enim, ut pulvinar felis. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Vivamus sed tincidunt ipsum. Praesent blandit enim at nunc volutpat vitae tincidunt arcu mollis. Vivamus luctus eros a est auctor facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ut lectus at ligula mattis varius dapibus id velit. Ut a lectus nibh, non tempus dolor. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [/tabs]\n\n[tabs type=\"separated\" titles=\"Tab 1, Tab 2, Tab 3, Tab 4\"][tab] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. [/tab] [tab] Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Aenean ultricies, magna in facilisis commodo, lacus orci bibendum enim, quis pellentesque dui sapien dignissim risus. In hac habitasse platea dictumst. Sed sed libero enim, ut pulvinar felis. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Vivamus sed tincidunt ipsum. Praesent blandit enim at nunc volutpat vitae tincidunt arcu mollis. Vivamus luctus eros a est auctor facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ut lectus at ligula mattis varius dapibus id velit. Ut a lectus nibh, non tempus dolor. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [/tabs]\n\n[tabs type=\"vertical\" titles=\"Tab 1, Tab 2, Tab 3, Tab 4\"][tab] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. [/tab] [tab] Vivamus bibendum purus sit amet lectus pellentesque consequat. Proin lectus est, adipiscing a congue ac, pretium a nisi. In a placerat nibh. In id hendrerit tortor. Ut ut tincidunt nisi. Nulla cursus magna id turpis dignissim et gravida purus dictum. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Aenean ultricies, magna in facilisis commodo, lacus orci bibendum enim, quis pellentesque dui sapien dignissim risus. In hac habitasse platea dictumst. Sed sed libero enim, ut pulvinar felis. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [tab] Vivamus sed tincidunt ipsum. Praesent blandit enim at nunc volutpat vitae tincidunt arcu mollis. Vivamus luctus eros a est auctor facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ut lectus at ligula mattis varius dapibus id velit. Ut a lectus nibh, non tempus dolor. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat. [/tab] [/tabs]\n\n ","Tabs","","publish","open","closed","","tabs","","","2012-08-06 14:44:36","2012-08-06 14:44:36","","0","http://freely.webtemplatemasters.com/?page_id=234","0","page","","0");
INSERT INTO wp_posts VALUES("235","1","2012-04-05 13:35:44","2012-04-05 13:35:44","Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!","Hello world!","","publish","open","open","","hello-world-2","","","2012-04-05 13:35:44","2012-04-05 13:35:44","","0","http://freely.webtemplatemasters.com/?p=1","0","post","","1");
INSERT INTO wp_posts VALUES("290","1","2012-08-07 10:05:22","2012-08-07 10:05:22","<h2>Audio File Shortcode</h2>\n[audio]http://upload.wikimedia.org/wikipedia/commons/9/9b/Pentagon_News_Sample.ogg[/audio]\n\n[divider style=\"dotted\"][/divider]\n<h2>Blog Shortcode</h2>\n[blog cat=\"4\" posts_per_page=\"1\" orderby=\"0\" order=\"DESC\" image=\"1\" meta=\"1\" full=\"0\" paging=\"0\"][/blog]\n\n[divider style=\"dotted\"][/divider]\n<h2>Zooming Circle</h2>\n[circle]Zooming Circle[/circle]\n\n[divider style=\"dotted\"][/divider]\n<h2>Column Posts Shortcode</h2>\n[one_third][columnpost post_id=\"70\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost][/one_third] [one_third][columnpost post_id=\"64\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost][/one_third] [one_third_last][columnpost post_id=\"68\" show_exert=\"0\" char_count=\"100\" show_featured_image=\"1\" custom_image_link=\"\" thumb_width=\"222\" thumb_height=\"122\" show_readmore=\"1\" text_align=\"none\" title_align=\"none\"][/columnpost][/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n<h2>Contact Form Shortcode</h2>\n[contactform]Contact Form 2[/contactform]\n\n[divider style=\"dotted\"][/divider]\n<h2> Dividers Shortcode</h2>\n[divider style=\"solid\"][/divider]\n\n[divider style=\"dotted\"][/divider]\n\n[divider style=\"linked\"][/divider]\n\n[divider style=\"dotted\"][/divider]\n<h2>Highlighted Content Shortcode</h2>\n[one_third]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Dolore eu fugiat nulla pariatu\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third]\n\n[one_third]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"3\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Fugiat nulla pariatu\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third]\n\n[one_third_last]\n\n[hoverbox type=\"icon\" image_src=\"http://\" icon_sprite=\"2\" image_width=\"232\" image_height=\"130\" box_link=\"#\" box_link_target=\"_self\" box_bg_color=\"#F7F7F7\" box_hover_bg_color=\"#191919\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"#ffffff\" text_color=\"\" text_hover_color=\"\" text_align=\"center\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit[/hoverbox]\n\n[/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n<h2>Hover Box Shortcode</h2>\n[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\n\n[divider style=\"dotted\"][/divider]\n<h2>Image Shortcodes</h2>\n<h4>Single Image</h4>\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"200\" height=\"200\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"0\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg[/image]\n\n[divider style=\"dotted\"][/divider]\n<h4>Image Gallery</h4>\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"fancybox\" fancybox_group=\"my_group\" width=\"120\" height=\"120\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"18\" margin_bottom=\"18\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg[/image][image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"fancybox\" fancybox_group=\"my_group\" width=\"120\" height=\"120\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"18\" margin_bottom=\"18\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/mature-couple-using-laptop-computer-and-smiling-.jpg[/image][image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"fancybox\" fancybox_group=\"my_group\" width=\"120\" height=\"120\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"18\" margin_bottom=\"18\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/group-of-happy-business-people-laughing.jpg[/image][image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"fancybox\" fancybox_group=\"my_group\" width=\"120\" height=\"120\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"18\" margin_bottom=\"18\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/glass-globe-or-earth-in-grass.jpg[/image][image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"fancybox\" fancybox_group=\"my_group\" width=\"120\" height=\"120\" alt=\"\" align=\"left\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"0\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg[/image]\n\n[divider style=\"dotted\"][/divider]\n<h2>Inline Box Shortcode</h2>\n[inlinebox title=\"Your Box Title Here\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/inlinebox_icons/icon4.png\"]Nunc eleifend euismod aliquet. Nunc eu orci vitae arcu ornare mollis eu interdum lorem. Nunc vel nisl in metus commodo interdum et quis odio.[/inlinebox]\n\n[divider style=\"dotted\"][/divider]\n<h2>Video Shortcode</h2>\n[video type=\"youtube\" html5_poster=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/blog_img_04.jpg\" src_mp4=\"\" src_webm=\" src_ogg=\"\" width=\"730\" height=\"400\"]1iIZeIy7TqM[/video]","Shortcodes","","publish","open","open","","shortcodes","","","2012-08-07 10:05:22","2012-08-07 10:05:22","","0","http://freely.webtemplatemasters.com/?page_id=290","0","page","","0");
INSERT INTO wp_posts VALUES("310","1","2012-08-07 10:56:26","2012-08-07 10:56:26","<h2>Charts</h2>\n[chart type=\"pie\" width=\"750\" height=\"400\" title=\"Pie chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Task,Hours per Day\"]sleep:2,eat:2,work:2[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"bar\" width=\"750\" height=\"400\" title=\"Bar chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Year, Sales, Expenses\"]2004:1000:400,2005:980:570,2006:800:300[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"column\" width=\"750\" height=\"400\" title=\"Column Chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Year, Sales, Expenses\"]2004:1000:400,2005:980:570,2006:800:300[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"geochart\" width=\"750\" height=\"400\" title=\"Geochart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Country,Popularity\"]Germany:200,France:300,United States:400[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"line\" width=\"750\" height=\"400\" title=\"Line Chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Year, Sales, Expenses\"]2004:1000:400,2005:1170:460,2006:660:1120,2007:1030:540[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"area\" width=\"750\" height=\"400\" title=\"Area Chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Year, Sales, Expenses\"]2004:1000:400,2005:1170:460,2006:660:1120,2007:1030:540[/chart]\n\n[divider style=\"solid\"][/divider]\n\n[chart type=\"combo\" width=\"750\" height=\"400\" title=\"Combo Chart\" bgcolor=\"\" font_name=\"Arial\" font_size=\"11\" chart_titles=\"Month,Bolivia,Ecuador,Madagascar,Papua New Guinea,Rwanda,Average\"]2004/05:165:938:522:998:450:614.6,2005/06:135:1120:599:1268:288:682,2006/07:157:1167:587:807:397:623,2007/08:139:1110:615:968:215:609.4,2008/09:136:691:629:1026:366:569.6[/chart]","Charts","","publish","open","open","","charts","","","2012-08-07 10:56:26","2012-08-07 10:56:26","","0","http://freely.webtemplatemasters.com/?page_id=310","0","page","","0");
INSERT INTO wp_posts VALUES("326","1","2014-04-10 13:37:56","2014-04-10 13:37:56"," ","","","publish","closed","open","","326","","","2014-10-03 10:49:35","2014-10-03 10:49:35","","0","http://buildtheark.co.ke/new/326/","5","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("355","1","2014-04-17 12:37:52","2014-04-17 12:37:52","","BTA Logo","","inherit","closed","open","","bta-logo","","","2014-04-17 12:37:52","2014-04-17 12:37:52","","0","http://buildtheark.co.ke/new/wp-content/uploads/2014/04/BTA-Logo.png","0","attachment","image/png","0");
INSERT INTO wp_posts VALUES("357","1","2014-04-17 12:52:36","2014-04-17 12:52:36","[one_third]\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n\n[/one_third]\n[one_third]\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n\n[/one_third]\n[one_third_last]\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n\n[/one_third_last]\n\n[divider style=\"solid\"][/divider]\n[one_third]\n\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\n[/one_third]\n[one_third]\n\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]\n\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\n\n[/one_third]\n[one_third_last]\n\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]\n\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]\n\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\n\n[/one_third_last]","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 12:52:36","2014-04-17 12:52:36","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("359","1","2014-04-17 12:54:45","2014-04-17 12:54:45"," ","","","publish","closed","open","","359","","","2014-10-03 10:49:35","2014-10-03 10:49:35","","0","http://buildtheark.co.ke/new/?p=359","1","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("361","1","2014-04-17 13:15:29","2014-04-17 13:15:29","[divider style=\"solid\"][/divider]\r\n[one_half]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]\r\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n[/one_half]\r\n[one_half_last]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]\r\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n[/one_half_last]\r\n[one_half]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]\r\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n[/one_half]\r\n\r\n[one_half_last]\r\n\r\n[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]\r\n\r\n[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]\r\n<p style=\"text-align: center;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: center;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n[/one_half_last]","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:15:29","2014-04-17 13:15:29","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("362","1","2014-04-17 13:16:01","2014-04-17 13:16:01","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:16:01","2014-04-17 13:16:01","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("363","1","2014-04-17 13:17:03","2014-04-17 13:17:03","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"green\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:17:03","2014-04-17 13:17:03","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("364","1","2014-04-17 13:18:19","2014-04-17 13:18:19","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"222\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"Orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:18:19","2014-04-17 13:18:19","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("365","1","2014-04-17 13:19:38","2014-04-17 13:19:38","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"250\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"250\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"250\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"Orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"122\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:19:38","2014-04-17 13:19:38","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("366","1","2014-04-17 13:20:25","2014-04-17 13:20:25","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"280\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"Orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:20:25","2014-04-17 13:20:25","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("367","1","2014-04-17 13:21:11","2014-04-17 13:21:11","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"Orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:21:11","2014-04-17 13:21:11","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("368","1","2014-04-17 13:22:01","2014-04-17 13:22:01","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"18\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"Orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"center\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:22:01","2014-04-17 13:22:01","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("369","1","2014-04-17 13:23:08","2014-04-17 13:23:08","<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:23:08","2014-04-17 13:23:08","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("370","1","2014-04-17 13:23:45","2014-04-17 13:23:45","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:23:45","2014-04-17 13:23:45","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("371","1","2014-04-17 13:44:59","2014-04-17 13:44:59","","HR","","inherit","closed","open","","hr","","","2014-04-17 13:44:59","2014-04-17 13:44:59","","0","http://buildtheark.co.ke/new/wp-content/uploads/2014/04/HR.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("372","1","2014-04-17 13:46:33","2014-04-17 13:46:33","","human_resources","","inherit","closed","open","","human_resources","","","2014-04-17 13:46:33","2014-04-17 13:46:33","","0","http://buildtheark.co.ke/new/wp-content/uploads/2014/04/human_resources.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("373","1","2014-04-17 13:50:35","2014-04-17 13:50:35","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"18\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:50:35","2014-04-17 13:50:35","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("374","1","2014-04-17 13:51:03","2014-04-17 13:51:03","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"18\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:51:03","2014-04-17 13:51:03","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("375","1","2014-04-17 13:51:50","2014-04-17 13:51:50","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"180\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 13:51:50","2014-04-17 13:51:50","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("376","1","2014-04-17 13:58:48","2014-04-17 13:58:48","","BTA Logo","","inherit","closed","open","","bta-logo-2","","","2014-04-17 13:58:48","2014-04-17 13:58:48","","0","http://buildtheark.co.ke/new/wp-content/uploads/2014/04/BTA-Logo1.png","0","attachment","image/png","0");
INSERT INTO wp_posts VALUES("377","1","2014-04-17 14:08:37","2014-04-17 14:08:37","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Excepteur sint occaecat[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Dolore eu fugiat nulla pariatu[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Oluptate velit esse cillum[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-04-17 14:08:37","2014-04-17 14:08:37","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("378","1","2014-05-16 09:00:39","2014-05-16 09:00:39","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nAttitudinal and Management Development Training\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Business Process Improvements incorporating\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Policy and Procedures Manual Development\r\n\r\n[/title]\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:00:39","2014-05-16 09:00:39","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("379","1","2014-05-16 09:03:02","2014-05-16 09:03:02","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nAttitudinal and Management\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Business Process\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Policy and Procedures Manual Development\r\n\r\n[/title]\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:03:02","2014-05-16 09:03:02","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("380","1","2014-05-16 09:06:06","2014-05-16 09:06:06","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nAttitudinal and Management\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Business Process\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Policy and Procedures\r\n\r\n[/title]\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:06:06","2014-05-16 09:06:06","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("381","1","2014-05-16 09:16:25","2014-05-16 09:16:25","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nAttitudinal and Management\r\n<p style=\"text-align: left;\">[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Policy and Procedures\r\n\r\n[/title]\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:16:25","2014-05-16 09:16:25","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("382","1","2014-05-16 09:16:52","2014-05-16 09:16:52","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]</p>\r\nHR Policy and Procedures\r\n\r\n[/title]\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:16:52","2014-05-16 09:16:52","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("384","1","2014-05-16 09:24:14","2014-05-16 09:24:14","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:24:14","2014-05-16 09:24:14","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("385","1","2014-05-16 09:32:39","2014-05-16 09:32:39","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:32:39","2014-05-16 09:32:39","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("386","1","2014-05-16 09:34:26","2014-05-16 09:34:26","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:34:26","2014-05-16 09:34:26","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("387","1","2014-05-16 09:40:04","2014-05-16 09:40:04","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Excepteur sint occaecat</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:40:04","2014-05-16 09:40:04","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("388","1","2014-05-16 09:41:40","2014-05-16 09:41:40","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:41:40","2014-05-16 09:41:40","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("390","1","2014-05-16 09:43:51","2014-05-16 09:43:51","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:43:51","2014-05-16 09:43:51","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("391","1","2014-05-16 09:44:20","2014-05-16 09:44:20","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:44:20","2014-05-16 09:44:20","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("392","1","2014-05-16 09:44:54","2014-05-16 09:44:54","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Headhunting Services[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Skill and Attitude[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Only the Right Staff[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:44:54","2014-05-16 09:44:54","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("393","1","2014-05-16 09:48:07","2014-05-16 09:48:07","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Policy and Procedures[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:48:07","2014-05-16 09:48:07","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("394","1","2014-05-16 09:50:56","2014-05-16 09:50:56","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: rgb(255, 102, 0);\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:50:56","2014-05-16 09:50:56","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("395","1","2014-05-16 09:54:35","2014-05-16 09:54:35","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:54:35","2014-05-16 09:54:35","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("396","1","2014-05-16 09:58:11","2014-05-16 09:58:11","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\nThe HR Business Process improvement service incorporates the development of ISO 9000:2000 Compliant HR policy &amp;amp; procedures manual.\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 09:58:11","2014-05-16 09:58:11","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("397","1","2014-05-16 10:00:32","2014-05-16 10:00:32","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\nBTA provides direction to organizations that seek to get operational solutions by helping create HR systems. HOW? By helping design HR systems that run the business and helping get people who can work within the system.\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 10:00:32","2014-05-16 10:00:32","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("398","1","2014-05-16 10:02:25","2014-05-16 10:02:25","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\nBTA provides direction to organizations that seek to get operational solutions by helping create HR systems. HOW? By helping design HR systems that run the business....\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools, national media advertising...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 10:02:25","2014-05-16 10:02:25","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("399","1","2014-05-16 10:04:12","2014-05-16 10:04:12","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\nBTA provides direction to organizations that seek to get operational solutions by helping create HR systems. HOW? By helping design HR systems that run the business....\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 10:04:12","2014-05-16 10:04:12","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("425","1","2014-05-16 14:57:58","2014-05-16 14:57:58","<p style=\"text-align: left;\">[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Executive Recruitment[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Headhunting Services</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_1.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology uses the latest recruiting tools...</p>\r\n<p style=\"text-align: left;\">[button url=\"#\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]\r\n[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"0\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Attitudinal and Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Skill and Attitude</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Attitudinal Training: has been defined by management gurus as the right combination of Knowledge, Skills and Attitude In today world of modern day Human Resource Training...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>\r\n<p style=\"text-align: left;\">[divider style=\"solid\"][/divider]\r\n[one_half]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]HR Business Process[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Extraordinary Systems</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_3.jpg[/image]</p>\r\nBTA provides direction to organizations that seek to get operational solutions by helping create HR systems. HOW? By helping design HR systems that run the business....\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half]</p>\r\n<p style=\"text-align: left;\">[one_half_last]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"22\" line_height=\"auto\" show_border=\"\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]Performance Management[/title]</p>\r\n<p style=\"text-align: left;\">[title show_icon=\"0\" title_type=\"usual\" title_icon=\"\" spot_title_symb=\"01\" font_size=\"16\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"left\" margin_bottom=\"\"]<span style=\"color: #ff6600;\">Only the Right Staff</span>[/title]</p>\r\n<p style=\"text-align: left;\">[image link=\"http://\" link_title=\"\" target=\"_self\" open_as=\"none\" fancybox_group=\"\" width=\"300\" height=\"150\" alt=\"\" align=\"none\" link_float=\"left\" margin_top=\"0\" margin_right=\"0\" margin_bottom=\"10\" margin_left=\"0\"]http://buildtheark.co.ke/new/wp-content/uploads/2012/08/item_img_2.jpg[/image]</p>\r\n<p style=\"text-align: left;\">Build The Arks recruitment services include the attracting, selecting and placement of top-level talent. Our recruiting methodology...</p>\r\n<p style=\"text-align: left;\">[button url=\"\" color=\"orange\" size=\"small\"] Read More [/button]</p>\r\n<p style=\"text-align: left;\">[/one_half_last]</p>","Home","","inherit","closed","open","","204-revision-v1","","","2014-05-16 14:57:58","2014-05-16 14:57:58","","204","http://buildtheark.co.ke/new/204-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("426","1","2014-05-16 17:09:17","2014-05-16 17:09:17","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-16 17:09:17","2014-05-16 17:09:17","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("429","1","2014-05-19 07:12:04","2014-05-19 07:12:04","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:12:04","2014-05-19 07:12:04","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("430","1","2014-05-19 07:15:35","2014-05-19 07:15:35","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:15:35","2014-05-19 07:15:35","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("431","1","2014-05-19 07:17:33","2014-05-19 07:17:33","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Excepteur sint occaecat\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:17:33","2014-05-19 07:17:33","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("432","1","2014-05-19 07:22:22","2014-05-19 07:22:22","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:22:22","2014-05-19 07:22:22","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("433","1","2014-05-19 07:26:01","2014-05-19 07:26:01","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Call for Business Outsourcing HR functions represents a paradigm shift in the way HR business is done as organizations look to reduce fixed costs and grow revenues whilst optimizing on staff use. [/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:26:01","2014-05-19 07:26:01","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("434","1","2014-05-19 07:29:16","2014-05-19 07:29:16","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Call for Business Outsourcing HR functions represents a paradigm shift in the way HR business is done as organizations reduce fixed costs and grow revenues. [/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:29:16","2014-05-19 07:29:16","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("435","1","2014-05-19 07:36:34","2014-05-19 07:36:34","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Call for Business Outsourcing HR functions represents a paradigm shift in the way HR business is done as organizations reduce fixed costs. [/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:36:34","2014-05-19 07:36:34","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("436","1","2014-05-19 07:37:50","2014-05-19 07:37:50","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Call for Business Outsourcing HR functions represents a paradigm shift in the way HR business is. [/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Magna aliqua enim[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third_last]","Executive Recruitment","","inherit","closed","open","","16-revision-v1","","","2014-05-19 07:37:50","2014-05-19 07:37:50","","16","http://buildtheark.co.ke/new/16-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("437","1","2014-05-19 07:40:36","2014-05-19 07:40:36","[one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/relaxed-business-man-smiling.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"About Us\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark achieves this objective by facilitating companies to outsource certain HR functions to deliver on their behalf. [/hoverbox][/one_third] [one_third][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/perfect-customer-support.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"Our History\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Build The Ark is a limited company incorporated in Kenya in October 2005 with the objective of providing HR solutions to its clients. [/hoverbox][/one_third] [one_third_last][hoverbox type=\"image\" image_src=\"http://buildtheark.co.ke/new/wp-content/uploads/2012/08/business-woman-pointing-at-you.jpg\" icon_sprite=\"1\" image_width=\"232\" image_height=\"130\" box_link=\"http://freely.webtemplatemasters.com/about/\" box_link_target=\"_self\" box_bg_color=\"\" box_hover_bg_color=\"\" title_text=\"How We Work\" title_type=\"h5\" title_color=\"\" title_hover_color=\"\" text_color=\"\" text_hover_color=\"\" text_align=\"left\"]Call for Business Outsourcing HR functions represents a paradigm shift in the way HR business is done as organizations. [/hoverbox][/one_third_last]\r\n\r\n[divider style=\"solid\"][/divider]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon7.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Duis aute irure dolor[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon8.png\" spot_title_symb=\"01\" font_size=\"\" line_height=\"auto\" show_border=\"1\" type=\"h5\" font_family=\"\" align=\"none\" margin_bottom=\"\"]Labore et dolore[/title]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n\r\nDolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipisicing elit lorem set.\r\n\r\n[/one_third]\r\n\r\n[one_third_last]\r\n\r\n[title show_icon=\"1\" title_type=\"usual\" title_icon=\"http://freely.webtemplatemasters.com/wp-content/themes/freely/images/icons/title_icons/icon9.png\