<?php
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
    die('Please do not load this page directly.');

if (get_comments_number() != 0) :
    ?>
    <!-- ************ - BEGIN Post Comments - ************** -->

    <div class="comment-list" id="comments">
        <h4><?php echo get_comments_number() ." ". __('Comments', THEMEMAKERS_THEME_FOLDER_NAME); ?></h4> 
        <ol> 
            <?php wp_list_comments('avatar_size=54&callback=tmk_comment'); ?>
        </ol>
    </div><!--/ #comments-->
    <!-- ************ - END Post Comments - ************** -->	
    <!--<div class="content-divider"></div>-->
    <?php
endif;

if (comments_open()) :
    ?>
    <!-- ************ - BEGIN Post Comments - ************** -->
    <div class="add-comment" id="addcomments">
		
        <h4><?php _e('Leave a Reply', THEMEMAKERS_THEME_FOLDER_NAME); ?></h4>
		
        <form id="commentform" action="<?php echo home_url(); ?>/wp-comments-post.php" method="post">
			
            <div class="inputfield">
                <?php if (is_user_logged_in()) { ?>
                <?php } else { ?>			
                    <div class="row">
                        <label><?php _e('Your Name', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <span class="required">(<?php _e('required', THEMEMAKERS_THEME_FOLDER_NAME); ?>)</span></label>
                        <input type="text" name="author" id="author" value="" class="inputtext required" />
                    </div><!--/ row-->
                    <div class="row">
                        <label><?php _e('E-mail', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <span class="required">(<?php _e('will not published', THEMEMAKERS_THEME_FOLDER_NAME); ?>) (<?php _e('required', THEMEMAKERS_THEME_FOLDER_NAME); ?>)</span></label>
                        <input type="text" name="email" id="email" value="" class="inputtext required" />	
                    </div><!--/ row-->
                    <div class="row">
                        <label><?php _e('Website', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</label>
                        <input type="text" name="url" id="url" value="" class="inputtext required" />	
                    </div><!--/ row-->
                <?php } ?>
            </div><!--/ .alignleft-->
			
            <div class="textfield" id="respond">
                <label><?php _e('Message', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</label>
                <textarea name="comment" id="comment" cols="30" rows="10"></textarea>
            </div><!--/ .alignright-->
			
			<div class="clear"></div>
			
			 <input type="submit" class="button green small" value="<?php _e('Submit', THEMEMAKERS_THEME_FOLDER_NAME); ?>" />
			
            <?php comment_id_fields(); ?>
            <?php do_action('comment_form', $post->ID); ?>
			
        </form><!--/ commentform-->
		
        <div class="clear"></div>
		
    </div><!--/ addcomments-->
	
    <!-- ************ - END Post Comments - ************** -->  
<?php endif; ?>
<script type="text/javascript" src="<?php echo home_url() ?>/wp-includes/js/comment-reply.js"></script>   
<input type="hidden" name="current_post_id" value="<?php echo $post->ID ?>" />
<input type="hidden" name="current_post_url" value="<?php echo get_permalink($post->ID) ?>" />
<input type="hidden" name="is_user_logged_in" value="<?php echo (is_user_logged_in()?1:0) ?>" />


<script type="text/javascript">
<?php if (isset($_GET['new_comment'])): ?>
        jQuery(document).ready(function(){
            jQuery('html,body').animate({scrollTop: jQuery('#comment-<?php echo $_GET['new_comment']; ?>').offset().top-50},'slow');
            jQuery('#comment-<?php echo $_GET['new_comment']; ?>').addClass("new_comment");                
        });
<?php endif; ?>
    
</script>


<div style="display: none;" id="addcomments_template">
	
    <div class="add-comment" id-reply="__INDEX__">
		
        <h4><?php _e('Leave a Reply', THEMEMAKERS_THEME_FOLDER_NAME); ?></h4>
		
        <div id="respond" class="textfield">
            <textarea rows="10" cols="30" name="comment"></textarea>
        </div><!--/ areafield-->
		
        <div class="inputfield">
			<input type="button" value="<?php _e('Reset', THEMEMAKERS_THEME_FOLDER_NAME); ?>" class="button green small reset">&nbsp;&nbsp;
			<input type="submit" value="<?php _e('Reply', THEMEMAKERS_THEME_FOLDER_NAME); ?>" class="button green small reply">
        </div><!--/ textfield-->
		
        <div class="clear"></div>
		
    </div>
	
</div>


<?php

function tmk_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    ?>
    <li class="comment" id="comment-<?php echo comment_ID() ?>" comment-id="<?php echo comment_ID() ?>">
        <div class="comment-body">
			
            <div class="avatar add-border"><?php echo get_avatar($comment, $size = '54', THEMEMAKERS_THEME_URI . '/images/avatar.png'); ?></div>
			
            <div class="comment-text">	
				
                <div class="comment-author"><?php _e('Author', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <?php echo get_comment_author_link(); ?></div>
                <div class="comment-date"><?php _e('Date', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <span><?php comment_date('F j, Y'); ?></span></div>
                <div class="comment-entry">
                    <?php comment_text_rss(); ?> <?php echo get_comment_reply_link(array_merge(array('reply_text' => '<span class="comment-reply">[' . __('Reply', THEMEMAKERS_THEME_FOLDER_NAME) . ']</span>'), array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div><!--/ comment-entry-->  
            </div><!--/ comment-text -->
			
            <div class="clear"></div>
        </div><!--/ comment-body-->
        <?php
    }