/*
	Elegant Accordion v1.0
	
	Originally by Mary Lou: http://tympanus.net/codrops/2010/04/26/elegant-accordion-with-jquery-and-css3/
	Plugin by Dean Sofer: http://www.deansofer.com/
*/

(function(a){
		var b=0;
		a.eAccordion=function(c,d){
				var e=this;
				b++;
				e.runTimes=b;
				e.$el=a(c);
				e.currentPage=1;
				e.timer=null;
				e.playing=false;
				e.$el.data("ElegantAccordion",e);
				e.init=function(){
						e.options=a.extend({},a.eAccordion.defaults,d);
						e.$items=e.$el.children("li");
						e.$single=e.$items.last();
						e.$single.css("margin-right","-20px");
						if(e.options.height){
								e.$items.css("height",e.options.height)
								}
								e.pages=e.$items.length;
						var b;
						if(e.options.expandedWidth.indexOf("%")>-1){
								b=e.$el.width()*(parseInt(e.options.expandedWidth)/100)
								}else{
								b=parseInt(e.options.expandedWidth)
								}
								e.contractedWidth=(e.$el.width()-b)/(e.pages-1);
						if(e.options.autoPlay){
								e.playing=!e.options.startStopped;
								e.startStop(e.playing)
								}
								if(e.options.pauseOnHover&&e.options.autoPlay){
								e.$el.hover(function(){
										e.clearTimer()
										},function(){
										e.startStop(e.playing)
										})
								}
								e.$items.filter("[data-bg]").each(function(){
								var b=a(this);
								b.css("backgroundImage","url("+b.data("bg")+")")
								});
						e.$items.hover(function(){
								e.startStop(false);
								e.gotoPage(e.$items.index(this)+1)
								},function(){
								if(!e.clickStopped){
										if(e.options.autoPlay){
												e.startStop(true)
												}else if(e.options.neutralState){
												e.gotoNeutral()
												}
										}
						}).click(function(){
				e.startStop(false);
				e.clickStopped=true
				}).children("div").width(b);
		if(e.options.hashTags==true&&!e.gotoHash()||e.options.hashTags==false){
				e.gotoPage(1,false)
				}
				if(e.options.neutralState){
				e.neutralWidth=100/e.pages+"%";
				e.gotoNeutral(false)
				}
		};

e.gotoPage=function(a,b){
		if(typeof a=="undefined"||a==null){
				a=1
				}
				if(e.options.stopAtEnd){
				if(a==e.pages)e.startStop(false)
						}
						if(a>e.pages)a=1;
		if(a<1)a=1;
		var c=e.$items.eq(a-1);
		duration=b!==false?e.options.animationTime:0;
		c.stop(true,true).animate({
				width:e.options.expandedWidth
				},duration,e.options.easing);
		c.children("h2").stop(true,true).animate({
				opacity:0
		},duration);
		c.children("div").stop(true,true).animate({
				opacity:1,
				marginBottom:0,
				paddingBottom:0
		},duration);
		$siblings=c.siblings();
		$siblings.stop(true,true).animate({
				width:e.contractedWidth
				},duration,e.options.easing);
		$siblings.children("h2").stop(true,true).animate({
				opacity:.9
		},duration);
		$siblings.children("div").stop(true,true).animate({
				opacity:0,
				marginBottom:"-"+e.options.bgHeight,
				paddingBottom:e.options.bgHeight
				},duration);
		e.currentPage=a
		};
		
e.gotoNeutral=function(a){
		duration=a!==false?e.options.animationTime:0;
		e.$items.stop(true,true).animate({
				width:e.neutralWidth
				},duration,e.options.easing);
		e.$items.children("h2").stop(true,true).animate({
				opacity:.9
		},duration);
		e.$items.children("div").stop(true,true).animate({
				opacity:0,
				marginBottom:"-"+e.options.bgHeight,
				paddingBottom:e.options.bgHeight
				},duration)
		};
		
e.goForward=function(){
		e.gotoPage(e.currentPage+1)
		};
		
e.goBack=function(){
		e.gotoPage(e.currentPage-1)
		};
		
e.gotoHash=function(){
		var a=window.location.hash.match(/^#?panel(\d+)-(\d+)$/);
		if(a){
				var b=parseInt(a[1]);
				if(b==e.runTimes){
						var c=parseInt(a[2]);
						var d=e.$items.filter(":eq("+c+")");
						if(d.length!=0){
								e.gotoPage(c,false);
								return true
								}
						}
		}
return false
};

e.startStop=function(a){
		if(a!==true)a=false;
		e.playing=a;
		if(a){
				e.clearTimer();
				e.timer=window.setInterval(function(){
						e.goForward()
						},e.options.delay)
				}else{
				e.clearTimer()
				}
		};

e.clearTimer=function(){
		if(e.timer)window.clearInterval(e.timer)
				};
				
e.setHash=function(a){
		if(typeof window.location.hash!=="undefined"){
				if(window.location.hash!==a){
						window.location.hash=a
						}
				}else if(location.hash!==a){
		location.hash=a
		}
		return a
};

e.init()
};

a.eAccordion.defaults={
		easing:"swing",
		autoPlay:true,
		startStopped:false,
		stopAtEnd:false,
		delay:4e3,
		animationTime:100,
		hashTags:true,
		pauseOnHover:true,
		height:null,
		expandedWidth:"60%",
		neutralState:false,
		bgHeight:"0"
};

a.fn.eAccordion=function(b){
		if(typeof b=="object"){
				return this.each(function(c){
						new a.eAccordion(this,b)
						})
				}else if(typeof b=="number"){
				return this.each(function(c){
						var d=a(this).data("ElegantAccordion");
						if(d){
								d.gotoPage(b)
								}
						})
		}
}
})(jQuery)