<?php get_header(); ?>
<!-- ************ - BEGIN Content Wrapper - ************** -->
<?php
$page_top = get_post_meta($post->ID, 'page_top', true);
$page_bottom = get_post_meta($post->ID, 'page_bottom', true);

if (!empty($page_top)) {
    echo '<div class="gray-holder">' . do_shortcode(html_entity_decode($page_top)) . '<div class="clear"></div></div>';
}
?>
<div class="clear"></div>
<br />
<div class="content-wrapper blogdetails">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <div class="post-item">

                <div class="post-title alignleft">
                    <h3><?php the_title(); ?></h3>
                </div><!--/ post-title-->



                <?php if (!get_option(THEMEMAKERS_THEME_PREFIX . 'hide_post_metadata')) : ?>
                    <div class="post-meta">
                        <div class="post-date"><?php _e('Date', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <a href="<?php bloginfo('url'); ?>/?m=<?php the_time('Ym'); ?>"><?php the_date(); ?></a></div>
                        <div class="post-author"><?php _e('Author', THEMEMAKERS_THEME_FOLDER_NAME); ?>: <?php the_author_link(); ?></div>
                        <div class="post-tags"><?php the_tags(); ?></div>

                        <?php if (!$_REQUEST['disable_blog_comments']): ?>
                            <?php if (get_comments_number() > 0): ?>
                                <div class="post-comments-icon"><a href="<?php the_permalink(); ?>#comments"><?php comments_number('0', '1', '%'); ?></a></div><!--/ post-comments-icon-->                    
                            <?php else: ?>
                                <div class="post-comments-icon"><a href="<?php the_permalink(); ?>#addcomments"><?php comments_number('0', '1', '%'); ?></a></div><!--/ post-comments-icon-->
                            <?php endif; ?>
                        <?php endif; ?>

                        <div class="clear"></div>
                    </div><!--/ post-meta-->
                <?php endif; ?>


                <div class="clear"></div>
                <?php
                global $post;
                $page_settings = Thememakers_Entity_Page_Constructor::get_page_settings($post->ID);
                if ($page_settings['page_slider_type'] != 'mosaic'):
                    ?>
                    <?php if (has_post_thumbnail($post->ID)): ?>
                        <div class="post-thumb">
                            <img src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 721); ?>" alt="" class="add-border">
                        </div><!--/ post-thumb-->
                    <?php endif; ?>
                <?php endif; ?>

                <div class="entry">
                    <?php the_content(); ?>
                </div><!--/ entry-->
                <div class="clear"></div>
            </div><!--/ post-item-->


            <!-- ************ - BEGIN About the Author - ************** -->
            <?php
            if (get_option(THEMEMAKERS_THEME_PREFIX . 'show_author_info')) {
                $user = get_userdata($post->post_author);
                ?>
                <div id="bio">
                    <h5><?php _e('About the Author', THEMEMAKERS_THEME_FOLDER_NAME); ?></h5>
                    <div class="add-border alignleft"><?php echo get_avatar($user->ID, 54, THEMEMAKERS_THEME_URI . '/images/avatar.png'); ?></div>
                    <div class="bio_info">
                        <p><?php echo stripslashes($user->description); ?></p>
                    </div><!--/ bio_info-->
                    <div class="clear"></div>
                </div><!--/ bio-->
            <?php } ?>
            <!-- ************ - END About the Author - ************** -->

            <?php
            if (get_option(THEMEMAKERS_THEME_PREFIX . 'enable_related_posts')) {

                $tags = wp_get_post_tags($post->ID);
                $tag_ids = array();

                if ($tags) {
                    foreach ($tags as $tag_item)
                        $tag_ids[] = $tag_item->term_id;
                }

                $query = new WP_Query(array(
                            'tag__in' => $tag_ids,
                            'post_type' => 'post',
                            'post__not_in' => array($post->ID),
                            'showposts' => 4
                                )
                );
                ?>
                <!-- ************ - BEGIN Related - ************** -->
                <div class="related">
                    <h4><?php _e('Related Posts', THEMEMAKERS_THEME_FOLDER_NAME) ?></h4>
                    <ul>
                        <?php
                        $i = 0;
                        if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                                ?>
                                <li class="<?php if ($i == 3) echo 'last'; ?>">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <a href="<?php the_permalink(); ?>"><img class="add-border" alt="" src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 160, true, 100); ?>"></a>
                                    <?php else: ?>
                                        <a href="<?php the_permalink(); ?>"><img class="add-border" alt="" src="<?php echo THEMEMAKERS_THEME_URI . '/images/no_img_160x101.gif' ?>"></a>
                                    <?php endif; ?>
                                    <div class="excerpt"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
                                </li>
                                <?php
                                $i++;
                            endwhile;
                        endif;
                        ?>
                    </ul>
                    <div class="clear"></div>
                </div><!--/ related-->
                <!-- ************ - END Related - ************** -->
            <?php } ?>
            <?php wp_reset_query(); ?>

            <?php
            $disable_blog_comments = get_option(THEMEMAKERS_THEME_PREFIX . "disable_blog_comments");
            $disable_portfolio_comments = get_option(THEMEMAKERS_THEME_PREFIX . "disable_portfolio_comments");

            $show_comments = 1;
            if ($post->post_type == "post") {
                $show_comments = !$disable_blog_comments;
            }

            if ($post->post_type == "folio") {
                $show_comments = !$disable_portfolio_comments;
            }

            if ($show_comments) {
                comments_template();
            }
            ?>
            <?php
        endwhile;
    endif;
    ?>
</div><!--/ content-wrapper-->
<?php
if (!empty($page_bottom)) {
    echo '<div class="box"><div class="content-wrapper">' . do_shortcode(html_entity_decode($page_bottom)) . '<div class="clear"></div></div></div>';
}
?>
<!-- ************ - END Content Wrapper - ************** -->
<?php get_footer(); ?>

