<?php
global $post;
$page_settings = Thememakers_Entity_Page_Constructor::get_page_settings($post->ID);

if (!$page_settings['page_slider'] AND $page_settings['page_slider_type'] != 'mosaic') {
    return;
}


$slider = new Thememakers_Entity_Slider();
$slides = Thememakers_Entity_Slider::get_slide_group($page_settings['page_slider']);
$options = $slider->get_slider_options($page_settings['page_slider_type']);
switch ($page_settings['page_slider_type']) {
    case 'nivo':
        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/nivo/themes/default/default.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/nivo/nivo-slider.css" />
        <?php if (!$options['enable_caption']) : ?>
            <style type="text/css">
                .nivoSlider .substrate{
                    display: none;
                }
            </style>
        <?php endif; ?>
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/nivo/jquery.nivo.slider.js"></script>

        <script type="text/javascript">
            jQuery(window).load(function() {
                jQuery('#slider').nivoSlider({
                    effect:"<?php echo $options['transition_effect'] ?>",// Specify sets like: 'fold,fade,sliceDown'
                    animSpeed:<?php echo $options['transition_speed'] ?>,// Slide transition speed
                    pauseTime:<?php echo $options['autoslide'] ?>,// How long each slide will show


                    startSlide: <?php echo $options['start_slide'] ?>,// Set starting Slide (0 index)
                    captionOpacity: 1,
                    directionNav: <?php echo $options['direction_nav'] ?>,// Next & Prev navigation
                    directionNavHide:<?php echo $options['direction_nav_hide'] ?>,// Only show on hover
                    manualAdvance:<?php echo $options['manual_advance'] ?>,// Force manual transitions
                    keyboardNav:true, // Use left & right arrows


                    slices: <?php echo $options['slices'] ?>, // For slice animations
                    boxCols: <?php echo $options['box_cols'] ?>, // For box animations
                    boxRows: <?php echo $options['box_rows'] ?>, // For box animations
                    controlNav: <?php echo $options['control_nav'] ?>, // 1,2,3... navigation
                    controlNavThumbs: 0, // Use thumbnails for Control Nav
                    pauseOnHover: <?php echo $options['pause_on_hover'] ?>, // Stop animation while hovering
                    prevText: 'Prev', // Prev directionNav text
                    nextText: 'Next', // Next directionNav text
                    randomStart: <?php echo $options['random_start'] ?>, // Start on a random slide
                    beforeChange: function(){}, // Triggers before a slide transition
                    afterChange: function(){}, // Triggers after a slide transition
                    slideshowEnd: function(){}, // Triggers after all slides have been shown
                    lastSlide: function(){}, // Triggers when last slide is shown
                    afterLoad: function(){} // Triggers when slider has loaded
                });
            });


        </script>



        <div id="slider" class="nivoSlider" style="width: <?php echo $options['slide_width'] ?>px; height: <?php echo $slider->slider_height_option; ?>px;">

            <?php
            if (!empty($slides)) {
                foreach ($slides as $slide) {
                    $slide_url = ThemeMakersHelper::resize_image($slide['image'], $options['slide_width'], true, $slider->slider_height_option);
                    $slide_thumb_url = ThemeMakersHelper::resize_image($slide['image'], $options['thumb_slide_width'], true, $options['thumb_slide_width']);
                    $slide_link_url = $slide['link'];
                    $slide_title = ThemeMakersHelper::quotes_shield($slide['title']);
                    $slide_subtitle = ThemeMakersHelper::quotes_shield($slide['subtitle']);
                    $slide_desciption = ThemeMakersHelper::quotes_shield($slide['description']);


                    $slide_title_color = $slide['additional']['slide_title_color'];
                    $slide_subtitle_color = $slide['additional']['slide_subtitle_color'];
                    $slide_description_color = $slide['additional']['slide_description_color'];


                    $caption = "";
                    if ($options['enable_caption']) {
                        $caption = '<div class="nivo-caption"><div class="alignleft"><h3 style="color:' . $slide_title_color . ' !important;">' . $slide_title . '</h3><span class="desc" style="color:' . $slide_subtitle_color . ' !important;">' . $slide_subtitle . '</span></div><p style="color:' . $slide_description_color . ' !important;">' . $slide_desciption . '</p></div>';
                    }

                    if (strlen($slide_link_url) > 0) {
                        ?>
                        <a href="<?php echo $slide_link_url; ?>">
                            <img src="<?php echo $slide_url; ?>" data-thumb="<?php echo $slide_thumb_url; ?>" alt="<?php echo $slide_title ?>" title='<?php echo $caption ?>' />
                        </a>
                        <?php
                    } else {
                        ?>
                        <img src="<?php echo $slide_url; ?>" data-thumb="<?php echo $slide_thumb_url; ?>" alt="<?php echo $slide_title ?>" title='<?php echo $caption ?>' />

                        <?php
                    }
                }
            }
            ?>



        </div>

        <?php
        break;

    case 'circle':
        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/circle/css/style.css" />
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/circle/jquery.slideshow.js"></script>
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/circle/jquery.tmpl.min.js"></script>
        <script type="text/javascript">
            jQuery(function() {
                jQuery('#cn-slideshow').slideshow();
            });
        </script>

        <style type="text/css">
            .cn-images img{position: relative;display: block;border-bottom: 5px solid #d0ab47; width: <?php echo $options['slide_width'] ?>px;}
            .cn-slideshow{width: <?php echo $options['slide_width'] ?>px; height:<?php echo $slider->slider_height_option ?>px;}
        </style>


        <div id="slider">
            <script id="barTmpl" type="text/x-jquery-tmpl">
                <div class="cn-bar">
                    <div class="cn-nav">
                        <a href="#" class="cn-nav-prev">
                            <span><?php _e('Previous', THEMEMAKERS_THEME_FOLDER_NAME); ?></span>
                            <div style="background-image:url(${prevSource});"></div>
                        </a>
                        <a href="#" class="cn-nav-next">
                            <span><?php _e('Next', THEMEMAKERS_THEME_FOLDER_NAME); ?></span>
                            <div style="background-image:url(${nextSource});"></div>
                        </a>
                    </div><!-- cn-nav -->
                    <div class="cn-nav-content">
                        <div class="cn-nav-content-prev">
            <!--				<strong>Previous</strong>
                                <h3>${prevTitle}</h3>-->
                        </div>
                        <div class="cn-nav-content-current">
                            <span>Currently viewing</span>
                            <h2>${currentTitle}</h2>
                        </div>
                        <div class="cn-nav-content-next">
            <!--				<strong>Next</strong>
                                <h3>${nextTitle}</h3>-->
                        </div>
                    </div><!-- cn-nav-content -->
                </div><!-- cn-bar -->
            </script>
        </div>

        <div class="container">
            <div class="wrapper">
                <div id="cn-slideshow" class="cn-slideshow">
                    <div class="cn-images">

                        <?php
                        if (!empty($slides)) {
                            foreach ($slides as $slide) {
                                $slide_url = ThemeMakersHelper::resize_image($slide['image'], $options['slide_width']);
                                $slide_thumb_url = ThemeMakersHelper::resize_image($slide['image'], 70);
                                $slide_link_url = $slide['link'];
                                $slide_subtitle = $slide['subtitle'];
                                $slide_desciption = $slide['description'];
                                ?>
                                <img src="<?php echo $slide_url; ?>" alt="image" title="<?php echo $slide_subtitle; ?>" data-thumb="<?php echo $slide_url; ?>" />
                                <?php
                            }
                        }
                        ?>



                    </div><!-- cn-images -->
                </div><!-- cn-slideshow -->
            </div>
        </div>



        <?php
        break;

    case 'accordion':
        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/elegant-accordion/css/style.css" />
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/elegant-accordion/jquery.elegantAccordion.min.js"></script>
        <script type="text/javascript">
            jQuery(function() {
                jQuery('#accordion').eAccordion({
                    easing: '<?php echo $options['easing'] ?>',// Anything other than "linear" or "swing" requires the easing plugin
                    autoPlay: <?php echo $options['auto_play'] ?>,// This turns off the entire FUNCTIONALY, not just if it starts running or not
                    startStopped: false,	// If autoPlay is on, this can force it to start stopped
                    stopAtEnd: <?php echo $options['stop_at_end'] ?>,		// If autoplay is on, it will stop when it reaches the last slide
                    delay: <?php echo $options['delay'] ?>,// How long between slide transitions in AutoPlay mode
                    animationTime: <?php echo $options['transition_speed'] ?>,		// How long the slide transition takes
                    hashTags: true,			// Should links change the hashtag in the URL?
                    pauseOnHover: <?php echo $options['pause_on_hover'] ?>,		// If true, and autoPlay is enabled, the show will pause on hover
                    height: <?php echo $slider->slider_height_option ?>,			// Override the default CSS height
                    expandedWidth: '<?php echo $options['expanded_width'] ?>%', // Width of the expanded slide
                    neutralState: true,		// If there should be a state when all pages are equal size (usually onMouseOut)
                    bgHeight: '<?php echo $options['bg_height'] ?>px'	// The height of the gradient image (bgDescription.png). Useful if you're modifying the image
                });

            });
        </script>

        <?php
        $caption_color = $options['caption_color'];
        ?>


        <?php if (!empty($caption_color)) : ?>
            <style type="text/css">
                #accordion h3{color:<?php echo $caption_color ?> !important}
            </style>
        <?php endif; ?>


        <div id="slider">
            <div class="elegant-slider">
                <ul class="accordion" id="accordion">

                    <?php
                    if (!empty($slides)) {
                        foreach ($slides as $slide) {
                            $slide_url = ThemeMakersHelper::resize_image($slide['image'], 770);
                            $slide_link_url = $slide['link'];
                            $slide_title = ThemeMakersHelper::quotes_shield($slide['title']);
                            $slide_subtitle = ThemeMakersHelper::quotes_shield($slide['subtitle']);
                            $slide_desciption = ThemeMakersHelper::quotes_shield($slide['description']);

                            $slide_title_color = $slide['additional']['slide_title_color'];
                            $slide_subtitle_color = $slide['additional']['slide_subtitle_color'];
                            $slide_description_color = $slide['additional']['slide_description_color'];
                            ?>

                            <li data-bg="<?php echo $slide_url; ?>">
                                <?php if ($options['enable_caption']) : ?>
                                    <div class="accordion_caption">
                                        <h3 <?php if (!empty($slide_title_color)): ?>style="color:<?php echo $slide_title_color ?> !important;"<?php endif; ?>><?php echo $slide_title; ?></h3>
                                        <p <?php if (!empty($slide_description_color)): ?>style="color:<?php echo $slide_description_color ?> !important;"<?php endif; ?>><?php echo $slide_desciption; ?> <?php if (!empty($slide_link_url)) : ?>
                                                <a href="<?php echo "http://" . $slide_link_url ?>">more &rarr;</a>
                                            <?php endif; ?></p>
                                    </div>
                                <?php endif; ?>
                            </li>


                            <?php
                        }
                    }
                    ?>


                </ul>
            </div>
        </div>



        <?php
        break;

    case 'rama':
        ?>
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/rama/js/freshline/jquery.freshline.FramesBanner.min.js"></script>
        <link rel="stylesheet" type="text/css" href="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/rama/css/settings.css" media="screen" />



        <script type="text/javascript">
            jQuery(function() {

                jQuery.noConflict();
                jQuery('#rama_slider').frames_slider(
                {
                    width:<?php echo $options['width'] ?>,
                    height:<?php echo $slider->slider_height_option ?>,
                    theme:"sport",
                    timer:<?php echo $options['autoslide'] ?>,
                    hidetoolbar:0
                }
            )
                jQuery('#slider').height(<?php echo $slider->slider_height_option; ?>);
                jQuery('#slider #toolbox').css('top',<?php echo $slider->slider_height_option; ?>-50);
            });

        </script>

        <div id="slider">
            <div id="rama_slider" class="frames_slider" style="display:none">
                <ul>

                    <?php
                    if (!empty($slides)) {
                        $counter = 0;
                        $transition_effect = $options['transition_effect'];
                        //$caption_area_position = $options['caption_area_position'];
                        $effects = $slider->slider_types_options['rama']['transition_effect']['values_list'];
                        foreach ($effects as $key => $value) {
                            $image_effects_array[] = $key;
                        }


                        foreach ($slides as $slide) {
                            $slide_url = ThemeMakersHelper::resize_image($slide['image'], $options['width']);
                            $slide_link_url = $slide['link'];
                            $slide_title = ThemeMakersHelper::quotes_shield($slide['title']);
                            $slide_desciption = ThemeMakersHelper::quotes_shield($slide['description']);

                            //***
                            //individual slide effect
                            $slide_effect = "";
                            $slide_title_effect = "";
                            $slide_description_effect = "";
                            if (isset($slide['additional']['rama']['slide_effect'])) {
                                $slide_effect = $slide['additional']['rama']['slide_effect'];
                            }

                            if (isset($slide['additional']['rama']['title_effect'])) {
                                $slide_title_effect = $slide['additional']['rama']['title_effect'];
                            }


                            if (isset($slide['additional']['rama']['description_effect'])) {
                                $slide_description_effect = $slide['additional']['rama']['description_effect'];
                            }


                            $slide_title_color = $slide['additional']['slide_title_color'];
                            $slide_subtitle_color = $slide['additional']['slide_subtitle_color'];
                            $slide_description_color = $slide['additional']['slide_description_color'];
                            ?>


                            <li data-transition="<?php echo(!empty($slide_effect) ? $slide_effect : ($transition_effect == 'random' ? $image_effects_array[rand(0, count($image_effects_array))] : $transition_effect)) ?>">
                                <img src="<?php echo $slide_url ?>" alt="<?php echo $slide_title ?>">


                                <?php if ($options['enable_caption']) : ?>
                                    <div class="mygooglefont creative_layer">


                                        <?php if (!empty($slide_title)): ?>
                                            <?php if (empty($slide_link_url)): ?>
                                                <div <?php if (!empty($slide_title_color)): ?>style="color:<?php echo $slide_title_color ?> !important;"<?php endif; ?> class="title_<?php echo (($counter % 4) + 1) ?> <?php echo (!empty($slide_title_effect) ? $slide_title_effect : $options['content_effect']) ?>"><?php echo $slide_title ?></div>
                                            <?php else: ?>
                                                <a <?php if (!empty($slide_title_color)): ?>style="color:<?php echo $slide_title_color ?> !important;"<?php endif; ?> href="<?php echo $slide_link_url ?>"><div <?php if (!empty($slide_title_color)): ?>style="color:<?php echo $slide_title_color ?> !important;"<?php endif; ?> class="title_<?php echo (($counter % 4) + 1) ?> <?php echo (!empty($slide_title_effect) ? $slide_title_effect : $options['content_effect']) ?>"><?php echo $slide_title ?></div></a>
                                            <?php endif; ?>
                                        <?php endif; ?>


                                        <?php if (!empty($slide_desciption)): ?>
                                            <div <?php if (!empty($slide_description_color)): ?>style="color:<?php echo $slide_description_color ?> !important;"<?php endif; ?> class="description_<?php echo (($counter % 4) + 1) ?> <?php echo (!empty($slide_description_effect) ? $slide_description_effect : $options['content_effect']) ?>"><?php echo $slide_desciption ?></div>
                                        <?php endif; ?>


                                    </div>
                                <?php endif; ?>

                            </li>

                            <?php
                            $counter++;
                        }
                    }
                    ?>





                </ul>



            </div>
        </div>


        <?php
        break;

    case 'mosaic':
        global $post;
        $src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
        $src = $src[0];
        ?>
        <script type="text/javascript" src="<?php echo THEMEMAKERS_THEME_URI; ?>/js/sliders/jquery.imjqmosaic.0.1.packed.js"></script>
        <script type="text/javascript">

            jQuery(function() {
                jQuery.imJQMosaic({
                    image:"<?php echo $src ?>",
                    target: 'mosaic_image',
                    frameWidth: '<?php echo $options['frame_width'] ?>',
                    frameHeight:'<?php echo $slider->slider_height_option; ?>',
                    numberOfTilesX: '<?php echo $options['tiles_x'] ?>',
                    numberOfTilesY: '<?php echo $options['tiles_y'] ?>',
                    tileBorder: '<?php echo $options['tile_border'] ?>',
                    tileBorderColor: "<?php echo $options['tile_border_color'] ?>",
                    tileBorderRadius: '1',
                    effectIntensity: '<?php echo $options['effect_intensity'] ?>',
        <?php if (!empty($options['color'])) : ?>
                        effectColor: "<?php echo $options['color'] ?>"
        <?php endif; ?>
                });

                jQuery('#mosaic_image,#slider').height(<?php echo $slider->slider_height_option; ?>);
            });


        </script>


        <div id="slider">
            <div id="mosaic_image"></div>
        </div>



        <?php
        break;

    default:
        break;
}
?>

<div style="clear:both;"></div>

