<?php
/*
  Template Name: Gallery
 */

get_header();

//get slider height
$slider_height = get_option(THEMEMAKERS_THEME_PREFIX . 'gallery_height');
if (!$slider_height) {
    $slider_height = 415;
}

$gallery_thumbnail_width = 220;

/*
  $gallery_thumbnail_width = get_option(THEMEMAKERS_THEME_PREFIX . "gallery_thumbnail_width");
  if (!$gallery_thumbnail_width) {
  $gallery_thumbnail_width = 220;
  }
 */
$gallery_hide_filter = get_option(THEMEMAKERS_THEME_PREFIX . "gallery_hide_filter");


//*****
$page_top = get_post_meta($post->ID, 'page_top', true);
$page_bottom = get_post_meta($post->ID, 'page_bottom', true);

if (!empty($page_top)) {
    echo '<div class="gray-holder">' . do_shortcode(html_entity_decode($page_top)) . '<div class="clear"></div></div>';
}
?>

<div id="workPanel" style="display: none;">
    <!-- CONTENT START -->
    <article class="workPanelContent" id="ajax_panel">
        <div id="grid-wrapper1">
            <a href="#" class="closeWorkPanel close"><?php _e('Close', THEMEMAKERS_THEME_FOLDER_NAME); ?></a>
            <div class="responsed_content"><?php _e('Loading', THEMEMAKERS_THEME_FOLDER_NAME); ?> ...</div>
            <div class="clear"></div>
        </div><!-- END GRID WRAPPER-->
    </article><!--/ workPanelContent-->
    <input type="hidden" value="<?php echo $slider_height; ?>" id="gallery_height"/>
    <!-- CONTENT END -->
</div><!--/ workPanel-->


<?php if (!$gallery_hide_filter): ?>
    <div class="splitter-wrap">

        <ul id="filter" class="splitter clearfix">
            <li class="segment-0 selected-0 active"><a href="#" data-rel="everyone"><?php _e('All', THEMEMAKERS_THEME_FOLDER_NAME); ?></a></li>
            <?php $skill_types = get_terms('gallery_categories', 'orderby=name'); ?>
            <?php foreach ($skill_types as $key => $item) : ?>
                <li class="segment-<?php echo($key + 1) ?>"><a title="<?php echo $item->name; ?>" href="#" data-rel="<?php echo $item->slug; ?>"><?php echo $item->name; ?></a></li>
            <?php endforeach; ?>
        </ul>

    </div><!--/ .splitter-wrap-->

<?php endif; ?>

<ul id="list" class="image-grid clearfix">

    <?php
    query_posts(array(
        'post_type' => 'gall',
        'showposts' => -1
    ));

    if (have_posts()) : while (have_posts()) : the_post();
            $skill_types = wp_get_post_terms($post->ID, 'gallery_categories');
            if (has_post_thumbnail()) {
                ?>

                <li id="id-<?php echo $post->ID; ?>" class="everyone <?php foreach ($skill_types as $item)
                echo $item->slug . ' '; ?>">
                    <a href="#" class="workPanelLink gallery_album_cover picture-icon" album_id="<?php echo $post->ID; ?>">
                        <img class="add-border" width="<?php echo $gallery_thumbnail_width; ?>" src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, $gallery_thumbnail_width, true, 140); ?>" alt="<?php the_title(); ?>" />
                    </a>
                </li>
                <?php
            } else {
                ?>
                <li id="id-<?php echo $post->ID; ?>" class="everyone <?php foreach ($skill_types as $item)
                    echo $item->slug . ' '; ?>">
                    <a href="#" class="workPanelLink gallery_album_cover picture-icon" album_id="<?php echo $post->ID; ?>">
                        <img class="add-border" width="<?php echo $gallery_thumbnail_width; ?>" src="<?php echo THEMEMAKERS_THEME_URI.'/images/no_img_220x140.gif' ?>" alt="<?php the_title(); ?>" />
                    </a>
                </li>
                <?php
            }
        endwhile;
    endif;
    wp_reset_query();
    ?>
</ul>

    <div class="clear"></div>
    
<?php
if (!empty($page_bottom)) {
    echo '<div class="box"><div class="content-wrapper">' . do_shortcode(html_entity_decode($page_bottom)) . '<div class="clear"></div></div></div>';
}
?>

<?php get_footer(); ?>

