<?php
wp_enqueue_script('thememakers_sudoslider_js', THEMEMAKERS_THEME_URI . '/js/jquery.sudoSlider.min.js');
get_header();

//get slider height
$slider_height = get_option(THEMEMAKERS_THEME_PREFIX . 'portfolio_slider_height');
if (!$slider_height) {
    $slider_height = 400;
}

$slider_width = get_option(THEMEMAKERS_THEME_PREFIX . 'portfolio_slider_width');
if (!$slider_width) {
    $slider_width = 470;
}
//get images quantity
global $post;
$images = get_post_meta($post->ID, 'thememakers_portfolio', true);
?>
<div class="content-wrapper">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <div class="singlePanelContent">

                <?php if ((!empty($images) AND !empty($images[0])) OR has_post_thumbnail($post->ID)): ?>
                    <div class="single-pics">

                        <div class="image-gallery-slider">

                    <div id="sudo_slider" >

                        <ul>

                            <?php
                            if (!empty($images) AND !empty($images[0])) {
                                $video_width = $slider_width;
                                $video_height = $slider_height;

                                foreach ($images as $source_url) {
                                    if (!empty($source_url)) {

                                        $video_type = 'youtube.com';
                                        $allows_array = array('youtube.com', 'player.vimeo.com', '.mp4', '.jpg', '.png', '.gif', '.bmp');

                                        foreach ($allows_array as $key => $needle) {
                                            $count = substr_count($source_url, $needle);
                                            if ($count) {
                                                $video_type = $allows_array[$key];
                                            }
                                        }

                                        switch ($video_type) {
                                            case $allows_array[0]:
                                                $source_url = explode("?v=", $source_url);
                                                $source_url = explode("&", $source_url[1]);
                                                if (is_array($source_url)) {
                                                    $source_url = $source_url[0];
                                                }
                                                echo "<li>" . do_shortcode('[video type="youtube" html5_poster="" src_mp4="" src_webm="" src_ogg="" width="' . $video_width . '" height="' . $video_height . '"]' . $source_url . '[/video]') . "</li>";
                                                break;
                                            case $allows_array[1]:
                                                $source_url = explode("/", $source_url);
                                                if (is_array($source_url)) {
                                                    $source_url = $source_url[count($source_url) - 1];
                                                }
                                                echo "<li>" . do_shortcode('[video type="vimeo" html5_poster="" src_mp4="" src_webm="" src_ogg="" width="' . $video_width . '" height="' . $video_height . '"]' . $source_url . '[/video]') . "</li>";
                                                break;
                                            case $allows_array[2]:
                                                $html5_poster = THEMEMAKERS_THEME_URI . "/images/video_poster.jpg";
                                                if (has_post_thumbnail($post->ID)) {
                                                    $html5_poster = ThemeMakersHelper::get_post_featured_image($post->ID, $video_width, true, $video_height);
                                                }
                                                echo "<li>" . do_shortcode('[video type="html5" html5_poster="' . $html5_poster . '" src_mp4="' . $source_url . '" src_webm="" src_ogg="" width="' . $video_width . '" height="' . $video_height . '"][/video]') . "</li>";
                                                break;

                                            default:
                                                ?>
                                                <li><img src="<?php echo ThemeMakersHelper::resize_image($source_url, $slider_width) ?>" width="<?php echo $slider_width ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" /></li>
                                                <?php
                                                break;
                                        }
                                    }
                                }
                            } else {
                                if (has_post_thumbnail($post->ID)) {
                                    ?>
                                    <li><img src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, $slider_width) ?>" width="<?php echo $slider_width ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" /></li>
                                    <?php
                                }
                            }
                            ?>

                        </ul>

                    </div><!--/ #sudo_slider-->

                </div><!--/ .image-gallery-slider-->    
                    </div><!--/ pics-->
                <?php endif; ?>



                <div class="text">
                    <h2><?php the_title(); ?></h2>
                    <?php if (get_post_meta($post->ID, 'portfolio_date', true) != '') { ?><em><?php _e('Release', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</em>  <?php echo get_post_meta($post->ID, 'portfolio_date', true); ?><br><?php } ?>

                    <?php if (get_the_terms($post->ID, 'clients')) { ?><em><?php _e('Client(s)', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</em>  

                        <?php echo get_the_term_list($post->ID, 'clients', '', ', ', ''); ?><br>

                    <?php } ?>
                    <?php if (get_post_meta($post->ID, 'portfolio_url', true) != '') { ?><em><?php _e('URL', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</em> <a href="<?php echo get_post_meta($post->ID, 'portfolio_url', true); ?>"><?php echo get_post_meta($post->ID, 'portfolio_url', true); ?></a><br><?php } ?>
                    <?php if (get_post_meta($post->ID, 'portfolio_tools', true) != '') { ?><em><?php _e('Tools', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</em> <?php echo get_post_meta($post->ID, 'portfolio_tools', true); ?><?php } ?><br />
                    <?php if (get_the_terms($post->ID, 'skills')) { ?><em><?php _e('Skill(s)', THEMEMAKERS_THEME_FOLDER_NAME); ?>:</em>  

                        <?php echo get_the_term_list($post->ID, 'skills', '', ', ', ''); ?><br>

                    <?php } ?>
                    <div class="any-text">
                        <?php the_content(); ?>
                    </div><!--/ any-text-->
             
                </div><!--/ text-->
                <div class="clear"></div>

                <br />
                <?php wp_reset_query(); ?>
                <?php if (!get_option(THEMEMAKERS_THEME_PREFIX . 'disable_portfolio_comments')): ?>
                    <?php comments_template(); ?>
                <?php endif; ?>


            </div><!--/ singlePanelContent-->
            <?php
        endwhile;
    endif;
    ?>
</div>

<script type="text/javascript">
    jQuery(document).ready(function(){	
        var sudoSlider = jQuery("#sudo_slider").sudoSlider();
    });	
</script>


<style type="text/css">
    /* Sudo Slider */
    #sudo_slider ul, #sudo_slider li{
		position: relative;
		display: block;
		margin: 0;
		padding: 0;
		list-style: none;
	}
  
    #sudo_slider, #sudo_slider li {width:<?php echo $slider_width ?>px;overflow:hidden;}
	 /*.nextBtn{left:<?php echo $slider_width ?>px;}*/		

</style>

<?php get_footer(); ?>

