<?php
/*
  Template Name: Portfolio 1 column
 */

get_header();

//query portfolio items
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
query_posts(array(
    'post_type' => 'folio',
    'paged' => $paged
));

global $post;
$page_top = get_post_meta($post->ID, 'page_top', true);
$page_bottom = get_post_meta($post->ID, 'page_bottom', true);

if (!empty($page_top)) {
    echo '<div class="gray-holder">' . do_shortcode(html_entity_decode($page_top)) . '<div class="clear"></div></div>';
}

$excerpt_symbols_count = get_option(THEMEMAKERS_THEME_PREFIX . "excerpt_symbols_count");
if (!$excerpt_symbols_count) {
    $excerpt_symbols_count = 140;
}
$show_full_content = get_option(THEMEMAKERS_THEME_PREFIX . 'show_full_content');
?>
<!-- ************ - BEGIN Gallery List - ************** -->
<section class="gallery-list gl_col_1">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <article class="gallery-item">
                <div class="entry clearfix">
                    <?php if (has_post_thumbnail()) { ?>
                        <div class="gallery-image plus-icon">
                            <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>" class="zoomer" rel="group">
                                <img src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 470); ?>" alt="<?php the_title(); ?>"/>
                            </a>
                        </div><!--/ gallery-image-->
                    <?php } ?>
                    <div class="gallery-text">
                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <p>
                            <?php
                            if ($excerpt_symbols_count) {
                                echo substr(get_the_excerpt(), 0, $excerpt_symbols_count) . " ...";
                            } else {
                                the_excerpt();
                            }
                            ?>
                        </p>
                        <p><a href="<?php the_permalink(); ?>" class="button gray small"><?php _e('Read more', THEMEMAKERS_THEME_FOLDER_NAME); ?></a></p>
                        <?php if (get_post_meta($post->ID, 'portfolio_url', true) != '') { ?>
                            <p><a class="other-link" href="<?php echo get_post_meta($post->ID, 'portfolio_url', true); ?>" target="_blank"><?php echo get_post_meta($post->ID, 'portfolio_url_title', true); ?></a></p><?php } ?>

                    </div><!--/ gallery-text-->
                </div><!--/ .entry-->
                <div class="clear"></div>
            </article><!--/ gallery-item-->
            <?php
        endwhile;
    endif;
    ?>
</section><!--/ gallery-list-->
<!-- ************ - END Gallery List - ************** -->
<!-- ************ - BEGIN Page navigation - ************** -->
<div class="clear"></div>
<div class="pagenavi">
    <?php
    ThemeMakersHelper::pagenavi();
    wp_reset_query();
    ?>
</div><!--/ pagenavi -->
<!-- ************ - END Page navigation - ************** -->


<?php
if (!empty($page_bottom)) {
    echo '<div class="box"><div class="content-wrapper">' . do_shortcode(html_entity_decode($page_bottom)) . '<div class="clear"></div></div></div>';
}
?>
<?php get_footer(); ?>
