<?php
/*
  Template Name: Portfolio 2 column
 */

get_header();

//query portfolio items
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
query_posts(array(
    'post_type' => 'folio',
    'paged' => $paged
));

global $post;
$page_top = get_post_meta($post->ID, 'page_top', true);
$page_bottom = get_post_meta($post->ID, 'page_bottom', true);

if (!empty($page_top)) {
    echo '<div class="gray-holder">' . do_shortcode(html_entity_decode($page_top)) . '<div class="clear"></div></div>';
}

$excerpt_symbols_count = get_option(THEMEMAKERS_THEME_PREFIX . "excerpt_symbols_count");
if (!$excerpt_symbols_count) {
    $excerpt_symbols_count = 140;
}
$show_full_content = get_option(THEMEMAKERS_THEME_PREFIX . 'show_full_content');
?>
<!-- ************ - BEGIN Gallery List - ************** -->
<section class="gallery-list gl_col_2 clearfix">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <article class="gallery-item">
                <?php if (has_post_thumbnail()) : ?>
                    <div class="gallery-image">
                        <a href="<?php the_permalink(); ?>"><img src="<?php echo ThemeMakersHelper::get_post_featured_image($post->ID, 350, true, 227); ?>" alt="" /></a>
                    </div><!--/ gallery-image-->
                <?php else: ?>
                    <a href="<?php the_permalink(); ?>"><img src="<?php echo THEMEMAKERS_THEME_URI . '/images/no_img_350x227.gif' ?>" alt="" /></a>
                <?php endif; ?>
                <div class="gallery-text">
                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                    <p>
                        <?php
                        if ($excerpt_symbols_count) {
                            echo substr(get_the_excerpt(), 0, $excerpt_symbols_count) . " ...";
                        } else {
                            the_excerpt();
                        }
                        ?>
                    </p>
                    <?php if (get_post_meta($post->ID, 'portfolio_url', true) != '') { ?><a target="_blank" href="<?php echo get_post_meta($post->ID, 'portfolio_url', true); ?>" class="external"><?php echo get_post_meta($post->ID, 'portfolio_url_title', true); ?></a><?php } ?>
                    <?php if (has_post_thumbnail()) : ?>
                        <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>" class="zoomer" rel="group"></a>                  
                    <?php endif; ?>
                </div><!--/ gallery-text-->
            </article><!--/ gallery-item-->
            <?php
        endwhile;
    endif;
    ?>
</section><!--/ gallery-list-->
<!-- ************ - END Gallery List - ************** -->
<!-- ************ - BEGIN Page navigation - ************** -->
<div class="clear"></div>
<div class="pagenavi">
    <?php
    ThemeMakersHelper::pagenavi();
    wp_reset_query();
    ?>
</div><!--/ pagenavi -->
<!-- ************ - END Page navigation - ************** -->


<?php
if (!empty($page_bottom)) {
    echo '<div class="box"><div class="content-wrapper">' . do_shortcode(html_entity_decode($page_bottom)) . '<div class="clear"></div></div></div>';
}
?>
<?php get_footer(); ?>
